/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

@BA.Hide
public class OrthogonalTiledMapRenderer
extends BatchTiledMapRenderer {
    public OrthogonalTiledMapRenderer() {
    }

    public OrthogonalTiledMapRenderer(TiledMap map) {
        super(map);
    }

    public OrthogonalTiledMapRenderer(TiledMap map, Batch batch) {
        super(map, batch);
    }

    public OrthogonalTiledMapRenderer(TiledMap map, float unitScale) {
        super(map, unitScale);
    }

    public OrthogonalTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        super(map, unitScale, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer layer) {
        this.renderTileLayerAt(layer, 0.0f, 0.0f);
    }

    public void renderTileLayerAt(TiledMapTileLayer layer, float PosX, float PosY) {
        Color color = this.batch.getColor();
        float f = Color.toFloatBits(color.r, color.g, color.b, color.a * layer.getOpacity());
        int n = layer.getWidth();
        int n2 = layer.getHeight();
        int n3 = n * (layer.getRepeatX() + 1);
        int n4 = n2 * (layer.getRepeatY() + 1);
        float f2 = layer.getTileWidth() * this.unitScale;
        float f3 = layer.getTileHeight() * this.unitScale;
        int n5 = Math.max(0, (int)(this.viewBounds.x / f2));
        int n6 = Math.min(n3, (int)((this.viewBounds.x + this.viewBounds.width + f2) / f2));
        int n7 = Math.max(0, (int)(this.viewBounds.y / f3));
        int n8 = Math.min(n4, (int)((this.viewBounds.y + this.viewBounds.height + f3) / f3)) - 1;
        float f4 = (float)n8 * f3;
        float f5 = (float)n5 * f2;
        float[] fArray = this.vertices;
        int n9 = n8;
        while (n9 >= n7) {
            int n10 = n9 < n2 ? n9 : n9 % n2;
            float f6 = f5;
            int n11 = n5;
            while (n11 < n6) {
                TiledMapTile tiledMapTile;
                int n12 = n11 < n ? n11 : n11 % n;
                TiledMapTileLayer.Cell cell = layer.getCell(n12, n10);
                if (cell != null && (tiledMapTile = cell.getTile()) != null) {
                    float f7;
                    boolean bl = cell.getFlipHorizontally();
                    boolean bl2 = cell.getFlipVertically();
                    int n13 = cell.getRotation();
                    lgTextureRegion lgTextureRegion2 = tiledMapTile.getTextureRegion();
                    float f8 = f6 + PosX + tiledMapTile.getOffsetX() * this.unitScale;
                    float f9 = f4 + PosY + tiledMapTile.getOffsetY() * this.unitScale;
                    float f10 = f8 + (float)lgTextureRegion2.getRegionWidth() * this.unitScale;
                    float f11 = f9 + (float)lgTextureRegion2.getRegionHeight() * this.unitScale;
                    float f12 = lgTextureRegion2.getU();
                    float f13 = lgTextureRegion2.getV2();
                    float f14 = lgTextureRegion2.getU2();
                    float f15 = lgTextureRegion2.getV();
                    fArray[0] = f8;
                    fArray[1] = f9;
                    fArray[2] = f;
                    fArray[3] = f12;
                    fArray[4] = f13;
                    fArray[5] = f8;
                    fArray[6] = f11;
                    fArray[7] = f;
                    fArray[8] = f12;
                    fArray[9] = f15;
                    fArray[10] = f10;
                    fArray[11] = f11;
                    fArray[12] = f;
                    fArray[13] = f14;
                    fArray[14] = f15;
                    fArray[15] = f10;
                    fArray[16] = f9;
                    fArray[17] = f;
                    fArray[18] = f14;
                    fArray[19] = f13;
                    if (bl) {
                        f7 = fArray[3];
                        fArray[3] = fArray[13];
                        fArray[13] = f7;
                        f7 = fArray[8];
                        fArray[8] = fArray[18];
                        fArray[18] = f7;
                    }
                    if (bl2) {
                        f7 = fArray[4];
                        fArray[4] = fArray[14];
                        fArray[14] = f7;
                        f7 = fArray[9];
                        fArray[9] = fArray[19];
                        fArray[19] = f7;
                    }
                    if (n13 != 0) {
                        switch (n13) {
                            case 1: {
                                f7 = fArray[4];
                                fArray[4] = fArray[9];
                                fArray[9] = fArray[14];
                                fArray[14] = fArray[19];
                                fArray[19] = f7;
                                float f16 = fArray[3];
                                fArray[3] = fArray[8];
                                fArray[8] = fArray[13];
                                fArray[13] = fArray[18];
                                fArray[18] = f16;
                                break;
                            }
                            case 2: {
                                f7 = fArray[3];
                                fArray[3] = fArray[13];
                                fArray[13] = f7;
                                f7 = fArray[8];
                                fArray[8] = fArray[18];
                                fArray[18] = f7;
                                float f16 = fArray[4];
                                fArray[4] = fArray[14];
                                fArray[14] = f16;
                                f16 = fArray[9];
                                fArray[9] = fArray[19];
                                fArray[19] = f16;
                                break;
                            }
                            case 3: {
                                f7 = fArray[4];
                                fArray[4] = fArray[19];
                                fArray[19] = fArray[14];
                                fArray[14] = fArray[9];
                                fArray[9] = f7;
                                float f16 = fArray[3];
                                fArray[3] = fArray[18];
                                fArray[18] = fArray[13];
                                fArray[13] = fArray[8];
                                fArray[8] = f16;
                            }
                        }
                    }
                    this.batch.draw(lgTextureRegion2.getInternalObject().getTexture(), fArray, 0, 20);
                }
                f6 += f2;
                ++n11;
            }
            f4 -= f3;
            --n9;
        }
    }
}

