/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class BSpline<T extends Vector<T>>
implements Path<T> {
    public T[] controlPoints;
    public Array<T> knots;
    public int degree;
    public boolean continuous;
    public int spanCount;
    private T a;
    private T b;
    private T c;

    public static <T extends Vector<T>> T cubic(T out, float t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)BSpline.cubic(out, (int)n2, (float)(f -= (float)n2), points, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T cubic_derivative(T out, float t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)BSpline.cubic(out, (int)n2, (float)(f -= (float)n2), points, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T cubic(T out, int i, float u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        float f = 1.0f - u;
        float f2 = u;
        float f3 = f2 * f2;
        float f4 = f3 * u;
        out.set(points[i]).scl((float)((3.0f * f4 - 6.0f * f3 + 4.0f) * 0.16666667f));
        if (continuous || i > 0) {
            float f5 = f;
            out.add(tmp.set(points[(n + i - 1) % n]).scl((float)(f5 * f5 * f * 0.16666667f)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((float)((-3.0f * f4 + 3.0f * f3 + 3.0f * u + 1.0f) * 0.16666667f)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((float)(f4 * 0.16666667f)));
        }
        return (T)out;
    }

    public static <T extends Vector<T>> T cubic_derivative(T out, int i, float u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        float f = 1.0f - u;
        float f2 = u;
        float f3 = f2 * f2;
        out.set(points[i]).scl((float)(1.5f * f3 - 2.0f * u));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((float)(-0.5f * f * f)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((float)(-1.5f * f3 + u + 0.5f)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((float)(0.5f * f3)));
        }
        return (T)out;
    }

    public static <T extends Vector<T>> T calculate(T out, float t, T[] points, int degree, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - degree;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)BSpline.calculate(out, (int)n2, (float)(f -= (float)n2), points, (int)degree, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T derivative(T out, float t, T[] points, int degree, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - degree;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)BSpline.derivative(out, (int)n2, (float)(f -= (float)n2), points, (int)degree, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T calculate(T out, int i, float u, T[] points, int degree, boolean continuous, T tmp) {
        switch (degree) {
            case 3: {
                return (T)BSpline.cubic(out, (int)i, (float)u, points, (boolean)continuous, tmp);
            }
        }
        return out;
    }

    public static <T extends Vector<T>> T derivative(T out, int i, float u, T[] points, int degree, boolean continuous, T tmp) {
        switch (degree) {
            case 3: {
                return (T)BSpline.cubic_derivative(out, (int)i, (float)u, points, (boolean)continuous, tmp);
            }
        }
        return out;
    }

    public BSpline() {
    }

    public BSpline(T[] controlPoints, int degree, boolean continuous) {
        this.set((Vector[])controlPoints, degree, continuous);
    }

    public BSpline set(T[] controlPoints, int degree, boolean continuous) {
        if (this.a == null) {
            this.a = controlPoints[0].cpy();
        }
        if (this.b == null) {
            this.b = controlPoints[0].cpy();
        }
        if (this.c == null) {
            this.c = controlPoints[0].cpy();
        }
        this.controlPoints = controlPoints;
        this.degree = degree;
        this.continuous = continuous;
        int n = this.spanCount = continuous ? controlPoints.length : controlPoints.length - degree;
        if (this.knots == null) {
            this.knots = new Array(this.spanCount);
        } else {
            this.knots.clear();
            this.knots.ensureCapacity(this.spanCount);
        }
        int n2 = 0;
        while (n2 < this.spanCount) {
            this.knots.add(BSpline.calculate(controlPoints[0].cpy(), (int)(continuous ? n2 : (int)((float)n2 + 0.5f * (float)degree)), (float)0.0f, controlPoints, (int)degree, (boolean)continuous, this.a));
            ++n2;
        }
        return this;
    }

    @Override
    public T valueAt(T out, float t) {
        int n = this.spanCount;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return this.valueAt(out, n2, f -= (float)n2);
    }

    public T valueAt(T out, int span, float u) {
        return (T)BSpline.calculate(out, (int)(this.continuous ? span : span + (int)((float)this.degree * 0.5f)), (float)u, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.a);
    }

    @Override
    public T derivativeAt(T out, float t) {
        int n = this.spanCount;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return this.derivativeAt(out, n2, f -= (float)n2);
    }

    public T derivativeAt(T out, int span, float u) {
        return (T)BSpline.derivative(out, (int)(this.continuous ? span : span + (int)((float)this.degree * 0.5f)), (float)u, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.a);
    }

    public int nearest(T in) {
        return this.nearest(in, 0, this.spanCount);
    }

    public int nearest(T in, int start, int count) {
        while (start < 0) {
            start += this.spanCount;
        }
        int n = start % this.spanCount;
        float f = in.dst2((Vector)((Vector)this.knots.get(n)));
        int n2 = 1;
        while (n2 < count) {
            float f2;
            int n3 = (start + n2) % this.spanCount;
            float f3 = in.dst2((Vector)((Vector)this.knots.get(n3)));
            if (f2 < f) {
                f = f3;
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public float approximate(T v) {
        return this.approximate(v, this.nearest(v));
    }

    public float approximate(T in, int start, int count) {
        return this.approximate(in, this.nearest(in, start, count));
    }

    public float approximate(T in, int near) {
        Vector vector;
        Vector vector2;
        Vector vector3;
        int n = near;
        Vector vector4 = (Vector)this.knots.get(near);
        Vector vector5 = (Vector)this.knots.get(near > 0 ? near - 1 : this.spanCount - 1);
        Vector vector6 = (Vector)this.knots.get((near + 1) % this.spanCount);
        float f = in.dst2((Vector)vector5);
        if (in.dst2((Vector)vector6) < f) {
            vector3 = vector4;
            vector2 = vector6;
            vector = in;
        } else {
            vector3 = vector5;
            vector2 = vector4;
            vector = in;
            n = near > 0 ? near - 1 : this.spanCount - 1;
        }
        float f2 = vector3.dst2(vector2);
        float f3 = vector.dst2((Vector)vector2);
        float f4 = vector.dst2((Vector)vector3);
        float f5 = (float)Math.sqrt(f2);
        float f6 = (f3 + f2 - f4) / (2.0f * f5);
        float f7 = MathUtils.clamp((f5 - f6) / f5, 0.0f, 1.0f);
        return ((float)n + f7) / (float)this.spanCount;
    }

    @Override
    public float locate(T v) {
        return this.approximate(v);
    }

    @Override
    public float approxLength(int samples) {
        float f = 0.0f;
        int n = 0;
        while (n < samples) {
            this.b.set(this.c);
            BSpline bSpline = this;
            bSpline.valueAt(bSpline.c, (float)n / ((float)samples - 1.0f));
            if (n > 0) {
                f += this.b.dst(this.c);
            }
            ++n;
        }
        return f;
    }
}

