/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class Bezier<T extends Vector<T>>
implements Path<T> {
    public Array<T> points = new Array();
    private T a;
    private T b;
    private T c;

    public static <T extends Vector<T>> T linear(T out, float t, T p0, T p1, T tmp) {
        return out.set(p0).scl((float)(1.0f - t)).add(tmp.set(p1).scl((float)t));
    }

    public static <T extends Vector<T>> T linear_derivative(T out, float t, T p0, T p1, T tmp) {
        return out.set(p1).sub(p0);
    }

    public static <T extends Vector<T>> T quadratic(T out, float t, T p0, T p1, T p2, T tmp) {
        float f;
        float f2 = f = 1.0f - t;
        float f3 = t;
        return out.set(p0).scl((float)(f2 * f2)).add(tmp.set(p1).scl((float)(2.0f * f * t))).add(tmp.set(p2).scl((float)(f3 * f3)));
    }

    public static <T extends Vector<T>> T quadratic_derivative(T out, float t, T p0, T p1, T p2, T tmp) {
        return out.set(p1).sub(p0).scl((float)2.0f).scl(1.0f - t).add(tmp.set(p2).sub(p1).scl((float)t).scl(2.0f));
    }

    public static <T extends Vector<T>> T cubic(T out, float t, T p0, T p1, T p2, T p3, T tmp) {
        float f = 1.0f - t;
        float f2 = f * f;
        float f3 = t;
        float f4 = f3 * f3;
        return out.set(p0).scl((float)(f2 * f)).add(tmp.set(p1).scl((float)(3.0f * f2 * t))).add(tmp.set(p2).scl((float)(3.0f * f * f4))).add(tmp.set(p3).scl((float)(f4 * t)));
    }

    public static <T extends Vector<T>> T cubic_derivative(T out, float t, T p0, T p1, T p2, T p3, T tmp) {
        float f = 1.0f - t;
        float f2 = f * f;
        float f3 = t;
        float f4 = f3 * f3;
        return out.set(p1).sub(p0).scl((float)(f2 * 3.0f)).add(tmp.set(p2).sub(p1).scl((float)(f * t * 6.0f))).add(tmp.set(p3).sub(p2).scl((float)(f4 * 3.0f)));
    }

    public Bezier() {
    }

    public Bezier(T ... points) {
        this.set((Vector[])points);
    }

    public Bezier(T[] points, int offset, int length) {
        this.set((Vector[])points, offset, length);
    }

    public Bezier(Array<T> points, int offset, int length) {
        this.set(points, offset, length);
    }

    public Bezier set(T ... points) {
        return this.set((Vector[])points, 0, points.length);
    }

    public Bezier set(T[] points, int offset, int length) {
        if (length < 2 || length > 4) {
            throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
        }
        if (this.a == null) {
            this.a = points[0].cpy();
        }
        if (this.b == null) {
            this.b = points[0].cpy();
        }
        if (this.c == null) {
            this.c = points[0].cpy();
        }
        this.points.clear();
        this.points.addAll(points, offset, length);
        return this;
    }

    public Bezier set(Array<T> points, int offset, int length) {
        if (length < 2 || length > 4) {
            throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
        }
        if (this.a == null) {
            this.a = ((Vector)points.get(0)).cpy();
        }
        this.points.clear();
        this.points.addAll(points, offset, length);
        return this;
    }

    @Override
    public T valueAt(T out, float t) {
        int n = this.points.size;
        if (n == 2) {
            Bezier.linear(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), this.a);
        } else if (n == 3) {
            Bezier.quadratic(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.a);
        } else if (n == 4) {
            Bezier.cubic(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.a);
        }
        return out;
    }

    @Override
    public T derivativeAt(T out, float t) {
        int n = this.points.size;
        if (n == 2) {
            Bezier.linear_derivative(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), this.a);
        } else if (n == 3) {
            Bezier.quadratic_derivative(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.a);
        } else if (n == 4) {
            Bezier.cubic_derivative(out, t, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.a);
        }
        return out;
    }

    @Override
    public float approximate(T v) {
        Vector vector = (Vector)this.points.get(0);
        Vector vector2 = (Vector)this.points.get(this.points.size - 1);
        Vector vector3 = v;
        float f = vector.dst2(vector2);
        float f2 = vector3.dst2((Vector)vector2);
        float f3 = vector3.dst2((Vector)vector);
        float f4 = (float)Math.sqrt(f);
        float f5 = (f2 + f - f3) / (2.0f * f4);
        return MathUtils.clamp((f4 - f5) / f4, 0.0f, 1.0f);
    }

    @Override
    public float locate(T v) {
        return this.approximate(v);
    }

    @Override
    public float approxLength(int samples) {
        float f = 0.0f;
        int n = 0;
        while (n < samples) {
            this.b.set(this.c);
            Bezier bezier = this;
            bezier.valueAt(bezier.c, (float)n / ((float)samples - 1.0f));
            if (n > 0) {
                f += this.b.dst(this.c);
            }
            ++n;
        }
        return f;
    }
}

