/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;

@BA.Hide
public class CatmullRomSpline<T extends Vector<T>>
implements Path<T> {
    public T[] controlPoints;
    public boolean continuous;
    public int spanCount;
    private T a;
    private T b;
    private T c;

    public static <T extends Vector<T>> T calculate(T out, float t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)CatmullRomSpline.calculate(out, (int)n2, (float)(f -= (float)n2), points, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T calculate(T out, int i, float u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        float f = u;
        float f2 = f * f;
        float f3 = f2 * u;
        out.set(points[i]).scl((float)(1.5f * f3 - 2.5f * f2 + 1.0f));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((float)(-0.5f * f3 + f2 - 0.5f * u)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((float)(-1.5f * f3 + 2.0f * f2 + 0.5f * u)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((float)(0.5f * f3 - 0.5f * f2)));
        }
        return (T)out;
    }

    public static <T extends Vector<T>> T derivative(T out, float t, T[] points, boolean continuous, T tmp) {
        int n = continuous ? points.length : points.length - 3;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return (T)CatmullRomSpline.derivative(out, (int)n2, (float)(f -= (float)n2), points, (boolean)continuous, tmp);
    }

    public static <T extends Vector<T>> T derivative(T out, int i, float u, T[] points, boolean continuous, T tmp) {
        int n = points.length;
        float f = u;
        float f2 = f * f;
        out.set(points[i]).scl((float)(-u * 5.0f + f2 * 4.5f));
        if (continuous || i > 0) {
            out.add(tmp.set(points[(n + i - 1) % n]).scl((float)(-0.5f + u * 2.0f - f2 * 1.5f)));
        }
        if (continuous || i < n - 1) {
            out.add(tmp.set(points[(i + 1) % n]).scl((float)(0.5f + u * 4.0f - f2 * 4.5f)));
        }
        if (continuous || i < n - 2) {
            out.add(tmp.set(points[(i + 2) % n]).scl((float)(-u + f2 * 1.5f)));
        }
        return (T)out;
    }

    public CatmullRomSpline() {
    }

    public CatmullRomSpline(T[] controlPoints, boolean continuous) {
        this.set((Vector[])controlPoints, continuous);
    }

    public CatmullRomSpline set(T[] controlPoints, boolean continuous) {
        if (this.a == null) {
            this.a = controlPoints[0].cpy();
        }
        if (this.b == null) {
            this.b = controlPoints[0].cpy();
        }
        if (this.c == null) {
            this.c = controlPoints[0].cpy();
        }
        this.controlPoints = controlPoints;
        this.continuous = continuous;
        this.spanCount = continuous ? controlPoints.length : controlPoints.length - 3;
        return this;
    }

    @Override
    public T valueAt(T out, float t) {
        int n = this.spanCount;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return this.valueAt(out, n2, f -= (float)n2);
    }

    public T valueAt(T out, int span, float u) {
        return (T)CatmullRomSpline.calculate(out, (int)(this.continuous ? span : span + 1), (float)u, this.controlPoints, (boolean)this.continuous, this.a);
    }

    @Override
    public T derivativeAt(T out, float t) {
        int n = this.spanCount;
        float f = t * (float)n;
        int n2 = t >= 1.0f ? n - 1 : (int)f;
        return this.derivativeAt(out, n2, f -= (float)n2);
    }

    public T derivativeAt(T out, int span, float u) {
        return (T)CatmullRomSpline.derivative(out, (int)(this.continuous ? span : span + 1), (float)u, this.controlPoints, (boolean)this.continuous, this.a);
    }

    public int nearest(T in) {
        return this.nearest(in, 0, this.spanCount);
    }

    public int nearest(T in, int start, int count) {
        while (start < 0) {
            start += this.spanCount;
        }
        int n = start % this.spanCount;
        float f = in.dst2(this.controlPoints[n]);
        int n2 = 1;
        while (n2 < count) {
            float f2;
            int n3 = (start + n2) % this.spanCount;
            float f3 = in.dst2(this.controlPoints[n3]);
            if (f2 < f) {
                f = f3;
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public float approximate(T v) {
        return this.approximate(v, this.nearest(v));
    }

    public float approximate(T in, int start, int count) {
        return this.approximate(in, this.nearest(in, start, count));
    }

    public float approximate(T in, int near) {
        T t;
        T t2;
        T t3;
        int n = near;
        T t4 = this.controlPoints[near];
        T t5 = this.controlPoints[near > 0 ? near - 1 : this.spanCount - 1];
        T t6 = this.controlPoints[(near + 1) % this.spanCount];
        float f = in.dst2(t5);
        if (in.dst2(t6) < f) {
            t3 = t4;
            t2 = t6;
            t = in;
        } else {
            t3 = t5;
            t2 = t4;
            t = in;
            n = near > 0 ? near - 1 : this.spanCount - 1;
        }
        float f2 = t3.dst2(t2);
        float f3 = t.dst2(t2);
        float f4 = t.dst2(t3);
        float f5 = (float)Math.sqrt(f2);
        float f6 = (f3 + f2 - f4) / (2.0f * f5);
        float f7 = MathUtils.clamp((f5 - f6) / f5, 0.0f, 1.0f);
        return ((float)n + f7) / (float)this.spanCount;
    }

    @Override
    public float locate(T v) {
        return this.approximate(v);
    }

    @Override
    public float approxLength(int samples) {
        float f = 0.0f;
        int n = 0;
        while (n < samples) {
            this.b.set(this.c);
            CatmullRomSpline catmullRomSpline = this;
            catmullRomSpline.valueAt(catmullRomSpline.c, (float)n / ((float)samples - 1.0f));
            if (n > 0) {
                f += this.b.dst(this.c);
            }
            ++n;
        }
        return f;
    }
}

