/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathCircle")
public class Circle
implements Serializable {
    public float x;
    public float y;
    public float radius;

    public Circle() {
    }

    public Circle(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    public Circle(Vector2 position, float radius) {
        this.x = position.x;
        this.y = position.y;
        this.radius = radius;
    }

    public Circle(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public Circle(Vector2 center, Vector2 edge) {
        this.x = center.x;
        this.y = center.y;
        this.radius = Vector2.len_xy(center.x - edge.x, center.y - edge.y);
    }

    public void Set(float x, float y, float radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    @BA.Hide
    public void set(Vector2 position, float radius) {
        this.x = position.x;
        this.y = position.y;
        this.radius = radius;
    }

    public void Set2(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public void Set3(Vector2 center, Vector2 edge) {
        this.x = center.x;
        this.y = center.y;
        this.radius = Vector2.len_xy(center.x - edge.x, center.y - edge.y);
    }

    public void SetPosition2(Vector2 position) {
        this.x = position.x;
        this.y = position.y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    protected void setX(float x) {
        this.x = x;
    }

    protected void setY(float y) {
        this.y = y;
    }

    protected void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean contains(float x, float y) {
        x = this.x - x;
        y = this.y - y;
        float f = x;
        float f2 = y;
        return f * f + f2 * f2 <= this.radius * this.radius;
    }

    @BA.Hide
    public boolean contains(Vector2 point) {
        float f = this.x - point.x;
        float f2 = this.y - point.y;
        float f3 = f;
        float f4 = f2;
        return f3 * f3 + f4 * f4 <= this.radius * this.radius;
    }

    public boolean contains2(Circle c2) {
        float f;
        float f2 = this.radius - c2.radius;
        if (f < 0.0f) {
            return false;
        }
        float f3 = this.x - c2.x;
        float f4 = this.y - c2.y;
        float f5 = f3;
        float f6 = f4;
        float f7 = f5 * f5 + f6 * f6;
        float f8 = this.radius + c2.radius;
        float f9 = f2;
        if (!(f9 * f9 < f7)) {
            float f10 = f8;
            if (f7 < f10 * f10) {
                return true;
            }
        }
        return false;
    }

    public boolean overlaps(Circle c2) {
        float f;
        float f2 = this.x - c2.x;
        float f3 = this.y - c2.y;
        float f4 = f2;
        float f5 = f3;
        float f6 = f4 * f4 + f5 * f5;
        float f7 = f = this.radius + c2.radius;
        return f6 < f7 * f7;
    }

    public String toString() {
        return String.valueOf(this.x) + "," + this.y + "," + this.radius;
    }

    public float circumference() {
        return this.radius * ((float)Math.PI * 2);
    }

    public float area() {
        return this.radius * this.radius * (float)Math.PI;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Circle circle = (Circle)o;
        return this.x == circle.x && this.y == circle.y && this.radius == circle.radius;
    }

    public int hashCode() {
        int n = 41 + NumberUtils.floatToRawIntBits(this.radius);
        n = 41 * n + NumberUtils.floatToRawIntBits(this.x);
        return 41 * n + NumberUtils.floatToRawIntBits(this.y);
    }
}

