/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathEllipse")
public class Ellipse
implements Serializable {
    public float x;
    public float y;
    public float width;
    public float height;
    private static final long serialVersionUID = 7381533206532032099L;

    public Ellipse() {
    }

    public Ellipse(Ellipse ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.width = ellipse.width;
        this.height = ellipse.height;
    }

    public Ellipse(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Ellipse(Vector2 position, float width, float height) {
        this.x = position.x;
        this.y = position.y;
        this.width = width;
        this.height = height;
    }

    public Ellipse(Vector2 position, Vector2 size) {
        this.x = position.x;
        this.y = position.y;
        this.width = size.x;
        this.height = size.y;
    }

    public Ellipse(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.width = circle.radius;
        this.height = circle.radius;
    }

    public boolean contains(float x, float y) {
        float f = x -= this.x;
        float f2 = y -= this.y;
        return f * f / (this.width * 0.5f * this.width * 0.5f) + f2 * f2 / (this.height * 0.5f * this.height * 0.5f) <= 1.0f;
    }

    @BA.Hide
    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public void Set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void Set2(Ellipse ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.width = ellipse.width;
        this.height = ellipse.height;
    }

    public void Set3(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.width = circle.radius;
        this.height = circle.radius;
    }

    @BA.Hide
    public void set(Vector2 position, Vector2 size) {
        this.x = position.x;
        this.y = position.y;
        this.width = size.x;
        this.height = size.y;
    }

    public Ellipse setPosition2(Vector2 position) {
        this.x = position.x;
        this.y = position.y;
        return this;
    }

    public Ellipse setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Ellipse setSize(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public float area() {
        return (float)Math.PI * (this.width * this.height) / 4.0f;
    }

    public float circumference() {
        float f = this.width / 2.0f;
        float f2 = this.height / 2.0f;
        if (f * 3.0f > f2 || f2 * 3.0f > f) {
            return (float)(3.1415927410125732 * ((double)(3.0f * (f + f2)) - Math.sqrt((3.0f * f + f2) * (f + 3.0f * f2))));
        }
        float f3 = f;
        float f4 = f2;
        return (float)(6.2831854820251465 * Math.sqrt((f3 * f3 + f4 * f4) / 2.0f));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Ellipse ellipse = (Ellipse)o;
        return this.x == ellipse.x && this.y == ellipse.y && this.width == ellipse.width && this.height == ellipse.height;
    }

    public int hashCode() {
        int n = 53 + NumberUtils.floatToRawIntBits(this.height);
        n = 53 * n + NumberUtils.floatToRawIntBits(this.width);
        n = 53 * n + NumberUtils.floatToRawIntBits(this.x);
        return 53 * n + NumberUtils.floatToRawIntBits(this.y);
    }
}

