/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

@BA.ShortName(value="lgMathFrustum")
public class Frustum {
    protected static final Vector3[] clipSpacePlanePoints = new Vector3[]{new Vector3(-1.0f, -1.0f, -1.0f), new Vector3(1.0f, -1.0f, -1.0f), new Vector3(1.0f, 1.0f, -1.0f), new Vector3(-1.0f, 1.0f, -1.0f), new Vector3(-1.0f, -1.0f, 1.0f), new Vector3(1.0f, -1.0f, 1.0f), new Vector3(1.0f, 1.0f, 1.0f), new Vector3(-1.0f, 1.0f, 1.0f)};
    protected static final float[] clipSpacePlanePointsArray = new float[24];
    public final Plane[] planes = new Plane[6];
    public final Vector3[] planePoints = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3()};
    protected final float[] planePointsArray = new float[24];

    static {
        int n = 0;
        Vector3[] vector3Array = clipSpacePlanePoints;
        int n2 = clipSpacePlanePoints.length;
        int n3 = 0;
        while (n3 < n2) {
            Vector3 vector3 = vector3Array[n3];
            Frustum.clipSpacePlanePointsArray[n++] = vector3.x;
            Frustum.clipSpacePlanePointsArray[n++] = vector3.y;
            Frustum.clipSpacePlanePointsArray[n++] = vector3.z;
            ++n3;
        }
    }

    public Frustum() {
        int n = 0;
        while (n < 6) {
            this.planes[n] = new Plane(new Vector3(), 0.0f);
            ++n;
        }
    }

    public void update(Matrix4 inverseProjectionView) {
        System.arraycopy(clipSpacePlanePointsArray, 0, this.planePointsArray, 0, clipSpacePlanePointsArray.length);
        Matrix4.prj(inverseProjectionView.val, this.planePointsArray, 0, 8, 3);
        int n = 0;
        int n2 = 0;
        while (n < 8) {
            Vector3 vector3 = this.planePoints[n];
            this.planePoints[n].x = this.planePointsArray[n2++];
            vector3.y = this.planePointsArray[n2++];
            vector3.z = this.planePointsArray[n2++];
            ++n;
        }
        this.planes[0].Set2(this.planePoints[1], this.planePoints[0], this.planePoints[2]);
        this.planes[1].Set2(this.planePoints[4], this.planePoints[5], this.planePoints[7]);
        this.planes[2].Set2(this.planePoints[0], this.planePoints[4], this.planePoints[3]);
        this.planes[3].Set2(this.planePoints[5], this.planePoints[1], this.planePoints[6]);
        this.planes[4].Set2(this.planePoints[2], this.planePoints[3], this.planePoints[6]);
        this.planes[5].Set2(this.planePoints[4], this.planePoints[0], this.planePoints[1]);
    }

    public boolean pointInFrustum(Vector3 point) {
        int n = 0;
        while (n < this.planes.length) {
            if (this.planes[n].testPoint(point) == Plane.PlaneSide.Back) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean pointInFrustum2(float x, float y, float z) {
        int n = 0;
        while (n < this.planes.length) {
            if (this.planes[n].testPoint(x, y, z) == Plane.PlaneSide.Back) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sphereInFrustum(Vector3 center, float radius) {
        int n = 0;
        while (n < 6) {
            if (this.planes[n].normal.x * center.x + this.planes[n].normal.y * center.y + this.planes[n].normal.z * center.z < -radius - this.planes[n].d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sphereInFrustum2(float x, float y, float z, float radius) {
        int n = 0;
        while (n < 6) {
            if (this.planes[n].normal.x * x + this.planes[n].normal.y * y + this.planes[n].normal.z * z < -radius - this.planes[n].d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar(Vector3 center, float radius) {
        int n = 2;
        while (n < 6) {
            if (this.planes[n].normal.x * center.x + this.planes[n].normal.y * center.y + this.planes[n].normal.z * center.z < -radius - this.planes[n].d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar2(float x, float y, float z, float radius) {
        int n = 2;
        while (n < 6) {
            if (this.planes[n].normal.x * x + this.planes[n].normal.y * y + this.planes[n].normal.z * z < -radius - this.planes[n].d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean boundsInFrustum(BoundingBox bounds) {
        Vector3[] vector3Array = bounds.getCorners();
        int n = vector3Array.length;
        int n2 = 0;
        int n3 = this.planes.length;
        while (n2 < n3) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (this.planes[n2].testPoint(vector3Array[n5]) == Plane.PlaneSide.Back) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 == 8) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

