/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;

@BA.ShortName(value="lgMathGeometryUtils")
public final class GeometryUtils {
    private static final Vector2 a = new Vector2();
    private static final Vector2 b = new Vector2();
    private static final Vector2 c = new Vector2();

    public static Vector2 barycentric(Vector2 p, Vector2 a2, Vector2 b2, Vector2 c2, Vector2 barycentricOut) {
        Vector2 vector2 = a.set(b2).sub(a2);
        Vector2 vector22 = b.set(c2).sub(a2);
        Vector2 vector23 = c.set(p).sub(a2);
        Vector2 vector24 = vector2;
        float f = vector24.dot(vector24);
        float f2 = vector2.dot(vector22);
        Vector2 vector25 = vector22;
        float f3 = vector25.dot(vector25);
        float f4 = vector23.dot(vector2);
        float f5 = vector23.dot(vector22);
        float f6 = f2;
        float f7 = f * f3 - f6 * f6;
        barycentricOut.x = (f3 * f4 - f2 * f5) / f7;
        barycentricOut.y = (f * f5 - f2 * f4) / f7;
        return barycentricOut;
    }

    public static float lowestPositiveRoot(float a2, float b2, float c2) {
        float f;
        float f2;
        float f3;
        float f4 = b2;
        float f5 = f4 * f4 - 4.0f * a2 * c2;
        if (f3 < 0.0f) {
            return Float.NaN;
        }
        float f6 = (float)Math.sqrt(f5);
        float f7 = (-b2 - f6) * (f2 = 1.0f / (2.0f * a2));
        if (f7 > (f = (-b2 + f6) * f2)) {
            float f8 = f;
            f = f7;
            f7 = f8;
        }
        if (f7 > 0.0f) {
            return f7;
        }
        if (f > 0.0f) {
            return f;
        }
        return Float.NaN;
    }

    public static boolean colinear(float x1, float y1, float x2, float y2, float x3, float y3) {
        float f = x3 - x2;
        float f2 = y2 - y1;
        float f3 = x2 - x1;
        float f4 = y3 - y2;
        return Math.abs(f * f2 - f3 * f4) < 1.0E-6f;
    }

    public static Vector2 triangleCentroid(float x1, float y1, float x2, float y2, float x3, float y3, Vector2 centroid) {
        centroid.x = (x1 + x2 + x3) / 3.0f;
        centroid.y = (y1 + y2 + y3) / 3.0f;
        return centroid;
    }

    public static float triangleArea(float x1, float y1, float x2, float y2, float x3, float y3) {
        return Math.abs((x1 - x3) * (y2 - y1) - (x1 - x2) * (y3 - y1)) * 0.5f;
    }

    public static Vector2 quadrilateralCentroid(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vector2 centroid) {
        float f = (x1 + x2 + x3) / 3.0f;
        float f2 = (y1 + y2 + y3) / 3.0f;
        float f3 = (x1 + x4 + x3) / 3.0f;
        float f4 = (y1 + y4 + y3) / 3.0f;
        float f5 = f;
        centroid.x = f5 - (f5 - f3) / 2.0f;
        float f6 = f2;
        centroid.y = f6 - (f6 - f4) / 2.0f;
        return centroid;
    }

    public static Vector2 polygonCentroid(float[] polygon, int offset, int count, Vector2 centroid) {
        float f;
        float f2;
        float f3;
        float f4;
        if (count < 6) {
            throw new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        int n = offset;
        int n2 = offset + count - 2;
        while (n < n2) {
            f4 = polygon[n];
            f3 = polygon[n + 1];
            f2 = polygon[n + 2];
            f = polygon[n + 3];
            float f8 = f4 * f - f2 * f3;
            f7 += f8;
            f5 += (f4 + f2) * f8;
            f6 += (f3 + f) * f8;
            n += 2;
        }
        float f9 = polygon[n];
        f4 = polygon[n + 1];
        f3 = polygon[offset];
        f2 = polygon[offset + 1];
        f = f9 * f2 - f3 * f4;
        f5 += (f9 + f3) * f;
        f6 += (f4 + f2) * f;
        if ((f7 += f) == 0.0f) {
            centroid.x = 0.0f;
            centroid.y = 0.0f;
        } else {
            centroid.x = f5 / (6.0f * (f7 *= 0.5f));
            centroid.y = f6 / (6.0f * f7);
        }
        return centroid;
    }

    public static float polygonArea(float[] polygon, int offset, int count) {
        float f = 0.0f;
        int n = offset;
        int n2 = offset + count;
        while (n < n2) {
            int n3;
            int n4 = n;
            int n5 = n + 1;
            int n6 = (n + 2) % n2;
            if (n6 < offset) {
                n6 += offset;
            }
            if ((n3 = (n + 3) % n2) < offset) {
                n3 += offset;
            }
            f = f + polygon[n4] * polygon[n3] - polygon[n6] * polygon[n5];
            n += 2;
        }
        return f * 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureCCW(float[] polygon) {
        float f;
        float f2;
        float f3;
        float f4;
        int n = polygon.length;
        float[] fArray = polygon;
        if (n <= 2) return;
        float f5 = 0.0f;
        int n2 = 0;
        int n3 = 0 + n - 3;
        while (n2 < n3) {
            f4 = fArray[n2];
            f3 = fArray[n2 + 1];
            f2 = fArray[n2 + 2];
            f = fArray[n2 + 3];
            f5 += f4 * f - f2 * f3;
            n2 += 2;
        }
        f4 = fArray[n - 2];
        f = fArray[1];
        f2 = fArray[0];
        f3 = fArray[n - 1];
        if (!(f5 + f4 * f - f2 * f3 < 0.0f)) return;
        boolean bl = true;
        if (!bl) {
            return;
        }
        int n4 = polygon.length - 2;
        int n5 = 0;
        int n6 = polygon.length / 2;
        while (n5 < n6) {
            int n7 = n4 - n5;
            float f6 = polygon[n5];
            float f7 = polygon[n5 + 1];
            polygon[n5] = polygon[n7];
            polygon[n5 + 1] = polygon[n7 + 1];
            polygon[n7] = f6;
            polygon[n7 + 1] = f7;
            n5 += 2;
        }
    }
}

