/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;

@BA.ShortName(value="lgMathInterpolation")
public class Interpolation {
    public static final Interpolation linear = new Interpolation(){

        @Override
        public final float apply(float a2) {
            return a2;
        }
    };
    public static final Interpolation fade = new Interpolation(){

        @Override
        public final float apply(float a2) {
            float f = a2;
            float f2 = a2;
            return MathUtils.clamp(f * f * a2 * (f2 * (f2 * 6.0f - 15.0f) + 10.0f), 0.0f, 1.0f);
        }
    };
    public static final Pow pow2 = new Pow(2);
    public static final PowIn pow2In = new PowIn(2);
    public static final PowOut pow2Out = new PowOut(2);
    public static final Pow pow3 = new Pow(3);
    public static final PowIn pow3In = new PowIn(3);
    public static final PowOut pow3Out = new PowOut(3);
    public static final Pow pow4 = new Pow(4);
    public static final PowIn pow4In = new PowIn(4);
    public static final PowOut pow4Out = new PowOut(4);
    public static final Pow pow5 = new Pow(5);
    public static final PowIn pow5In = new PowIn(5);
    public static final PowOut pow5Out = new PowOut(5);
    public static final Interpolation sine = new Interpolation(){

        @Override
        public final float apply(float a2) {
            return (1.0f - MathUtils.cos(a2 * (float)Math.PI)) / 2.0f;
        }
    };
    public static final Interpolation sineIn = new Interpolation(){

        @Override
        public final float apply(float a2) {
            return 1.0f - MathUtils.cos(a2 * (float)Math.PI / 2.0f);
        }
    };
    public static final Interpolation sineOut = new Interpolation(){

        @Override
        public final float apply(float a2) {
            return MathUtils.sin(a2 * (float)Math.PI / 2.0f);
        }
    };
    public static final Exp exp10 = new Exp(2.0f, 10.0f);
    public static final ExpIn exp10In = new ExpIn(2.0f, 10.0f);
    public static final ExpOut exp10Out = new ExpOut(2.0f, 10.0f);
    public static final Exp exp5 = new Exp(2.0f, 5.0f);
    public static final ExpIn exp5In = new ExpIn(2.0f, 5.0f);
    public static final ExpOut exp5Out = new ExpOut(2.0f, 5.0f);
    public static final Interpolation circle = new Interpolation(){

        @Override
        public final float apply(float a2) {
            if (a2 <= 0.5f) {
                float f = a2 *= 2.0f;
                return (1.0f - (float)Math.sqrt(1.0f - f * f)) / 2.0f;
            }
            float f = a2 = (a2 - 1.0f) * 2.0f;
            return ((float)Math.sqrt(1.0f - f * f) + 1.0f) / 2.0f;
        }
    };
    public static final Interpolation circleIn = new Interpolation(){

        @Override
        public final float apply(float a2) {
            float f = a2;
            return 1.0f - (float)Math.sqrt(1.0f - f * f);
        }
    };
    public static final Interpolation circleOut = new Interpolation(){

        @Override
        public final float apply(float a2) {
            float f = a2 -= 1.0f;
            return (float)Math.sqrt(1.0f - f * f);
        }
    };
    public static final Elastic elastic = new Elastic(2.0f, 10.0f, 7, 1.0f);
    public static final ElasticIn elasticIn = new ElasticIn(2.0f, 10.0f, 6, 1.0f);
    public static final ElasticOut elasticOut = new ElasticOut(2.0f, 10.0f, 7, 1.0f);
    public static final Swing swing = new Swing(1.5f);
    public static final SwingIn swingIn = new SwingIn(2.0f);
    public static final SwingOut swingOut = new SwingOut(2.0f);
    public static final Bounce bounce = new Bounce(4);
    public static final BounceIn bounceIn = new BounceIn(4);
    public static final BounceOut bounceOut = new BounceOut(4);

    public float apply(float Value2) {
        return Value2;
    }

    public float apply(float start, float end, float a2) {
        return start + (end - start) * this.apply(a2);
    }

    @BA.Hide
    public static class Bounce
    extends BounceOut {
        public Bounce(float[] widths, float[] heights) {
            super(widths, heights);
        }

        public Bounce(int bounces) {
            super(bounces);
        }

        private float a(float f) {
            float f2;
            float f3 = f + this.a[0] / 2.0f;
            if (f2 < this.a[0]) {
                return f3 / (this.a[0] / 2.0f) - 1.0f;
            }
            return super.apply(f);
        }

        @Override
        public float apply(float a2) {
            if (a2 <= 0.5f) {
                return (1.0f - this.a(1.0f - a2 * 2.0f)) / 2.0f;
            }
            return this.a(a2 * 2.0f - 1.0f) / 2.0f + 0.5f;
        }
    }

    @BA.Hide
    public static class BounceIn
    extends BounceOut {
        public BounceIn(float[] widths, float[] heights) {
            super(widths, heights);
        }

        public BounceIn(int bounces) {
            super(bounces);
        }

        @Override
        public float apply(float a2) {
            return 1.0f - super.apply(1.0f - a2);
        }
    }

    @BA.Hide
    public static class BounceOut
    extends Interpolation {
        final float[] a;
        private float[] b;

        public BounceOut(float[] widths, float[] heights) {
            if (widths.length != heights.length) {
                throw new IllegalArgumentException("Must be the same number of widths and heights.");
            }
            this.a = widths;
            this.b = heights;
        }

        public BounceOut(int bounces) {
            if (bounces < 2 || bounces > 5) {
                throw new IllegalArgumentException("bounces cannot be < 2 or > 5: ".concat(String.valueOf(bounces)));
            }
            this.a = new float[bounces];
            this.b = new float[bounces];
            this.b[0] = 1.0f;
            switch (bounces) {
                case 2: {
                    this.a[0] = 0.6f;
                    this.a[1] = 0.4f;
                    this.b[1] = 0.33f;
                    break;
                }
                case 3: {
                    this.a[0] = 0.4f;
                    this.a[1] = 0.4f;
                    this.a[2] = 0.2f;
                    this.b[1] = 0.33f;
                    this.b[2] = 0.1f;
                    break;
                }
                case 4: {
                    this.a[0] = 0.34f;
                    this.a[1] = 0.34f;
                    this.a[2] = 0.2f;
                    this.a[3] = 0.15f;
                    this.b[1] = 0.26f;
                    this.b[2] = 0.11f;
                    this.b[3] = 0.03f;
                    break;
                }
                case 5: {
                    this.a[0] = 0.3f;
                    this.a[1] = 0.3f;
                    this.a[2] = 0.2f;
                    this.a[3] = 0.1f;
                    this.a[4] = 0.1f;
                    this.b[1] = 0.45f;
                    this.b[2] = 0.3f;
                    this.b[3] = 0.15f;
                    this.b[4] = 0.06f;
                }
            }
            this.a[0] = this.a[0] * 2.0f;
        }

        @Override
        public float apply(float a2) {
            float f;
            a2 += this.a[0] / 2.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = 0;
            int n2 = this.a.length;
            while (n < n2) {
                f2 = this.a[n];
                if (a2 <= f2) {
                    f3 = this.b[n];
                    break;
                }
                a2 -= f2;
                ++n;
            }
            float f4 = f = 4.0f / f2 * f3 * (a2 /= f2);
            return 1.0f - (f4 - f4 * a2) * f2;
        }
    }

    @BA.Hide
    public static class Elastic
    extends Interpolation {
        final float a;
        final float b;
        final float c;
        final float d;

        public Elastic(float value, float power, int bounces, float scale) {
            this.a = value;
            this.b = power;
            this.c = scale;
            this.d = (float)bounces * (float)Math.PI * (float)(bounces % 2 == 0 ? 1 : -1);
        }

        @Override
        public float apply(float a2) {
            if (a2 <= 0.5f) {
                return (float)Math.pow(this.a, this.b * ((a2 *= 2.0f) - 1.0f)) * MathUtils.sin(a2 * this.d) * this.c / 2.0f;
            }
            a2 = (1.0f - a2) * 2.0f;
            return 1.0f - (float)Math.pow(this.a, this.b * (a2 - 1.0f)) * MathUtils.sin(a2 * this.d) * this.c / 2.0f;
        }
    }

    @BA.Hide
    public static class ElasticIn
    extends Elastic {
        public ElasticIn(float value, float power, int bounces, float scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public float apply(float a2) {
            if ((double)a2 >= 0.99) {
                return 1.0f;
            }
            return (float)Math.pow(this.a, this.b * (a2 - 1.0f)) * MathUtils.sin(a2 * this.d) * this.c;
        }
    }

    @BA.Hide
    public static class ElasticOut
    extends Elastic {
        public ElasticOut(float value, float power, int bounces, float scale) {
            super(value, power, bounces, scale);
        }

        @Override
        public float apply(float a2) {
            a2 = 1.0f - a2;
            return 1.0f - (float)Math.pow(this.a, this.b * (a2 - 1.0f)) * MathUtils.sin(a2 * this.d) * this.c;
        }
    }

    @BA.Hide
    public static class Exp
    extends Interpolation {
        final float a;
        final float b;
        final float c;
        final float d;

        public Exp(float value, float power) {
            this.a = value;
            this.b = power;
            this.c = (float)Math.pow(value, -power);
            this.d = 1.0f / (1.0f - this.c);
        }

        @Override
        public float apply(float a2) {
            if (a2 <= 0.5f) {
                return ((float)Math.pow(this.a, this.b * (a2 * 2.0f - 1.0f)) - this.c) * this.d / 2.0f;
            }
            return (2.0f - ((float)Math.pow(this.a, -this.b * (a2 * 2.0f - 1.0f)) - this.c) * this.d) / 2.0f;
        }
    }

    @BA.Hide
    public static class ExpIn
    extends Exp {
        public ExpIn(float value, float power) {
            super(value, power);
        }

        @Override
        public float apply(float a2) {
            return ((float)Math.pow(this.a, this.b * (a2 - 1.0f)) - this.c) * this.d;
        }
    }

    @BA.Hide
    public static class ExpOut
    extends Exp {
        public ExpOut(float value, float power) {
            super(value, power);
        }

        @Override
        public float apply(float a2) {
            return 1.0f - ((float)Math.pow(this.a, -this.b * a2) - this.c) * this.d;
        }
    }

    @BA.Hide
    public static class Pow
    extends Interpolation {
        final int a;

        public Pow(int power) {
            this.a = power;
        }

        @Override
        public float apply(float a2) {
            if (a2 <= 0.5f) {
                return (float)Math.pow(a2 * 2.0f, this.a) / 2.0f;
            }
            return (float)Math.pow((a2 - 1.0f) * 2.0f, this.a) / (float)(this.a % 2 == 0 ? -2 : 2) + 1.0f;
        }
    }

    @BA.Hide
    public static class PowIn
    extends Pow {
        public PowIn(int power) {
            super(power);
        }

        @Override
        public float apply(float a2) {
            return (float)Math.pow(a2, this.a);
        }
    }

    @BA.Hide
    public static class PowOut
    extends Pow {
        public PowOut(int power) {
            super(power);
        }

        @Override
        public float apply(float a2) {
            return (float)Math.pow(a2 - 1.0f, this.a) * (float)(this.a % 2 == 0 ? -1 : 1) + 1.0f;
        }
    }

    @BA.Hide
    public static class Swing
    extends Interpolation {
        private final float a;

        public Swing(float scale) {
            this.a = scale * 2.0f;
        }

        @Override
        public float apply(float a2) {
            if (a2 <= 0.5f) {
                return (a2 *= 2.0f) * a2 * ((this.a + 1.0f) * a2 - this.a) / 2.0f;
            }
            a2 = (a2 - 1.0f) * 2.0f;
            return a2 * a2 * ((this.a + 1.0f) * a2 + this.a) / 2.0f + 1.0f;
        }
    }

    @BA.Hide
    public static class SwingIn
    extends Interpolation {
        private final float a;

        public SwingIn(float scale) {
            this.a = scale;
        }

        @Override
        public float apply(float a2) {
            float f = a2;
            return f * f * ((this.a + 1.0f) * a2 - this.a);
        }
    }

    @BA.Hide
    public static class SwingOut
    extends Interpolation {
        private final float a;

        public SwingOut(float scale) {
            this.a = scale;
        }

        @Override
        public float apply(float a2) {
            return (a2 -= 1.0f) * a2 * ((this.a + 1.0f) * a2 + this.a) + 1.0f;
        }
    }
}

