/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.utils.lgArray;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.Array;
import java.util.Arrays;
import java.util.List;

@BA.ShortName(value="lgMathIntersector")
public final class Intersector {
    private static final Vector3 a = new Vector3();
    private static final Vector3 b = new Vector3();
    private static final Vector3 c = new Vector3();
    private static final Plane d = new Plane(new Vector3(), 0.0f);
    private static final Vector3 e = new Vector3();
    private static Vector3 f = new Vector3();
    private static Vector3 g = new Vector3();
    private static Vector3 h = new Vector3();
    private static Vector3 i = new Vector3();
    private static Vector3 j = new Vector3();
    private static Vector2 k = new Vector2();
    private static Vector3 l = new Vector3();

    public static boolean isPointInTriangle3(Vector3 point, Vector3 t1, Vector3 t2, Vector3 t3) {
        a.set(t1).sub(point);
        b.set(t2).sub(point);
        c.set(t3).sub(point);
        float f = a.dot(b);
        float f2 = a.dot(c);
        float f3 = b.dot(c);
        Vector3 vector3 = c;
        float f4 = vector3.dot(vector3);
        if (f3 * f2 - f4 * f < 0.0f) {
            return false;
        }
        Vector3 vector32 = b;
        float f5 = vector32.dot(vector32);
        return !(f * f3 - f2 * f5 < 0.0f);
    }

    public static boolean isPointInTriangle2(Vector2 p, Vector2 a2, Vector2 b2, Vector2 c2) {
        boolean bl;
        float f;
        float f2;
        if ((c2.x - a2.x) * f2 - (c2.y - a2.y) * f > 0.0f == (bl = (b2.x - a2.x) * (f2 = p.y - a2.y) - (b2.y - a2.y) * (f = p.x - a2.x) > 0.0f)) {
            return false;
        }
        return (c2.x - b2.x) * (p.y - b2.y) - (c2.y - b2.y) * (p.x - b2.x) > 0.0f == bl;
    }

    public static boolean isPointInTriangle(float px, float py, float ax, float ay, float bx, float by, float cx, float cy) {
        boolean bl;
        float f;
        float f2;
        if ((cx - ax) * f2 - (cy - ay) * f > 0.0f == (bl = (bx - ax) * (f2 = py - ay) - (by - ay) * (f = px - ax) > 0.0f)) {
            return false;
        }
        return (cx - bx) * (py - by) - (cy - by) * (px - bx) > 0.0f == bl;
    }

    public static boolean intersectSegmentPlane(Vector3 start, Vector3 end, Plane plane, Vector3 intersection) {
        Vector3 vector3 = a.set(end).sub(start);
        float f = vector3.dot(plane.getNormal());
        float f2 = -(start.dot(plane.getNormal()) + plane.getD()) / f;
        if (f2 < 0.0f || f2 > 1.0f) {
            return false;
        }
        intersection.set(start).add(vector3.scl(f2));
        return true;
    }

    public static int pointLineSide(Vector2 linePoint1, Vector2 linePoint2, Vector2 point) {
        return (int)Math.signum((linePoint2.x - linePoint1.x) * (point.y - linePoint1.y) - (linePoint2.y - linePoint1.y) * (point.x - linePoint1.x));
    }

    public static int pointLineSide(float linePoint1X, float linePoint1Y, float linePoint2X, float linePoint2Y, float pointX, float pointY) {
        return (int)Math.signum((linePoint2X - linePoint1X) * (pointY - linePoint1Y) - (linePoint2Y - linePoint1Y) * (pointX - linePoint1X));
    }

    public static boolean isPointInPolygon(lgArray Polygon2, Vector2 Point) {
        return Intersector.isPointInPolygon(Polygon2.getInternalObject(), Point);
    }

    @BA.Hide
    public static boolean isPointInPolygon(Array<Vector2> polygon, Vector2 point) {
        Vector2 vector2 = polygon.peek();
        boolean bl = false;
        int n = 0;
        while (n < polygon.size) {
            Vector2 vector22;
            Vector2 vector23 = polygon.get(n);
            if ((vector22.y < point.y && vector2.y >= point.y || vector2.y < point.y && vector23.y >= point.y) && vector23.x + (point.y - vector23.y) / (vector2.y - vector23.y) * (vector2.x - vector23.x) < point.x) {
                bl = !bl;
            }
            vector2 = vector23;
            ++n;
        }
        return bl;
    }

    public static boolean isPointInPolygon2(float[] polygon, int offset, int count, float x, float y) {
        boolean bl = false;
        int n = offset + count - 2;
        int n2 = offset;
        int n3 = n;
        while (n2 <= n3) {
            float f;
            float f2;
            float f3 = polygon[n2 + 1];
            float f4 = polygon[n + 1];
            if ((f3 < y && f4 >= y || f4 < y && f3 >= y) && f2 + (y - f3) / (f4 - f3) * (polygon[n] - (f = polygon[n2])) < x) {
                bl = !bl;
            }
            n = n2;
            n2 += 2;
        }
        return bl;
    }

    public static float distanceLinePoint(Vector2 start, Vector2 end, Vector2 point) {
        return Intersector.distanceLinePoint2(start.x, start.y, end.x, end.y, point.x, point.y);
    }

    public static float distanceLinePoint2(float startX, float startY, float endX, float endY, float pointX, float pointY) {
        float f = (float)Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
        return Math.abs((pointX - startX) * (endY - startY) - (pointY - startY) * (endX - startX)) / f;
    }

    public static float distanceSegmentPoint(float startX, float startY, float endX, float endY, float pointX, float pointY) {
        return Intersector.nearestSegmentPoint(startX, startY, endX, endY, pointX, pointY, k).dst_xy(pointX, pointY);
    }

    public static float distanceSegmentPoint(Vector2 start, Vector2 end, Vector2 point) {
        return Intersector.nearestSegmentPoint(start, end, point, k).dst(point);
    }

    public static Vector2 nearestSegmentPoint(Vector2 start, Vector2 end, Vector2 point, Vector2 nearest) {
        float f;
        float f2 = start.dst2(end);
        if (f2 == 0.0f) {
            return nearest.set(start);
        }
        float f3 = ((point.x - start.x) * (end.x - start.x) + (point.y - start.y) * (end.y - start.y)) / f2;
        if (f < 0.0f) {
            return nearest.set(start);
        }
        if (f3 > 1.0f) {
            return nearest.set(end);
        }
        return nearest.set(start.x + f3 * (end.x - start.x), start.y + f3 * (end.y - start.y));
    }

    public static Vector2 nearestSegmentPoint(float startX, float startY, float endX, float endY, float pointX, float pointY, Vector2 nearest) {
        float f;
        float f2 = endX - startX;
        float f3 = endY - startY;
        float f4 = f2;
        float f5 = f3;
        float f6 = f4 * f4 + f5 * f5;
        if (f6 == 0.0f) {
            return nearest.set(startX, startY);
        }
        float f7 = ((pointX - startX) * f2 + (pointY - startY) * f3) / f6;
        if (f < 0.0f) {
            return nearest.set(startX, startY);
        }
        if (f7 > 1.0f) {
            return nearest.set(endX, endY);
        }
        return nearest.set(startX + f7 * f2, startY + f7 * f3);
    }

    public static boolean intersectSegmentCircle(Vector2 start, Vector2 end, Vector2 center, float squareRadius) {
        float f;
        g.set(end.x - start.x, end.y - start.y, 0.0f);
        h.set(center.x - start.x, center.y - start.y, 0.0f);
        float f2 = g.len();
        float f3 = h.dot(g.nor());
        if (f <= 0.0f) {
            i.set(start.x, start.y, 0.0f);
        } else if (f3 >= f2) {
            i.set(end.x, end.y, 0.0f);
        } else {
            j.set(g.scl(f3));
            i.set(Intersector.j.x + start.x, Intersector.j.y + start.y, 0.0f);
        }
        float f4 = center.x - Intersector.i.x;
        float f5 = center.y - Intersector.i.y;
        float f6 = f4;
        float f7 = f5;
        return f6 * f6 + f7 * f7 <= squareRadius;
    }

    public static float intersectSegmentCircleDisplace(Vector2 start, Vector2 end, Vector2 point, float radius, Vector2 displacement) {
        float f;
        float f2;
        float f3 = (point.x - start.x) * (end.x - start.x) + (point.y - start.y) * (end.y - start.y);
        float f4 = f2 = start.dst(end);
        if ((f3 /= f4 * f4) < 0.0f || f3 > 1.0f) {
            return Float.POSITIVE_INFINITY;
        }
        g.set(end.x, end.y, 0.0f).sub(start.x, start.y, 0.0f);
        i.set(start.x, start.y, 0.0f).add(g.scl(f3));
        f2 = i.dst(point.x, point.y, 0.0f);
        if (f < radius) {
            displacement.set(point).sub(Intersector.i.x, Intersector.i.y).nor();
            return f2;
        }
        return Float.POSITIVE_INFINITY;
    }

    public static float intersectRayRay(Vector2 start1, Vector2 direction1, Vector2 start2, Vector2 direction2) {
        float f = start2.x - start1.x;
        float f2 = start2.y - start1.y;
        float f3 = direction1.x * direction2.y - direction1.y * direction2.x;
        if (f3 == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float f4 = direction2.x / f3;
        float f5 = direction2.y / f3;
        return f * f5 - f2 * f4;
    }

    public static boolean intersectRayPlane(Ray ray, Plane plane, Vector3 intersection) {
        float f = ray.direction.dot(plane.getNormal());
        if (f != 0.0f) {
            float f2;
            float f3 = -(ray.origin.dot(plane.getNormal()) + plane.getD()) / f;
            if (f2 < 0.0f) {
                return false;
            }
            if (intersection != null) {
                intersection.set(ray.origin).add(a.set(ray.direction).scl(f3));
            }
            return true;
        }
        if (plane.testPoint(ray.origin) == Plane.PlaneSide.OnPlane) {
            if (intersection != null) {
                intersection.set(ray.origin);
            }
            return true;
        }
        return false;
    }

    public static float intersectLinePlane(float x, float y, float z, float x2, float y2, float z2, Plane plane, Vector3 intersection) {
        Vector3 vector3 = g.set(x2, y2, z2).sub(x, y, z);
        Vector3 vector32 = i.set(x, y, z);
        float f = vector3.dot(plane.getNormal());
        if (f != 0.0f) {
            float f2 = -(vector32.dot(plane.getNormal()) + plane.getD()) / f;
            if (intersection != null) {
                intersection.set(vector32).add(vector3.scl(f2));
            }
            return f2;
        }
        if (plane.testPoint(vector32) == Plane.PlaneSide.OnPlane) {
            if (intersection != null) {
                intersection.set(vector32);
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public static boolean intersectRayTriangle(Ray ray, Vector3 t1, Vector3 t2, Vector3 t3, Vector3 intersection) {
        float f;
        Vector3 vector3 = a.set(t2).sub(t1);
        Vector3 vector32 = b.set(t3).sub(t1);
        Vector3 vector33 = c.set(ray.direction).crs(vector32);
        float f2 = vector3.dot(vector33);
        if (MathUtils.isZero(f2)) {
            d.Set2(t1, t2, t3);
            if (d.testPoint(ray.origin) == Plane.PlaneSide.OnPlane && Intersector.isPointInTriangle3(ray.origin, t1, t2, t3)) {
                if (intersection != null) {
                    intersection.set(ray.origin);
                }
                return true;
            }
            return false;
        }
        f2 = 1.0f / f2;
        Vector3 vector34 = e.set(ray.origin).sub(t1);
        float f3 = vector34.dot(vector33) * f2;
        if (f3 < 0.0f || f3 > 1.0f) {
            return false;
        }
        Vector3 vector35 = vector34.crs(vector3);
        float f4 = ray.direction.dot(vector35) * f2;
        if (f4 < 0.0f || f3 + f4 > 1.0f) {
            return false;
        }
        float f5 = vector32.dot(vector35) * f2;
        if (f < 0.0f) {
            return false;
        }
        if (intersection != null) {
            if (f5 <= 1.0E-6f) {
                intersection.set(ray.origin);
            } else {
                ray.getEndPoint(intersection, f5);
            }
        }
        return true;
    }

    public static boolean intersectRaySphere(Ray ray, Vector3 center, float radius, Vector3 intersection) {
        float f;
        float f2 = ray.direction.dot(center.x - ray.origin.x, center.y - ray.origin.y, center.z - ray.origin.z);
        if (f < 0.0f) {
            return false;
        }
        float f3 = center.dst2(ray.origin.x + ray.direction.x * f2, ray.origin.y + ray.direction.y * f2, ray.origin.z + ray.direction.z * f2);
        float f4 = radius;
        float f5 = f4 * f4;
        if (f3 > f5) {
            return false;
        }
        if (intersection != null) {
            intersection.set(ray.direction).scl(f2 - (float)Math.sqrt(f5 - f3)).add(ray.origin);
        }
        return true;
    }

    public static boolean intersectRayBounds(Ray ray, BoundingBox box, Vector3 intersection) {
        float f;
        if (box.contains2(ray.origin)) {
            if (intersection != null) {
                intersection.set(ray.origin);
            }
            return true;
        }
        float f2 = 0.0f;
        boolean bl = false;
        if (ray.origin.x <= box.min.x && ray.direction.x > 0.0f) {
            float f3;
            f = (box.min.x - ray.origin.x) / ray.direction.x;
            if (f3 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.y >= box.min.y && Intersector.c.y <= box.max.y && Intersector.c.z >= box.min.z && Intersector.c.z <= box.max.z) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (ray.origin.x >= box.max.x && ray.direction.x < 0.0f) {
            float f4;
            f = (box.max.x - ray.origin.x) / ray.direction.x;
            if (f4 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.y >= box.min.y && Intersector.c.y <= box.max.y && Intersector.c.z >= box.min.z && Intersector.c.z <= box.max.z && (!bl || f < f2)) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (ray.origin.y <= box.min.y && ray.direction.y > 0.0f) {
            float f5;
            f = (box.min.y - ray.origin.y) / ray.direction.y;
            if (f5 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.x >= box.min.x && Intersector.c.x <= box.max.x && Intersector.c.z >= box.min.z && Intersector.c.z <= box.max.z && (!bl || f < f2)) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (ray.origin.y >= box.max.y && ray.direction.y < 0.0f) {
            float f6;
            f = (box.max.y - ray.origin.y) / ray.direction.y;
            if (f6 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.x >= box.min.x && Intersector.c.x <= box.max.x && Intersector.c.z >= box.min.z && Intersector.c.z <= box.max.z && (!bl || f < f2)) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (ray.origin.z <= box.min.z && ray.direction.z > 0.0f) {
            float f7;
            f = (box.min.z - ray.origin.z) / ray.direction.z;
            if (f7 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.x >= box.min.x && Intersector.c.x <= box.max.x && Intersector.c.y >= box.min.y && Intersector.c.y <= box.max.y && (!bl || f < f2)) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (ray.origin.z >= box.max.z && ray.direction.z < 0.0f) {
            float f8;
            f = (box.max.z - ray.origin.z) / ray.direction.z;
            if (f8 >= 0.0f) {
                c.set(ray.direction).scl(f).add(ray.origin);
                if (Intersector.c.x >= box.min.x && Intersector.c.x <= box.max.x && Intersector.c.y >= box.min.y && Intersector.c.y <= box.max.y && (!bl || f < f2)) {
                    bl = true;
                    f2 = f;
                }
            }
        }
        if (bl && intersection != null) {
            intersection.set(ray.direction).scl(f2).add(ray.origin);
            if (intersection.x < box.min.x) {
                intersection.x = box.min.x;
            } else if (intersection.x > box.max.x) {
                intersection.x = box.max.x;
            }
            if (intersection.y < box.min.y) {
                intersection.y = box.min.y;
            } else if (intersection.y > box.max.y) {
                intersection.y = box.max.y;
            }
            if (intersection.z < box.min.z) {
                intersection.z = box.min.z;
            } else if (intersection.z > box.max.z) {
                intersection.z = box.max.z;
            }
        }
        return bl;
    }

    public static boolean intersectRayBoundsFast(Ray ray, BoundingBox box) {
        return Intersector.intersectRayBoundsFast(ray, box.getCenter(h), box.getDimensions(i));
    }

    @BA.Hide
    public static boolean intersectRayBoundsFast(Ray ray, Vector3 center, Vector3 dimensions) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = 1.0f / ray.direction.x;
        float f8 = 1.0f / ray.direction.y;
        float f9 = 1.0f / ray.direction.z;
        float f10 = (center.x - dimensions.x * 0.5f - ray.origin.x) * f7;
        float f11 = (center.x + dimensions.x * 0.5f - ray.origin.x) * f7;
        if (f10 > f11) {
            f6 = f10;
            f10 = f11;
            f11 = f6;
        }
        if ((f6 = (center.y - dimensions.y * 0.5f - ray.origin.y) * f8) > (f5 = (center.y + dimensions.y * 0.5f - ray.origin.y) * f8)) {
            f4 = f6;
            f6 = f5;
            f5 = f4;
        }
        if ((f4 = (center.z - dimensions.z * 0.5f - ray.origin.z) * f9) > (f3 = (center.z + dimensions.z * 0.5f - ray.origin.z) * f9)) {
            f2 = f4;
            f4 = f3;
            f3 = f2;
        }
        f2 = Math.max(Math.max(f10, f6), f4);
        float f12 = Math.min(Math.min(f11, f5), f3);
        return f >= 0.0f && f12 >= f2;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] triangles, Vector3 intersection) {
        float f = Float.MAX_VALUE;
        boolean bl = false;
        if (triangles.length / 3 % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        int n = 0;
        while (n < triangles.length - 6) {
            if (Intersector.intersectRayTriangle(ray, h.set(triangles[n], triangles[n + 1], triangles[n + 2]), i.set(triangles[n + 3], triangles[n + 4], triangles[n + 5]), j.set(triangles[n + 6], triangles[n + 7], triangles[n + 8]), g)) {
                float f2;
                float f3 = ray.origin.dst2(g);
                if (f2 < f) {
                    f = f3;
                    Intersector.f.set(g);
                    bl = true;
                }
            }
            n += 9;
        }
        if (!bl) {
            return false;
        }
        if (intersection != null) {
            intersection.set(Intersector.f);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, float[] vertices, short[] indices, int vertexSize, Vector3 intersection) {
        float f = Float.MAX_VALUE;
        boolean bl = false;
        if (indices.length % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        int n = 0;
        while (n < indices.length) {
            int n2 = indices[n] * vertexSize;
            int n3 = indices[n + 1] * vertexSize;
            int n4 = indices[n + 2] * vertexSize;
            if (Intersector.intersectRayTriangle(ray, h.set(vertices[n2], vertices[n2 + 1], vertices[n2 + 2]), i.set(vertices[n3], vertices[n3 + 1], vertices[n3 + 2]), j.set(vertices[n4], vertices[n4 + 1], vertices[n4 + 2]), g)) {
                float f2;
                float f3 = ray.origin.dst2(g);
                if (f2 < f) {
                    f = f3;
                    Intersector.f.set(g);
                    bl = true;
                }
            }
            n += 3;
        }
        if (!bl) {
            return false;
        }
        if (intersection != null) {
            intersection.set(Intersector.f);
        }
        return true;
    }

    public static boolean intersectRayTriangles(Ray ray, List<Vector3> triangles, Vector3 intersection) {
        float f = Float.MAX_VALUE;
        boolean bl = false;
        if (triangles.size() % 3 != 0) {
            throw new RuntimeException("triangle list size is not a multiple of 3");
        }
        int n = 0;
        while (n < triangles.size() - 2) {
            if (Intersector.intersectRayTriangle(ray, triangles.get(n), triangles.get(n + 1), triangles.get(n + 2), g)) {
                float f2;
                float f3 = ray.origin.dst2(g);
                if (f2 < f) {
                    f = f3;
                    Intersector.f.set(g);
                    bl = true;
                }
            }
            n += 3;
        }
        if (!bl) {
            return false;
        }
        if (intersection != null) {
            intersection.set(Intersector.f);
        }
        return true;
    }

    public static boolean intersectLines(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, Vector2 intersection) {
        float f = p4.y;
        float f2 = p3.y;
        float f3 = p2.x;
        float f4 = p1.x;
        float f5 = p4.x;
        float f6 = p3.x;
        float f7 = p2.y;
        float f8 = p1.y;
        float f9 = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
        if (f9 == 0.0f) {
            return false;
        }
        if (intersection != null) {
            float f10 = ((f5 - f6) * (f8 - f2) - (f - f2) * (f4 - f6)) / f9;
            intersection.set(f4 + (f3 - f4) * f10, f8 + (f7 - f8) * f10);
        }
        return true;
    }

    public static boolean intersectLines2(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vector2 intersection) {
        float f = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (f == 0.0f) {
            return false;
        }
        if (intersection != null) {
            float f2 = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / f;
            intersection.set(x1 + (x2 - x1) * f2, y1 + (y2 - y1) * f2);
        }
        return true;
    }

    public static boolean intersectLinePolygon(Vector2 p1, Vector2 p2, Polygon polygon) {
        float[] fArray = polygon.getTransformedVertices();
        float f = p1.x;
        float f2 = p1.y;
        float f3 = p2.x;
        float f4 = p2.y;
        int n = fArray.length;
        float f5 = fArray[n - 2];
        float f6 = fArray[n - 1];
        int n2 = 0;
        while (n2 < n) {
            float f7 = fArray[n2 + 1];
            float f8 = fArray[n2];
            float f9 = (f7 - f6) * (f3 - f) - (f8 - f5) * (f4 - f2);
            if (f9 != 0.0f) {
                float f10;
                float f11 = f2 - f6;
                float f12 = f - f5;
                float f13 = ((f8 - f5) * f11 - (f7 - f6) * f12) / f9;
                if (f10 >= 0.0f && f13 <= 1.0f) {
                    return true;
                }
            }
            f5 = f8;
            f6 = f7;
            n2 += 2;
        }
        return false;
    }

    public static boolean intersectRectangles(Rectangle rectangle1, Rectangle rectangle2, Rectangle intersection) {
        if (rectangle1.overlaps(rectangle2)) {
            intersection.x = Math.max(rectangle1.x, rectangle2.x);
            intersection.width = Math.min(rectangle1.x + rectangle1.width, rectangle2.x + rectangle2.width) - intersection.x;
            intersection.y = Math.max(rectangle1.y, rectangle2.y);
            intersection.height = Math.min(rectangle1.y + rectangle1.height, rectangle2.y + rectangle2.height) - intersection.y;
            return true;
        }
        return false;
    }

    public static boolean intersectSegmentPolygon(Vector2 p1, Vector2 p2, Polygon polygon) {
        float[] fArray = polygon.getTransformedVertices();
        float f = p1.x;
        float f2 = p1.y;
        float f3 = p2.x;
        float f4 = p2.y;
        int n = fArray.length;
        float f5 = fArray[n - 2];
        float f6 = fArray[n - 1];
        int n2 = 0;
        while (n2 < n) {
            float f7 = fArray[n2 + 1];
            float f8 = fArray[n2];
            float f9 = (f7 - f6) * (f3 - f) - (f8 - f5) * (f4 - f2);
            if (f9 != 0.0f) {
                float f10;
                float f11 = f2 - f6;
                float f12 = f - f5;
                float f13 = ((f8 - f5) * f11 - (f7 - f6) * f12) / f9;
                if (f10 >= 0.0f && f13 <= 1.0f) {
                    float f14;
                    float f15 = ((f3 - f) * f11 - (f4 - f2) * f12) / f9;
                    if (f14 >= 0.0f && f15 <= 1.0f) {
                        return true;
                    }
                }
            }
            f5 = f8;
            f6 = f7;
            n2 += 2;
        }
        return false;
    }

    public static boolean intersectSegments(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, Vector2 intersection) {
        float f = p4.y;
        float f2 = p3.y;
        float f3 = p2.x;
        float f4 = p1.x;
        float f5 = p4.x;
        float f6 = p3.x;
        float f7 = p2.y;
        float f8 = p1.y;
        float f9 = (f - f2) * (f3 - f4) - (f5 - f6) * (f7 - f8);
        if (f9 == 0.0f) {
            return false;
        }
        float f10 = f8 - f2;
        float f11 = f4 - f6;
        float f12 = ((f5 - f6) * f10 - (f - f2) * f11) / f9;
        if (f12 < 0.0f || f12 > 1.0f) {
            return false;
        }
        float f13 = ((f3 - f4) * f10 - (f7 - f8) * f11) / f9;
        if (f13 < 0.0f || f13 > 1.0f) {
            return false;
        }
        if (intersection != null) {
            intersection.set(f4 + (f3 - f4) * f12, f8 + (f7 - f8) * f12);
        }
        return true;
    }

    public static boolean intersectSegments2(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vector2 intersection) {
        float f = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (f == 0.0f) {
            return false;
        }
        float f2 = y1 - y3;
        float f3 = x1 - x3;
        float f4 = ((x4 - x3) * f2 - (y4 - y3) * f3) / f;
        if (f4 < 0.0f || f4 > 1.0f) {
            return false;
        }
        float f5 = ((x2 - x1) * f2 - (y2 - y1) * f3) / f;
        if (f5 < 0.0f || f5 > 1.0f) {
            return false;
        }
        if (intersection != null) {
            intersection.set(x1 + (x2 - x1) * f4, y1 + (y2 - y1) * f4);
        }
        return true;
    }

    public static boolean overlaps(Circle c1, Circle c2) {
        return c1.overlaps(c2);
    }

    public static boolean overlaps(Rectangle r1, Rectangle r2) {
        return r1.overlaps(r2);
    }

    public static boolean overlaps(Circle c2, Rectangle r) {
        float f = c2.x;
        float f2 = c2.y;
        if (c2.x < r.x) {
            f = r.x;
        } else if (c2.x > r.x + r.width) {
            f = r.x + r.width;
        }
        if (c2.y < r.y) {
            f2 = r.y;
        } else if (c2.y > r.y + r.height) {
            f2 = r.y + r.height;
        }
        float f3 = f - c2.x;
        f = f3 * f3;
        float f4 = f2 - c2.y;
        f2 = f4 * f4;
        return f + f2 < c2.radius * c2.radius;
    }

    public static boolean overlapConvexPolygons(Polygon p1, Polygon p2) {
        return Intersector.overlapConvexPolygons2(p1, p2, null);
    }

    public static boolean overlapConvexPolygons2(Polygon p1, Polygon p2, MinimumTranslationVector mtv) {
        return Intersector.overlapConvexPolygons(p1.getTransformedVertices(), p2.getTransformedVertices(), mtv);
    }

    public static boolean overlapConvexPolygons(float[] verts1, float[] verts2, MinimumTranslationVector mtv) {
        return Intersector.overlapConvexPolygons(verts1, 0, verts1.length, verts2, 0, verts2.length, mtv);
    }

    public static boolean overlapConvexPolygons(float[] verts1, int offset1, int count1, float[] verts2, int offset2, int count2, MinimumTranslationVector mtv) {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15 = Float.MAX_VALUE;
        float f16 = 0.0f;
        float f17 = 0.0f;
        int n2 = offset1 + count1;
        int n3 = offset2 + count2;
        int n4 = offset1;
        while (n4 < n2) {
            f14 = verts1[n4];
            f13 = verts1[n4 + 1];
            f12 = verts1[(n4 + 2) % count1];
            f11 = verts1[(n4 + 3) % count1];
            f10 = f13 - f11;
            f9 = -(f14 - f12);
            float f18 = f10;
            float f19 = f9;
            f8 = (float)Math.sqrt(f18 * f18 + f19 * f19);
            f6 = f7 = (f10 /= f8) * verts1[0] + (f9 /= f8) * verts1[1];
            int n5 = offset1;
            while (n5 < n2) {
                float f20;
                f5 = f10 * verts1[n5] + f9 * verts1[n5 + 1];
                if (f20 < f7) {
                    f7 = f5;
                } else if (f5 > f6) {
                    f6 = f5;
                }
                n5 += 2;
            }
            n = 0;
            f5 = f4 = f10 * verts2[0] + f9 * verts2[1];
            int n6 = offset2;
            while (n6 < n3) {
                float f21;
                n -= Intersector.pointLineSide(f14, f13, f12, f11, verts2[n6], verts2[n6 + 1]);
                f3 = f10 * verts2[n6] + f9 * verts2[n6 + 1];
                if (f21 < f4) {
                    f4 = f3;
                } else if (f3 > f5) {
                    f5 = f3;
                }
                n6 += 2;
            }
            if (!(f7 <= f4 && f6 >= f4 || f4 <= f7 && f5 >= f7)) {
                return false;
            }
            f2 = Math.min(f6, f5) - Math.max(f7, f4);
            if (f7 < f4 && f6 > f5 || f4 < f7 && f5 > f6) {
                f3 = Math.abs(f7 - f4);
                f2 = f3 < (f = Math.abs(f6 - f5)) ? (f2 += f3) : (f2 += f);
            }
            if (f2 < f15) {
                f15 = f2;
                f16 = n >= 0 ? f10 : -f10;
                f17 = n >= 0 ? f9 : -f9;
            }
            n4 += 2;
        }
        n4 = offset2;
        while (n4 < n3) {
            f14 = verts2[n4];
            f13 = verts2[n4 + 1];
            f12 = verts2[(n4 + 2) % count2];
            f11 = verts2[(n4 + 3) % count2];
            f10 = f13 - f11;
            f9 = -(f14 - f12);
            float f22 = f10;
            float f23 = f9;
            f8 = (float)Math.sqrt(f22 * f22 + f23 * f23);
            n = 0;
            f6 = f7 = (f10 /= f8) * verts1[0] + (f9 /= f8) * verts1[1];
            int n7 = offset1;
            while (n7 < n2) {
                f5 = f10 * verts1[n7] + f9 * verts1[n7 + 1];
                n -= Intersector.pointLineSide(f14, f13, f12, f11, verts1[n7], verts1[n7 + 1]);
                if (f5 < f7) {
                    f7 = f5;
                } else if (f5 > f6) {
                    f6 = f5;
                }
                n7 += 2;
            }
            f5 = f4 = f10 * verts2[0] + f9 * verts2[1];
            int n8 = offset2;
            while (n8 < n3) {
                float f24;
                f3 = f10 * verts2[n8] + f9 * verts2[n8 + 1];
                if (f24 < f4) {
                    f4 = f3;
                } else if (f3 > f5) {
                    f5 = f3;
                }
                n8 += 2;
            }
            if (!(f7 <= f4 && f6 >= f4 || f4 <= f7 && f5 >= f7)) {
                return false;
            }
            f2 = Math.min(f6, f5) - Math.max(f7, f4);
            if (f7 < f4 && f6 > f5 || f4 < f7 && f5 > f6) {
                f3 = Math.abs(f7 - f4);
                f2 = f3 < (f = Math.abs(f6 - f5)) ? (f2 += f3) : (f2 += f);
            }
            if (f2 < f15) {
                f15 = f2;
                f16 = n < 0 ? f10 : -f10;
                f17 = n < 0 ? f9 : -f9;
            }
            n4 += 2;
        }
        if (mtv != null) {
            mtv.normal.set(f16, f17);
            mtv.depth = f15;
        }
        return true;
    }

    public static void splitTriangle(float[] triangle, Plane plane, SplitTriangle split) {
        int n = triangle.length / 3;
        boolean bl = plane.testPoint(triangle[0], triangle[1], triangle[2]) == Plane.PlaneSide.Back;
        boolean bl2 = plane.testPoint(triangle[0 + n], triangle[1 + n], triangle[2 + n]) == Plane.PlaneSide.Back;
        boolean bl3 = plane.testPoint(triangle[0 + n * 2], triangle[1 + n * 2], triangle[2 + n * 2]) == Plane.PlaneSide.Back;
        SplitTriangle splitTriangle = split;
        split.b = false;
        splitTriangle.c = 0;
        splitTriangle.d = 0;
        splitTriangle.numFront = 0;
        splitTriangle.numBack = 0;
        splitTriangle.total = 0;
        if (bl == bl2 && bl2 == bl3) {
            split.total = 1;
            if (bl) {
                split.numBack = 1;
                System.arraycopy(triangle, 0, split.back, 0, triangle.length);
                return;
            }
            split.numFront = 1;
            System.arraycopy(triangle, 0, split.front, 0, triangle.length);
            return;
        }
        split.total = 3;
        split.numFront = (bl ? 0 : 1) + (bl2 ? 0 : 1) + (bl3 ? 0 : 1);
        split.numBack = split.total - split.numFront;
        boolean bl4 = split.b = !bl;
        if (bl != bl2) {
            int n2 = n;
            Intersector.a(triangle, 0, n2, n2, plane, split.a);
            split.a(triangle, 0, n);
            SplitTriangle splitTriangle2 = split;
            splitTriangle2.a(splitTriangle2.a, 0, n);
            split.b = !split.b;
            SplitTriangle splitTriangle3 = split;
            splitTriangle3.a(splitTriangle3.a, 0, n);
        } else {
            split.a(triangle, 0, n);
        }
        int n3 = n;
        int n4 = n3 + n3;
        if (bl2 != bl3) {
            Intersector.a(triangle, n, n4, n, plane, split.a);
            int n5 = n;
            split.a(triangle, n5, n5);
            SplitTriangle splitTriangle4 = split;
            splitTriangle4.a(splitTriangle4.a, 0, n);
            split.b = !split.b;
            SplitTriangle splitTriangle5 = split;
            splitTriangle5.a(splitTriangle5.a, 0, n);
        } else {
            int n6 = n;
            split.a(triangle, n6, n6);
        }
        int n7 = n4;
        if (bl3 != bl) {
            Intersector.a(triangle, n7, 0, n, plane, split.a);
            split.a(triangle, n7, n);
            SplitTriangle splitTriangle6 = split;
            splitTriangle6.a(splitTriangle6.a, 0, n);
            split.b = !split.b;
            SplitTriangle splitTriangle7 = split;
            splitTriangle7.a(splitTriangle7.a, 0, n);
        } else {
            split.a(triangle, n7, n);
        }
        if (split.numFront == 2) {
            System.arraycopy(split.front, n * 2, split.front, n * 3, n * 2);
            System.arraycopy(split.front, 0, split.front, n * 5, n);
            return;
        }
        System.arraycopy(split.back, n * 2, split.back, n * 3, n * 2);
        System.arraycopy(split.back, 0, split.back, n * 5, n);
    }

    private static void a(float[] fArray, int n, int n2, int n3, Plane plane, float[] fArray2) {
        float f = Intersector.intersectLinePlane(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n2], fArray[n2 + 1], fArray[n2 + 2], plane, l);
        fArray2[0] = Intersector.l.x;
        fArray2[1] = Intersector.l.y;
        fArray2[2] = Intersector.l.z;
        int n4 = 3;
        while (n4 < n3) {
            float f2 = fArray[n + n4];
            float f3 = fArray[n2 + n4];
            fArray2[0 + n4] = f2 + f * (f3 - f2);
            ++n4;
        }
    }

    @BA.ShortName(value="lgMathIntersectorMinimumTranslationVector")
    public static class MinimumTranslationVector {
        public Vector2 normal = new Vector2();
        public float depth = 0.0f;
    }

    @BA.ShortName(value="lgMathIntersectorSplitTriangle")
    public static class SplitTriangle {
        public float[] front;
        public float[] back;
        float[] a;
        public int numFront;
        public int numBack;
        public int total;
        boolean b = false;
        int c = 0;
        int d = 0;

        public void Initialize(int numAttributes) {
            this.front = new float[numAttributes * 3 * 2];
            this.back = new float[numAttributes * 3 * 2];
            this.a = new float[numAttributes];
        }

        public SplitTriangle() {
        }

        public SplitTriangle(int numAttributes) {
            this.Initialize(numAttributes);
        }

        public String toString() {
            return "SplitTriangle [front=" + Arrays.toString(this.front) + ", back=" + Arrays.toString(this.back) + ", numFront=" + this.numFront + ", numBack=" + this.numBack + ", total=" + this.total + "]";
        }

        final void a(float[] fArray, int n, int n2) {
            if (this.b) {
                System.arraycopy(fArray, n, this.front, this.c, n2);
                this.c += n2;
                return;
            }
            System.arraycopy(fArray, n, this.back, this.d, n2);
            this.d += n2;
        }
    }
}

