/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.RandomXS128;

@BA.ShortName(value="lgMathUtils")
public final class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float E = (float)Math.E;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    @BA.Hide
    public static RandomXS128 random = new RandomXS128();

    public static float sin(float radians) {
        return a.a[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return a.a[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float degrees) {
        return a.a[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static float cosDeg(float degrees) {
        return a.a[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static float atan2(float y, float x) {
        float f;
        if (x == 0.0f) {
            if (y > 0.0f) {
                return 1.5707964f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float f2 = y / x;
        if (Math.abs(f) < 1.0f) {
            float f3 = f2 / (1.0f + 0.28f * f2 * f2);
            if (x < 0.0f) {
                return f3 + (y < 0.0f ? (float)(-Math.PI) : (float)Math.PI);
            }
            return f3;
        }
        float f4 = f2;
        float f5 = 1.5707964f - f4 / (f4 * f2 + 0.28f);
        if (y < 0.0f) {
            return f5 - (float)Math.PI;
        }
        return f5;
    }

    public static void Randomize(long Seed) {
        random.setSeed(Seed);
    }

    public static int RandomInt(int range) {
        return MathUtils.random(range);
    }

    @BA.Hide
    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int RandomInt2(int start, int end) {
        return MathUtils.random(start, end);
    }

    @BA.Hide
    public static int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean RandomBoolean2(float chance) {
        return MathUtils.random() < chance;
    }

    public static float RandomFloat() {
        return random.nextFloat();
    }

    @BA.Hide
    public static float random() {
        return random.nextFloat();
    }

    @BA.Hide
    public static float random(float range) {
        return random.nextFloat() * range;
    }

    public static float RandomFloat2(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static float randomTriangular(float min, float max) {
        return MathUtils.randomTriangular2(min, max, min + (max - min) * 0.5f);
    }

    public static float randomTriangular2(float min, float max, float mode) {
        float f;
        float f2 = random.nextFloat();
        if (f2 <= (mode - min) / (f = max - min)) {
            return min + (float)Math.sqrt(f2 * f * (mode - min));
        }
        return max - (float)Math.sqrt((1.0f - f2) * f * (max - mode));
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        int n = --value;
        int n2 = n | n >> 1;
        int n3 = n2 | n2 >> 2;
        int n4 = n3 | n3 >> 4;
        int n5 = n4 | n4 >> 8;
        return (n5 | n5 >> 16) + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        if (value != 0) {
            int n = value;
            if ((n & n - 1) == 0) {
                return true;
            }
        }
        return false;
    }

    public static short clamp3(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp2(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp4(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float lerp(float fromValue, float toValue, float progress) {
        return fromValue + (toValue - fromValue) * progress;
    }

    public static float lerpAngle(float fromRadians, float toRadians, float progress) {
        float f = (toRadians - fromRadians + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return (fromRadians + f * progress + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float fromDegrees, float toDegrees, float progress) {
        float f = (toDegrees - fromDegrees + 360.0f + 180.0f) % 360.0f - 180.0f;
        return (fromDegrees + f * progress + 360.0f) % 360.0f;
    }

    public static int floor(float value) {
        return (int)((double)value + 16384.0) - 16384;
    }

    public static int floorPositive(float value) {
        return (int)value;
    }

    public static int ceil(float value) {
        return (int)((double)value + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float value) {
        return (int)((double)value + 0.9999999);
    }

    public static int round(float value) {
        return (int)((double)value + 16384.5) - 16384;
    }

    public static int roundPositive(float value) {
        return (int)(value + 0.5f);
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean isZero2(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a2, float b2) {
        return Math.abs(a2 - b2) <= 1.0E-6f;
    }

    public static boolean isEqual2(float a2, float b2, float tolerance) {
        return Math.abs(a2 - b2) <= tolerance;
    }

    public static float log(float a2, float value) {
        return (float)(Math.log(value) / Math.log(a2));
    }

    public static float log2(float value) {
        return MathUtils.log(2.0f, value);
    }

    static final class a {
        static final float[] a = new float[16384];

        static {
            int n = 0;
            while (n < 16384) {
                int n2 = n++;
                com.badlogic.gdx.math.MathUtils$a.a[n2] = (float)Math.sin(((float)n2 + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            n = 0;
            while (n < 360) {
                com.badlogic.gdx.math.MathUtils$a.a[(int)((float)n * 45.511112f) & 0x3FFF] = (float)Math.sin((float)n * ((float)Math.PI / 180));
                n += 90;
            }
        }
    }
}

