/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.Serializable;

@BA.ShortName(value="lgMathMatrix3")
public class Matrix3
implements Serializable {
    private static final long serialVersionUID = 7907569533774959788L;
    public static final int M00 = 0;
    public static final int M01 = 3;
    public static final int M02 = 6;
    public static final int M10 = 1;
    public static final int M11 = 4;
    public static final int M12 = 7;
    public static final int M20 = 2;
    public static final int M21 = 5;
    public static final int M22 = 8;
    public float[] val = new float[9];
    private float[] a = new float[9];

    public Matrix3() {
        this.idt();
    }

    public Matrix3(Matrix3 matrix) {
        this.Set(matrix);
    }

    public Matrix3(float[] values) {
        this.Set3(values);
    }

    public Matrix3 idt() {
        float[] fArray = this.val;
        this.val[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 mul(Matrix3 m) {
        float[] fArray = this.val;
        float f = this.val[0] * m.val[0] + fArray[3] * m.val[1] + fArray[6] * m.val[2];
        float f2 = fArray[0] * m.val[3] + fArray[3] * m.val[4] + fArray[6] * m.val[5];
        float f3 = fArray[0] * m.val[6] + fArray[3] * m.val[7] + fArray[6] * m.val[8];
        float f4 = fArray[1] * m.val[0] + fArray[4] * m.val[1] + fArray[7] * m.val[2];
        float f5 = fArray[1] * m.val[3] + fArray[4] * m.val[4] + fArray[7] * m.val[5];
        float f6 = fArray[1] * m.val[6] + fArray[4] * m.val[7] + fArray[7] * m.val[8];
        float f7 = fArray[2] * m.val[0] + fArray[5] * m.val[1] + fArray[8] * m.val[2];
        float f8 = fArray[2] * m.val[3] + fArray[5] * m.val[4] + fArray[8] * m.val[5];
        float f9 = fArray[2] * m.val[6] + fArray[5] * m.val[7] + fArray[8] * m.val[8];
        fArray[0] = f;
        fArray[1] = f4;
        fArray[2] = f7;
        fArray[3] = f2;
        fArray[4] = f5;
        fArray[5] = f8;
        fArray[6] = f3;
        fArray[7] = f6;
        fArray[8] = f9;
        return this;
    }

    public Matrix3 setToRotation(float degrees) {
        return this.setToRotationRad((float)Math.PI / 180 * degrees);
    }

    public Matrix3 setToRotationRad(float radians) {
        float f = (float)Math.cos(radians);
        float f2 = (float)Math.sin(radians);
        float[] fArray = this.val;
        this.val[0] = f;
        fArray[1] = f2;
        fArray[2] = 0.0f;
        fArray[3] = -f2;
        fArray[4] = f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToRotation2(Vector3 axis, float degrees) {
        return this.setToRotation3(axis, MathUtils.cosDeg(degrees), MathUtils.sinDeg(degrees));
    }

    public Matrix3 setToRotation3(Vector3 axis, float cos, float sin) {
        float[] fArray = this.val;
        float f = 1.0f - cos;
        fArray[0] = f * axis.x * axis.x + cos;
        fArray[1] = f * axis.x * axis.y - axis.z * sin;
        fArray[2] = f * axis.z * axis.x + axis.y * sin;
        fArray[3] = f * axis.x * axis.y + axis.z * sin;
        fArray[4] = f * axis.y * axis.y + cos;
        fArray[5] = f * axis.y * axis.z - axis.x * sin;
        fArray[6] = f * axis.z * axis.x - axis.y * sin;
        fArray[7] = f * axis.y * axis.z + axis.x * sin;
        fArray[8] = f * axis.z * axis.z + cos;
        return this;
    }

    public Matrix3 setToTranslation(float x, float y) {
        float[] fArray = this.val;
        this.val[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = x;
        fArray[7] = y;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToTranslation2(Vector2 translation) {
        float[] fArray = this.val;
        this.val[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = 0.0f;
        fArray[6] = translation.x;
        fArray[7] = translation.y;
        fArray[8] = 1.0f;
        return this;
    }

    public Matrix3 setToScaling(float scaleX, float scaleY) {
        float[] fArray = this.val;
        this.val[0] = scaleX;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = scaleY;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return this;
    }

    public String toString() {
        float[] fArray = this.val;
        return "[" + fArray[0] + "|" + fArray[3] + "|" + fArray[6] + "]\n[" + fArray[1] + "|" + fArray[4] + "|" + fArray[7] + "]\n[" + fArray[2] + "|" + fArray[5] + "|" + fArray[8] + "]";
    }

    public float det() {
        float[] fArray = this.val;
        return this.val[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }

    public Matrix3 inv() {
        float f = this.det();
        if (f == 0.0f) {
            throw new GdxRuntimeException("Can't invert a singular matrix");
        }
        float f2 = 1.0f / f;
        float[] fArray = this.a;
        float[] fArray2 = this.val;
        fArray[0] = fArray2[4] * fArray2[8] - fArray2[5] * fArray2[7];
        fArray[1] = fArray2[2] * fArray2[7] - fArray2[1] * fArray2[8];
        fArray[2] = fArray2[1] * fArray2[5] - fArray2[2] * fArray2[4];
        fArray[3] = fArray2[5] * fArray2[6] - fArray2[3] * fArray2[8];
        fArray[4] = fArray2[0] * fArray2[8] - fArray2[2] * fArray2[6];
        fArray[5] = fArray2[2] * fArray2[3] - fArray2[0] * fArray2[5];
        fArray[6] = fArray2[3] * fArray2[7] - fArray2[4] * fArray2[6];
        fArray[7] = fArray2[1] * fArray2[6] - fArray2[0] * fArray2[7];
        fArray[8] = fArray2[0] * fArray2[4] - fArray2[1] * fArray2[3];
        fArray2[0] = f2 * fArray[0];
        fArray2[1] = f2 * fArray[1];
        fArray2[2] = f2 * fArray[2];
        fArray2[3] = f2 * fArray[3];
        fArray2[4] = f2 * fArray[4];
        fArray2[5] = f2 * fArray[5];
        fArray2[6] = f2 * fArray[6];
        fArray2[7] = f2 * fArray[7];
        fArray2[8] = f2 * fArray[8];
        return this;
    }

    public Matrix3 Set(Matrix3 mat) {
        System.arraycopy(mat.val, 0, this.val, 0, this.val.length);
        return this;
    }

    public Matrix3 Set2(Matrix4 mat) {
        float[] fArray = this.val;
        this.val[0] = mat.val[0];
        fArray[1] = mat.val[1];
        fArray[2] = mat.val[2];
        fArray[3] = mat.val[4];
        fArray[4] = mat.val[5];
        fArray[5] = mat.val[6];
        fArray[6] = mat.val[8];
        fArray[7] = mat.val[9];
        fArray[8] = mat.val[10];
        return this;
    }

    public Matrix3 Set3(float[] values) {
        System.arraycopy(values, 0, this.val, 0, this.val.length);
        return this;
    }

    public Matrix3 trn2(Vector2 vector) {
        this.val[6] = this.val[6] + vector.x;
        this.val[7] = this.val[7] + vector.y;
        return this;
    }

    public Matrix3 trn(float x, float y) {
        this.val[6] = this.val[6] + x;
        this.val[7] = this.val[7] + y;
        return this;
    }

    public Matrix3 trn3(Vector3 vector) {
        this.val[6] = this.val[6] + vector.x;
        this.val[7] = this.val[7] + vector.y;
        return this;
    }

    public Matrix3 translate(float x, float y) {
        float[] fArray = this.val;
        this.a[0] = 1.0f;
        this.a[1] = 0.0f;
        this.a[2] = 0.0f;
        this.a[3] = 0.0f;
        this.a[4] = 1.0f;
        this.a[5] = 0.0f;
        this.a[6] = x;
        this.a[7] = y;
        this.a[8] = 1.0f;
        Matrix3.a(fArray, this.a);
        return this;
    }

    public Matrix3 translate2(Vector2 translation) {
        float[] fArray = this.val;
        this.a[0] = 1.0f;
        this.a[1] = 0.0f;
        this.a[2] = 0.0f;
        this.a[3] = 0.0f;
        this.a[4] = 1.0f;
        this.a[5] = 0.0f;
        this.a[6] = translation.x;
        this.a[7] = translation.y;
        this.a[8] = 1.0f;
        Matrix3.a(fArray, this.a);
        return this;
    }

    public Matrix3 rotate(float degrees) {
        return this.rotateRad((float)Math.PI / 180 * degrees);
    }

    public Matrix3 rotateRad(float radians) {
        if (radians == 0.0f) {
            return this;
        }
        float f = (float)Math.cos(radians);
        float f2 = (float)Math.sin(radians);
        float[] fArray = this.a;
        this.a[0] = f;
        fArray[1] = f2;
        fArray[2] = 0.0f;
        fArray[3] = -f2;
        fArray[4] = f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.a(this.val, fArray);
        return this;
    }

    public Matrix3 scale(float scaleX, float scaleY) {
        float[] fArray = this.a;
        this.a[0] = scaleX;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = scaleY;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.a(this.val, fArray);
        return this;
    }

    public Matrix3 scale2(Vector2 scale) {
        float[] fArray = this.a;
        this.a[0] = scale.x;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = scale.y;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        Matrix3.a(this.val, fArray);
        return this;
    }

    public float[] getValues() {
        return this.val;
    }

    public Vector2 getTranslation(Vector2 position) {
        position.x = this.val[6];
        position.y = this.val[7];
        return position;
    }

    public Vector2 getScale(Vector2 scale) {
        float[] fArray = this.val;
        scale.x = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[3] * fArray[3]);
        scale.y = (float)Math.sqrt(fArray[1] * fArray[1] + fArray[4] * fArray[4]);
        return scale;
    }

    public float getRotation() {
        return 57.295776f * (float)Math.atan2(this.val[1], this.val[0]);
    }

    public float getRotationRad() {
        return (float)Math.atan2(this.val[1], this.val[0]);
    }

    public Matrix3 scl(float scale) {
        this.val[0] = this.val[0] * scale;
        this.val[4] = this.val[4] * scale;
        return this;
    }

    public Matrix3 scl2(Vector2 scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[4] = this.val[4] * scale.y;
        return this;
    }

    public Matrix3 scl3(Vector3 scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[4] = this.val[4] * scale.y;
        return this;
    }

    public Matrix3 transpose() {
        float[] fArray = this.val;
        float f = this.val[1];
        float f2 = fArray[2];
        float f3 = fArray[3];
        float f4 = fArray[5];
        float f5 = fArray[6];
        float f6 = fArray[7];
        fArray[3] = f;
        fArray[6] = f2;
        fArray[1] = f3;
        fArray[7] = f4;
        fArray[2] = f5;
        fArray[5] = f6;
        return this;
    }

    private static void a(float[] fArray, float[] fArray2) {
        float f = fArray[0] * fArray2[0] + fArray[3] * fArray2[1] + fArray[6] * fArray2[2];
        float f2 = fArray[0] * fArray2[3] + fArray[3] * fArray2[4] + fArray[6] * fArray2[5];
        float f3 = fArray[0] * fArray2[6] + fArray[3] * fArray2[7] + fArray[6] * fArray2[8];
        float f4 = fArray[1] * fArray2[0] + fArray[4] * fArray2[1] + fArray[7] * fArray2[2];
        float f5 = fArray[1] * fArray2[3] + fArray[4] * fArray2[4] + fArray[7] * fArray2[5];
        float f6 = fArray[1] * fArray2[6] + fArray[4] * fArray2[7] + fArray[7] * fArray2[8];
        float f7 = fArray[2] * fArray2[0] + fArray[5] * fArray2[1] + fArray[8] * fArray2[2];
        float f8 = fArray[2] * fArray2[3] + fArray[5] * fArray2[4] + fArray[8] * fArray2[5];
        float f9 = fArray[2] * fArray2[6] + fArray[5] * fArray2[7] + fArray[8] * fArray2[8];
        fArray[0] = f;
        fArray[1] = f4;
        fArray[2] = f7;
        fArray[3] = f2;
        fArray[4] = f5;
        fArray[5] = f8;
        fArray[6] = f3;
        fArray[7] = f6;
        fArray[8] = f9;
    }
}

