/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

@BA.ShortName(value="lgMathMatrix4")
public class Matrix4
implements Serializable {
    private static final long serialVersionUID = -2717655254359579617L;
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    private static final float[] a = new float[16];
    public final float[] val = new float[16];
    private static Quaternion b = new Quaternion();
    private static Vector3 c;
    private static Vector3 d;
    private static Vector3 e;
    private static Vector3 f;
    private static Matrix4 g;
    private static Vector3 h;
    private static Vector3 i;
    private static Vector3 j;

    static {
        new Quaternion();
        c = new Vector3();
        d = new Vector3();
        e = new Vector3();
        f = new Vector3();
        g = new Matrix4();
        h = new Vector3();
        i = new Vector3();
        j = new Vector3();
    }

    public Matrix4() {
        this.val[0] = 1.0f;
        this.val[5] = 1.0f;
        this.val[10] = 1.0f;
        this.val[15] = 1.0f;
    }

    public Matrix4(Matrix4 matrix) {
        this.set(matrix);
    }

    public Matrix4(float[] values) {
        this.Set2(values);
    }

    public Matrix4(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Matrix4(Vector3 position, Quaternion rotation, Vector3 scale) {
        this.set(position, rotation, scale);
    }

    public Matrix4 set(Matrix4 matrix) {
        return this.Set2(matrix.val);
    }

    public Matrix4 Set2(float[] values) {
        System.arraycopy(values, 0, this.val, 0, this.val.length);
        return this;
    }

    @BA.Hide
    public Matrix4 set(Quaternion quaternion) {
        return this.Set3(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Matrix4 Set3(float quaternionX, float quaternionY, float quaternionZ, float quaternionW) {
        return this.Set4(0.0f, 0.0f, 0.0f, quaternionX, quaternionY, quaternionZ, quaternionW);
    }

    @BA.Hide
    public Matrix4 set(Vector3 position, Quaternion orientation) {
        return this.Set4(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w);
    }

    public Matrix4 Set4(float translationX, float translationY, float translationZ, float quaternionX, float quaternionY, float quaternionZ, float quaternionW) {
        float f = quaternionX * 2.0f;
        float f2 = quaternionY * 2.0f;
        float f3 = quaternionZ * 2.0f;
        float f4 = quaternionW * f;
        float f5 = quaternionW * f2;
        float f6 = quaternionW * f3;
        float f7 = quaternionX * f;
        float f8 = quaternionX * f2;
        float f9 = quaternionX * f3;
        float f10 = quaternionY * f2;
        float f11 = quaternionY * f3;
        float f12 = quaternionZ * f3;
        this.val[0] = 1.0f - (f10 + f12);
        this.val[4] = f8 - f6;
        this.val[8] = f9 + f5;
        this.val[12] = translationX;
        this.val[1] = f8 + f6;
        this.val[5] = 1.0f - (f7 + f12);
        this.val[9] = f11 - f4;
        this.val[13] = translationY;
        this.val[2] = f9 - f5;
        this.val[6] = f11 + f4;
        this.val[10] = 1.0f - (f7 + f10);
        this.val[14] = translationZ;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    @BA.Hide
    public Matrix4 set(Vector3 position, Quaternion orientation, Vector3 scale) {
        return this.Set5(position.x, position.y, position.z, orientation.x, orientation.y, orientation.z, orientation.w, scale.x, scale.y, scale.z);
    }

    public Matrix4 Set5(float translationX, float translationY, float translationZ, float quaternionX, float quaternionY, float quaternionZ, float quaternionW, float scaleX, float scaleY, float scaleZ) {
        float f = quaternionX * 2.0f;
        float f2 = quaternionY * 2.0f;
        float f3 = quaternionZ * 2.0f;
        float f4 = quaternionW * f;
        float f5 = quaternionW * f2;
        float f6 = quaternionW * f3;
        float f7 = quaternionX * f;
        float f8 = quaternionX * f2;
        float f9 = quaternionX * f3;
        float f10 = quaternionY * f2;
        float f11 = quaternionY * f3;
        float f12 = quaternionZ * f3;
        this.val[0] = scaleX * (1.0f - (f10 + f12));
        this.val[4] = scaleY * (f8 - f6);
        this.val[8] = scaleZ * (f9 + f5);
        this.val[12] = translationX;
        this.val[1] = scaleX * (f8 + f6);
        this.val[5] = scaleY * (1.0f - (f7 + f12));
        this.val[9] = scaleZ * (f11 - f4);
        this.val[13] = translationY;
        this.val[2] = scaleX * (f9 - f5);
        this.val[6] = scaleY * (f11 + f4);
        this.val[10] = scaleZ * (1.0f - (f7 + f10));
        this.val[14] = translationZ;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 Set6(Vector3 xAxis, Vector3 yAxis, Vector3 zAxis, Vector3 pos) {
        this.val[0] = xAxis.x;
        this.val[4] = xAxis.y;
        this.val[8] = xAxis.z;
        this.val[1] = yAxis.x;
        this.val[5] = yAxis.y;
        this.val[9] = yAxis.z;
        this.val[2] = zAxis.x;
        this.val[6] = zAxis.y;
        this.val[10] = zAxis.z;
        this.val[12] = pos.x;
        this.val[13] = pos.y;
        this.val[14] = pos.z;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 cpy() {
        return new Matrix4(this);
    }

    public Matrix4 trn(Vector3 vector) {
        this.val[12] = this.val[12] + vector.x;
        this.val[13] = this.val[13] + vector.y;
        this.val[14] = this.val[14] + vector.z;
        return this;
    }

    public Matrix4 trn(float x, float y, float z) {
        this.val[12] = this.val[12] + x;
        this.val[13] = this.val[13] + y;
        this.val[14] = this.val[14] + z;
        return this;
    }

    public float[] getValues() {
        return this.val;
    }

    public Matrix4 mul(Matrix4 matrix) {
        Matrix4.mul(this.val, matrix.val);
        return this;
    }

    public Matrix4 mulLeft(Matrix4 matrix) {
        g.set(matrix);
        Matrix4.mul(Matrix4.g.val, this.val);
        return this.set(g);
    }

    public Matrix4 tra() {
        Matrix4.a[0] = this.val[0];
        Matrix4.a[4] = this.val[1];
        Matrix4.a[8] = this.val[2];
        Matrix4.a[12] = this.val[3];
        Matrix4.a[1] = this.val[4];
        Matrix4.a[5] = this.val[5];
        Matrix4.a[9] = this.val[6];
        Matrix4.a[13] = this.val[7];
        Matrix4.a[2] = this.val[8];
        Matrix4.a[6] = this.val[9];
        Matrix4.a[10] = this.val[10];
        Matrix4.a[14] = this.val[11];
        Matrix4.a[3] = this.val[12];
        Matrix4.a[7] = this.val[13];
        Matrix4.a[11] = this.val[14];
        Matrix4.a[15] = this.val[15];
        return this.Set2(a);
    }

    public Matrix4 idt() {
        this.val[0] = 1.0f;
        this.val[4] = 0.0f;
        this.val[8] = 0.0f;
        this.val[12] = 0.0f;
        this.val[1] = 0.0f;
        this.val[5] = 1.0f;
        this.val[9] = 0.0f;
        this.val[13] = 0.0f;
        this.val[2] = 0.0f;
        this.val[6] = 0.0f;
        this.val[10] = 1.0f;
        this.val[14] = 0.0f;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 inv() {
        float f = this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
        if (f == 0.0f) {
            throw new RuntimeException("non-invertible matrix");
        }
        float f2 = 1.0f / f;
        Matrix4.a[0] = this.val[9] * this.val[14] * this.val[7] - this.val[13] * this.val[10] * this.val[7] + this.val[13] * this.val[6] * this.val[11] - this.val[5] * this.val[14] * this.val[11] - this.val[9] * this.val[6] * this.val[15] + this.val[5] * this.val[10] * this.val[15];
        Matrix4.a[4] = this.val[12] * this.val[10] * this.val[7] - this.val[8] * this.val[14] * this.val[7] - this.val[12] * this.val[6] * this.val[11] + this.val[4] * this.val[14] * this.val[11] + this.val[8] * this.val[6] * this.val[15] - this.val[4] * this.val[10] * this.val[15];
        Matrix4.a[8] = this.val[8] * this.val[13] * this.val[7] - this.val[12] * this.val[9] * this.val[7] + this.val[12] * this.val[5] * this.val[11] - this.val[4] * this.val[13] * this.val[11] - this.val[8] * this.val[5] * this.val[15] + this.val[4] * this.val[9] * this.val[15];
        Matrix4.a[12] = this.val[12] * this.val[9] * this.val[6] - this.val[8] * this.val[13] * this.val[6] - this.val[12] * this.val[5] * this.val[10] + this.val[4] * this.val[13] * this.val[10] + this.val[8] * this.val[5] * this.val[14] - this.val[4] * this.val[9] * this.val[14];
        Matrix4.a[1] = this.val[13] * this.val[10] * this.val[3] - this.val[9] * this.val[14] * this.val[3] - this.val[13] * this.val[2] * this.val[11] + this.val[1] * this.val[14] * this.val[11] + this.val[9] * this.val[2] * this.val[15] - this.val[1] * this.val[10] * this.val[15];
        Matrix4.a[5] = this.val[8] * this.val[14] * this.val[3] - this.val[12] * this.val[10] * this.val[3] + this.val[12] * this.val[2] * this.val[11] - this.val[0] * this.val[14] * this.val[11] - this.val[8] * this.val[2] * this.val[15] + this.val[0] * this.val[10] * this.val[15];
        Matrix4.a[9] = this.val[12] * this.val[9] * this.val[3] - this.val[8] * this.val[13] * this.val[3] - this.val[12] * this.val[1] * this.val[11] + this.val[0] * this.val[13] * this.val[11] + this.val[8] * this.val[1] * this.val[15] - this.val[0] * this.val[9] * this.val[15];
        Matrix4.a[13] = this.val[8] * this.val[13] * this.val[2] - this.val[12] * this.val[9] * this.val[2] + this.val[12] * this.val[1] * this.val[10] - this.val[0] * this.val[13] * this.val[10] - this.val[8] * this.val[1] * this.val[14] + this.val[0] * this.val[9] * this.val[14];
        Matrix4.a[2] = this.val[5] * this.val[14] * this.val[3] - this.val[13] * this.val[6] * this.val[3] + this.val[13] * this.val[2] * this.val[7] - this.val[1] * this.val[14] * this.val[7] - this.val[5] * this.val[2] * this.val[15] + this.val[1] * this.val[6] * this.val[15];
        Matrix4.a[6] = this.val[12] * this.val[6] * this.val[3] - this.val[4] * this.val[14] * this.val[3] - this.val[12] * this.val[2] * this.val[7] + this.val[0] * this.val[14] * this.val[7] + this.val[4] * this.val[2] * this.val[15] - this.val[0] * this.val[6] * this.val[15];
        Matrix4.a[10] = this.val[4] * this.val[13] * this.val[3] - this.val[12] * this.val[5] * this.val[3] + this.val[12] * this.val[1] * this.val[7] - this.val[0] * this.val[13] * this.val[7] - this.val[4] * this.val[1] * this.val[15] + this.val[0] * this.val[5] * this.val[15];
        Matrix4.a[14] = this.val[12] * this.val[5] * this.val[2] - this.val[4] * this.val[13] * this.val[2] - this.val[12] * this.val[1] * this.val[6] + this.val[0] * this.val[13] * this.val[6] + this.val[4] * this.val[1] * this.val[14] - this.val[0] * this.val[5] * this.val[14];
        Matrix4.a[3] = this.val[9] * this.val[6] * this.val[3] - this.val[5] * this.val[10] * this.val[3] - this.val[9] * this.val[2] * this.val[7] + this.val[1] * this.val[10] * this.val[7] + this.val[5] * this.val[2] * this.val[11] - this.val[1] * this.val[6] * this.val[11];
        Matrix4.a[7] = this.val[4] * this.val[10] * this.val[3] - this.val[8] * this.val[6] * this.val[3] + this.val[8] * this.val[2] * this.val[7] - this.val[0] * this.val[10] * this.val[7] - this.val[4] * this.val[2] * this.val[11] + this.val[0] * this.val[6] * this.val[11];
        Matrix4.a[11] = this.val[8] * this.val[5] * this.val[3] - this.val[4] * this.val[9] * this.val[3] - this.val[8] * this.val[1] * this.val[7] + this.val[0] * this.val[9] * this.val[7] + this.val[4] * this.val[1] * this.val[11] - this.val[0] * this.val[5] * this.val[11];
        Matrix4.a[15] = this.val[4] * this.val[9] * this.val[2] - this.val[8] * this.val[5] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] + this.val[0] * this.val[5] * this.val[10];
        this.val[0] = a[0] * f2;
        this.val[4] = a[4] * f2;
        this.val[8] = a[8] * f2;
        this.val[12] = a[12] * f2;
        this.val[1] = a[1] * f2;
        this.val[5] = a[5] * f2;
        this.val[9] = a[9] * f2;
        this.val[13] = a[13] * f2;
        this.val[2] = a[2] * f2;
        this.val[6] = a[6] * f2;
        this.val[10] = a[10] * f2;
        this.val[14] = a[14] * f2;
        this.val[3] = a[3] * f2;
        this.val[7] = a[7] * f2;
        this.val[11] = a[11] * f2;
        this.val[15] = a[15] * f2;
        return this;
    }

    public float det() {
        return this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
    }

    public float det3x3() {
        return this.val[0] * this.val[5] * this.val[10] + this.val[4] * this.val[9] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] - this.val[8] * this.val[5] * this.val[2];
    }

    public Matrix4 setToProjection(float near, float far, float fovy, float aspectRatio) {
        this.idt();
        float f = (float)(1.0 / Math.tan((double)fovy * (Math.PI / 180) / 2.0));
        float f2 = (far + near) / (near - far);
        float f3 = 2.0f * far * near / (near - far);
        this.val[0] = f / aspectRatio;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = f;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = f2;
        this.val[11] = -1.0f;
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = f3;
        this.val[15] = 0.0f;
        return this;
    }

    public Matrix4 setToOrtho2D(float x, float y, float width, float height) {
        float f = x;
        float f2 = y;
        this.setToOrtho(f, f + width, f2, f2 + height, 0.0f, 1.0f);
        return this;
    }

    public Matrix4 setToOrtho2D(float x, float y, float width, float height, float near, float far) {
        float f = x;
        float f2 = y;
        this.setToOrtho(f, f + width, f2, f2 + height, near, far);
        return this;
    }

    public Matrix4 setToOrtho(float left, float right, float bottom, float top, float near, float far) {
        this.idt();
        float f = 2.0f / (right - left);
        float f2 = 2.0f / (top - bottom);
        float f3 = -2.0f / (far - near);
        float f4 = -(right + left) / (right - left);
        float f5 = -(top + bottom) / (top - bottom);
        float f6 = -(far + near) / (far - near);
        this.val[0] = f;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = f2;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = f3;
        this.val[11] = 0.0f;
        this.val[12] = f4;
        this.val[13] = f5;
        this.val[14] = f6;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 setTranslation(Vector3 vector) {
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Matrix4 setTranslation(float x, float y, float z) {
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4 setToTranslation(Vector3 vector) {
        this.idt();
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Matrix4 setToTranslation(float x, float y, float z) {
        this.idt();
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(Vector3 translation, Vector3 scaling) {
        this.idt();
        this.val[12] = translation.x;
        this.val[13] = translation.y;
        this.val[14] = translation.z;
        this.val[0] = scaling.x;
        this.val[5] = scaling.y;
        this.val[10] = scaling.z;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(float translationX, float translationY, float translationZ, float scalingX, float scalingY, float scalingZ) {
        this.idt();
        this.val[12] = translationX;
        this.val[13] = translationY;
        this.val[14] = translationZ;
        this.val[0] = scalingX;
        this.val[5] = scalingY;
        this.val[10] = scalingZ;
        return this;
    }

    public Matrix4 setToRotation(Vector3 axis, float degrees) {
        if (degrees == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(b.set(axis, degrees));
    }

    public Matrix4 setToRotationRad(Vector3 axis, float radians) {
        if (radians == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(b.setFromAxisRad(axis, radians));
    }

    public Matrix4 setToRotation(float axisX, float axisY, float axisZ, float degrees) {
        if (degrees == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(b.setFromAxis(axisX, axisY, axisZ, degrees));
    }

    public Matrix4 setToRotationRad(float axisX, float axisY, float axisZ, float radians) {
        if (radians == 0.0f) {
            this.idt();
            return this;
        }
        return this.set(b.setFromAxisRad(axisX, axisY, axisZ, radians));
    }

    public Matrix4 setToRotation(Vector3 v1, Vector3 v2) {
        return this.set(b.setFromCross(v1, v2));
    }

    public Matrix4 setToRotation(float x1, float y1, float z1, float x2, float y2, float z2) {
        return this.set(b.setFromCross(x1, y1, z1, x2, y2, z2));
    }

    public Matrix4 setFromEulerAngles(float yaw, float pitch, float roll) {
        b.setEulerAngles(yaw, pitch, roll);
        return this.set(b);
    }

    public Matrix4 setToScaling(Vector3 vector) {
        this.idt();
        this.val[0] = vector.x;
        this.val[5] = vector.y;
        this.val[10] = vector.z;
        return this;
    }

    public Matrix4 setToScaling(float x, float y, float z) {
        this.idt();
        this.val[0] = x;
        this.val[5] = y;
        this.val[10] = z;
        return this;
    }

    public Matrix4 setToLookAt(Vector3 direction, Vector3 up) {
        c.set(direction).nor();
        d.set(direction).nor();
        d.crs(up).nor();
        e.set(d).crs(c).nor();
        this.idt();
        this.val[0] = Matrix4.d.x;
        this.val[4] = Matrix4.d.y;
        this.val[8] = Matrix4.d.z;
        this.val[1] = Matrix4.e.x;
        this.val[5] = Matrix4.e.y;
        this.val[9] = Matrix4.e.z;
        this.val[2] = -Matrix4.c.x;
        this.val[6] = -Matrix4.c.y;
        this.val[10] = -Matrix4.c.z;
        return this;
    }

    public Matrix4 setToLookAt(Vector3 position, Vector3 target, Vector3 up) {
        f.set(target).sub(position);
        this.setToLookAt(f, up);
        this.mul(g.setToTranslation(-position.x, -position.y, -position.z));
        return this;
    }

    public Matrix4 setToWorld(Vector3 position, Vector3 forward, Vector3 up) {
        i.set(forward).nor();
        h.set(i).crs(up).nor();
        j.set(h).crs(i).nor();
        this.Set6(h, j, i.scl(-1.0f), position);
        return this;
    }

    public String toString() {
        return "[" + this.val[0] + "|" + this.val[4] + "|" + this.val[8] + "|" + this.val[12] + "]\n[" + this.val[1] + "|" + this.val[5] + "|" + this.val[9] + "|" + this.val[13] + "]\n[" + this.val[2] + "|" + this.val[6] + "|" + this.val[10] + "|" + this.val[14] + "]\n[" + this.val[3] + "|" + this.val[7] + "|" + this.val[11] + "|" + this.val[15] + "]\n";
    }

    public Matrix4 lerp(Matrix4 matrix, float alpha) {
        int n = 0;
        while (n < 16) {
            this.val[n] = this.val[n] * (1.0f - alpha) + matrix.val[n] * alpha;
            ++n;
        }
        return this;
    }

    public Matrix4 set(Matrix3 mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[2] = mat.val[2];
        this.val[3] = 0.0f;
        this.val[4] = mat.val[3];
        this.val[5] = mat.val[4];
        this.val[6] = mat.val[5];
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = 1.0f;
        this.val[11] = 0.0f;
        this.val[12] = mat.val[6];
        this.val[13] = mat.val[7];
        this.val[14] = 0.0f;
        this.val[15] = mat.val[8];
        return this;
    }

    @BA.Hide
    public Matrix4 set(Affine2 affine) {
        this.val[0] = affine.m00;
        this.val[1] = affine.m10;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = affine.m01;
        this.val[5] = affine.m11;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = 1.0f;
        this.val[11] = 0.0f;
        this.val[12] = affine.m02;
        this.val[13] = affine.m12;
        this.val[14] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    @BA.Hide
    public Matrix4 setAsAffine(Affine2 affine) {
        this.val[0] = affine.m00;
        this.val[1] = affine.m10;
        this.val[4] = affine.m01;
        this.val[5] = affine.m11;
        this.val[12] = affine.m02;
        this.val[13] = affine.m12;
        return this;
    }

    @BA.Hide
    public Matrix4 setAsAffine(Matrix4 mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[4] = mat.val[4];
        this.val[5] = mat.val[5];
        this.val[12] = mat.val[12];
        this.val[13] = mat.val[13];
        return this;
    }

    public Matrix4 scl2(Vector3 scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[5] = this.val[5] * scale.y;
        this.val[10] = this.val[10] * scale.z;
        return this;
    }

    public Matrix4 scl(float x, float y, float z) {
        this.val[0] = this.val[0] * x;
        this.val[5] = this.val[5] * y;
        this.val[10] = this.val[10] * z;
        return this;
    }

    public Matrix4 scl3(float scale) {
        this.val[0] = this.val[0] * scale;
        this.val[5] = this.val[5] * scale;
        this.val[10] = this.val[10] * scale;
        return this;
    }

    public Vector3 getTranslation(Vector3 position) {
        position.x = this.val[12];
        position.y = this.val[13];
        position.z = this.val[14];
        return position;
    }

    @BA.Hide
    public Quaternion getRotation(Quaternion rotation) {
        return rotation.setFromMatrix(this);
    }

    public float getScaleXSquared() {
        return this.val[0] * this.val[0] + this.val[4] * this.val[4] + this.val[8] * this.val[8];
    }

    public float getScaleYSquared() {
        return this.val[1] * this.val[1] + this.val[5] * this.val[5] + this.val[9] * this.val[9];
    }

    public float getScaleZSquared() {
        return this.val[2] * this.val[2] + this.val[6] * this.val[6] + this.val[10] * this.val[10];
    }

    public float getScaleX() {
        if (MathUtils.isZero(this.val[4]) && MathUtils.isZero(this.val[8])) {
            return Math.abs(this.val[0]);
        }
        return (float)Math.sqrt(this.getScaleXSquared());
    }

    public float getScaleY() {
        if (MathUtils.isZero(this.val[1]) && MathUtils.isZero(this.val[9])) {
            return Math.abs(this.val[5]);
        }
        return (float)Math.sqrt(this.getScaleYSquared());
    }

    public float getScaleZ() {
        if (MathUtils.isZero(this.val[2]) && MathUtils.isZero(this.val[6])) {
            return Math.abs(this.val[10]);
        }
        return (float)Math.sqrt(this.getScaleZSquared());
    }

    public Vector3 getScale(Vector3 scale) {
        return scale.set(this.getScaleX(), this.getScaleY(), this.getScaleZ());
    }

    public Matrix4 toNormalMatrix() {
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = 0.0f;
        return this.inv().tra();
    }

    public static native void mul(float[] var0, float[] var1);

    public static native void mulVec(float[] var0, float[] var1);

    public static native void mulVec(float[] var0, float[] var1, int var2, int var3, int var4);

    public static native void prj(float[] var0, float[] var1);

    public static native void prj(float[] var0, float[] var1, int var2, int var3, int var4);

    public static native void rot(float[] var0, float[] var1);

    public static native void rot(float[] var0, float[] var1, int var2, int var3, int var4);

    public static native boolean inv(float[] var0);

    public static native float det(float[] var0);

    public Matrix4 translate2(Vector3 translation) {
        return this.translate(translation.x, translation.y, translation.z);
    }

    public Matrix4 translate(float x, float y, float z) {
        Matrix4.a[0] = 1.0f;
        Matrix4.a[4] = 0.0f;
        Matrix4.a[8] = 0.0f;
        Matrix4.a[12] = x;
        Matrix4.a[1] = 0.0f;
        Matrix4.a[5] = 1.0f;
        Matrix4.a[9] = 0.0f;
        Matrix4.a[13] = y;
        Matrix4.a[2] = 0.0f;
        Matrix4.a[6] = 0.0f;
        Matrix4.a[10] = 1.0f;
        Matrix4.a[14] = z;
        Matrix4.a[3] = 0.0f;
        Matrix4.a[7] = 0.0f;
        Matrix4.a[11] = 0.0f;
        Matrix4.a[15] = 1.0f;
        Matrix4.mul(this.val, a);
        return this;
    }

    public Matrix4 rotate(Vector3 axis, float degrees) {
        if (degrees == 0.0f) {
            return this;
        }
        b.set(axis, degrees);
        return this.rotate(b);
    }

    public Matrix4 rotate(float axisX, float axisY, float axisZ, float degrees) {
        if (degrees == 0.0f) {
            return this;
        }
        b.setFromAxis(axisX, axisY, axisZ, degrees);
        return this.rotate(b);
    }

    public Matrix4 rotateRad(float axisX, float axisY, float axisZ, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        b.setFromAxisRad(axisX, axisY, axisZ, radians);
        return this.rotate(b);
    }

    @BA.Hide
    public Matrix4 rotate(Quaternion rotation) {
        rotation.toMatrix(a);
        Matrix4.mul(this.val, a);
        return this;
    }

    public Matrix4 rotate(Vector3 v1, Vector3 v2) {
        return this.rotate(b.setFromCross(v1, v2));
    }

    public Matrix4 scale(float scaleX, float scaleY, float scaleZ) {
        Matrix4.a[0] = scaleX;
        Matrix4.a[4] = 0.0f;
        Matrix4.a[8] = 0.0f;
        Matrix4.a[12] = 0.0f;
        Matrix4.a[1] = 0.0f;
        Matrix4.a[5] = scaleY;
        Matrix4.a[9] = 0.0f;
        Matrix4.a[13] = 0.0f;
        Matrix4.a[2] = 0.0f;
        Matrix4.a[6] = 0.0f;
        Matrix4.a[10] = scaleZ;
        Matrix4.a[14] = 0.0f;
        Matrix4.a[3] = 0.0f;
        Matrix4.a[7] = 0.0f;
        Matrix4.a[11] = 0.0f;
        Matrix4.a[15] = 1.0f;
        Matrix4.mul(this.val, a);
        return this;
    }

    public void extract4x3Matrix(float[] dst) {
        dst[0] = this.val[0];
        dst[1] = this.val[1];
        dst[2] = this.val[2];
        dst[3] = this.val[4];
        dst[4] = this.val[5];
        dst[5] = this.val[6];
        dst[6] = this.val[8];
        dst[7] = this.val[9];
        dst[8] = this.val[10];
        dst[9] = this.val[12];
        dst[10] = this.val[13];
        dst[11] = this.val[14];
    }
}

