/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

@BA.ShortName(value="lgMathPlane")
public class Plane
implements Serializable {
    private static final long serialVersionUID = -1240652082930747866L;
    public static final PlaneSide PLANESIDE_OnPlane = PlaneSide.OnPlane;
    public static final PlaneSide PLANESIDE_Back = PlaneSide.Back;
    public static final PlaneSide PLANESIDE_Front = PlaneSide.Front;
    protected final Vector3 normal = new Vector3();
    protected float d = 0.0f;

    public Plane() {
    }

    public void Set(Vector3 normal, float d) {
        this.normal.set(normal).nor();
        this.d = d;
    }

    public Plane(Vector3 normal, float d) {
        this.Set(normal, d);
    }

    public Plane(Vector3 normal, Vector3 point) {
        this.normal.set(normal).nor();
        this.d = -this.normal.dot(point);
    }

    public Plane(Vector3 point1, Vector3 point2, Vector3 point3) {
        this.Set2(point1, point2, point3);
    }

    public void Set2(Vector3 point1, Vector3 point2, Vector3 point3) {
        this.normal.set(point1).sub(point2).crs(point2.x - point3.x, point2.y - point3.y, point2.z - point3.z).nor();
        this.d = -point1.dot(this.normal);
    }

    public void Set3(float nx, float ny, float nz, float d) {
        this.normal.set(nx, ny, nz);
        this.d = d;
    }

    public float distance(Vector3 point) {
        return this.normal.dot(point) + this.d;
    }

    public PlaneSide testPoint(Vector3 point) {
        float f = this.normal.dot(point) + this.d;
        if (f == 0.0f) {
            return PlaneSide.OnPlane;
        }
        if (f < 0.0f) {
            return PlaneSide.Back;
        }
        return PlaneSide.Front;
    }

    public PlaneSide testPoint(float x, float y, float z) {
        float f = this.normal.dot(x, y, z) + this.d;
        if (f == 0.0f) {
            return PlaneSide.OnPlane;
        }
        if (f < 0.0f) {
            return PlaneSide.Back;
        }
        return PlaneSide.Front;
    }

    public boolean isFrontFacing(Vector3 direction) {
        return this.normal.dot(direction) <= 0.0f;
    }

    public Vector3 getNormal() {
        return this.normal;
    }

    public float getD() {
        return this.d;
    }

    public void Set4(Vector3 point, Vector3 normal) {
        this.normal.set(normal);
        this.d = -point.dot(normal);
    }

    public void Set5(float pointX, float pointY, float pointZ, float norX, float norY, float norZ) {
        this.normal.set(norX, norY, norZ);
        this.d = -(pointX * norX + pointY * norY + pointZ * norZ);
    }

    public void Set6(Plane plane) {
        this.normal.set(plane.normal);
        this.d = plane.d;
    }

    public String toString() {
        return String.valueOf(this.normal.toString()) + ", " + this.d;
    }

    @BA.Hide
    public static enum PlaneSide {
        OnPlane,
        Back,
        Front;

    }
}

