/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;

@BA.ShortName(value="lgMathPolygon")
public class Polygon {
    private float[] a;
    private float[] b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;
    private float h = 1.0f;
    private float i = 1.0f;
    private boolean j = true;
    private Rectangle k;

    public Polygon() {
        this.a = new float[0];
    }

    public Polygon(float[] vertices) {
        if (vertices.length < 6) {
            throw new IllegalArgumentException("polygons must contain at least 3 points.");
        }
        this.a = vertices;
    }

    public float[] getVertices() {
        return this.a;
    }

    public float[] getTransformedVertices() {
        if (!this.j) {
            return this.b;
        }
        this.j = false;
        float[] fArray = this.a;
        if (this.b == null || this.b.length != fArray.length) {
            this.b = new float[fArray.length];
        }
        float[] fArray2 = this.b;
        float f = this.c;
        float f2 = this.d;
        float f3 = this.e;
        float f4 = this.f;
        float f5 = this.h;
        float f6 = this.i;
        boolean bl = f5 != 1.0f || f6 != 1.0f;
        float f7 = this.g;
        float f8 = MathUtils.cosDeg(f7);
        float f9 = MathUtils.sinDeg(f7);
        int n = 0;
        int n2 = fArray.length;
        while (n < n2) {
            float f10 = fArray[n] - f3;
            float f11 = fArray[n + 1] - f4;
            if (bl) {
                f10 *= f5;
                f11 *= f6;
            }
            if (f7 != 0.0f) {
                float f12 = f10;
                f10 = f8 * f10 - f9 * f11;
                f11 = f9 * f12 + f8 * f11;
            }
            fArray2[n] = f + f10 + f3;
            fArray2[n + 1] = f2 + f11 + f4;
            n += 2;
        }
        return fArray2;
    }

    public void setOrigin(float originX, float originY) {
        this.e = originX;
        this.f = originY;
        this.j = true;
    }

    public void setPosition(float x, float y) {
        this.c = x;
        this.d = y;
        this.j = true;
    }

    public void setVertices(float[] vertices) {
        if (vertices.length < 6) {
            throw new IllegalArgumentException("polygons must contain at least 3 points.");
        }
        this.a = vertices;
        this.j = true;
    }

    public void translate(float x, float y) {
        this.c += x;
        this.d += y;
        this.j = true;
    }

    public void setRotation(float degrees) {
        this.g = degrees;
        this.j = true;
    }

    public void rotate(float degrees) {
        this.g += degrees;
        this.j = true;
    }

    public void setScale(float scaleX, float scaleY) {
        this.h = scaleX;
        this.i = scaleY;
        this.j = true;
    }

    public void scale(float amount) {
        this.h += amount;
        this.i += amount;
        this.j = true;
    }

    public void dirty() {
        this.j = true;
    }

    public float area() {
        float[] fArray = this.getTransformedVertices();
        return GeometryUtils.polygonArea(fArray, 0, fArray.length);
    }

    public Rectangle getBoundingRectangle() {
        float[] fArray = this.getTransformedVertices();
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[0];
        float f4 = fArray[1];
        int n = fArray.length;
        int n2 = 2;
        while (n2 < n) {
            f = f > fArray[n2] ? fArray[n2] : f;
            f2 = f2 > fArray[n2 + 1] ? fArray[n2 + 1] : f2;
            f3 = f3 < fArray[n2] ? fArray[n2] : f3;
            f4 = f4 < fArray[n2 + 1] ? fArray[n2 + 1] : f4;
            n2 += 2;
        }
        if (this.k == null) {
            this.k = new Rectangle();
        }
        this.k.x = f;
        this.k.y = f2;
        this.k.width = f3 - f;
        this.k.height = f4 - f2;
        return this.k;
    }

    public boolean contains(float x, float y) {
        float[] fArray = this.getTransformedVertices();
        int n = fArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            float f = fArray[n3];
            float f2 = fArray[n3 + 1];
            float f3 = fArray[(n3 + 2) % n];
            float f4 = fArray[(n3 + 3) % n];
            if ((f2 <= y && y < f4 || f4 <= y && y < f2) && x < (f3 - f) / (f4 - f2) * (y - f2) + f) {
                ++n2;
            }
            n3 += 2;
        }
        return n2 & true;
    }

    public float getX() {
        return this.c;
    }

    public float getY() {
        return this.d;
    }

    public float getOriginX() {
        return this.e;
    }

    public float getOriginY() {
        return this.f;
    }

    public float getRotation() {
        return this.g;
    }

    public float getScaleX() {
        return this.h;
    }

    public float getScaleY() {
        return this.i;
    }
}

