/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;

@BA.ShortName(value="lgMathPolyline")
public class Polyline {
    private float[] a;
    private float[] b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;
    private float h = 1.0f;
    private float i = 1.0f;
    private float j;
    private float k;
    private boolean l = true;
    private boolean m = true;
    private boolean n = true;

    public Polyline() {
        this.a = new float[0];
    }

    public Polyline(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("polylines must contain at least 2 points.");
        }
        this.a = vertices;
    }

    public float[] getVertices() {
        return this.a;
    }

    public float[] getTransformedVertices() {
        if (!this.n) {
            return this.b;
        }
        this.n = false;
        float[] fArray = this.a;
        if (this.b == null || this.b.length < fArray.length) {
            this.b = new float[fArray.length];
        }
        float[] fArray2 = this.b;
        float f = this.c;
        float f2 = this.d;
        float f3 = this.e;
        float f4 = this.f;
        float f5 = this.h;
        float f6 = this.i;
        boolean bl = f5 != 1.0f || f6 != 1.0f;
        float f7 = this.g;
        float f8 = MathUtils.cosDeg(f7);
        float f9 = MathUtils.sinDeg(f7);
        int n = 0;
        int n2 = fArray.length;
        while (n < n2) {
            float f10 = fArray[n] - f3;
            float f11 = fArray[n + 1] - f4;
            if (bl) {
                f10 *= f5;
                f11 *= f6;
            }
            if (f7 != 0.0f) {
                float f12 = f10;
                f10 = f8 * f10 - f9 * f11;
                f11 = f9 * f12 + f8 * f11;
            }
            fArray2[n] = f + f10 + f3;
            fArray2[n + 1] = f2 + f11 + f4;
            n += 2;
        }
        return fArray2;
    }

    public float getLength() {
        if (!this.m) {
            return this.j;
        }
        this.m = false;
        this.j = 0.0f;
        int n = 0;
        int n2 = this.a.length - 2;
        while (n < n2) {
            float f = this.a[n + 2] - this.a[n];
            float f2 = this.a[n + 1] - this.a[n + 3];
            float f3 = f;
            float f4 = f2;
            this.j += (float)Math.sqrt(f3 * f3 + f4 * f4);
            n += 2;
        }
        return this.j;
    }

    public float getScaledLength() {
        if (!this.l) {
            return this.k;
        }
        this.l = false;
        this.k = 0.0f;
        int n = 0;
        int n2 = this.a.length - 2;
        while (n < n2) {
            float f = this.a[n + 2] * this.h - this.a[n] * this.h;
            float f2 = this.a[n + 1] * this.i - this.a[n + 3] * this.i;
            float f3 = f;
            float f4 = f2;
            this.k += (float)Math.sqrt(f3 * f3 + f4 * f4);
            n += 2;
        }
        return this.k;
    }

    public float getX() {
        return this.c;
    }

    public float getY() {
        return this.d;
    }

    public float getOriginX() {
        return this.e;
    }

    public float getOriginY() {
        return this.f;
    }

    public float getRotation() {
        return this.g;
    }

    public float getScaleX() {
        return this.h;
    }

    public float getScaleY() {
        return this.i;
    }

    public void setOrigin(float originX, float originY) {
        this.e = originX;
        this.f = originY;
        this.n = true;
    }

    public void setPosition(float x, float y) {
        this.c = x;
        this.d = y;
        this.n = true;
    }

    public void setVertices(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("polylines must contain at least 2 points.");
        }
        this.a = vertices;
        this.n = true;
    }

    public void setRotation(float degrees) {
        this.g = degrees;
        this.n = true;
    }

    public void rotate(float degrees) {
        this.g += degrees;
        this.n = true;
    }

    public void setScale(float scaleX, float scaleY) {
        this.h = scaleX;
        this.i = scaleY;
        this.n = true;
        this.l = true;
    }

    public void scale(float amount) {
        this.h += amount;
        this.i += amount;
        this.n = true;
        this.l = true;
    }

    public void calculateLength() {
        this.m = true;
    }

    public void calculateScaledLength() {
        this.l = true;
    }

    public void dirty() {
        this.n = true;
    }

    public void translate(float x, float y) {
        this.c += x;
        this.d += y;
        this.n = true;
    }
}

