/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.Hide
public class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    private static Quaternion a = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    private static Quaternion b = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Quaternion() {
        this.idt();
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Vector3 axis, float angle) {
        this.set(axis, angle);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(Vector3 axis, float angle) {
        return this.setFromAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion cpy() {
        return new Quaternion(this);
    }

    public static final float len(float x, float y, float z, float w) {
        float f = x;
        float f2 = y;
        float f3 = z;
        float f4 = w;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public String toString() {
        return "[" + this.x + "|" + this.y + "|" + this.z + "|" + this.w + "]";
    }

    public Quaternion setEulerAngles(float yaw, float pitch, float roll) {
        return this.setEulerAnglesRad(yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), roll * ((float)Math.PI / 180));
    }

    public Quaternion setEulerAnglesRad(float yaw, float pitch, float roll) {
        float f = roll * 0.5f;
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        float f4 = pitch * 0.5f;
        float f5 = (float)Math.sin(f4);
        float f6 = (float)Math.cos(f4);
        float f7 = yaw * 0.5f;
        float f8 = (float)Math.sin(f7);
        float f9 = (float)Math.cos(f7);
        float f10 = f9 * f5;
        float f11 = f8 * f6;
        float f12 = f9 * f6;
        float f13 = f8 * f5;
        this.x = f10 * f3 + f11 * f2;
        this.y = f11 * f3 - f10 * f2;
        this.z = f12 * f2 - f13 * f3;
        this.w = f12 * f3 + f13 * f2;
        return this;
    }

    public int getGimbalPole() {
        float f;
        float f2 = this.y * this.x + this.z * this.w;
        if (f > 0.499f) {
            return 1;
        }
        if (f2 < -0.499f) {
            return -1;
        }
        return 0;
    }

    public float getRollRad() {
        int n = this.getGimbalPole();
        if (n == 0) {
            return MathUtils.atan2(2.0f * (this.w * this.z + this.y * this.x), 1.0f - 2.0f * (this.x * this.x + this.z * this.z));
        }
        return (float)n * 2.0f * MathUtils.atan2(this.y, this.w);
    }

    public float getRoll() {
        return this.getRollRad() * 57.295776f;
    }

    public float getPitchRad() {
        int n = this.getGimbalPole();
        if (n == 0) {
            return (float)Math.asin(MathUtils.clamp(2.0f * (this.w * this.x - this.z * this.y), -1.0f, 1.0f));
        }
        return (float)n * (float)Math.PI * 0.5f;
    }

    public float getPitch() {
        return this.getPitchRad() * 57.295776f;
    }

    public float getYawRad() {
        if (this.getGimbalPole() == 0) {
            return MathUtils.atan2(2.0f * (this.y * this.w + this.x * this.z), 1.0f - 2.0f * (this.y * this.y + this.x * this.x));
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.getYawRad() * 57.295776f;
    }

    public static final float len2(float x, float y, float z, float w) {
        float f = x;
        float f2 = y;
        float f3 = z;
        float f4 = w;
        return f * f + f2 * f2 + f3 * f3 + f4 * f4;
    }

    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaternion nor() {
        float f = this.len2();
        if (f != 0.0f && !MathUtils.isEqual(f, 1.0f)) {
            f = (float)Math.sqrt(f);
            this.w /= f;
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 transform(Vector3 v) {
        b.set(this);
        b.conjugate();
        b.mulLeft(a.set(v.x, v.y, v.z, 0.0f)).mulLeft(this);
        v.x = Quaternion.b.x;
        v.y = Quaternion.b.y;
        v.z = Quaternion.b.z;
        return v;
    }

    public Quaternion mul(Quaternion other) {
        float f = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        float f2 = this.w * other.y + this.y * other.w + this.z * other.x - this.x * other.z;
        float f3 = this.w * other.z + this.z * other.w + this.x * other.y - this.y * other.x;
        float f4 = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Quaternion mul(float x, float y, float z, float w) {
        float f = this.w * x + this.x * w + this.y * z - this.z * y;
        float f2 = this.w * y + this.y * w + this.z * x - this.x * z;
        float f3 = this.w * z + this.z * w + this.x * y - this.y * x;
        float f4 = this.w * w - this.x * x - this.y * y - this.z * z;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Quaternion mulLeft(Quaternion other) {
        float f = other.w * this.x + other.x * this.w + other.y * this.z - other.z * this.y;
        float f2 = other.w * this.y + other.y * this.w + other.z * this.x - other.x * this.z;
        float f3 = other.w * this.z + other.z * this.w + other.x * this.y - other.y * this.x;
        float f4 = other.w * this.w - other.x * this.x - other.y * this.y - other.z * this.z;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Quaternion mulLeft(float x, float y, float z, float w) {
        float f = w * this.x + x * this.w + y * this.z - z * y;
        float f2 = w * this.y + y * this.w + z * this.x - x * z;
        float f3 = w * this.z + z * this.w + x * this.y - y * x;
        float f4 = z;
        float f5 = w * this.w - x * this.x - y * this.y - f4 * f4;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f5;
        return this;
    }

    public void toMatrix(float[] matrix) {
        float f = this.x * this.x;
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.x * this.w;
        float f5 = this.y * this.y;
        float f6 = this.y * this.z;
        float f7 = this.y * this.w;
        float f8 = this.z * this.z;
        float f9 = this.z * this.w;
        matrix[0] = 1.0f - 2.0f * (f5 + f8);
        matrix[4] = 2.0f * (f2 - f9);
        matrix[8] = 2.0f * (f3 + f7);
        matrix[12] = 0.0f;
        matrix[1] = 2.0f * (f2 + f9);
        matrix[5] = 1.0f - 2.0f * (f + f8);
        matrix[9] = 2.0f * (f6 - f4);
        matrix[13] = 0.0f;
        matrix[2] = 2.0f * (f3 - f7);
        matrix[6] = 2.0f * (f6 + f4);
        matrix[10] = 1.0f - 2.0f * (f + f5);
        matrix[14] = 0.0f;
        matrix[3] = 0.0f;
        matrix[7] = 0.0f;
        matrix[11] = 0.0f;
        matrix[15] = 1.0f;
    }

    public Quaternion idt() {
        return this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public boolean isIdentity() {
        return MathUtils.isZero(this.x) && MathUtils.isZero(this.y) && MathUtils.isZero(this.z) && MathUtils.isEqual(this.w, 1.0f);
    }

    public boolean isIdentity(float tolerance) {
        return MathUtils.isZero2(this.x, tolerance) && MathUtils.isZero2(this.y, tolerance) && MathUtils.isZero2(this.z, tolerance) && MathUtils.isEqual2(this.w, 1.0f, tolerance);
    }

    public Quaternion setFromAxis(Vector3 axis, float degrees) {
        return this.setFromAxis(axis.x, axis.y, axis.z, degrees);
    }

    public Quaternion setFromAxisRad(Vector3 axis, float radians) {
        return this.setFromAxisRad(axis.x, axis.y, axis.z, radians);
    }

    public Quaternion setFromAxis(float x, float y, float z, float degrees) {
        return this.setFromAxisRad(x, y, z, degrees * ((float)Math.PI / 180));
    }

    public Quaternion setFromAxisRad(float x, float y, float z, float radians) {
        float f = Vector3.len(x, y, z);
        if (f == 0.0f) {
            return this.idt();
        }
        f = 1.0f / f;
        float f2 = radians < 0.0f ? (float)Math.PI * 2 - -radians % ((float)Math.PI * 2) : radians % ((float)Math.PI * 2);
        float f3 = (float)Math.sin(f2 / 2.0f);
        float f4 = (float)Math.cos(f2 / 2.0f);
        return this.set(f * x * f3, f * y * f3, f * z * f3, f4).nor();
    }

    public Quaternion setFromMatrix(boolean normalizeAxes, Matrix4 matrix) {
        return this.setFromAxes(normalizeAxes, matrix.val[0], matrix.val[4], matrix.val[8], matrix.val[1], matrix.val[5], matrix.val[9], matrix.val[2], matrix.val[6], matrix.val[10]);
    }

    public Quaternion setFromMatrix(Matrix4 matrix) {
        return this.setFromMatrix(false, matrix);
    }

    public Quaternion setFromMatrix(boolean normalizeAxes, Matrix3 matrix) {
        return this.setFromAxes(normalizeAxes, matrix.val[0], matrix.val[3], matrix.val[6], matrix.val[1], matrix.val[4], matrix.val[7], matrix.val[2], matrix.val[5], matrix.val[8]);
    }

    public Quaternion setFromMatrix(Matrix3 matrix) {
        return this.setFromMatrix(false, matrix);
    }

    public Quaternion setFromAxes(float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        return this.setFromAxes(false, xx, xy, xz, yx, yy, yz, zx, zy, zz);
    }

    public Quaternion setFromAxes(boolean normalizeAxes, float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        float f;
        float f2;
        float f3;
        if (normalizeAxes) {
            f3 = 1.0f / Vector3.len(xx, xy, xz);
            f2 = 1.0f / Vector3.len(yx, yy, yz);
            float f4 = 1.0f / Vector3.len(zx, zy, zz);
            xx *= f3;
            xy *= f3;
            xz *= f3;
            yx *= f2;
            yy *= f2;
            yz *= f2;
            zx *= f4;
            zy *= f4;
            zz *= f4;
        }
        f3 = xx + yy + zz;
        if (f >= 0.0f) {
            f2 = (float)Math.sqrt(f3 + 1.0f);
            this.w = 0.5f * f2;
            f2 = 0.5f / f2;
            this.x = (zy - yz) * f2;
            this.y = (xz - zx) * f2;
            this.z = (yx - xy) * f2;
        } else if (xx > yy && xx > zz) {
            f2 = (float)Math.sqrt(1.0 + (double)xx - (double)yy - (double)zz);
            this.x = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.y = (yx + xy) * f2;
            this.z = (xz + zx) * f2;
            this.w = (zy - yz) * f2;
        } else if (yy > zz) {
            f2 = (float)Math.sqrt(1.0 + (double)yy - (double)xx - (double)zz);
            this.y = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.x = (yx + xy) * f2;
            this.z = (zy + yz) * f2;
            this.w = (xz - zx) * f2;
        } else {
            f2 = (float)Math.sqrt(1.0 + (double)zz - (double)xx - (double)yy);
            this.z = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.x = (xz + zx) * f2;
            this.y = (zy + yz) * f2;
            this.w = (yx - xy) * f2;
        }
        return this;
    }

    public Quaternion setFromCross(Vector3 v1, Vector3 v2) {
        float f = (float)Math.acos(MathUtils.clamp(v1.dot(v2), -1.0f, 1.0f));
        return this.setFromAxisRad(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x, f);
    }

    public Quaternion setFromCross(float x1, float y1, float z1, float x2, float y2, float z2) {
        float f = (float)Math.acos(MathUtils.clamp(Vector3.dot(x1, y1, z1, x2, y2, z2), -1.0f, 1.0f));
        return this.setFromAxisRad(y1 * z2 - z1 * y2, z1 * x2 - x1 * z2, x1 * y2 - y1 * x2, f);
    }

    public Quaternion slerp(Quaternion end, float alpha) {
        float f;
        float f2 = this.x * end.x + this.y * end.y + this.z * end.z + this.w * end.w;
        float f3 = f < 0.0f ? -f2 : f2;
        float f4 = 1.0f - alpha;
        float f5 = alpha;
        if ((double)(1.0f - f3) > 0.1) {
            float f6 = (float)Math.acos(f3);
            float f7 = 1.0f / (float)Math.sin(f6);
            f4 = (float)Math.sin(f4 * f6) * f7;
            f5 = (float)Math.sin(alpha * f6) * f7;
        }
        if (f2 < 0.0f) {
            f5 = -f5;
        }
        this.x = f4 * this.x + f5 * end.x;
        this.y = f4 * this.y + f5 * end.y;
        this.z = f4 * this.z + f5 * end.z;
        this.w = f4 * this.w + f5 * end.w;
        return this;
    }

    public int hashCode() {
        int n = 31 + NumberUtils.floatToRawIntBits(this.w);
        n = 31 * n + NumberUtils.floatToRawIntBits(this.x);
        n = 31 * n + NumberUtils.floatToRawIntBits(this.y);
        return 31 * n + NumberUtils.floatToRawIntBits(this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)obj;
        return NumberUtils.floatToRawIntBits(this.w) == NumberUtils.floatToRawIntBits(quaternion.w) && NumberUtils.floatToRawIntBits(this.x) == NumberUtils.floatToRawIntBits(quaternion.x) && NumberUtils.floatToRawIntBits(this.y) == NumberUtils.floatToRawIntBits(quaternion.y) && NumberUtils.floatToRawIntBits(this.z) == NumberUtils.floatToRawIntBits(quaternion.z);
    }

    public static final float dot(float x1, float y1, float z1, float w1, float x2, float y2, float z2, float w2) {
        return x1 * x2 + y1 * y2 + z1 * z2 + w1 * w2;
    }

    public float dot(Quaternion other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public Quaternion mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public float getAxisAngle(Vector3 axis) {
        return this.getAxisAngleRad(axis) * 57.295776f;
    }

    public float getAxisAngleRad(Vector3 axis) {
        double d;
        if (this.w > 1.0f) {
            this.nor();
        }
        float f = (float)(2.0 * Math.acos(this.w));
        double d2 = Math.sqrt(1.0f - this.w * this.w);
        if (d < (double)1.0E-6f) {
            axis.x = this.x;
            axis.y = this.y;
            axis.z = this.z;
        } else {
            axis.x = (float)((double)this.x / d2);
            axis.y = (float)((double)this.y / d2);
            axis.z = (float)((double)this.z / d2);
        }
        return f;
    }

    public float getAngleRad() {
        return (float)(2.0 * Math.acos(this.w > 1.0f ? this.w / this.len() : this.w));
    }

    public float getAngle() {
        return this.getAngleRad() * 57.295776f;
    }

    public void getSwingTwist(float axisX, float axisY, float axisZ, Quaternion swing, Quaternion twist) {
        float f = Vector3.dot(this.x, this.y, this.z, axisX, axisY, axisZ);
        twist.set(axisX * f, axisY * f, axisZ * f, this.w).nor();
        swing.set(twist).conjugate().mulLeft(this);
    }

    public void getSwingTwist(Vector3 axis, Quaternion swing, Quaternion twist) {
        this.getSwingTwist(axis.x, axis.y, axis.z, swing, twist);
    }

    public float getAngleAroundRad(float axisX, float axisY, float axisZ) {
        float f = Vector3.dot(this.x, this.y, this.z, axisX, axisY, axisZ);
        float f2 = Quaternion.len2(axisX * f, axisY * f, axisZ * f, this.w);
        if (MathUtils.isZero(f2)) {
            return 0.0f;
        }
        return (float)(2.0 * Math.acos(MathUtils.clamp((float)((double)this.w / Math.sqrt(f2)), -1.0f, 1.0f)));
    }

    public float getAngleAroundRad(Vector3 axis) {
        return this.getAngleAroundRad(axis.x, axis.y, axis.z);
    }

    public float getAngleAround(float axisX, float axisY, float axisZ) {
        return this.getAngleAroundRad(axisX, axisY, axisZ) * 57.295776f;
    }

    public float getAngleAround(Vector3 axis) {
        return this.getAngleAround(axis.x, axis.y, axis.z);
    }
}

