/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathRectangle")
public class Rectangle
implements Serializable {
    public static final Rectangle tmp = new Rectangle();
    public static final Rectangle tmp2 = new Rectangle();
    private static final long serialVersionUID = 5733252015138115702L;
    public float x;
    public float y;
    public float width;
    public float height;

    public Rectangle() {
    }

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public Rectangle Set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    protected float getX() {
        return this.x;
    }

    protected Rectangle setX(float x) {
        this.x = x;
        return this;
    }

    protected float getY() {
        return this.y;
    }

    protected Rectangle setY(float y) {
        this.y = y;
        return this;
    }

    protected float getWidth() {
        return this.width;
    }

    protected Rectangle setWidth(float width) {
        this.width = width;
        return this;
    }

    protected float getHeight() {
        return this.height;
    }

    protected Rectangle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Vector2 getPosition(Vector2 position) {
        return position.set(this.x, this.y);
    }

    public Rectangle setPosition(Vector2 position) {
        this.x = position.x;
        this.y = position.y;
        return this;
    }

    public Rectangle setPosition2(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rectangle setSize2(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setSize(float sizeXY) {
        this.width = sizeXY;
        this.height = sizeXY;
        return this;
    }

    public Vector2 getSize(Vector2 size) {
        return size.set(this.width, this.height);
    }

    public boolean contains(float x, float y) {
        return this.x <= x && this.x + this.width >= x && this.y <= y && this.y + this.height >= y;
    }

    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        float f = rectangle.x;
        float f2 = f + rectangle.width;
        float f3 = rectangle.y;
        float f4 = f3 + rectangle.height;
        return f > this.x && f < this.x + this.width && f2 > this.x && f2 < this.x + this.width && f3 > this.y && f3 < this.y + this.height && f4 > this.y && f4 < this.y + this.height;
    }

    public boolean overlaps(Rectangle r) {
        return this.x < r.x + r.width && this.x + this.width > r.x && this.y < r.y + r.height && this.y + this.height > r.y;
    }

    public Rectangle Set2(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    }

    public Rectangle merge(Rectangle rect) {
        float f = Math.min(this.x, rect.x);
        float f2 = Math.max(this.x + this.width, rect.x + rect.width);
        this.x = f;
        this.width = f2 - f;
        float f3 = Math.min(this.y, rect.y);
        float f4 = Math.max(this.y + this.height, rect.y + rect.height);
        this.y = f3;
        this.height = f4 - f3;
        return this;
    }

    public Rectangle merge2(float x, float y) {
        float f = Math.min(this.x, x);
        float f2 = Math.max(this.x + this.width, x);
        this.x = f;
        this.width = f2 - f;
        float f3 = Math.min(this.y, y);
        float f4 = Math.max(this.y + this.height, y);
        this.y = f3;
        this.height = f4 - f3;
        return this;
    }

    public Rectangle merge(Vector2 vec) {
        return this.merge2(vec.x, vec.y);
    }

    public Rectangle merge(Vector2[] vecs) {
        float f = this.x;
        float f2 = this.x + this.width;
        float f3 = this.y;
        float f4 = this.y + this.height;
        int n = 0;
        while (n < vecs.length) {
            Vector2 vector2 = vecs[n];
            f = Math.min(f, vector2.x);
            f2 = Math.max(f2, vector2.x);
            f3 = Math.min(f3, vector2.y);
            f4 = Math.max(f4, vector2.y);
            ++n;
        }
        this.x = f;
        this.width = f2 - f;
        this.y = f3;
        this.height = f4 - f3;
        return this;
    }

    public float getAspectRatio() {
        if (this.height == 0.0f) {
            return Float.NaN;
        }
        return this.width / this.height;
    }

    public Vector2 getCenter(Vector2 vector) {
        vector.x = this.x + this.width / 2.0f;
        vector.y = this.y + this.height / 2.0f;
        return vector;
    }

    public Rectangle SetCenter2(float x, float y) {
        this.setPosition2(x - this.width / 2.0f, y - this.height / 2.0f);
        return this;
    }

    public Rectangle setCenter(Vector2 position) {
        this.setPosition2(position.x - this.width / 2.0f, position.y - this.height / 2.0f);
        return this;
    }

    public Rectangle fitOutside(Rectangle rect) {
        float f;
        float f2 = this.getAspectRatio();
        if (f > rect.getAspectRatio()) {
            this.setSize2(rect.height * f2, rect.height);
        } else {
            this.setSize2(rect.width, rect.width / f2);
        }
        this.setPosition2(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public Rectangle fitInside(Rectangle rect) {
        float f;
        float f2 = this.getAspectRatio();
        if (f < rect.getAspectRatio()) {
            this.setSize2(rect.height * f2, rect.height);
        } else {
            this.setSize2(rect.width, rect.width / f2);
        }
        this.setPosition2(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.width + "," + this.height + "]";
    }

    public float area() {
        return this.width * this.height;
    }

    public float perimeter() {
        return 2.0f * (this.width + this.height);
    }

    public int hashCode() {
        int n = 31 + NumberUtils.floatToRawIntBits(this.height);
        n = 31 * n + NumberUtils.floatToRawIntBits(this.width);
        n = 31 * n + NumberUtils.floatToRawIntBits(this.x);
        return 31 * n + NumberUtils.floatToRawIntBits(this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)obj;
        if (NumberUtils.floatToRawIntBits(this.height) != NumberUtils.floatToRawIntBits(rectangle.height)) {
            return false;
        }
        if (NumberUtils.floatToRawIntBits(this.width) != NumberUtils.floatToRawIntBits(rectangle.width)) {
            return false;
        }
        if (NumberUtils.floatToRawIntBits(this.x) != NumberUtils.floatToRawIntBits(rectangle.x)) {
            return false;
        }
        return NumberUtils.floatToRawIntBits(this.y) == NumberUtils.floatToRawIntBits(rectangle.y);
    }
}

