/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathVector2")
public class Vector2
implements Vector<Vector2>,
Serializable {
    private static final long serialVersionUID = 913902788239530931L;
    public static final Vector2 X2 = new Vector2(1.0f, 0.0f);
    public static final Vector2 Y2 = new Vector2(0.0f, 1.0f);
    public static final Vector2 Zero = new Vector2(0.0f, 0.0f);
    public float x;
    public float y;

    public Vector2() {
    }

    public Vector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(Vector2 v) {
        this.set(v);
    }

    @Override
    public Vector2 cpy() {
        return new Vector2(this);
    }

    @BA.Hide
    public static float len_xy(float x, float y) {
        float f = x;
        float f2 = y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public float len2() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2 Set2(Vector2 v) {
        return this.set(v);
    }

    @Override
    @BA.Hide
    public Vector2 set(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2 Set(float X, float Y) {
        return this.set(X, Y);
    }

    @BA.Hide
    public Vector2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public Vector2 sub(Vector2 v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    @Override
    public Vector2 nor() {
        float f = this.len();
        if (f != 0.0f) {
            this.x /= f;
            this.y /= f;
        }
        return this;
    }

    @Override
    public Vector2 add(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2 add2(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    public float dot(Vector2 v) {
        return this.x * v.x + this.y * v.y;
    }

    @Override
    public Vector2 scl(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2 scl2(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @Override
    public Vector2 scl(Vector2 v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public Vector2 div(float value) {
        return this.scl(1.0f / value);
    }

    public Vector2 div2(float vx, float vy) {
        return this.scl2(1.0f / vx, 1.0f / vy);
    }

    public Vector2 div3(Vector2 other) {
        return this.scl2(1.0f / other.x, 1.0f / other.y);
    }

    @Override
    public float dst(Vector2 v) {
        float f = v.x - this.x;
        float f2 = v.y - this.y;
        float f3 = f;
        float f4 = f2;
        return (float)Math.sqrt(f3 * f3 + f4 * f4);
    }

    public float dst_xy(float x, float y) {
        float f = x - this.x;
        float f2 = y - this.y;
        float f3 = f;
        float f4 = f2;
        return (float)Math.sqrt(f3 * f3 + f4 * f4);
    }

    @Override
    public float dst2(Vector2 v) {
        float f = v.x - this.x;
        float f2 = v.y - this.y;
        float f3 = f;
        float f4 = f2;
        return f3 * f3 + f4 * f4;
    }

    public float dst2_xy(float x, float y) {
        float f = x - this.x;
        float f2 = y - this.y;
        float f3 = f;
        float f4 = f2;
        return f3 * f3 + f4 * f4;
    }

    @Override
    public Vector2 limit(float limit) {
        float f = this.len2();
        float f2 = limit;
        float f3 = f2 * f2;
        if (f > f3) {
            return this.scl((float)Math.sqrt(f3 / f));
        }
        return this;
    }

    @Override
    public Vector2 clamp(float min, float max) {
        float f = this.len2();
        if (f == 0.0f) {
            return this;
        }
        float f2 = max;
        float f3 = f2 * f2;
        if (f > f3) {
            return this.scl((float)Math.sqrt(f3 / f));
        }
        float f4 = min;
        float f5 = f4 * f4;
        if (f < f5) {
            return this.scl((float)Math.sqrt(f5 / f));
        }
        return this;
    }

    public String toString() {
        return "[" + this.x + ":" + this.y + "]";
    }

    public Vector2 sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2 mul(Matrix3 mat) {
        float f = this.x * mat.val[0] + this.y * mat.val[3] + mat.val[6];
        float f2 = this.x * mat.val[1] + this.y * mat.val[4] + mat.val[7];
        this.x = f;
        this.y = f2;
        return this;
    }

    public float crs(Vector2 v) {
        return this.x * v.y - this.y * v.x;
    }

    public float crs2(float x, float y) {
        return this.x * y - this.y * x;
    }

    public float getAngle() {
        float f;
        float f2 = (float)Math.atan2(this.y, this.x) * 57.295776f;
        if (f < 0.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public float getAngleRad() {
        return (float)Math.atan2(this.y, this.x);
    }

    public void setAngle(float degrees) {
        Vector2 vector2 = this;
        vector2.set(vector2.len(), 0.0f);
        this.rotate(degrees);
    }

    public Vector2 rotate(float degrees) {
        return this.rotateRad(degrees * ((float)Math.PI / 180));
    }

    public Vector2 rotateRad(float radians) {
        float f = (float)Math.cos(radians);
        float f2 = (float)Math.sin(radians);
        float f3 = this.x * f - this.y * f2;
        float f4 = this.x * f2 + this.y * f;
        this.x = f3;
        this.y = f4;
        return this;
    }

    public Vector2 rotate90(int dir) {
        float f = this.x;
        if (dir >= 0) {
            this.x = -this.y;
            this.y = f;
        } else {
            this.x = this.y;
            this.y = -f;
        }
        return this;
    }

    @Override
    public Vector2 lerp(Vector2 target, float alpha) {
        float f = 1.0f - alpha;
        this.x = this.x * f + target.x * alpha;
        this.y = this.y * f + target.y * alpha;
        return this;
    }

    @Override
    public Vector2 interpolate(Vector2 target, float alpha, Interpolation interpolation) {
        return this.lerp(target, interpolation.apply(alpha));
    }

    public int hashCode() {
        int n = 31 + NumberUtils.floatToIntBits(this.x);
        return 31 * n + NumberUtils.floatToIntBits(this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2 vector2 = (Vector2)obj;
        if (NumberUtils.floatToIntBits(this.x) != NumberUtils.floatToIntBits(vector2.x)) {
            return false;
        }
        return NumberUtils.floatToIntBits(this.y) == NumberUtils.floatToIntBits(vector2.y);
    }

    public boolean epsilonEquals2(Vector2 other, float epsilon) {
        if (other == null) {
            return false;
        }
        if (Math.abs(other.x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(other.y - this.y) > epsilon);
    }

    public boolean epsilonEquals(float x, float y, float epsilon) {
        if (Math.abs(x - this.x) > epsilon) {
            return false;
        }
        return !(Math.abs(y - this.y) > epsilon);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit2(1.0E-9f);
    }

    @Override
    public boolean isUnit2(float margin) {
        return Math.abs(this.len2() - 1.0f) < margin;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    @Override
    public boolean isZero2(float margin) {
        return this.len2() < margin;
    }

    public boolean isOnLine(Vector2 other) {
        return MathUtils.isZero(this.x * other.y - this.y * other.x);
    }

    public boolean isCollinear(Vector2 other) {
        return this.isOnLine(other) && this.dot(other) > 0.0f;
    }

    public boolean isPerpendicular(Vector2 vector) {
        return MathUtils.isZero(this.dot(vector));
    }

    public boolean hasSameDirection(Vector2 vector) {
        return this.dot(vector) > 0.0f;
    }

    public boolean hasOppositeDirection(Vector2 vector) {
        return this.dot(vector) < 0.0f;
    }
}

