/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathVector3")
public class Vector3
implements Vector<Vector3>,
Serializable {
    private static final long serialVersionUID = 3840054589595372522L;
    public float x;
    public float y;
    public float z;
    public static final Vector3 X3 = new Vector3(1.0f, 0.0f, 0.0f);
    public static final Vector3 Y3 = new Vector3(0.0f, 1.0f, 0.0f);
    public static final Vector3 Z3 = new Vector3(0.0f, 0.0f, 1.0f);
    public static final Vector3 Zero = new Vector3(0.0f, 0.0f, 0.0f);
    private static final Matrix4 a = new Matrix4();

    public Vector3() {
    }

    public Vector3(float x, float y, float z) {
        this.set(x, y, z);
    }

    public Vector3(Vector3 vector) {
        this.set(vector);
    }

    public Vector3(float[] values) {
        this.set(values[0], values[1], values[2]);
    }

    public Vector3(Vector2 vector, float z) {
        this.set(vector.x, vector.y, z);
    }

    public Vector3 set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public Vector3 set(Vector3 vector) {
        return this.set(vector.x, vector.y, vector.z);
    }

    public Vector3 set2(float[] values) {
        return this.set(values[0], values[1], values[2]);
    }

    public Vector3 set(Vector2 vector, float z) {
        return this.set(vector.x, vector.y, z);
    }

    @Override
    public Vector3 cpy() {
        return new Vector3(this);
    }

    @Override
    public Vector3 add(Vector3 vector) {
        return this.add(vector.x, vector.y, vector.z);
    }

    public Vector3 add(float x, float y, float z) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x + x, this.y + y, this.z + z);
    }

    @Override
    public Vector3 add(float values) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x + values, this.y + values, this.z + values);
    }

    @Override
    public Vector3 sub(Vector3 a_vec) {
        return this.sub(a_vec.x, a_vec.y, a_vec.z);
    }

    public Vector3 sub(float x, float y, float z) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x - x, this.y - y, this.z - z);
    }

    @Override
    public Vector3 sub(float value) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x - value, this.y - value, this.z - value);
    }

    @Override
    public Vector3 scl(float value) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x * value, this.y * value, this.z * value);
    }

    public Vector3 mul(float value) {
        return this.scl(value);
    }

    @Override
    public Vector3 scl(Vector3 other) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3 mul(Vector3 other) {
        return this.scl(other);
    }

    public Vector3 scl(float vx, float vy, float vz) {
        Vector3 vector3 = this;
        return vector3.set(vector3.x * vx, this.y * vy, this.z * vz);
    }

    public static float len(float x, float y, float z) {
        float f = x;
        float f2 = y;
        float f3 = z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static float len2(float x, float y, float z) {
        float f = x;
        float f2 = y;
        float f3 = z;
        return f * f + f2 * f2 + f3 * f3;
    }

    @Override
    public float len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public boolean idt(Vector3 vector) {
        return this.x == vector.x && this.y == vector.y && this.z == vector.z;
    }

    public static float dst(float x1, float y1, float z1, float x2, float y2, float z2) {
        float f = x2 - x1;
        float f2 = y2 - y1;
        float f3 = z2 - z1;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
    }

    @Override
    public float dst(Vector3 vector) {
        float f = vector.x - this.x;
        float f2 = vector.y - this.y;
        float f3 = vector.z - this.z;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
    }

    public float dst(float x, float y, float z) {
        float f = x - this.x;
        float f2 = y - this.y;
        float f3 = z - this.z;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
    }

    public static float dst2(float x1, float y1, float z1, float x2, float y2, float z2) {
        float f = x2 - x1;
        float f2 = y2 - y1;
        float f3 = z2 - z1;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }

    @Override
    public float dst2(Vector3 point) {
        float f = point.x - this.x;
        float f2 = point.y - this.y;
        float f3 = point.z - this.z;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }

    public float dst2(float x, float y, float z) {
        float f = x - this.x;
        float f2 = y - this.y;
        float f3 = z - this.z;
        float f4 = f;
        float f5 = f2;
        float f6 = f3;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }

    @Override
    public Vector3 nor() {
        float f = this.len2();
        if (f == 0.0f || f == 1.0f) {
            return this;
        }
        return this.scl(1.0f / (float)Math.sqrt(f));
    }

    public static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    @Override
    public float dot(Vector3 vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public Vector3 crs(Vector3 vector) {
        Vector3 vector3 = this;
        return vector3.set(vector3.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public Vector3 crs(float x, float y, float z) {
        Vector3 vector3 = this;
        return vector3.set(vector3.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public Vector3 mul(Matrix4 matrix) {
        float[] fArray = matrix.val;
        Vector3 vector3 = this;
        return vector3.set(vector3.x * fArray[0] + this.y * fArray[4] + this.z * fArray[8] + fArray[12], this.x * fArray[1] + this.y * fArray[5] + this.z * fArray[9] + fArray[13], this.x * fArray[2] + this.y * fArray[6] + this.z * fArray[10] + fArray[14]);
    }

    public Vector3 mul(Quaternion quat) {
        return quat.transform(this);
    }

    public Vector3 prj(Matrix4 matrix) {
        float[] fArray = matrix.val;
        float f = 1.0f / (this.x * fArray[3] + this.y * fArray[7] + this.z * fArray[11] + fArray[15]);
        Vector3 vector3 = this;
        return vector3.set((vector3.x * fArray[0] + this.y * fArray[4] + this.z * fArray[8] + fArray[12]) * f, (this.x * fArray[1] + this.y * fArray[5] + this.z * fArray[9] + fArray[13]) * f, (this.x * fArray[2] + this.y * fArray[6] + this.z * fArray[10] + fArray[14]) * f);
    }

    public Vector3 rot(Matrix4 matrix) {
        float[] fArray = matrix.val;
        Vector3 vector3 = this;
        return vector3.set(vector3.x * fArray[0] + this.y * fArray[4] + this.z * fArray[8], this.x * fArray[1] + this.y * fArray[5] + this.z * fArray[9], this.x * fArray[2] + this.y * fArray[6] + this.z * fArray[10]);
    }

    public Vector3 rotate(float degrees, float axisX, float axisY, float axisZ) {
        return this.mul(a.setToRotation(axisX, axisY, axisZ, degrees));
    }

    public Vector3 rotate(Vector3 axis, float degrees) {
        a.setToRotation(axis, degrees);
        return this.mul(a);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit2(1.0E-9f);
    }

    @Override
    public boolean isUnit2(float margin) {
        return Math.abs(this.len2() - 1.0f) < margin;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    @Override
    public boolean isZero2(float margin) {
        return this.len2() < margin;
    }

    @Override
    public Vector3 lerp(Vector3 target, float alpha) {
        this.x += alpha * (target.x - this.x);
        this.y += alpha * (target.y - this.y);
        this.z += alpha * (target.z - this.z);
        return this;
    }

    @Override
    public Vector3 interpolate(Vector3 target, float alpha, Interpolation interpolator) {
        return this.lerp(target, interpolator.apply(0.0f, 1.0f, alpha));
    }

    public Vector3 slerp(Vector3 target, float alpha) {
        float f = this.dot(target);
        if ((double)f > 0.9995 || (double)f < -0.9995) {
            return this.lerp(target, alpha);
        }
        float f2 = (float)Math.acos(f) * alpha;
        float f3 = (float)Math.sin(f2);
        float f4 = target.x - this.x * f;
        float f5 = target.y - this.y * f;
        float f6 = target.z - this.z * f;
        float f7 = f4;
        float f8 = f5;
        float f9 = f6;
        float f10 = f7 * f7 + f8 * f8 + f9 * f9;
        float f11 = f3 * (f10 < 1.0E-4f ? 1.0f : 1.0f / (float)Math.sqrt(f10));
        return this.scl((float)Math.cos(f2)).add(f4 * f11, f5 * f11, f6 * f11).nor();
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public Vector3 limit(float limit) {
        float f = limit;
        if (this.len2() > f * f) {
            this.nor().scl(limit);
        }
        return this;
    }

    @Override
    public Vector3 clamp(float min, float max) {
        float f = this.len2();
        if (f == 0.0f) {
            return this;
        }
        float f2 = max;
        if (f > f2 * f2) {
            return this.nor().scl(max);
        }
        float f3 = min;
        if (f < f3 * f3) {
            return this.nor().scl(min);
        }
        return this;
    }

    public int hashCode() {
        int n = 31 + NumberUtils.floatToIntBits(this.x);
        n = 31 * n + NumberUtils.floatToIntBits(this.y);
        return 31 * n + NumberUtils.floatToIntBits(this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)obj;
        if (NumberUtils.floatToIntBits(this.x) != NumberUtils.floatToIntBits(vector3.x)) {
            return false;
        }
        if (NumberUtils.floatToIntBits(this.y) != NumberUtils.floatToIntBits(vector3.y)) {
            return false;
        }
        return NumberUtils.floatToIntBits(this.z) == NumberUtils.floatToIntBits(vector3.z);
    }

    public boolean epsilonEquals(Vector3 other, float epsilon) {
        if (other == null) {
            return false;
        }
        if (Math.abs(other.x - this.x) > epsilon) {
            return false;
        }
        if (Math.abs(other.y - this.y) > epsilon) {
            return false;
        }
        return !(Math.abs(other.z - this.z) > epsilon);
    }

    public boolean epsilonEquals(float x, float y, float z, float epsilon) {
        if (Math.abs(x - this.x) > epsilon) {
            return false;
        }
        if (Math.abs(y - this.y) > epsilon) {
            return false;
        }
        return !(Math.abs(z - this.z) > epsilon);
    }
}

