/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import anywheresoftware.b4a.BA;

@BA.ShortName(value="lgMathWindowedMean")
public final class WindowedMean {
    private float[] a;
    private int b = 0;
    private int c;
    private float d = 0.0f;
    private boolean e = true;

    public WindowedMean(int window_size) {
        this.a = new float[window_size];
    }

    public final boolean hasEnoughData() {
        return this.b >= this.a.length;
    }

    public final void clear() {
        this.b = 0;
        this.c = 0;
        int n = 0;
        while (n < this.a.length) {
            this.a[n] = 0.0f;
            ++n;
        }
        this.e = true;
    }

    public final void addValue(float value) {
        if (this.b < this.a.length) {
            ++this.b;
        }
        this.a[this.c++] = value;
        if (this.c > this.a.length - 1) {
            this.c = 0;
        }
        this.e = true;
    }

    public final float getMean() {
        if (this.hasEnoughData()) {
            if (this.e) {
                float f = 0.0f;
                int n = 0;
                while (n < this.a.length) {
                    f += this.a[n];
                    ++n;
                }
                this.d = f / (float)this.a.length;
                this.e = false;
            }
            return this.d;
        }
        return 0.0f;
    }

    public final float getOldest() {
        if (this.c == this.a.length - 1) {
            return this.a[0];
        }
        return this.a[this.c + 1];
    }

    public final float getLatest() {
        return this.a[this.c - 1 == -1 ? this.a.length - 1 : this.c - 1];
    }

    public final float standardDeviation() {
        if (!this.hasEnoughData()) {
            return 0.0f;
        }
        float f = this.getMean();
        float f2 = 0.0f;
        int n = 0;
        while (n < this.a.length) {
            f2 += (this.a[n] - f) * (this.a[n] - f);
            ++n;
        }
        return (float)Math.sqrt(f2 / (float)this.a.length);
    }

    public final int getWindowSize() {
        return this.a.length;
    }
}

