/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;
import java.util.List;

@BA.ShortName(value="lgMathBoundingBox")
public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -1286036817192127343L;
    private Vector3[] a = new Vector3[8];
    public final Vector3 min = new Vector3();
    public final Vector3 max = new Vector3();
    private Vector3 b = new Vector3();
    private Vector3 c = new Vector3();
    private boolean d = true;

    public Vector3 getCenter() {
        return this.b;
    }

    @BA.Hide
    public Vector3 getCenter(Vector3 out) {
        return out.set(this.b);
    }

    protected void updateCorners() {
        if (!this.d) {
            return;
        }
        this.a[0].set(this.min.x, this.min.y, this.min.z);
        this.a[1].set(this.max.x, this.min.y, this.min.z);
        this.a[2].set(this.max.x, this.max.y, this.min.z);
        this.a[3].set(this.min.x, this.max.y, this.min.z);
        this.a[4].set(this.min.x, this.min.y, this.max.z);
        this.a[5].set(this.max.x, this.min.y, this.max.z);
        this.a[6].set(this.max.x, this.max.y, this.max.z);
        this.a[7].set(this.min.x, this.max.y, this.max.z);
        this.d = false;
    }

    public Vector3[] getCorners() {
        this.updateCorners();
        return this.a;
    }

    public Vector3 getDimensions() {
        return this.c;
    }

    @BA.Hide
    public Vector3 getDimensions(Vector3 out) {
        return out.set(this.c);
    }

    @BA.Hide
    public Vector3 getMin() {
        return this.min;
    }

    @BA.Hide
    public synchronized Vector3 getMax() {
        return this.max;
    }

    public BoundingBox() {
        this.d = true;
        int n = 0;
        while (n < 8) {
            this.a[n] = new Vector3();
            ++n;
        }
        this.clr();
    }

    public BoundingBox(BoundingBox bounds) {
        this.d = true;
        int n = 0;
        while (n < 8) {
            this.a[n] = new Vector3();
            ++n;
        }
        this.Set2(bounds);
    }

    public void Initialize(Vector3 minimum, Vector3 maximum) {
        this.d = true;
        int n = 0;
        while (n < 8) {
            this.a[n] = new Vector3();
            ++n;
        }
        this.set(minimum, maximum);
    }

    public BoundingBox(Vector3 minimum, Vector3 maximum) {
        this.Initialize(minimum, maximum);
    }

    public BoundingBox Set2(BoundingBox bounds) {
        this.d = true;
        return this.set(bounds.min, bounds.max);
    }

    public BoundingBox set(Vector3 minimum, Vector3 maximum) {
        this.min.set(minimum.x < maximum.x ? minimum.x : maximum.x, minimum.y < maximum.y ? minimum.y : maximum.y, minimum.z < maximum.z ? minimum.z : maximum.z);
        this.max.set(minimum.x > maximum.x ? minimum.x : maximum.x, minimum.y > maximum.y ? minimum.y : maximum.y, minimum.z > maximum.z ? minimum.z : maximum.z);
        this.b.set(this.min).add(this.max).scl(0.5f);
        this.c.set(this.max).sub(this.min);
        this.d = true;
        return this;
    }

    public BoundingBox Set3(Vector3[] points) {
        this.inf();
        Vector3[] vector3Array = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3 vector3 = vector3Array[n2];
            this.ext(vector3);
            ++n2;
        }
        this.d = true;
        return this;
    }

    public BoundingBox Set4(List<Vector3> points) {
        this.inf();
        for (Vector3 vector3 : points) {
            this.ext(vector3);
        }
        this.d = true;
        return this;
    }

    public BoundingBox inf() {
        this.min.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.max.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.b.set(0.0f, 0.0f, 0.0f);
        this.c.set(0.0f, 0.0f, 0.0f);
        this.d = true;
        return this;
    }

    public BoundingBox ext(Vector3 point) {
        this.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min.set(BoundingBox.a(this.min.x, point.x), BoundingBox.a(this.min.y, point.y), BoundingBox.a(this.min.z, point.z)), this.max.set(Math.max(this.max.x, point.x), Math.max(this.max.y, point.y), Math.max(this.max.z, point.z)));
    }

    public BoundingBox clr() {
        this.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min.set(0.0f, 0.0f, 0.0f), this.max.set(0.0f, 0.0f, 0.0f));
    }

    public boolean isValid() {
        return this.min.x < this.max.x && this.min.y < this.max.y && this.min.z < this.max.z;
    }

    public BoundingBox ext2(BoundingBox a_bounds) {
        this.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min.set(BoundingBox.a(this.min.x, a_bounds.min.x), BoundingBox.a(this.min.y, a_bounds.min.y), BoundingBox.a(this.min.z, a_bounds.min.z)), this.max.set(BoundingBox.b(this.max.x, a_bounds.max.x), BoundingBox.b(this.max.y, a_bounds.max.y), BoundingBox.b(this.max.z, a_bounds.max.z)));
    }

    public BoundingBox ext3(BoundingBox bounds, Matrix4 transform) {
        bounds.updateCorners();
        Vector3[] vector3Array = this.a;
        int n = 0;
        while (n < 8) {
            Vector3 vector3 = vector3Array[n];
            vector3.mul(transform);
            this.min.set(BoundingBox.a(this.min.x, vector3.x), BoundingBox.a(this.min.y, vector3.y), BoundingBox.a(this.min.z, vector3.z));
            this.max.set(BoundingBox.b(this.max.x, vector3.x), BoundingBox.b(this.max.y, vector3.y), BoundingBox.b(this.max.z, vector3.z));
            ++n;
        }
        this.d = true;
        bounds.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min, this.max);
    }

    public BoundingBox mul(Matrix4 matrix) {
        this.updateCorners();
        this.inf();
        Vector3[] vector3Array = this.a;
        int n = 0;
        while (n < 8) {
            Vector3 vector3 = vector3Array[n];
            vector3.mul(matrix);
            this.min.set(BoundingBox.a(this.min.x, vector3.x), BoundingBox.a(this.min.y, vector3.y), BoundingBox.a(this.min.z, vector3.z));
            this.max.set(BoundingBox.b(this.max.x, vector3.x), BoundingBox.b(this.max.y, vector3.y), BoundingBox.b(this.max.z, vector3.z));
            ++n;
        }
        this.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min, this.max);
    }

    public boolean contains(BoundingBox b2) {
        return !this.isValid() || this.min.x <= b2.min.x && this.min.y <= b2.min.y && this.min.z <= b2.min.z && this.max.x >= b2.max.x && this.max.y >= b2.max.y && this.max.z >= b2.max.z;
    }

    public boolean intersects(BoundingBox b2) {
        if (!this.isValid()) {
            return false;
        }
        float f = Math.abs(this.b.x - b2.b.x);
        float f2 = this.c.x / 2.0f + b2.c.x / 2.0f;
        float f3 = Math.abs(this.b.y - b2.b.y);
        float f4 = this.c.y / 2.0f + b2.c.y / 2.0f;
        float f5 = Math.abs(this.b.z - b2.b.z);
        float f6 = this.c.z / 2.0f + b2.c.z / 2.0f;
        return f <= f2 && f3 <= f4 && f5 <= f6;
    }

    public boolean contains2(Vector3 v) {
        return this.min.x <= v.x && this.max.x >= v.x && this.min.y <= v.y && this.max.y >= v.y && this.min.z <= v.z && this.max.z >= v.z;
    }

    public String toString() {
        return "[" + this.min + "|" + this.max + "]";
    }

    public BoundingBox ext4(float x, float y, float z) {
        this.d = true;
        BoundingBox boundingBox = this;
        return boundingBox.set(boundingBox.min.set(BoundingBox.a(this.min.x, x), BoundingBox.a(this.min.y, y), BoundingBox.a(this.min.z, z)), this.max.set(BoundingBox.b(this.max.x, x), BoundingBox.b(this.max.y, y), BoundingBox.b(this.max.z, z)));
    }

    private static float a(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        return f;
    }

    private static float b(float f, float f2) {
        if (f > f2) {
            return f;
        }
        return f2;
    }
}

