/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

@BA.ShortName(value="lgMathRay")
public class Ray
implements Serializable {
    private static final long serialVersionUID = -620692054835390878L;
    public Vector3 origin = new Vector3();
    public Vector3 direction = new Vector3();
    private static Vector3 a = new Vector3();

    public Ray() {
    }

    public void Initialize(Vector3 Origin, Vector3 Direction) {
        this.origin = Origin;
        this.direction = Direction;
    }

    public Ray(Vector3 origin, Vector3 direction) {
        this.origin.set(origin);
        this.direction.set(direction).nor();
    }

    public Ray cpy() {
        return new Ray(this.origin, this.direction);
    }

    public Vector3 getEndPoint(Vector3 out, float distance) {
        return out.set(this.direction).scl(distance).add(this.origin);
    }

    public Ray mul(Matrix4 matrix) {
        a.set(this.origin).add(this.direction);
        a.mul(matrix);
        this.origin.mul(matrix);
        this.direction.set(a.sub(this.origin));
        return this;
    }

    public String toString() {
        return "ray [" + this.origin + ":" + this.direction + "]";
    }

    public Ray Set(Vector3 origin, Vector3 direction) {
        this.origin.set(origin);
        this.direction.set(direction);
        return this;
    }

    public Ray Set2(float x, float y, float z, float dx, float dy, float dz) {
        this.origin.set(x, y, z);
        this.direction.set(dx, dy, dz);
        return this;
    }

    public Ray Set3(Ray ray) {
        this.origin.set(ray.origin);
        this.direction.set(ray.direction);
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Ray ray = (Ray)o;
        return this.direction.equals(ray.direction) && this.origin.equals(ray.origin);
    }
}

