/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math.collision;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

@BA.ShortName(value="lgMathSphere")
public class Sphere
implements Serializable {
    private static final long serialVersionUID = -6487336868908521596L;
    public float radius;
    public Vector3 center;

    public Sphere() {
    }

    public void Initialize(Vector3 Center, float Radius) {
        this.center = Center;
        this.radius = Radius;
    }

    public Sphere(Vector3 center, float radius) {
        this.center = new Vector3(center);
        this.radius = radius;
    }

    public boolean overlaps(Sphere sphere) {
        return this.center.dst2(sphere.center) < (this.radius + sphere.radius) * (this.radius + sphere.radius);
    }

    public int hashCode() {
        int n = 71 + this.center.hashCode();
        return 71 * n + NumberUtils.floatToRawIntBits(this.radius);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Sphere sphere = (Sphere)o;
        return this.radius == sphere.radius && this.center.equals(sphere.center);
    }

    public float volume() {
        return 4.1887903f * this.radius * this.radius * this.radius;
    }

    public float surfaceArea() {
        return (float)Math.PI * 4 * this.radius * this.radius;
    }
}

