/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;

@BA.ShortName(value="lgSocket")
public class NetJavaSocketImpl
implements Socket {
    private java.net.Socket a;

    public NetJavaSocketImpl() {
    }

    public NetJavaSocketImpl(Net.Protocol protocol, String host, int port, SocketHints hints) {
        try {
            this.a = new java.net.Socket();
            this.a(hints);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(host, port);
            if (hints != null) {
                this.a.connect(inetSocketAddress, hints.connectTimeout);
                return;
            }
            this.a.connect(inetSocketAddress);
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error making a socket connection to " + host + ":" + port, exception);
        }
    }

    public NetJavaSocketImpl(java.net.Socket socket, SocketHints hints) {
        this.a = socket;
        this.a(hints);
    }

    private void a(SocketHints socketHints) {
        if (socketHints != null) {
            try {
                this.a.setPerformancePreferences(socketHints.performancePrefConnectionTime, socketHints.performancePrefLatency, socketHints.performancePrefBandwidth);
                this.a.setTrafficClass(socketHints.trafficClass);
                this.a.setTcpNoDelay(socketHints.tcpNoDelay);
                this.a.setKeepAlive(socketHints.keepAlive);
                this.a.setSendBufferSize(socketHints.sendBufferSize);
                this.a.setReceiveBufferSize(socketHints.receiveBufferSize);
                this.a.setSoLinger(socketHints.linger, socketHints.lingerDuration);
                this.a.setSoTimeout(socketHints.socketTimeout);
                return;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error setting socket hints.", exception);
            }
        }
    }

    @Override
    public boolean isConnected() {
        if (this.a != null) {
            return this.a.isConnected();
        }
        return false;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.a.getInputStream();
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error getting input stream from socket.", exception);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return this.a.getOutputStream();
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error getting output stream from socket.", exception);
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.a.getRemoteSocketAddress().toString();
    }

    @Override
    public void dispose() {
        if (this.a != null) {
            try {
                this.a.close();
                this.a = null;
                return;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error closing socket.", exception);
            }
        }
    }
}

