/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.utils.lgArray;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;

@BA.ShortName(value="lgBox2DBody")
public class Body {
    protected long addr;
    private final float[] a = new float[4];
    private final World b;
    private Array<Fixture> c = new Array(2);
    protected Array<JointEdge> joints = new Array(2);
    private Object d;
    private final Transform e = new Transform();
    private final Vector2 f = new Vector2();
    private final Vector2 g = new Vector2();
    private final Vector2 h = new Vector2();
    private final Vector2 i = new Vector2();
    private final MassData j = new MassData();
    private final Vector2 k = new Vector2();
    private final Vector2 l = new Vector2();
    public final Vector2 localPoint2 = new Vector2();
    public final Vector2 localVector = new Vector2();
    public final Vector2 linVelWorld = new Vector2();
    public final Vector2 linVelLoc = new Vector2();

    public Body() {
        this.b = null;
    }

    protected Body(World world, long addr) {
        this.b = world;
        this.addr = addr;
    }

    protected void reset(long addr) {
        this.addr = addr;
        this.d = null;
        int n = 0;
        while (n < this.c.size) {
            this.b.freeFixtures.free(this.c.get(n));
            ++n;
        }
        this.c.clear();
        this.joints.clear();
    }

    public Fixture createFixture(FixtureDef def) {
        Body body = this;
        long l = body.jniCreateFixture(body.addr, def.shape.addr, def.friction, def.restitution, def.density, def.isSensor, def.filter.categoryBits, def.filter.maskBits, def.filter.groupIndex);
        Fixture fixture = this.b.freeFixtures.obtain();
        fixture.reset(this, l);
        this.b.fixtures.put(fixture.addr, fixture);
        this.c.add(fixture);
        return fixture;
    }

    private native long jniCreateFixture(long var1, long var3, float var5, float var6, float var7, boolean var8, short var9, short var10, short var11);

    public Fixture createFixture2(Shape shape, float density) {
        Body body = this;
        long l = body.jniCreateFixture(body.addr, shape.addr, density);
        Fixture fixture = this.b.freeFixtures.obtain();
        fixture.reset(this, l);
        this.b.fixtures.put(fixture.addr, fixture);
        this.c.add(fixture);
        return fixture;
    }

    private native long jniCreateFixture(long var1, long var3, float var5);

    public void destroyFixture(Fixture fixture) {
        this.b.a(this, fixture);
        fixture.setUserData(null);
        this.b.fixtures.remove(fixture.addr);
        this.c.removeValue(fixture, true);
        this.b.freeFixtures.free(fixture);
    }

    public void setTransform(Vector2 position, float angle) {
        Body body = this;
        body.jniSetTransform(body.addr, position.x, position.y, angle);
    }

    public void setTransform2(float x, float y, float angle) {
        Body body = this;
        body.jniSetTransform(body.addr, x, y, angle);
    }

    private native void jniSetTransform(long var1, float var3, float var4, float var5);

    public Transform getTransform() {
        Body body = this;
        body.jniGetTransform(body.addr, this.e.vals);
        return this.e;
    }

    private native void jniGetTransform(long var1, float[] var3);

    public Vector2 getPosition() {
        Body body = this;
        body.jniGetPosition(body.addr, this.a);
        this.f.x = this.a[0];
        this.f.y = this.a[1];
        return this.f;
    }

    private native void jniGetPosition(long var1, float[] var3);

    public float getAngle() {
        Body body = this;
        return body.jniGetAngle(body.addr);
    }

    private native float jniGetAngle(long var1);

    public Vector2 getWorldCenter() {
        Body body = this;
        body.jniGetWorldCenter(body.addr, this.a);
        this.g.x = this.a[0];
        this.g.y = this.a[1];
        return this.g;
    }

    private native void jniGetWorldCenter(long var1, float[] var3);

    public Vector2 getLocalCenter() {
        Body body = this;
        body.jniGetLocalCenter(body.addr, this.a);
        this.h.x = this.a[0];
        this.h.y = this.a[1];
        return this.h;
    }

    private native void jniGetLocalCenter(long var1, float[] var3);

    public void setLinearVelocity(Vector2 v) {
        Body body = this;
        body.jniSetLinearVelocity(body.addr, v.x, v.y);
    }

    public void setLinearVelocity2(float vX, float vY) {
        Body body = this;
        body.jniSetLinearVelocity(body.addr, vX, vY);
    }

    private native void jniSetLinearVelocity(long var1, float var3, float var4);

    public Vector2 getLinearVelocity() {
        Body body = this;
        body.jniGetLinearVelocity(body.addr, this.a);
        this.i.x = this.a[0];
        this.i.y = this.a[1];
        return this.i;
    }

    private native void jniGetLinearVelocity(long var1, float[] var3);

    public void setAngularVelocity(float omega) {
        Body body = this;
        body.jniSetAngularVelocity(body.addr, omega);
    }

    private native void jniSetAngularVelocity(long var1, float var3);

    public float getAngularVelocity() {
        Body body = this;
        return body.jniGetAngularVelocity(body.addr);
    }

    private native float jniGetAngularVelocity(long var1);

    public void applyForce(Vector2 force, Vector2 point, boolean wake) {
        Body body = this;
        body.jniApplyForce(body.addr, force.x, force.y, point.x, point.y, wake);
    }

    public void applyForce2(float forceX, float forceY, float pointX, float pointY, boolean wake) {
        Body body = this;
        body.jniApplyForce(body.addr, forceX, forceY, pointX, pointY, wake);
    }

    private native void jniApplyForce(long var1, float var3, float var4, float var5, float var6, boolean var7);

    public void applyForceToCenter(Vector2 force, boolean wake) {
        Body body = this;
        body.jniApplyForceToCenter(body.addr, force.x, force.y, wake);
    }

    public void applyForceToCenter2(float forceX, float forceY, boolean wake) {
        Body body = this;
        body.jniApplyForceToCenter(body.addr, forceX, forceY, wake);
    }

    private native void jniApplyForceToCenter(long var1, float var3, float var4, boolean var5);

    public void applyTorque(float torque, boolean wake) {
        Body body = this;
        body.jniApplyTorque(body.addr, torque, wake);
    }

    private native void jniApplyTorque(long var1, float var3, boolean var4);

    public void applyLinearImpulse(Vector2 impulse, Vector2 point, boolean wake) {
        Body body = this;
        body.jniApplyLinearImpulse(body.addr, impulse.x, impulse.y, point.x, point.y, wake);
    }

    public void applyLinearImpulse2(float impulseX, float impulseY, float pointX, float pointY, boolean wake) {
        Body body = this;
        body.jniApplyLinearImpulse(body.addr, impulseX, impulseY, pointX, pointY, wake);
    }

    private native void jniApplyLinearImpulse(long var1, float var3, float var4, float var5, float var6, boolean var7);

    public void applyAngularImpulse(float impulse, boolean wake) {
        Body body = this;
        body.jniApplyAngularImpulse(body.addr, impulse, wake);
    }

    private native void jniApplyAngularImpulse(long var1, float var3, boolean var4);

    public float getMass() {
        Body body = this;
        return body.jniGetMass(body.addr);
    }

    private native float jniGetMass(long var1);

    public float getInertia() {
        Body body = this;
        return body.jniGetInertia(body.addr);
    }

    private native float jniGetInertia(long var1);

    public MassData getMassData() {
        Body body = this;
        body.jniGetMassData(body.addr, this.a);
        this.j.mass = this.a[0];
        this.j.center.x = this.a[1];
        this.j.center.y = this.a[2];
        this.j.I = this.a[3];
        return this.j;
    }

    private native void jniGetMassData(long var1, float[] var3);

    public void setMassData(MassData data) {
        Body body = this;
        body.jniSetMassData(body.addr, data.mass, data.center.x, data.center.y, data.I);
    }

    private native void jniSetMassData(long var1, float var3, float var4, float var5, float var6);

    public void resetMassData() {
        Body body = this;
        body.jniResetMassData(body.addr);
    }

    private native void jniResetMassData(long var1);

    public Vector2 getWorldPoint(Vector2 localPoint) {
        Body body = this;
        body.jniGetWorldPoint(body.addr, localPoint.x, localPoint.y, this.a);
        this.k.x = this.a[0];
        this.k.y = this.a[1];
        return this.k;
    }

    private native void jniGetWorldPoint(long var1, float var3, float var4, float[] var5);

    public Vector2 getWorldVector(Vector2 localVector) {
        Body body = this;
        body.jniGetWorldVector(body.addr, localVector.x, localVector.y, this.a);
        this.l.x = this.a[0];
        this.l.y = this.a[1];
        return this.l;
    }

    private native void jniGetWorldVector(long var1, float var3, float var4, float[] var5);

    public Vector2 getLocalPoint(Vector2 worldPoint) {
        Body body = this;
        body.jniGetLocalPoint(body.addr, worldPoint.x, worldPoint.y, this.a);
        this.localPoint2.x = this.a[0];
        this.localPoint2.y = this.a[1];
        return this.localPoint2;
    }

    private native void jniGetLocalPoint(long var1, float var3, float var4, float[] var5);

    public Vector2 getLocalVector(Vector2 worldVector) {
        Body body = this;
        body.jniGetLocalVector(body.addr, worldVector.x, worldVector.y, this.a);
        this.localVector.x = this.a[0];
        this.localVector.y = this.a[1];
        return this.localVector;
    }

    private native void jniGetLocalVector(long var1, float var3, float var4, float[] var5);

    public Vector2 getLinearVelocityFromWorldPoint(Vector2 worldPoint) {
        Body body = this;
        body.jniGetLinearVelocityFromWorldPoint(body.addr, worldPoint.x, worldPoint.y, this.a);
        this.linVelWorld.x = this.a[0];
        this.linVelWorld.y = this.a[1];
        return this.linVelWorld;
    }

    private native void jniGetLinearVelocityFromWorldPoint(long var1, float var3, float var4, float[] var5);

    public Vector2 getLinearVelocityFromLocalPoint(Vector2 localPoint) {
        Body body = this;
        body.jniGetLinearVelocityFromLocalPoint(body.addr, localPoint.x, localPoint.y, this.a);
        this.linVelLoc.x = this.a[0];
        this.linVelLoc.y = this.a[1];
        return this.linVelLoc;
    }

    private native void jniGetLinearVelocityFromLocalPoint(long var1, float var3, float var4, float[] var5);

    public float getLinearDamping() {
        Body body = this;
        return body.jniGetLinearDamping(body.addr);
    }

    private native float jniGetLinearDamping(long var1);

    public void setLinearDamping(float linearDamping) {
        Body body = this;
        body.jniSetLinearDamping(body.addr, linearDamping);
    }

    private native void jniSetLinearDamping(long var1, float var3);

    public float getAngularDamping() {
        Body body = this;
        return body.jniGetAngularDamping(body.addr);
    }

    private native float jniGetAngularDamping(long var1);

    public void setAngularDamping(float angularDamping) {
        Body body = this;
        body.jniSetAngularDamping(body.addr, angularDamping);
    }

    private native void jniSetAngularDamping(long var1, float var3);

    public void setType(BodyDef.BodyType type) {
        Body body = this;
        body.jniSetType(body.addr, type.getValue());
    }

    private native void jniSetType(long var1, int var3);

    public BodyDef.BodyType getType() {
        Body body = this;
        int n = body.jniGetType(body.addr);
        if (n == 0) {
            return BodyDef.BodyType.StaticBody;
        }
        if (n == 1) {
            return BodyDef.BodyType.KinematicBody;
        }
        if (n == 2) {
            return BodyDef.BodyType.DynamicBody;
        }
        return BodyDef.BodyType.StaticBody;
    }

    private native int jniGetType(long var1);

    public void setBullet(boolean flag) {
        Body body = this;
        body.jniSetBullet(body.addr, flag);
    }

    private native void jniSetBullet(long var1, boolean var3);

    public boolean isBullet() {
        Body body = this;
        return body.jniIsBullet(body.addr);
    }

    private native boolean jniIsBullet(long var1);

    public void setSleepingAllowed(boolean flag) {
        Body body = this;
        body.jniSetSleepingAllowed(body.addr, flag);
    }

    private native void jniSetSleepingAllowed(long var1, boolean var3);

    public boolean isSleepingAllowed() {
        Body body = this;
        return body.jniIsSleepingAllowed(body.addr);
    }

    private native boolean jniIsSleepingAllowed(long var1);

    public void setAwake(boolean flag) {
        Body body = this;
        body.jniSetAwake(body.addr, flag);
    }

    private native void jniSetAwake(long var1, boolean var3);

    public boolean isAwake() {
        Body body = this;
        return body.jniIsAwake(body.addr);
    }

    private native boolean jniIsAwake(long var1);

    public void setActive(boolean flag) {
        if (flag) {
            Body body = this;
            body.jniSetActive(body.addr, flag);
            return;
        }
        this.b.a(this);
    }

    private native void jniSetActive(long var1, boolean var3);

    public boolean isActive() {
        Body body = this;
        return body.jniIsActive(body.addr);
    }

    private native boolean jniIsActive(long var1);

    public void setFixedRotation(boolean flag) {
        Body body = this;
        body.jniSetFixedRotation(body.addr, flag);
    }

    private native void jniSetFixedRotation(long var1, boolean var3);

    public boolean isFixedRotation() {
        Body body = this;
        return body.jniIsFixedRotation(body.addr);
    }

    private native boolean jniIsFixedRotation(long var1);

    public void GetFixtureList(lgArray Fixtures) {
        Fixtures.setArray(this.c);
    }

    public Fixture GetFixture(int Index) {
        return this.c.get(Index);
    }

    @BA.Hide
    public Array<Fixture> getFixtureList() {
        return this.c;
    }

    public void GetJointList(lgArray Joints) {
        Joints.setArray(this.joints);
    }

    @BA.Hide
    public Array<JointEdge> getJointList() {
        return this.joints;
    }

    public float getGravityScale() {
        Body body = this;
        return body.jniGetGravityScale(body.addr);
    }

    private native float jniGetGravityScale(long var1);

    public void setGravityScale(float scale) {
        Body body = this;
        body.jniSetGravityScale(body.addr, scale);
    }

    private native void jniSetGravityScale(long var1, float var3);

    public World getWorld() {
        return this.b;
    }

    public Object getUserData() {
        return this.d;
    }

    public void setUserData(Object userData) {
        this.d = userData;
    }
}

