/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.WorldManifold;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

@BA.ShortName(value="lgBox2DDebugRenderer")
public class Box2DDebugRenderer
implements Disposable {
    protected ShapeRenderer renderer;
    private static final Vector2[] a = new Vector2[1000];
    private static final Vector2 b = new Vector2();
    private static final Vector2 c = new Vector2();
    private static final Array<Body> d = new Array();
    private static final Array<Joint> e = new Array();
    private boolean f;
    private boolean g;
    private boolean h;
    private boolean i;
    private boolean j;
    private boolean k;
    public final Color SHAPE_NOT_ACTIVE = new Color(0.5f, 0.5f, 0.3f, 1.0f);
    public final Color SHAPE_STATIC = new Color(0.5f, 0.9f, 0.5f, 1.0f);
    public final Color SHAPE_KINEMATIC = new Color(0.5f, 0.5f, 0.9f, 1.0f);
    public final Color SHAPE_NOT_AWAKE = new Color(0.6f, 0.6f, 0.6f, 1.0f);
    public final Color SHAPE_AWAKE = new Color(0.9f, 0.7f, 0.7f, 1.0f);
    public final Color JOINT_COLOR = new Color(0.5f, 0.8f, 0.8f, 1.0f);
    public final Color AABB_COLOR = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public final Color VELOCITY_COLOR = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    private static Vector2 l = new Vector2();
    private static Vector2 m = new Vector2();
    private final Vector2 n = new Vector2();
    private final Vector2 o = new Vector2();
    private final Vector2 p = new Vector2();

    public void Initialize() {
        this.Initialize2(true, true, false, true, false, true);
    }

    public void Initialize2(boolean drawBodies, boolean drawJoints, boolean drawAABBs, boolean drawInactiveBodies, boolean drawVelocities, boolean drawContacts) {
        this.renderer = new ShapeRenderer();
        int n = 0;
        while (n < 1000) {
            Box2DDebugRenderer.a[n] = new Vector2();
            ++n;
        }
        this.f = drawBodies;
        this.g = drawJoints;
        this.h = drawAABBs;
        this.i = drawInactiveBodies;
        this.j = drawVelocities;
        this.k = drawContacts;
    }

    public void render(World world, Matrix4 projMatrix) {
        Object object;
        Object object2;
        Box2DDebugRenderer box2DDebugRenderer;
        Object object3;
        Object object4;
        Object object5;
        this.renderer.setProjectionMatrix(projMatrix);
        World world2 = world;
        Box2DDebugRenderer box2DDebugRenderer2 = this;
        box2DDebugRenderer2.renderer.begin(ShapeRenderer.ShapeType.Line);
        if (box2DDebugRenderer2.f || box2DDebugRenderer2.h) {
            world2.getBodies(d);
            object5 = d.iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                if (!((Body)object4).isActive() && !box2DDebugRenderer2.i) continue;
                box2DDebugRenderer2.renderBody((Body)object4);
            }
        }
        if (box2DDebugRenderer2.g) {
            world2.getJoints(e);
            object5 = e.iterator();
            while (object5.hasNext()) {
                object4 = (Joint)object5.next();
                object3 = object4;
                box2DDebugRenderer = box2DDebugRenderer2;
                object2 = ((Joint)object3).getBodyA();
                object = ((Joint)object3).getBodyB();
                Transform transform = ((Body)object2).getTransform();
                Transform transform2 = ((Body)object).getTransform();
                Vector2 vector2 = transform.getPosition();
                Vector2 vector22 = transform2.getPosition();
                Vector2 vector23 = ((Joint)object3).getAnchorA();
                Vector2 vector24 = ((Joint)object3).getAnchorB();
                if (((Joint)object3).getType() == JointDef.JointType.DistanceJoint) {
                    box2DDebugRenderer.a(vector23, vector24, box2DDebugRenderer.JOINT_COLOR);
                    continue;
                }
                if (((Joint)object3).getType() == JointDef.JointType.PulleyJoint) {
                    PulleyJoint pulleyJoint = (PulleyJoint)object3;
                    Vector2 vector25 = pulleyJoint.getGroundAnchorA();
                    Vector2 vector26 = pulleyJoint.getGroundAnchorB();
                    box2DDebugRenderer.a(vector25, vector23, box2DDebugRenderer.JOINT_COLOR);
                    box2DDebugRenderer.a(vector26, vector24, box2DDebugRenderer.JOINT_COLOR);
                    box2DDebugRenderer.a(vector25, vector26, box2DDebugRenderer.JOINT_COLOR);
                    continue;
                }
                if (((Joint)object3).getType() == JointDef.JointType.MouseJoint) {
                    box2DDebugRenderer.a(((Joint)object3).getAnchorA(), ((Joint)object3).getAnchorB(), box2DDebugRenderer.JOINT_COLOR);
                    continue;
                }
                box2DDebugRenderer.a(vector2, vector23, box2DDebugRenderer.JOINT_COLOR);
                box2DDebugRenderer.a(vector23, vector24, box2DDebugRenderer.JOINT_COLOR);
                box2DDebugRenderer.a(vector22, vector24, box2DDebugRenderer.JOINT_COLOR);
            }
        }
        box2DDebugRenderer2.renderer.end();
        if (box2DDebugRenderer2.k) {
            box2DDebugRenderer2.renderer.begin(ShapeRenderer.ShapeType.Point);
            object4 = world2.getContactList().iterator();
            while (object4.hasNext()) {
                object3 = object5 = object4.next();
                box2DDebugRenderer = box2DDebugRenderer2;
                object2 = ((Contact)object3).getWorldManifold();
                if (((WorldManifold)object2).getNumberOfContactPoints() == 0) continue;
                object = ((WorldManifold)object2).getPoints()[0];
                box2DDebugRenderer.renderer.setColor(box2DDebugRenderer.a(((Contact)object3).getFixtureA().getBody()));
                box2DDebugRenderer.renderer.point(((Vector2)object).x, ((Vector2)object).y, 0.0f);
            }
            box2DDebugRenderer2.renderer.end();
        }
    }

    protected void renderBody(Body body) {
        Transform transform = body.getTransform();
        for (Fixture fixture : body.getFixtureList()) {
            int n;
            Box2DDebugRenderer box2DDebugRenderer;
            Fixture fixture2;
            Transform transform2;
            Object object;
            if (this.f) {
                int n2;
                object = this.a(body);
                transform2 = transform;
                fixture2 = fixture;
                box2DDebugRenderer = this;
                if (fixture2.getType() == Shape.Type.Circle) {
                    CircleShape circleShape = (CircleShape)fixture2.getShape();
                    l.set(circleShape.getPosition());
                    transform2.mul(l);
                    Object object2 = object;
                    Vector2 vector2 = m.set(transform2.vals[2], transform2.vals[3]);
                    float f = circleShape.getRadius();
                    Vector2 vector22 = l;
                    Box2DDebugRenderer box2DDebugRenderer2 = box2DDebugRenderer;
                    float f2 = 0.0f;
                    box2DDebugRenderer2.renderer.setColor(((Color)object2).r, ((Color)object2).g, ((Color)object2).b, ((Color)object2).a);
                    int n3 = 0;
                    while (n3 < 20) {
                        box2DDebugRenderer2.o.set((float)Math.cos(f2) * f + vector22.x, (float)Math.sin(f2) * f + vector22.y);
                        if (n3 == 0) {
                            box2DDebugRenderer2.p.set(box2DDebugRenderer2.o);
                            box2DDebugRenderer2.n.set(box2DDebugRenderer2.o);
                        } else {
                            box2DDebugRenderer2.renderer.line(box2DDebugRenderer2.p.x, box2DDebugRenderer2.p.y, box2DDebugRenderer2.o.x, box2DDebugRenderer2.o.y);
                            box2DDebugRenderer2.p.set(box2DDebugRenderer2.o);
                        }
                        ++n3;
                        f2 += 0.31415927f;
                    }
                    box2DDebugRenderer2.renderer.line(box2DDebugRenderer2.n.x, box2DDebugRenderer2.n.y, box2DDebugRenderer2.p.x, box2DDebugRenderer2.p.y);
                    box2DDebugRenderer2.renderer.line(vector22.x, vector22.y, 0.0f, vector22.x + vector2.x * f, vector22.y + vector2.y * f, 0.0f);
                } else if (fixture2.getType() == Shape.Type.Edge) {
                    EdgeShape edgeShape = (EdgeShape)fixture2.getShape();
                    edgeShape.getVertex1(a[0]);
                    edgeShape.getVertex2(a[1]);
                    transform2.mul(a[0]);
                    transform2.mul(a[1]);
                    box2DDebugRenderer.a(a, 2, (Color)object, true);
                } else if (fixture2.getType() == Shape.Type.Polygon) {
                    PolygonShape polygonShape = (PolygonShape)fixture2.getShape();
                    n = polygonShape.getVertexCount();
                    n2 = 0;
                    while (n2 < n) {
                        polygonShape.getVertex(n2, a[n2]);
                        transform2.mul(a[n2]);
                        ++n2;
                    }
                    box2DDebugRenderer.a(a, n, (Color)object, true);
                } else if (fixture2.getType() == Shape.Type.Chain) {
                    ChainShape chainShape = (ChainShape)fixture2.getShape();
                    n = chainShape.getVertexCount();
                    n2 = 0;
                    while (n2 < n) {
                        chainShape.getVertex(n2, a[n2]);
                        transform2.mul(a[n2]);
                        ++n2;
                    }
                    box2DDebugRenderer.a(a, n, (Color)object, false);
                }
                if (this.j) {
                    Vector2 vector2 = body.getPosition();
                    this.a(vector2, body.getLinearVelocity().add(vector2), this.VELOCITY_COLOR);
                }
            }
            if (!this.h) continue;
            transform2 = transform;
            fixture2 = fixture;
            box2DDebugRenderer = this;
            if (fixture2.getType() == Shape.Type.Circle) {
                object = (CircleShape)fixture2.getShape();
                float f = ((Shape)object).getRadius();
                a[0].set(((CircleShape)object).getPosition());
                transform2.mul(a[0]);
                b.set(Box2DDebugRenderer.a[0].x - f, Box2DDebugRenderer.a[0].y - f);
                c.set(Box2DDebugRenderer.a[0].x + f, Box2DDebugRenderer.a[0].y + f);
                a[0].set(Box2DDebugRenderer.b.x, Box2DDebugRenderer.b.y);
                a[1].set(Box2DDebugRenderer.c.x, Box2DDebugRenderer.b.y);
                a[2].set(Box2DDebugRenderer.c.x, Box2DDebugRenderer.c.y);
                a[3].set(Box2DDebugRenderer.b.x, Box2DDebugRenderer.c.y);
                box2DDebugRenderer.a(a, 4, box2DDebugRenderer.AABB_COLOR, true);
                continue;
            }
            if (fixture2.getType() != Shape.Type.Polygon) continue;
            object = (PolygonShape)fixture2.getShape();
            int n4 = ((PolygonShape)object).getVertexCount();
            ((PolygonShape)object).getVertex(0, a[0]);
            b.set(transform2.mul(a[0]));
            c.set(b);
            n = 1;
            while (n < n4) {
                ((PolygonShape)object).getVertex(n, a[n]);
                transform2.mul(a[n]);
                Box2DDebugRenderer.b.x = Math.min(Box2DDebugRenderer.b.x, Box2DDebugRenderer.a[n].x);
                Box2DDebugRenderer.b.y = Math.min(Box2DDebugRenderer.b.y, Box2DDebugRenderer.a[n].y);
                Box2DDebugRenderer.c.x = Math.max(Box2DDebugRenderer.c.x, Box2DDebugRenderer.a[n].x);
                Box2DDebugRenderer.c.y = Math.max(Box2DDebugRenderer.c.y, Box2DDebugRenderer.a[n].y);
                ++n;
            }
            a[0].set(Box2DDebugRenderer.b.x, Box2DDebugRenderer.b.y);
            a[1].set(Box2DDebugRenderer.c.x, Box2DDebugRenderer.b.y);
            a[2].set(Box2DDebugRenderer.c.x, Box2DDebugRenderer.c.y);
            a[3].set(Box2DDebugRenderer.b.x, Box2DDebugRenderer.c.y);
            box2DDebugRenderer.a(a, 4, box2DDebugRenderer.AABB_COLOR, true);
        }
    }

    private Color a(Body body) {
        if (!body.isActive()) {
            return this.SHAPE_NOT_ACTIVE;
        }
        if (body.getType() == BodyDef.BodyType.StaticBody) {
            return this.SHAPE_STATIC;
        }
        if (body.getType() == BodyDef.BodyType.KinematicBody) {
            return this.SHAPE_KINEMATIC;
        }
        if (!body.isAwake()) {
            return this.SHAPE_NOT_AWAKE;
        }
        return this.SHAPE_AWAKE;
    }

    private void a(Vector2[] vector2Array, int n, Color color, boolean bl) {
        this.renderer.setColor(color.r, color.g, color.b, color.a);
        this.p.set(vector2Array[0]);
        this.n.set(vector2Array[0]);
        int n2 = 1;
        while (n2 < n) {
            Vector2 vector2 = vector2Array[n2];
            this.renderer.line(this.p.x, this.p.y, vector2.x, vector2.y);
            this.p.set(vector2);
            ++n2;
        }
        if (bl) {
            this.renderer.line(this.n.x, this.n.y, this.p.x, this.p.y);
        }
    }

    private void a(Vector2 vector2, Vector2 vector22, Color color) {
        this.renderer.setColor(color);
        this.renderer.line(vector2.x, vector2.y, vector22.x, vector22.y);
    }

    public boolean isDrawBodies() {
        return this.f;
    }

    public void setDrawBodies(boolean drawBodies) {
        this.f = drawBodies;
    }

    public boolean isDrawJoints() {
        return this.g;
    }

    public void setDrawJoints(boolean drawJoints) {
        this.g = drawJoints;
    }

    public boolean isDrawAABBs() {
        return this.h;
    }

    public void setDrawAABBs(boolean drawAABBs) {
        this.h = drawAABBs;
    }

    public boolean isDrawInactiveBodies() {
        return this.i;
    }

    public void setDrawInactiveBodies(boolean drawInactiveBodies) {
        this.i = drawInactiveBodies;
    }

    public boolean isDrawVelocities() {
        return this.j;
    }

    public void setDrawVelocities(boolean drawVelocities) {
        this.j = drawVelocities;
    }

    public boolean isDrawContacts() {
        return this.k;
    }

    public void setDrawContacts(boolean drawContacts) {
        this.k = drawContacts;
    }

    public static Vector2 getAxis() {
        return m;
    }

    public static void setAxis(Vector2 axis) {
        m = axis;
    }

    @Override
    public void dispose() {
        this.renderer.dispose();
    }
}

