/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Shape;

@BA.ShortName(value="lgBox2DChainShape")
public class ChainShape
extends Shape {
    private boolean a = false;
    private static float[] b = new float[2];

    public ChainShape() {
        this.addr = this.newChainShape();
    }

    private native long newChainShape();

    ChainShape(long addr) {
        this.addr = addr;
    }

    @Override
    public Shape.Type getType() {
        return Shape.Type.Chain;
    }

    public void createLoop2(float[] vertices) {
        ChainShape chainShape = this;
        chainShape.jniCreateLoop(chainShape.addr, vertices, vertices.length / 2);
        this.a = true;
    }

    public void createLoop(Vector2[] vertices) {
        float[] fArray = new float[vertices.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < vertices.length * 2) {
            fArray[n] = vertices[n2].x;
            fArray[n + 1] = vertices[n2].y;
            n += 2;
            ++n2;
        }
        ChainShape chainShape = this;
        chainShape.jniCreateLoop(chainShape.addr, fArray, fArray.length / 2);
        this.a = true;
    }

    private native void jniCreateLoop(long var1, float[] var3, int var4);

    public void createChain(float[] vertices) {
        ChainShape chainShape = this;
        chainShape.jniCreateChain(chainShape.addr, vertices, vertices.length / 2);
        this.a = false;
    }

    public void createChain(Vector2[] vertices) {
        float[] fArray = new float[vertices.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < vertices.length * 2) {
            fArray[n] = vertices[n2].x;
            fArray[n + 1] = vertices[n2].y;
            n += 2;
            ++n2;
        }
        this.createChain(fArray);
    }

    private native void jniCreateChain(long var1, float[] var3, int var4);

    public void setPrevVertex(Vector2 prevVertex) {
        this.setPrevVertex(prevVertex.x, prevVertex.y);
    }

    public void setPrevVertex(float prevVertexX, float prevVertexY) {
        ChainShape chainShape = this;
        chainShape.jniSetPrevVertex(chainShape.addr, prevVertexX, prevVertexY);
    }

    private native void jniSetPrevVertex(long var1, float var3, float var4);

    public void setNextVertex(Vector2 nextVertex) {
        this.setNextVertex(nextVertex.x, nextVertex.y);
    }

    public void setNextVertex(float nextVertexX, float nextVertexY) {
        ChainShape chainShape = this;
        chainShape.jniSetNextVertex(chainShape.addr, nextVertexX, nextVertexY);
    }

    private native void jniSetNextVertex(long var1, float var3, float var4);

    public int getVertexCount() {
        ChainShape chainShape = this;
        return chainShape.jniGetVertexCount(chainShape.addr);
    }

    private native int jniGetVertexCount(long var1);

    public void getVertex(int index, Vector2 vertex) {
        ChainShape chainShape = this;
        chainShape.jniGetVertex(chainShape.addr, index, b);
        vertex.x = b[0];
        vertex.y = b[1];
    }

    private native void jniGetVertex(long var1, int var3, float[] var4);

    public boolean isLooped() {
        return this.a;
    }
}

