/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.WorldManifold;

@BA.ShortName(value="lgBox2DContact")
public class Contact {
    protected long addr;
    protected World world;
    protected final WorldManifold worldManifold = new WorldManifold();
    private final float[] a = new float[8];

    protected Contact(World world, long addr) {
        this.addr = addr;
        this.world = world;
    }

    public WorldManifold getWorldManifold() {
        int n;
        Contact contact = this;
        this.worldManifold.numContactPoints = n = contact.jniGetWorldManifold(contact.addr, this.a);
        this.worldManifold.normal.set(this.a[0], this.a[1]);
        int n2 = 0;
        while (n2 < n) {
            Vector2 vector2 = this.worldManifold.points[n2];
            this.worldManifold.points[n2].x = this.a[2 + n2 * 2];
            vector2.y = this.a[2 + n2 * 2 + 1];
            ++n2;
        }
        this.worldManifold.separations[0] = this.a[6];
        this.worldManifold.separations[1] = this.a[7];
        return this.worldManifold;
    }

    private native int jniGetWorldManifold(long var1, float[] var3);

    public boolean isTouching() {
        Contact contact = this;
        return contact.jniIsTouching(contact.addr);
    }

    private native boolean jniIsTouching(long var1);

    public void setEnabled(boolean flag) {
        Contact contact = this;
        contact.jniSetEnabled(contact.addr, flag);
    }

    private native void jniSetEnabled(long var1, boolean var3);

    public boolean isEnabled() {
        Contact contact = this;
        return contact.jniIsEnabled(contact.addr);
    }

    private native boolean jniIsEnabled(long var1);

    public Fixture getFixtureA() {
        Contact contact = this;
        return this.world.fixtures.get(contact.jniGetFixtureA(contact.addr));
    }

    private native long jniGetFixtureA(long var1);

    public Fixture getFixtureB() {
        Contact contact = this;
        return this.world.fixtures.get(contact.jniGetFixtureB(contact.addr));
    }

    private native long jniGetFixtureB(long var1);

    public int getChildIndexA() {
        Contact contact = this;
        return contact.jniGetChildIndexA(contact.addr);
    }

    private native int jniGetChildIndexA(long var1);

    public int getChildIndexB() {
        Contact contact = this;
        return contact.jniGetChildIndexB(contact.addr);
    }

    private native int jniGetChildIndexB(long var1);

    public void setFriction(float friction) {
        Contact contact = this;
        contact.jniSetFriction(contact.addr, friction);
    }

    private native void jniSetFriction(long var1, float var3);

    public float getFriction() {
        Contact contact = this;
        return contact.jniGetFriction(contact.addr);
    }

    private native float jniGetFriction(long var1);

    public void resetFriction() {
        Contact contact = this;
        contact.jniResetFriction(contact.addr);
    }

    private native void jniResetFriction(long var1);

    public void setRestitution(float restitution) {
        Contact contact = this;
        contact.jniSetRestitution(contact.addr, restitution);
    }

    private native void jniSetRestitution(long var1, float var3);

    public float getRestitution() {
        Contact contact = this;
        return contact.jniGetRestitution(contact.addr);
    }

    private native float jniGetRestitution(long var1);

    public void ResetRestitution() {
        Contact contact = this;
        contact.jniResetRestitution(contact.addr);
    }

    private native void jniResetRestitution(long var1);

    public float getTangentSpeed() {
        Contact contact = this;
        return contact.jniGetTangentSpeed(contact.addr);
    }

    private native float jniGetTangentSpeed(long var1);

    public void setTangentSpeed(float speed) {
        Contact contact = this;
        contact.jniSetTangentSpeed(contact.addr, speed);
    }

    private native void jniSetTangentSpeed(long var1, float var3);
}

