/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.ShortName(value="lgBox2DFixture")
public class Fixture {
    private Body a;
    protected long addr;
    protected Shape shape;
    protected Object userData;
    private final short[] b = new short[3];
    private final Filter c = new Filter();

    public Fixture() {
        this.a = null;
    }

    protected Fixture(Body body, long addr) {
        this.a = body;
        this.addr = addr;
    }

    protected void reset(Body body, long addr) {
        this.a = body;
        this.addr = addr;
        this.shape = null;
        this.userData = null;
    }

    public Shape.Type getType() {
        Fixture fixture = this;
        switch (fixture.jniGetType(fixture.addr)) {
            case 0: {
                return Shape.Type.Circle;
            }
            case 1: {
                return Shape.Type.Edge;
            }
            case 2: {
                return Shape.Type.Polygon;
            }
            case 3: {
                return Shape.Type.Chain;
            }
        }
        throw new GdxRuntimeException("Unknown shape type!");
    }

    private native int jniGetType(long var1);

    public Shape getShape() {
        if (this.shape == null) {
            Fixture fixture = this;
            long l = fixture.jniGetShape(fixture.addr);
            if (l == 0L) {
                throw new GdxRuntimeException("Null shape address!");
            }
            switch (Shape.jniGetType(l)) {
                case 0: {
                    this.shape = new CircleShape(l);
                    break;
                }
                case 1: {
                    this.shape = new EdgeShape(l);
                    break;
                }
                case 2: {
                    this.shape = new PolygonShape(l);
                    break;
                }
                case 3: {
                    this.shape = new ChainShape(l);
                    break;
                }
                default: {
                    throw new GdxRuntimeException("Unknown shape type!");
                }
            }
        }
        return this.shape;
    }

    private native long jniGetShape(long var1);

    public void setSensor(boolean sensor) {
        Fixture fixture = this;
        fixture.jniSetSensor(fixture.addr, sensor);
    }

    private native void jniSetSensor(long var1, boolean var3);

    public boolean isSensor() {
        Fixture fixture = this;
        return fixture.jniIsSensor(fixture.addr);
    }

    private native boolean jniIsSensor(long var1);

    public void setFilterData(Filter filter) {
        Fixture fixture = this;
        fixture.jniSetFilterData(fixture.addr, filter.categoryBits, filter.maskBits, filter.groupIndex);
    }

    private native void jniSetFilterData(long var1, short var3, short var4, short var5);

    public Filter getFilterData() {
        Fixture fixture = this;
        fixture.jniGetFilterData(fixture.addr, this.b);
        this.c.maskBits = this.b[0];
        this.c.categoryBits = this.b[1];
        this.c.groupIndex = this.b[2];
        return this.c;
    }

    private native void jniGetFilterData(long var1, short[] var3);

    public void refilter() {
        Fixture fixture = this;
        fixture.jniRefilter(fixture.addr);
    }

    private native void jniRefilter(long var1);

    public Body getBody() {
        return this.a;
    }

    public boolean testPoint(Vector2 p) {
        Fixture fixture = this;
        return fixture.jniTestPoint(fixture.addr, p.x, p.y);
    }

    public boolean testPoint(float x, float y) {
        Fixture fixture = this;
        return fixture.jniTestPoint(fixture.addr, x, y);
    }

    private native boolean jniTestPoint(long var1, float var3, float var4);

    public void setDensity(float density) {
        Fixture fixture = this;
        fixture.jniSetDensity(fixture.addr, density);
    }

    private native void jniSetDensity(long var1, float var3);

    public float getDensity() {
        Fixture fixture = this;
        return fixture.jniGetDensity(fixture.addr);
    }

    private native float jniGetDensity(long var1);

    public float getFriction() {
        Fixture fixture = this;
        return fixture.jniGetFriction(fixture.addr);
    }

    private native float jniGetFriction(long var1);

    public void setFriction(float friction) {
        Fixture fixture = this;
        fixture.jniSetFriction(fixture.addr, friction);
    }

    private native void jniSetFriction(long var1, float var3);

    public float getRestitution() {
        Fixture fixture = this;
        return fixture.jniGetRestitution(fixture.addr);
    }

    private native float jniGetRestitution(long var1);

    public void setRestitution(float restitution) {
        Fixture fixture = this;
        fixture.jniSetRestitution(fixture.addr, restitution);
    }

    private native void jniSetRestitution(long var1, float var3);

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }
}

