/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.World;

@BA.ShortName(value="lgBox2DJoint")
public abstract class Joint {
    protected long addr;
    private final World a;
    private final float[] b = new float[2];
    private Object c;
    protected JointEdge jointEdgeA;
    protected JointEdge jointEdgeB;
    private final Vector2 d = new Vector2();
    private final Vector2 e = new Vector2();
    private final Vector2 f = new Vector2();

    protected Joint(World world, long addr) {
        this.a = world;
        this.addr = addr;
    }

    public JointDef.JointType getType() {
        Joint joint = this;
        int n = joint.jniGetType(joint.addr);
        if (n > 0 && n < JointDef.JointType.valueTypes.length) {
            return JointDef.JointType.valueTypes[n];
        }
        return JointDef.JointType.Unknown;
    }

    private native int jniGetType(long var1);

    public Body getBodyA() {
        Joint joint = this;
        return this.a.bodies.get(joint.jniGetBodyA(joint.addr));
    }

    private native long jniGetBodyA(long var1);

    public Body getBodyB() {
        Joint joint = this;
        return this.a.bodies.get(joint.jniGetBodyB(joint.addr));
    }

    private native long jniGetBodyB(long var1);

    public Vector2 getAnchorA() {
        Joint joint = this;
        joint.jniGetAnchorA(joint.addr, this.b);
        this.d.x = this.b[0];
        this.d.y = this.b[1];
        return this.d;
    }

    private native void jniGetAnchorA(long var1, float[] var3);

    public Vector2 getAnchorB() {
        Joint joint = this;
        joint.jniGetAnchorB(joint.addr, this.b);
        this.e.x = this.b[0];
        this.e.y = this.b[1];
        return this.e;
    }

    private native void jniGetAnchorB(long var1, float[] var3);

    public boolean getCollideConnected() {
        Joint joint = this;
        return joint.jniGetCollideConnected(joint.addr);
    }

    private native boolean jniGetCollideConnected(long var1);

    public Vector2 getReactionForce(float inv_dt) {
        Joint joint = this;
        joint.jniGetReactionForce(joint.addr, inv_dt, this.b);
        this.f.x = this.b[0];
        this.f.y = this.b[1];
        return this.f;
    }

    private native void jniGetReactionForce(long var1, float var3, float[] var4);

    public float getReactionTorque(float inv_dt) {
        Joint joint = this;
        return joint.jniGetReactionTorque(joint.addr, inv_dt);
    }

    private native float jniGetReactionTorque(long var1, float var3);

    public Object getUserData() {
        return this.c;
    }

    public void setUserData(Object userData) {
        this.c = userData;
    }

    public boolean isActive() {
        Joint joint = this;
        return joint.jniIsActive(joint.addr);
    }

    private native boolean jniIsActive(long var1);
}

