/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;

@BA.ShortName(value="lgBox2DManifold")
public class Manifold {
    long a;
    private ManifoldPoint[] b = new ManifoldPoint[]{new ManifoldPoint(this), new ManifoldPoint(this)};
    private Vector2 c = new Vector2();
    private Vector2 d = new Vector2();
    private int[] e = new int[2];
    private float[] f = new float[4];
    public static final ManifoldType MANIFOLDTYPE_Circle = ManifoldType.Circle;
    public static final ManifoldType MANIFOLDTYPE_FaceA = ManifoldType.FaceA;
    public static final ManifoldType MANIFOLDTYPE_FaceB = ManifoldType.FaceB;

    protected Manifold(long addr) {
        this.a = addr;
    }

    public ManifoldType getType() {
        Manifold manifold = this;
        int n = manifold.jniGetType(manifold.a);
        if (n == 0) {
            return ManifoldType.Circle;
        }
        if (n == 1) {
            return ManifoldType.FaceA;
        }
        if (n == 2) {
            return ManifoldType.FaceB;
        }
        return ManifoldType.Circle;
    }

    private native int jniGetType(long var1);

    public int getPointCount() {
        Manifold manifold = this;
        return manifold.jniGetPointCount(manifold.a);
    }

    private native int jniGetPointCount(long var1);

    public Vector2 getLocalNormal() {
        Manifold manifold = this;
        manifold.jniGetLocalNormal(manifold.a, this.f);
        this.c.set(this.f[0], this.f[1]);
        return this.c;
    }

    private native void jniGetLocalNormal(long var1, float[] var3);

    public Vector2 getLocalPoint() {
        Manifold manifold = this;
        manifold.jniGetLocalPoint(manifold.a, this.f);
        this.d.set(this.f[0], this.f[1]);
        return this.d;
    }

    private native void jniGetLocalPoint(long var1, float[] var3);

    public ManifoldPoint[] getPoints() {
        Manifold manifold = this;
        int n = manifold.jniGetPointCount(manifold.a);
        int n2 = 0;
        while (n2 < n) {
            Manifold manifold2 = this;
            int n3 = manifold2.jniGetPoint(manifold2.a, this.f, n2);
            ManifoldPoint manifoldPoint = this.b[n2];
            this.b[n2].contactID = n3;
            manifoldPoint.localPoint.set(this.f[0], this.f[1]);
            manifoldPoint.normalImpulse = this.f[2];
            manifoldPoint.tangentImpulse = this.f[3];
            ++n2;
        }
        return this.b;
    }

    private native int jniGetPoint(long var1, float[] var3, int var4);

    @BA.ShortName(value="lgBox2DManifoldPoint")
    public class ManifoldPoint {
        public final Vector2 localPoint = new Vector2();
        public float normalImpulse;
        public float tangentImpulse;
        public int contactID = 0;
        private /* synthetic */ Manifold a;

        public ManifoldPoint(Manifold manifold) {
            this.a = manifold;
        }

        public String toString() {
            return "id: " + this.contactID + ", " + this.localPoint + ", " + this.normalImpulse + ", " + this.tangentImpulse;
        }
    }

    @BA.Hide
    public static enum ManifoldType {
        Circle,
        FaceA,
        FaceB;

    }
}

