/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Shape;

@BA.ShortName(value="lgBox2DPolygonShape")
public class PolygonShape
extends Shape {
    private static float[] a = new float[2];

    public PolygonShape() {
        this.addr = this.newPolygonShape();
    }

    protected PolygonShape(long addr) {
        this.addr = addr;
    }

    private native long newPolygonShape();

    @Override
    public Shape.Type getType() {
        return Shape.Type.Polygon;
    }

    public void Set(Vector2[] vertices) {
        float[] fArray = new float[vertices.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < vertices.length * 2) {
            fArray[n] = vertices[n2].x;
            fArray[n + 1] = vertices[n2].y;
            n += 2;
            ++n2;
        }
        PolygonShape polygonShape = this;
        polygonShape.jniSet(polygonShape.addr, fArray, 0, fArray.length);
    }

    public void Set2(float[] vertices) {
        PolygonShape polygonShape = this;
        polygonShape.jniSet(polygonShape.addr, vertices, 0, vertices.length);
    }

    public void Set3(float[] vertices, int offset, int len) {
        PolygonShape polygonShape = this;
        polygonShape.jniSet(polygonShape.addr, vertices, offset, len);
    }

    private native void jniSet(long var1, float[] var3, int var4, int var5);

    public void SetAsBox(float hx, float hy) {
        PolygonShape polygonShape = this;
        polygonShape.jniSetAsBox(polygonShape.addr, hx, hy);
    }

    private native void jniSetAsBox(long var1, float var3, float var4);

    public void SetAsBox2(float hx, float hy, Vector2 center, float angle) {
        PolygonShape polygonShape = this;
        polygonShape.jniSetAsBox(polygonShape.addr, hx, hy, center.x, center.y, angle);
    }

    private native void jniSetAsBox(long var1, float var3, float var4, float var5, float var6, float var7);

    public int getVertexCount() {
        PolygonShape polygonShape = this;
        return polygonShape.jniGetVertexCount(polygonShape.addr);
    }

    private native int jniGetVertexCount(long var1);

    public void getVertex(int index, Vector2 vertex) {
        PolygonShape polygonShape = this;
        polygonShape.jniGetVertex(polygonShape.addr, index, a);
        vertex.x = a[0];
        vertex.y = a[1];
    }

    private native void jniGetVertex(long var1, int var3, float[] var4);
}

