/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactFilter;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.joints.DistanceJoint;
import com.badlogic.gdx.physics.box2d.joints.DistanceJointDef;
import com.badlogic.gdx.physics.box2d.joints.FrictionJoint;
import com.badlogic.gdx.physics.box2d.joints.FrictionJointDef;
import com.badlogic.gdx.physics.box2d.joints.GearJoint;
import com.badlogic.gdx.physics.box2d.joints.GearJointDef;
import com.badlogic.gdx.physics.box2d.joints.MotorJoint;
import com.badlogic.gdx.physics.box2d.joints.MotorJointDef;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJointDef;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import com.badlogic.gdx.physics.box2d.joints.PulleyJointDef;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.physics.box2d.joints.RopeJoint;
import com.badlogic.gdx.physics.box2d.joints.RopeJointDef;
import com.badlogic.gdx.physics.box2d.joints.WeldJoint;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.physics.box2d.joints.WheelJoint;
import com.badlogic.gdx.physics.box2d.joints.WheelJointDef;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SharedLibraryLoader;

@BA.Hide
public final class World
implements Disposable {
    protected final Pool<Body> freeBodies = new Pool<Body>(this){
        private /* synthetic */ World a;
        {
            this.a = world;
            super(100, 200);
        }

        @Override
        public final /* synthetic */ Object newObject() {
            1 var1_1 = this;
            return new Body(var1_1.a, 0L);
        }
    };
    protected final Pool<Fixture> freeFixtures = new Pool<Fixture>(this){
        private /* synthetic */ World a;
        {
            this.a = world;
            super(100, 200);
        }

        @Override
        public final /* synthetic */ Object newObject() {
            return new Fixture(null, 0L);
        }
    };
    protected final long addr;
    protected final LongMap<Body> bodies = new LongMap(100);
    protected final LongMap<Fixture> fixtures = new LongMap(100);
    protected final LongMap<Joint> joints = new LongMap(100);
    protected ContactFilter contactFilter = null;
    protected ContactListener contactListener = null;
    private float[] a = new float[2];
    private Vector2 b = new Vector2();
    private QueryCallback c = null;
    private long[] d = new long[200];
    private final Array<Contact> e = new Array();
    private final Array<Contact> f = new Array();
    private final Contact g = new Contact(this, 0L);
    private final Manifold h = new Manifold(0L);
    private final ContactImpulse i = new ContactImpulse(this, 0L);
    private RayCastCallback j = null;
    private Vector2 k = new Vector2();
    private Vector2 l = new Vector2();

    static {
        new SharedLibraryLoader().load("gdx-box2d");
    }

    public World(Vector2 gravity, boolean doSleep) {
        this.addr = this.newWorld(gravity.x, gravity.y, doSleep);
        this.e.ensureCapacity(this.d.length);
        this.f.ensureCapacity(this.d.length);
        int n = 0;
        while (n < this.d.length) {
            this.f.add(new Contact(this, 0L));
            ++n;
        }
    }

    private native long newWorld(float var1, float var2, boolean var3);

    public final void setContactFilter(ContactFilter filter) {
        this.contactFilter = filter;
        this.setUseDefaultContactFilter(filter == null);
    }

    private native void setUseDefaultContactFilter(boolean var1);

    public final void setContactListener(ContactListener listener) {
        this.contactListener = listener;
    }

    public final Body createBody(BodyDef def) {
        World world = this;
        long l = world.jniCreateBody(world.addr, def.type.getValue(), def.position.x, def.position.y, def.angle, def.linearVelocity.x, def.linearVelocity.y, def.angularVelocity, def.linearDamping, def.angularDamping, def.allowSleep, def.awake, def.fixedRotation, def.bullet, def.active, def.gravityScale);
        Body body = this.freeBodies.obtain();
        body.reset(l);
        this.bodies.put(body.addr, body);
        return body;
    }

    private native long jniCreateBody(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, float var17);

    public final void destroyBody(Body body) {
        Array<JointEdge> array = body.getJointList();
        while (array.size > 0) {
            this.destroyJoint(body.getJointList().get((int)0).joint);
        }
        World world = this;
        world.jniDestroyBody(world.addr, body.addr);
        body.setUserData(null);
        this.bodies.remove(body.addr);
        Array<Fixture> array2 = body.getFixtureList();
        while (array2.size > 0) {
            Fixture fixture = array2.removeIndex(0);
            this.fixtures.remove(fixture.addr).setUserData(null);
            this.freeFixtures.free(fixture);
        }
        this.freeBodies.free(body);
    }

    private native void jniDestroyBody(long var1, long var3);

    final void a(Body body, Fixture fixture) {
        World world = this;
        world.jniDestroyFixture(world.addr, body.addr, fixture.addr);
    }

    private native void jniDestroyFixture(long var1, long var3, long var5);

    final void a(Body body) {
        World world = this;
        world.jniDeactivateBody(world.addr, body.addr);
    }

    private native void jniDeactivateBody(long var1, long var3);

    public final Joint createJoint(JointDef def) {
        long l;
        JointDef jointDef;
        JointDef jointDef2 = def;
        World world = this;
        if (jointDef2.type == JointDef.JointType.DistanceJoint) {
            jointDef = (DistanceJointDef)jointDef2;
            World world2 = world;
            l = world2.jniCreateDistanceJoint(world2.addr, jointDef.bodyA.addr, jointDef.bodyB.addr, jointDef.collideConnected, jointDef.localAnchorA.x, jointDef.localAnchorA.y, jointDef.localAnchorB.x, jointDef.localAnchorB.y, jointDef.length, jointDef.frequencyHz, jointDef.dampingRatio);
        } else if (jointDef2.type == JointDef.JointType.FrictionJoint) {
            jointDef = (FrictionJointDef)jointDef2;
            World world3 = world;
            l = world3.jniCreateFrictionJoint(world3.addr, ((FrictionJointDef)jointDef).bodyA.addr, ((FrictionJointDef)jointDef).bodyB.addr, ((FrictionJointDef)jointDef).collideConnected, ((FrictionJointDef)jointDef).localAnchorA.x, ((FrictionJointDef)jointDef).localAnchorA.y, ((FrictionJointDef)jointDef).localAnchorB.x, ((FrictionJointDef)jointDef).localAnchorB.y, ((FrictionJointDef)jointDef).maxForce, ((FrictionJointDef)jointDef).maxTorque);
        } else if (jointDef2.type == JointDef.JointType.GearJoint) {
            jointDef = (GearJointDef)jointDef2;
            World world4 = world;
            l = world4.jniCreateGearJoint(world4.addr, ((GearJointDef)jointDef).bodyA.addr, ((GearJointDef)jointDef).bodyB.addr, ((GearJointDef)jointDef).collideConnected, ((GearJointDef)jointDef).joint1.addr, ((GearJointDef)jointDef).joint2.addr, ((GearJointDef)jointDef).ratio);
        } else if (jointDef2.type == JointDef.JointType.MotorJoint) {
            jointDef = (MotorJointDef)jointDef2;
            World world5 = world;
            l = world5.jniCreateMotorJoint(world5.addr, ((MotorJointDef)jointDef).bodyA.addr, ((MotorJointDef)jointDef).bodyB.addr, ((MotorJointDef)jointDef).collideConnected, ((MotorJointDef)jointDef).linearOffset.x, ((MotorJointDef)jointDef).linearOffset.y, ((MotorJointDef)jointDef).angularOffset, ((MotorJointDef)jointDef).maxForce, ((MotorJointDef)jointDef).maxTorque, ((MotorJointDef)jointDef).correctionFactor);
        } else if (jointDef2.type == JointDef.JointType.MouseJoint) {
            jointDef = (MouseJointDef)jointDef2;
            World world6 = world;
            l = world6.jniCreateMouseJoint(world6.addr, ((MouseJointDef)jointDef).bodyA.addr, ((MouseJointDef)jointDef).bodyB.addr, ((MouseJointDef)jointDef).collideConnected, ((MouseJointDef)jointDef).target.x, ((MouseJointDef)jointDef).target.y, ((MouseJointDef)jointDef).maxForce, ((MouseJointDef)jointDef).frequencyHz, ((MouseJointDef)jointDef).dampingRatio);
        } else if (jointDef2.type == JointDef.JointType.PrismaticJoint) {
            jointDef = (PrismaticJointDef)jointDef2;
            World world7 = world;
            l = world7.jniCreatePrismaticJoint(world7.addr, ((PrismaticJointDef)jointDef).bodyA.addr, ((PrismaticJointDef)jointDef).bodyB.addr, ((PrismaticJointDef)jointDef).collideConnected, ((PrismaticJointDef)jointDef).localAnchorA.x, ((PrismaticJointDef)jointDef).localAnchorA.y, ((PrismaticJointDef)jointDef).localAnchorB.x, ((PrismaticJointDef)jointDef).localAnchorB.y, ((PrismaticJointDef)jointDef).localAxisA.x, ((PrismaticJointDef)jointDef).localAxisA.y, ((PrismaticJointDef)jointDef).referenceAngle, ((PrismaticJointDef)jointDef).enableLimit, ((PrismaticJointDef)jointDef).lowerTranslation, ((PrismaticJointDef)jointDef).upperTranslation, ((PrismaticJointDef)jointDef).enableMotor, ((PrismaticJointDef)jointDef).maxMotorForce, ((PrismaticJointDef)jointDef).motorSpeed);
        } else if (jointDef2.type == JointDef.JointType.PulleyJoint) {
            jointDef = (PulleyJointDef)jointDef2;
            World world8 = world;
            l = world8.jniCreatePulleyJoint(world8.addr, ((PulleyJointDef)jointDef).bodyA.addr, ((PulleyJointDef)jointDef).bodyB.addr, ((PulleyJointDef)jointDef).collideConnected, ((PulleyJointDef)jointDef).groundAnchorA.x, ((PulleyJointDef)jointDef).groundAnchorA.y, ((PulleyJointDef)jointDef).groundAnchorB.x, ((PulleyJointDef)jointDef).groundAnchorB.y, ((PulleyJointDef)jointDef).localAnchorA.x, ((PulleyJointDef)jointDef).localAnchorA.y, ((PulleyJointDef)jointDef).localAnchorB.x, ((PulleyJointDef)jointDef).localAnchorB.y, ((PulleyJointDef)jointDef).lengthA, ((PulleyJointDef)jointDef).lengthB, ((PulleyJointDef)jointDef).ratio);
        } else if (jointDef2.type == JointDef.JointType.RevoluteJoint) {
            jointDef = (RevoluteJointDef)jointDef2;
            World world9 = world;
            l = world9.jniCreateRevoluteJoint(world9.addr, ((RevoluteJointDef)jointDef).bodyA.addr, ((RevoluteJointDef)jointDef).bodyB.addr, ((RevoluteJointDef)jointDef).collideConnected, ((RevoluteJointDef)jointDef).localAnchorA.x, ((RevoluteJointDef)jointDef).localAnchorA.y, ((RevoluteJointDef)jointDef).localAnchorB.x, ((RevoluteJointDef)jointDef).localAnchorB.y, ((RevoluteJointDef)jointDef).referenceAngle, ((RevoluteJointDef)jointDef).enableLimit, ((RevoluteJointDef)jointDef).lowerAngle, ((RevoluteJointDef)jointDef).upperAngle, ((RevoluteJointDef)jointDef).enableMotor, ((RevoluteJointDef)jointDef).motorSpeed, ((RevoluteJointDef)jointDef).maxMotorTorque);
        } else if (jointDef2.type == JointDef.JointType.RopeJoint) {
            jointDef = (RopeJointDef)jointDef2;
            World world10 = world;
            l = world10.jniCreateRopeJoint(world10.addr, ((RopeJointDef)jointDef).bodyA.addr, ((RopeJointDef)jointDef).bodyB.addr, ((RopeJointDef)jointDef).collideConnected, ((RopeJointDef)jointDef).localAnchorA.x, ((RopeJointDef)jointDef).localAnchorA.y, ((RopeJointDef)jointDef).localAnchorB.x, ((RopeJointDef)jointDef).localAnchorB.y, ((RopeJointDef)jointDef).maxLength);
        } else if (jointDef2.type == JointDef.JointType.WeldJoint) {
            jointDef = (WeldJointDef)jointDef2;
            World world11 = world;
            l = world11.jniCreateWeldJoint(world11.addr, ((WeldJointDef)jointDef).bodyA.addr, ((WeldJointDef)jointDef).bodyB.addr, ((WeldJointDef)jointDef).collideConnected, ((WeldJointDef)jointDef).localAnchorA.x, ((WeldJointDef)jointDef).localAnchorA.y, ((WeldJointDef)jointDef).localAnchorB.x, ((WeldJointDef)jointDef).localAnchorB.y, ((WeldJointDef)jointDef).referenceAngle, ((WeldJointDef)jointDef).frequencyHz, ((WeldJointDef)jointDef).dampingRatio);
        } else if (jointDef2.type == JointDef.JointType.WheelJoint) {
            jointDef = (WheelJointDef)jointDef2;
            World world12 = world;
            l = world12.jniCreateWheelJoint(world12.addr, ((WheelJointDef)jointDef).bodyA.addr, ((WheelJointDef)jointDef).bodyB.addr, ((WheelJointDef)jointDef).collideConnected, ((WheelJointDef)jointDef).localAnchorA.x, ((WheelJointDef)jointDef).localAnchorA.y, ((WheelJointDef)jointDef).localAnchorB.x, ((WheelJointDef)jointDef).localAnchorB.y, ((WheelJointDef)jointDef).localAxisA.x, ((WheelJointDef)jointDef).localAxisA.y, ((WheelJointDef)jointDef).enableMotor, ((WheelJointDef)jointDef).maxMotorTorque, ((WheelJointDef)jointDef).motorSpeed, ((WheelJointDef)jointDef).frequencyHz, ((WheelJointDef)jointDef).dampingRatio);
        } else {
            l = 0L;
        }
        long l2 = l;
        Joint joint = null;
        if (def.type == JointDef.JointType.DistanceJoint) {
            joint = new DistanceJoint(this, l2);
        }
        if (def.type == JointDef.JointType.FrictionJoint) {
            joint = new FrictionJoint(this, l2);
        }
        if (def.type == JointDef.JointType.GearJoint) {
            joint = new GearJoint(this, l2, ((GearJointDef)def).joint1, ((GearJointDef)def).joint2);
        }
        if (def.type == JointDef.JointType.MotorJoint) {
            joint = new MotorJoint(this, l2);
        }
        if (def.type == JointDef.JointType.MouseJoint) {
            joint = new MouseJoint(this, l2);
        }
        if (def.type == JointDef.JointType.PrismaticJoint) {
            joint = new PrismaticJoint(this, l2);
        }
        if (def.type == JointDef.JointType.PulleyJoint) {
            joint = new PulleyJoint(this, l2);
        }
        if (def.type == JointDef.JointType.RevoluteJoint) {
            joint = new RevoluteJoint(this, l2);
        }
        if (def.type == JointDef.JointType.RopeJoint) {
            joint = new RopeJoint(this, l2);
        }
        if (def.type == JointDef.JointType.WeldJoint) {
            joint = new WeldJoint(this, l2);
        }
        if (def.type == JointDef.JointType.WheelJoint) {
            joint = new WheelJoint(this, l2);
        }
        if (joint != null) {
            this.joints.put(joint.addr, joint);
        }
        JointEdge jointEdge = new JointEdge(def.bodyB, joint);
        JointEdge jointEdge2 = new JointEdge(def.bodyA, joint);
        joint.jointEdgeA = jointEdge;
        joint.jointEdgeB = jointEdge2;
        def.bodyA.joints.add(jointEdge);
        def.bodyB.joints.add(jointEdge2);
        return joint;
    }

    private native long jniCreateWheelJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, boolean var14, float var15, float var16, float var17, float var18);

    private native long jniCreateRopeJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12);

    private native long jniCreateDistanceJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);

    private native long jniCreateFrictionJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13);

    private native long jniCreateGearJoint(long var1, long var3, long var5, boolean var7, long var8, long var10, float var12);

    private native long jniCreateMotorJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13);

    private native long jniCreateMouseJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12);

    private native long jniCreatePrismaticJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, boolean var15, float var16, float var17, boolean var18, float var19, float var20);

    private native long jniCreatePulleyJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18);

    private native long jniCreateRevoluteJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, boolean var13, float var14, float var15, boolean var16, float var17, float var18);

    private native long jniCreateWeldJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);

    public final void destroyJoint(Joint joint) {
        joint.setUserData(null);
        this.joints.remove(joint.addr);
        joint.jointEdgeA.other.joints.removeValue(joint.jointEdgeB, true);
        joint.jointEdgeB.other.joints.removeValue(joint.jointEdgeA, true);
        World world = this;
        world.jniDestroyJoint(world.addr, joint.addr);
    }

    private native void jniDestroyJoint(long var1, long var3);

    public final void step(float timeStep, int velocityIterations, int positionIterations) {
        World world = this;
        world.jniStep(world.addr, timeStep, velocityIterations, positionIterations);
    }

    private native void jniStep(long var1, float var3, int var4, int var5);

    public final void clearForces() {
        World world = this;
        world.jniClearForces(world.addr);
    }

    private native void jniClearForces(long var1);

    public final void setWarmStarting(boolean flag) {
        World world = this;
        world.jniSetWarmStarting(world.addr, flag);
    }

    private native void jniSetWarmStarting(long var1, boolean var3);

    public final void setContinuousPhysics(boolean flag) {
        World world = this;
        world.jniSetContiousPhysics(world.addr, flag);
    }

    private native void jniSetContiousPhysics(long var1, boolean var3);

    public final int getProxyCount() {
        World world = this;
        return world.jniGetProxyCount(world.addr);
    }

    private native int jniGetProxyCount(long var1);

    public final int getBodyCount() {
        World world = this;
        return world.jniGetBodyCount(world.addr);
    }

    private native int jniGetBodyCount(long var1);

    public final int getFixtureCount() {
        return this.fixtures.size;
    }

    public final int getJointCount() {
        World world = this;
        return world.jniGetJointcount(world.addr);
    }

    private native int jniGetJointcount(long var1);

    public final int getContactCount() {
        World world = this;
        return world.jniGetContactCount(world.addr);
    }

    private native int jniGetContactCount(long var1);

    public final void setGravity(Vector2 gravity) {
        World world = this;
        world.jniSetGravity(world.addr, gravity.x, gravity.y);
    }

    private native void jniSetGravity(long var1, float var3, float var4);

    public final Vector2 getGravity() {
        World world = this;
        world.jniGetGravity(world.addr, this.a);
        this.b.x = this.a[0];
        this.b.y = this.a[1];
        return this.b;
    }

    private native void jniGetGravity(long var1, float[] var3);

    public final boolean isLocked() {
        World world = this;
        return world.jniIsLocked(world.addr);
    }

    private native boolean jniIsLocked(long var1);

    public final void setAutoClearForces(boolean flag) {
        World world = this;
        world.jniSetAutoClearForces(world.addr, flag);
    }

    private native void jniSetAutoClearForces(long var1, boolean var3);

    public final boolean getAutoClearForces() {
        World world = this;
        return world.jniGetAutoClearForces(world.addr);
    }

    private native boolean jniGetAutoClearForces(long var1);

    public final void QueryAABB(QueryCallback callback, float lowerX, float lowerY, float upperX, float upperY) {
        this.c = callback;
        World world = this;
        world.jniQueryAABB(world.addr, lowerX, lowerY, upperX, upperY);
    }

    private native void jniQueryAABB(long var1, float var3, float var4, float var5, float var6);

    public final Array<Contact> getContactList() {
        int n;
        int n2 = this.getContactCount();
        if (n2 > this.d.length) {
            n = 2 * n2;
            this.d = new long[n];
            this.e.ensureCapacity(n);
            this.f.ensureCapacity(n);
        }
        if (n2 > this.f.size) {
            n = this.f.size;
            int n3 = 0;
            while (n3 < n2 - n) {
                this.f.add(new Contact(this, 0L));
                ++n3;
            }
        }
        World world = this;
        world.jniGetContactList(world.addr, this.d);
        this.e.clear();
        n = 0;
        while (n < n2) {
            Contact contact = this.f.get(n);
            this.f.get(n).addr = this.d[n];
            this.e.add(contact);
            ++n;
        }
        return this.e;
    }

    public final void getBodies(Array<Body> bodies) {
        bodies.clear();
        bodies.ensureCapacity(this.bodies.size);
        LongMap.Values<Body> values = this.bodies.values();
        while (values.hasNext()) {
            bodies.add((Body)values.next());
        }
    }

    public final void getFixtures(Array<Fixture> fixtures) {
        fixtures.clear();
        fixtures.ensureCapacity(this.fixtures.size);
        LongMap.Values<Fixture> values = this.fixtures.values();
        while (values.hasNext()) {
            fixtures.add((Fixture)values.next());
        }
    }

    public final void getJoints(Array<Joint> joints) {
        joints.clear();
        joints.ensureCapacity(this.joints.size);
        LongMap.Values<Joint> values = this.joints.values();
        while (values.hasNext()) {
            joints.add((Joint)values.next());
        }
    }

    private native void jniGetContactList(long var1, long[] var3);

    @Override
    public final void dispose() {
        World world = this;
        world.jniDispose(world.addr);
    }

    private native void jniDispose(long var1);

    private boolean contactFilter(long fixtureA, long fixtureB) {
        if (this.contactFilter != null) {
            return this.contactFilter.shouldCollide(this.fixtures.get(fixtureA), this.fixtures.get(fixtureB));
        }
        Filter filter = this.fixtures.get(fixtureA).getFilterData();
        Filter filter2 = this.fixtures.get(fixtureB).getFilterData();
        if (filter.groupIndex == filter2.groupIndex && filter.groupIndex != 0) {
            return filter.groupIndex > 0;
        }
        return (filter.maskBits & filter2.categoryBits) != 0 && (filter.categoryBits & filter2.maskBits) != 0;
    }

    private void beginContact(long contactAddr) {
        this.g.addr = contactAddr;
        if (this.contactListener != null) {
            this.contactListener.beginContact(this.g);
        }
    }

    private void endContact(long contactAddr) {
        this.g.addr = contactAddr;
        if (this.contactListener != null) {
            this.contactListener.endContact(this.g);
        }
    }

    private void preSolve(long contactAddr, long manifoldAddr) {
        this.g.addr = contactAddr;
        this.h.a = manifoldAddr;
        if (this.contactListener != null) {
            this.contactListener.preSolve(this.g, this.h);
        }
    }

    private void postSolve(long contactAddr, long impulseAddr) {
        this.g.addr = contactAddr;
        this.i.a = impulseAddr;
        if (this.contactListener != null) {
            this.contactListener.postSolve(this.g, this.i);
        }
    }

    private boolean reportFixture(long addr) {
        if (this.c != null) {
            return this.c.reportFixture(this.fixtures.get(addr));
        }
        return false;
    }

    public static native void setVelocityThreshold(float var0);

    public static native float getVelocityThreshold();

    public final void rayCast(RayCastCallback callback, Vector2 point1, Vector2 point2) {
        this.rayCast(callback, point1.x, point1.y, point2.x, point2.y);
    }

    public final void rayCast(RayCastCallback callback, float point1X, float point1Y, float point2X, float point2Y) {
        this.j = callback;
        World world = this;
        world.jniRayCast(world.addr, point1X, point1Y, point2X, point2Y);
    }

    private native void jniRayCast(long var1, float var3, float var4, float var5, float var6);

    private float reportRayFixture(long addr, float pX, float pY, float nX, float nY, float fraction) {
        if (this.j != null) {
            this.k.x = pX;
            this.k.y = pY;
            this.l.x = nX;
            this.l.y = nY;
            return this.j.reportRayFixture(this.fixtures.get(addr), this.k, this.l, fraction);
        }
        return 0.0f;
    }
}

