/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.joints;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;

@BA.ShortName(value="lgBox2DWheelJoint")
public class WheelJoint
extends Joint {
    private final float[] a = new float[2];
    private final Vector2 b = new Vector2();
    private final Vector2 c = new Vector2();
    private final Vector2 d = new Vector2();

    public WheelJoint(World world, long addr) {
        super(world, addr);
    }

    public Vector2 getLocalAnchorA() {
        WheelJoint wheelJoint = this;
        wheelJoint.jniGetLocalAnchorA(wheelJoint.addr, this.a);
        this.b.set(this.a[0], this.a[1]);
        return this.b;
    }

    private native void jniGetLocalAnchorA(long var1, float[] var3);

    public Vector2 getLocalAnchorB() {
        WheelJoint wheelJoint = this;
        wheelJoint.jniGetLocalAnchorB(wheelJoint.addr, this.a);
        this.c.set(this.a[0], this.a[1]);
        return this.c;
    }

    private native void jniGetLocalAnchorB(long var1, float[] var3);

    public Vector2 getLocalAxisA() {
        WheelJoint wheelJoint = this;
        wheelJoint.jniGetLocalAxisA(wheelJoint.addr, this.a);
        this.d.set(this.a[0], this.a[1]);
        return this.d;
    }

    private native void jniGetLocalAxisA(long var1, float[] var3);

    public float getJointTranslation() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetJointTranslation(wheelJoint.addr);
    }

    private native float jniGetJointTranslation(long var1);

    public float getJointSpeed() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetJointSpeed(wheelJoint.addr);
    }

    private native float jniGetJointSpeed(long var1);

    public boolean isMotorEnabled() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniIsMotorEnabled(wheelJoint.addr);
    }

    private native boolean jniIsMotorEnabled(long var1);

    public void enableMotor(boolean flag) {
        WheelJoint wheelJoint = this;
        wheelJoint.jniEnableMotor(wheelJoint.addr, flag);
    }

    private native void jniEnableMotor(long var1, boolean var3);

    public void setMotorSpeed(float speed) {
        WheelJoint wheelJoint = this;
        wheelJoint.jniSetMotorSpeed(wheelJoint.addr, speed);
    }

    private native void jniSetMotorSpeed(long var1, float var3);

    public float getMotorSpeed() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetMotorSpeed(wheelJoint.addr);
    }

    private native float jniGetMotorSpeed(long var1);

    public void setMaxMotorTorque(float torque) {
        WheelJoint wheelJoint = this;
        wheelJoint.jniSetMaxMotorTorque(wheelJoint.addr, torque);
    }

    private native void jniSetMaxMotorTorque(long var1, float var3);

    public float getMaxMotorTorque() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetMaxMotorTorque(wheelJoint.addr);
    }

    private native float jniGetMaxMotorTorque(long var1);

    public float getMotorTorque(float invDt) {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetMotorTorque(wheelJoint.addr, invDt);
    }

    private native float jniGetMotorTorque(long var1, float var3);

    public void setSpringFrequencyHz(float hz) {
        WheelJoint wheelJoint = this;
        wheelJoint.jniSetSpringFrequencyHz(wheelJoint.addr, hz);
    }

    private native void jniSetSpringFrequencyHz(long var1, float var3);

    public float getSpringFrequencyHz() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetSpringFrequencyHz(wheelJoint.addr);
    }

    private native float jniGetSpringFrequencyHz(long var1);

    public void setSpringDampingRatio(float ratio) {
        WheelJoint wheelJoint = this;
        wheelJoint.jniSetSpringDampingRatio(wheelJoint.addr, ratio);
    }

    private native void jniSetSpringDampingRatio(long var1, float var3);

    public float getSpringDampingRatio() {
        WheelJoint wheelJoint = this;
        return wheelJoint.jniGetSpringDampingRatio(wheelJoint.addr);
    }

    private native float jniGetSpringDampingRatio(long var1);
}

