/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgSpriteBatch;
import anywheresoftware.b4a.libgdx.scene2d.lgStage;
import anywheresoftware.b4a.libgdx.utils.lgArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.DebugRenderer;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

@BA.ShortName(value="lgScn2DActor")
public class Actor {
    public static final Touchable TOUCHABLE_Enabled = Touchable.enabled;
    public static final Touchable TOUCHABLE_Disabled = Touchable.disabled;
    public static final Touchable TOUCHABLE_ChildrenOnly = Touchable.childrenOnly;
    private lgStage l;
    Group a;
    private final DelayedRemovalArray<EventListener> m = new DelayedRemovalArray(0);
    private final DelayedRemovalArray<EventListener> n = new DelayedRemovalArray(0);
    private final Array<Action> o = new Array(0);
    private String p;
    private Touchable q = Touchable.enabled;
    private boolean r = true;
    float b;
    float c;
    float d;
    float e;
    float f;
    float g;
    float h = 1.0f;
    float i = 1.0f;
    float j;
    final Color k = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Object s;
    private boolean t = true;
    public static Color debugColor = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    protected BA _ba;
    private String u;
    protected String _evtDraw;

    public void Initialize(BA ba, String EvtPrefix) {
        this._ba = ba;
        this.u = "";
        this._evtDraw = "";
        if (EvtPrefix.length() > 0) {
            String string = EvtPrefix.toLowerCase(BA.cul);
            if (this._ba.subExists(String.valueOf(string) + "_act")) {
                this.u = String.valueOf(string) + "_act";
            }
            if (this._ba.subExists(String.valueOf(string) + "_draw")) {
                this._evtDraw = String.valueOf(string) + "_draw";
            }
        }
        if (this.HasActions()) {
            this.clearActions();
        }
    }

    public boolean IsInitialized() {
        return this._ba != null;
    }

    public void Draw(lgSpriteBatch Batch2, float ParentAlpha) {
        this.draw(Batch2.getInternalObject(), ParentAlpha);
    }

    @BA.Hide
    public void draw(Batch batch, float parentAlpha) {
        if (this._ba == null) {
            throw new GdxRuntimeException("Actor not initialized (" + this.toString() + ")");
        }
        if (this._evtDraw.length() > 0) {
            if (this.l == null) {
                Object[] objectArray = new Object[2];
                objectArray[1] = Float.valueOf(parentAlpha);
                this._ba.raiseEvent2((Object)this, false, this._evtDraw, true, objectArray);
                return;
            }
            this._ba.raiseEvent2((Object)this, false, this._evtDraw, true, new Object[]{this.l.getSpriteBatch(), Float.valueOf(parentAlpha)});
        }
    }

    public void act(float delta) {
        Array<Action> array = this.o;
        if (array.size > 0) {
            if (this.l != null && this.l.getActionsRequestRendering()) {
                Gdx.graphics.requestRendering();
            }
            int n = 0;
            while (n < array.size) {
                int n2;
                Action action = array.get(n);
                if (action.act(delta) && n < array.size && (n2 = array.get(n) == action ? n : array.indexOf(action, true)) != -1) {
                    array.removeIndex(n2);
                    action.setActor(null);
                    --n;
                }
                ++n;
            }
        }
        if (!this.IsInitialized()) {
            throw new GdxRuntimeException("Actor not initialized (" + this.toString() + ")");
        }
        if (this.u.length() > 0) {
            this._ba.raiseEvent2((Object)this, false, this.u, true, new Object[]{Float.valueOf(delta)});
        }
    }

    public boolean fire(Event event) {
        if (event.getStage() == null) {
            if (this.l == null) {
                return true;
            }
            event.setStage(this.l);
        }
        event.setTarget(this);
        Array array = Pools.obtain(Array.class);
        Group group = this.a;
        while (group != null) {
            array.add(group);
            group = group.a;
        }
        try {
            T[] TArray = array.items;
            int n = array.size - 1;
            while (n >= 0) {
                ((Group)TArray[n]).notify(event, true);
                if (event.isStopped()) {
                    boolean bl = event.isCancelled();
                    return bl;
                }
                --n;
            }
            this.notify(event, true);
            if (event.isStopped()) {
                boolean bl = event.isCancelled();
                return bl;
            }
            this.notify(event, false);
            if (!event.getBubbles()) {
                boolean bl = event.isCancelled();
                return bl;
            }
            if (event.isStopped()) {
                boolean bl = event.isCancelled();
                return bl;
            }
            n = 0;
            int n2 = array.size;
            while (n < n2) {
                ((Group)TArray[n]).notify(event, false);
                if (event.isStopped()) {
                    boolean bl = event.isCancelled();
                    return bl;
                }
                ++n;
            }
            boolean bl = event.isCancelled();
            return bl;
        }
        finally {
            array.clear();
            Pools.free(array);
        }
    }

    public boolean notify(Event event, boolean capture) {
        DelayedRemovalArray<EventListener> delayedRemovalArray;
        if (event.getTarget() == null) {
            throw new IllegalArgumentException("The event target cannot be null.");
        }
        if ((delayedRemovalArray = capture ? this.n : this.m).size == 0) {
            return event.isCancelled();
        }
        event.setListenerActor(this);
        event.setCapture(capture);
        if (event.getStage() == null) {
            event.setStage(this.l);
        }
        delayedRemovalArray.begin();
        int n = 0;
        int n2 = delayedRemovalArray.size;
        while (n < n2) {
            EventListener eventListener = (EventListener)delayedRemovalArray.get(n);
            if (eventListener.handle(event)) {
                InputEvent inputEvent;
                event.handle();
                if (event instanceof InputEvent && (inputEvent = (InputEvent)event).getType() == InputEvent.Type.touchDown) {
                    event.getStage().AddTouchFocus(eventListener, this, inputEvent.getTarget(), inputEvent.getPointer());
                }
            }
            ++n;
        }
        delayedRemovalArray.end();
        return event.isCancelled();
    }

    public Actor hit(float x, float y, boolean touchable) {
        if (touchable && this.q != Touchable.enabled) {
            return null;
        }
        if (x >= 0.0f && x < this.d && y >= 0.0f && y < this.e) {
            return this;
        }
        return null;
    }

    public boolean remove() {
        if (this.a != null) {
            return this.a.removeActor(this, true);
        }
        return false;
    }

    public boolean addListener(EventListener listener) {
        if (!this.m.contains(listener, true)) {
            this.m.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(EventListener listener) {
        return this.m.removeValue(listener, true);
    }

    public lgArray GetListenersList() {
        return new lgArray(this.m);
    }

    @BA.Hide
    public Array<EventListener> getListeners() {
        return this.m;
    }

    public boolean addCaptureListener(EventListener listener) {
        if (!this.n.contains(listener, true)) {
            this.n.add(listener);
        }
        return true;
    }

    public boolean removeCaptureListener(EventListener listener) {
        return this.n.removeValue(listener, true);
    }

    public lgArray GetCaptureListenersList() {
        return new lgArray(this.n);
    }

    @BA.Hide
    public Array<EventListener> getCaptureListeners() {
        return this.n;
    }

    public void addAction(Action action) {
        action.setActor(this);
        this.o.add(action);
        if (this.l != null && this.l.getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
    }

    public void removeAction(Action action) {
        if (this.o.removeValue(action, true)) {
            action.setActor(null);
        }
    }

    public lgArray GetActionsList() {
        return new lgArray(this.o);
    }

    @BA.Hide
    public Array<Action> getActions() {
        return this.o;
    }

    public boolean HasActions() {
        return this.o.size > 0;
    }

    public void clearActions() {
        int n = this.o.size - 1;
        while (n >= 0) {
            this.o.get(n).setActor(null);
            --n;
        }
        this.o.clear();
    }

    public void clearListeners() {
        this.m.clear();
        this.n.clear();
    }

    public void clear() {
        this.clearActions();
        this.clearListeners();
    }

    public lgStage Stage() {
        return this.l;
    }

    @BA.Hide
    public Stage getStage() {
        if (this.l == null) {
            return null;
        }
        return this.l.getInternalObject();
    }

    @BA.Hide
    protected void setStage(lgStage stage) {
        this.l = stage;
    }

    public boolean isDescendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        Actor actor2 = this;
        while (actor2 != null) {
            if (actor2 == actor) {
                return true;
            }
            actor2 = actor2.a;
        }
        return false;
    }

    public boolean isAscendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        while (actor != null) {
            if (actor == this) {
                return true;
            }
            actor = actor.a;
        }
        return false;
    }

    public boolean hasParent() {
        return this.a != null;
    }

    public Group getParent() {
        return this.a;
    }

    protected void setParent(Group parent) {
        this.a = parent;
    }

    public boolean isTouchable() {
        return this.q == Touchable.enabled;
    }

    public Touchable getTouchable() {
        return this.q;
    }

    public void setTouchable(Touchable touchable) {
        this.q = touchable;
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    @BA.Hide
    public boolean isVisible() {
        return this.r;
    }

    public void setVisible(boolean visible) {
        this.r = visible;
    }

    public Object getTag() {
        return this.s;
    }

    public void setTag(Object Value2) {
        this.s = Value2;
    }

    public float getX() {
        return this.b;
    }

    @BA.Hide
    public float getX(int alignment) {
        float f = this.b;
        if ((alignment & 0x10) != 0) {
            f += this.d;
        } else if ((alignment & 8) == 0) {
            f += this.d / 2.0f;
        }
        return f;
    }

    public void setX(float x) {
        if (this.b != x) {
            this.b = x;
            this.positionChanged();
        }
    }

    public float getY() {
        return this.c;
    }

    public void setY(float y) {
        if (this.c != y) {
            this.c = y;
            this.positionChanged();
        }
    }

    @BA.Hide
    public float getY(int alignment) {
        float f = this.c;
        if ((alignment & 2) != 0) {
            f += this.e;
        } else if ((alignment & 4) == 0) {
            f += this.e / 2.0f;
        }
        return f;
    }

    public void setPosition(float x, float y) {
        if (this.b != x || this.c != y) {
            this.b = x;
            this.c = y;
            this.positionChanged();
        }
    }

    @BA.Hide
    public void setPosition(float x, float y, int alignment) {
        if ((alignment & 0x10) != 0) {
            x -= this.d;
        } else if ((alignment & 8) == 0) {
            x -= this.d / 2.0f;
        }
        if ((alignment & 2) != 0) {
            y -= this.e;
        } else if ((alignment & 4) == 0) {
            y -= this.e / 2.0f;
        }
        if (this.b != x || this.c != y) {
            this.b = x;
            this.c = y;
            this.positionChanged();
        }
    }

    public void SetCenterPosition(float x, float y) {
        float f = x - this.d / 2.0f;
        float f2 = y - this.e / 2.0f;
        if (this.b != f || this.c != f2) {
            this.b = f;
            this.c = f2;
            this.positionChanged();
        }
    }

    public float getCenterX() {
        return this.b + this.d / 2.0f;
    }

    public float getCenterY() {
        return this.c + this.e / 2.0f;
    }

    public void moveBy(float x, float y) {
        if (x != 0.0f || y != 0.0f) {
            this.b += x;
            this.c += y;
            this.positionChanged();
        }
    }

    public float getWidth() {
        return this.d;
    }

    public void setWidth(float width) {
        if (this.d != width) {
            this.d = width;
            this.sizeChanged();
        }
    }

    public float getHeight() {
        return this.e;
    }

    public void setHeight(float height) {
        if (this.e != height) {
            this.e = height;
            this.sizeChanged();
        }
    }

    public float getTop() {
        return this.c + this.e;
    }

    public float getRight() {
        return this.b + this.d;
    }

    protected void positionChanged() {
    }

    protected void sizeChanged() {
    }

    public void setSize(float width, float height) {
        if (this.d != width || this.e != height) {
            this.d = width;
            this.e = height;
            this.sizeChanged();
        }
    }

    public void sizeBy(float size) {
        if (size != 0.0f) {
            this.d += size;
            this.e += size;
            this.sizeChanged();
        }
    }

    public void sizeBy(float width, float height) {
        if (width != 0.0f || height != 0.0f) {
            this.d += width;
            this.e += height;
            this.sizeChanged();
        }
    }

    public void SetBounds(float x, float y, float width, float height) {
        if (this.b != x || this.c != y) {
            this.b = x;
            this.c = y;
            this.positionChanged();
        }
        if (this.d != width || this.e != height) {
            this.d = width;
            this.e = height;
            this.sizeChanged();
        }
    }

    public float getOriginX() {
        return this.f;
    }

    public void setOriginX(float originX) {
        this.f = originX;
    }

    public float getOriginY() {
        return this.g;
    }

    public void setOriginY(float originY) {
        this.g = originY;
    }

    public void setOrigin(float originX, float originY) {
        this.f = originX;
        this.g = originY;
    }

    public float getScaleX() {
        return this.h;
    }

    public void setScaleX(float scaleX) {
        this.h = scaleX;
    }

    public float getScaleY() {
        return this.i;
    }

    public void setScaleY(float scaleY) {
        this.i = scaleY;
    }

    @BA.Hide
    public void setScale(float scaleXY) {
        this.h = scaleXY;
        this.i = scaleXY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.h = scaleX;
        this.i = scaleY;
    }

    @BA.Hide
    public void scaleBy(float scale) {
        this.h += scale;
        this.i += scale;
    }

    public void scaleBy(float scaleX, float scaleY) {
        this.h += scaleX;
        this.i += scaleY;
    }

    public float getRotation() {
        return this.j;
    }

    public void setRotation(float degrees) {
        this.j = degrees;
    }

    public void rotateBy(float amountInDegrees) {
        this.j += amountInDegrees;
    }

    public void setColor(Color color) {
        this.k.set(color);
    }

    public void SetColorRGBA(float R, float G, float B, float A) {
        this.k.set(R, G, B, A);
    }

    public Color getColor() {
        return this.k;
    }

    public String getName() {
        return this.p;
    }

    public void setName(String name) {
        this.p = name;
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public void setZIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("ZIndex cannot be < 0.");
        }
        Group group = this.a;
        if (group == null) {
            return;
        }
        SnapshotArray<Actor> snapshotArray = group.l;
        if (snapshotArray.size == 1) {
            return;
        }
        if ((index = Math.min(index, snapshotArray.size - 1)) == snapshotArray.indexOf(this, true)) {
            return;
        }
        if (!((Array)snapshotArray).removeValue(this, true)) {
            return;
        }
        ((Array)snapshotArray).insert(index, this);
    }

    public int getZIndex() {
        Group group = this.a;
        if (group == null) {
            return -1;
        }
        return group.l.indexOf(this, true);
    }

    public boolean ClipBegin() {
        Actor actor = this;
        return actor.clipBegin(actor.b, this.c, this.d, this.e);
    }

    public boolean ClipBegin2(float X, float Y, float Width, float Height) {
        return this.clipBegin(X, Y, Width, Height);
    }

    @BA.Hide
    public boolean clipBegin(float x, float y, float width, float height) {
        if (width <= 0.0f || height <= 0.0f) {
            return false;
        }
        if (this.l == null || this.l.getInternalObject() == null) {
            return false;
        }
        Rectangle rectangle = Rectangle.tmp;
        Rectangle.tmp.x = x;
        rectangle.y = y;
        rectangle.width = width;
        rectangle.height = height;
        Rectangle rectangle2 = Pools.obtain(Rectangle.class);
        this.l.getInternalObject().calculateScissors(rectangle, rectangle2);
        if (ScissorStack.pushScissors(rectangle2)) {
            return true;
        }
        Pools.free(rectangle2);
        return false;
    }

    public void ClipEnd() {
        Pools.free(ScissorStack.popScissors());
    }

    public Vector2 screenToLocalCoordinates(Vector2 screenCoords) {
        if (this.l == null) {
            return screenCoords;
        }
        Actor actor = this;
        return actor.stageToLocalCoordinates(actor.l.getInternalObject().screenToStageCoordinates(screenCoords));
    }

    public Vector2 stageToLocalCoordinates(Vector2 stageCoords) {
        if (this.a != null) {
            this.a.stageToLocalCoordinates(stageCoords);
        }
        this.parentToLocalCoordinates(stageCoords);
        return stageCoords;
    }

    public Vector2 localToStageCoordinates(Vector2 localCoords) {
        return this.localToAscendantCoordinates(null, localCoords);
    }

    public Vector2 localToParentCoordinates(Vector2 localCoords) {
        float f = -this.j;
        float f2 = this.h;
        float f3 = this.i;
        float f4 = this.b;
        float f5 = this.c;
        if (f == 0.0f) {
            if (f2 == 1.0f && f3 == 1.0f) {
                localCoords.x += f4;
                localCoords.y += f5;
            } else {
                float f6 = this.f;
                float f7 = this.g;
                localCoords.x = (localCoords.x - f6) * f2 + f6 + f4;
                localCoords.y = (localCoords.y - f7) * f3 + f7 + f5;
            }
        } else {
            float f8 = (float)Math.cos(f * ((float)Math.PI / 180));
            float f9 = (float)Math.sin(f * ((float)Math.PI / 180));
            float f10 = this.f;
            float f11 = this.g;
            float f12 = (localCoords.x - f10) * f2;
            float f13 = (localCoords.y - f11) * f3;
            localCoords.x = f12 * f8 + f13 * f9 + f10 + f4;
            localCoords.y = f12 * -f9 + f13 * f8 + f11 + f5;
        }
        return localCoords;
    }

    public Vector2 localToAscendantCoordinates(Actor ascendant, Vector2 localCoords) {
        Actor actor = this;
        while (actor != null) {
            actor.localToParentCoordinates(localCoords);
            actor = actor.a;
            if (actor == ascendant) break;
        }
        return localCoords;
    }

    public Vector2 parentToLocalCoordinates(Vector2 parentCoords) {
        float f = this.j;
        float f2 = this.h;
        float f3 = this.i;
        float f4 = this.b;
        float f5 = this.c;
        if (f == 0.0f) {
            if (f2 == 1.0f && f3 == 1.0f) {
                parentCoords.x -= f4;
                parentCoords.y -= f5;
            } else {
                float f6 = this.f;
                float f7 = this.g;
                parentCoords.x = (parentCoords.x - f4 - f6) / f2 + f6;
                parentCoords.y = (parentCoords.y - f5 - f7) / f3 + f7;
            }
        } else {
            float f8 = (float)Math.cos(f * ((float)Math.PI / 180));
            float f9 = (float)Math.sin(f * ((float)Math.PI / 180));
            float f10 = this.f;
            float f11 = this.g;
            float f12 = parentCoords.x - f4 - f10;
            float f13 = parentCoords.y - f5 - f11;
            parentCoords.x = (f12 * f8 + f13 * f9) / f2 + f10;
            parentCoords.y = (f12 * -f9 + f13 * f8) / f3 + f11;
        }
        return parentCoords;
    }

    @BA.Hide
    public void getDebugRects(Array<DebugRenderer.DebugRect> debugRects) {
        DebugRenderer.DebugRect debugRect = DebugRenderer.debugRectPool.obtain();
        debugRect.bottomLeft.set(0.0f, 0.0f);
        debugRect.topRight.set(this.d, this.e);
        debugRect.color.set(debugColor);
        debugRects.add(debugRect);
    }

    public boolean getDebuggingEnabled() {
        return this.t;
    }

    public void setDebuggingEnabled(boolean enabled) {
        this.t = enabled;
    }

    public String toString() {
        int n;
        String string = this.p;
        if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

