/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.lgGdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;

@BA.ShortName(value="lgScn2DInputListener")
public class InputListener
implements EventListener {
    private static final Vector2 a = new Vector2();
    protected BA _ba = null;
    private String b;
    private static boolean c;

    public InputListener Initialize(BA ba, String EvtPrefix) {
        if (ba != null && ba.service != null && ba.getClassNameWithoutPackage().equals("wallpaperservice")) {
            BA.Log((String)"The input listeners are not compatible with Live Wallpapers.");
            return null;
        }
        this._ba = ba;
        this.b = EvtPrefix.length() > 0 ? EvtPrefix.toLowerCase(BA.cul) : "";
        c = lgGdx.App().getLogLevel() >= 3;
        return this;
    }

    @Override
    public boolean handle(Event e) {
        if (!(e instanceof InputEvent)) {
            return false;
        }
        InputEvent inputEvent = (InputEvent)e;
        switch (inputEvent.getType()) {
            case keyDown: {
                InputEvent inputEvent2 = inputEvent;
                return this.keyDown(inputEvent2, inputEvent2.getKeyCode());
            }
            case keyUp: {
                InputEvent inputEvent3 = inputEvent;
                return this.keyUp(inputEvent3, inputEvent3.getKeyCode());
            }
            case keyTyped: {
                InputEvent inputEvent4 = inputEvent;
                return this.keyTyped(inputEvent4, inputEvent4.getCharacter());
            }
        }
        InputEvent inputEvent5 = inputEvent;
        inputEvent5.toCoordinates(inputEvent5.getListenerActor(), a);
        switch (inputEvent.getType()) {
            case touchDown: {
                return this.touchDown(inputEvent, InputListener.a.x, InputListener.a.y, inputEvent.getPointer(), inputEvent.getButton());
            }
            case touchUp: {
                this.touchUp(inputEvent, InputListener.a.x, InputListener.a.y, inputEvent.getPointer(), inputEvent.getButton());
                return true;
            }
            case touchDragged: {
                this.touchDragged(inputEvent, InputListener.a.x, InputListener.a.y, inputEvent.getPointer());
                return true;
            }
            case enter: {
                this.enter(inputEvent, InputListener.a.x, InputListener.a.y, inputEvent.getPointer(), inputEvent.getRelatedActor());
                return false;
            }
            case exit: {
                this.exit(inputEvent, InputListener.a.x, InputListener.a.y, inputEvent.getPointer(), inputEvent.getRelatedActor());
                return false;
            }
        }
        return false;
    }

    @BA.Hide
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        if (c) {
            BA.Log((String)">>> TOUCH_DOWN");
            if (event.getTarget() == null) {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=null"));
            } else {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=" + event.getTarget().getName()));
            }
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_touchdown", false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer});
        }
        return event.isHandled();
    }

    @BA.Hide
    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
        if (c) {
            BA.Log((String)">>> TOUCH_UP");
            if (event.getTarget() == null) {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=null"));
            } else {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=" + event.getTarget().getName()));
            }
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_touchup", false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer});
        }
    }

    @BA.Hide
    public void touchDragged(InputEvent event, float x, float y, int pointer) {
        if (c) {
            BA.Log((String)">>> TOUCH_DRAGGED");
            if (event.getTarget() == null) {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=null"));
            } else {
                BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer + " Target=" + event.getTarget().getName()));
            }
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_touchdragged", false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer});
        }
    }

    @BA.Hide
    public boolean mouseMoved(InputEvent event, float x, float y) {
        return false;
    }

    @BA.Hide
    public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
        if (c) {
            BA.Log((String)">>> ENTER");
            String string = "X=" + x + " Y=" + y + " Ptr=" + pointer;
            string = event.getTarget() == null ? String.valueOf(string) + " Target=null" : String.valueOf(string) + " Target=" + event.getTarget().getName();
            if (fromActor != null) {
                string = String.valueOf(string) + " FromActor=" + fromActor.getName();
            }
            BA.Log((String)string);
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_enter", false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer, fromActor});
        }
    }

    @BA.Hide
    public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
        if (c) {
            BA.Log((String)">>> EXIT");
            String string = "X=" + x + " Y=" + y + " Ptr=" + pointer;
            string = event.getTarget() == null ? String.valueOf(string) + " Target=null" : String.valueOf(string) + " Target=" + event.getTarget().getName();
            if (toActor != null) {
                string = String.valueOf(string) + " ToActor=" + toActor.getName();
            }
            BA.Log((String)string);
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_exit", false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer, toActor});
        }
    }

    @BA.Hide
    public boolean scrolled(InputEvent event, float x, float y, int amount) {
        return false;
    }

    @BA.Hide
    public boolean keyDown(InputEvent event, int keycode) {
        if (c) {
            BA.Log((String)">>> KEY_DOWN: ".concat(String.valueOf(keycode)));
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_keydown", false, new Object[]{event, keycode});
        }
        return event.isHandled();
    }

    @BA.Hide
    public boolean keyUp(InputEvent event, int keycode) {
        if (c) {
            BA.Log((String)">>> KEY_UP: ".concat(String.valueOf(keycode)));
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_keyup", false, new Object[]{event, keycode});
        }
        return event.isHandled();
    }

    @BA.Hide
    public boolean keyTyped(InputEvent event, char character) {
        if (c) {
            BA.Log((String)">>> KEY_TYPED");
        }
        if (this._ba != null && !event.isStopped()) {
            this._ba.raiseEvent2((Object)this, false, String.valueOf(this.b) + "_keytyped", false, new Object[]{event, Character.valueOf(character)});
        }
        return event.isHandled();
    }
}

