/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgSpriteBatch;
import anywheresoftware.b4a.libgdx.scene2d.lgStage;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

@BA.Hide
public class Stage
extends InputAdapter
implements Disposable {
    private static final Vector3 a = new Vector3();
    private float b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;
    private float h;
    private float i;
    private Camera j;
    private final lgSpriteBatch k;
    private final lgStage l;
    private BA m;
    private String n;
    private boolean o;
    private final Group p;
    private final Vector2 q = new Vector2();
    private final Actor[] r = new Actor[20];
    private final boolean[] s = new boolean[20];
    private final int[] t = new int[20];
    private final int[] u = new int[20];
    private int v;
    private int w;
    private Actor x;
    private Actor y;
    private Actor z;
    private final SnapshotArray<TouchFocus> A = new SnapshotArray(true, 4, TouchFocus.class);
    private boolean B = true;

    public Stage(float width, float height, boolean keepAspectRatio, lgSpriteBatch batch, lgStage subStage, BA ba, String EvtPrefix) {
        boolean bl = this.o = batch == null;
        if (this.o) {
            this.k = new lgSpriteBatch();
            this.k.Initialize();
        } else {
            this.k = batch;
        }
        this.f = width;
        this.g = height;
        this.p = new Group();
        this.m = ba;
        this.n = EvtPrefix.toLowerCase(BA.cul);
        this.l = subStage;
        this.p.Initialize(this.m, this.n);
        this.p.setStage(this.l);
        this.j = new OrthographicCamera();
        this.setViewport(width, height, keepAspectRatio);
    }

    public void setViewport(float width, float height) {
        this.setViewport(width, height, false, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setViewport(float width, float height, boolean keepAspectRatio) {
        this.setViewport(width, height, keepAspectRatio, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setViewport(float stageWidth, float stageHeight, boolean keepAspectRatio, float viewportX, float viewportY, float viewportWidth, float viewportHeight) {
        float f;
        float f2;
        this.b = viewportX;
        this.c = viewportY;
        this.d = viewportWidth;
        this.e = viewportHeight;
        if (keepAspectRatio) {
            if (viewportHeight / viewportWidth < stageHeight / stageWidth) {
                f2 = viewportHeight / stageHeight;
                f = stageHeight / viewportHeight;
                float f3 = stageWidth * f2;
                float f4 = (viewportWidth - f3) * f;
                this.f = stageWidth + f4;
                this.g = stageHeight;
                this.h = f4 / 2.0f;
                this.i = 0.0f;
            } else {
                f2 = viewportWidth / stageWidth;
                f = stageWidth / viewportWidth;
                float f5 = stageHeight * f2;
                float f6 = (viewportHeight - f5) * f;
                this.g = stageHeight + f6;
                this.f = stageWidth;
                this.h = 0.0f;
                this.i = f6 / 2.0f;
            }
        } else {
            this.f = stageWidth;
            this.g = stageHeight;
            this.h = 0.0f;
            this.i = 0.0f;
        }
        f2 = this.f / 2.0f;
        f = this.g / 2.0f;
        this.j.position.set(f2, f, 0.0f);
        this.j.viewportWidth = this.f;
        this.j.viewportHeight = this.g;
        if (this.p.IsInitialized()) {
            this.p.d = this.f;
            this.p.e = this.g;
        }
    }

    public void draw() {
        this.j.update();
        if (!this.p.isVisible()) {
            return;
        }
        if (this.k != null) {
            this.k.setProjectionMatrix(this.j.combined);
            this.k.Begin();
            this.p.draw(this.k.getInternalObject(), 1.0f);
            this.k.End();
        }
    }

    public void act() {
        this.act(Math.min(Gdx.graphics.getDeltaTime(), 0.033333335f));
    }

    public void act(float delta) {
        int n = 0;
        while (n < 20) {
            Actor actor = this.r[n];
            if (!this.s[n]) {
                if (actor != null) {
                    this.r[n] = null;
                    Stage stage = this;
                    stage.screenToStageCoordinates(stage.q.set(this.t[n], this.u[n]));
                    InputEvent inputEvent = Pools.obtain(InputEvent.class);
                    inputEvent.setType(InputEvent.Type.exit);
                    inputEvent.setStage(this.l);
                    inputEvent.setStageX(this.q.x);
                    inputEvent.setStageY(this.q.y);
                    inputEvent.setRelatedActor(actor);
                    inputEvent.setPointer(n);
                    actor.fire(inputEvent);
                    Pools.free(inputEvent);
                }
            } else {
                this.r[n] = this.a(actor, this.t[n], this.u[n], n);
            }
            ++n;
        }
        Application.ApplicationType applicationType = Gdx.app.getType();
        if (applicationType == Application.ApplicationType.Desktop || applicationType == Application.ApplicationType.Applet || applicationType == Application.ApplicationType.WebGL) {
            this.x = this.a(this.x, this.v, this.w, -1);
        }
        this.p.act(delta);
    }

    private Actor a(Actor actor, int n, int n2, int n3) {
        InputEvent inputEvent;
        Stage stage = this;
        stage.screenToStageCoordinates(stage.q.set(n, n2));
        Stage stage2 = this;
        Actor actor2 = stage2.hit(stage2.q.x, this.q.y, true);
        if (actor2 == actor) {
            return actor;
        }
        if (actor != null) {
            inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setStage(this.l);
            inputEvent.setStageX(this.q.x);
            inputEvent.setStageY(this.q.y);
            inputEvent.setPointer(n3);
            inputEvent.setType(InputEvent.Type.exit);
            inputEvent.setRelatedActor(actor2);
            actor.fire(inputEvent);
            Pools.free(inputEvent);
        }
        if (actor2 != null) {
            inputEvent = Pools.obtain(InputEvent.class);
            inputEvent.setStage(this.l);
            inputEvent.setStageX(this.q.x);
            inputEvent.setStageY(this.q.y);
            inputEvent.setPointer(n3);
            inputEvent.setType(InputEvent.Type.enter);
            inputEvent.setRelatedActor(actor);
            actor2.fire(inputEvent);
            Pools.free(inputEvent);
        }
        return actor2;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if ((float)screenX < this.b || (float)screenX >= this.b + this.d) {
            return false;
        }
        if ((float)(Gdx.graphics.getHeight() - screenY) < this.c || (float)(Gdx.graphics.getHeight() - screenY) >= this.c + this.e) {
            return false;
        }
        this.s[pointer] = true;
        this.t[pointer] = screenX;
        this.u[pointer] = screenY;
        Stage stage = this;
        stage.screenToStageCoordinates(stage.q.set(screenX, screenY));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchDown);
        inputEvent.setStage(this.l);
        inputEvent.setStageX(this.q.x);
        inputEvent.setStageY(this.q.y);
        inputEvent.setPointer(pointer);
        inputEvent.setButton(button);
        Stage stage2 = this;
        Actor actor = stage2.hit(stage2.q.x, this.q.y, true);
        if (actor == null) {
            if (this.p.getTouchable() == Touchable.enabled) {
                this.p.fire(inputEvent);
            }
        } else {
            actor.fire(inputEvent);
        }
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.t[pointer] = screenX;
        this.u[pointer] = screenY;
        this.v = screenX;
        this.w = screenY;
        if (this.A.size == 0) {
            return false;
        }
        Stage stage = this;
        stage.screenToStageCoordinates(stage.q.set(screenX, screenY));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchDragged);
        inputEvent.setStage(this.l);
        inputEvent.setStageX(this.q.x);
        inputEvent.setStageY(this.q.y);
        inputEvent.setPointer(pointer);
        SnapshotArray<TouchFocus> snapshotArray = this.A;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = 0;
        int n2 = snapshotArray.size;
        while (n < n2) {
            TouchFocus touchFocus = touchFocusArray[n];
            if (touchFocus.d == pointer && snapshotArray.contains(touchFocus, true)) {
                inputEvent.setTarget(touchFocus.c);
                inputEvent.setListenerActor(touchFocus.b);
                if (touchFocus.a.handle(inputEvent)) {
                    inputEvent.handle();
                }
            }
            ++n;
        }
        snapshotArray.end();
        n = inputEvent.isHandled() ? 1 : 0;
        Pools.free(inputEvent);
        return n != 0;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.s[pointer] = false;
        this.t[pointer] = screenX;
        this.u[pointer] = screenY;
        if (this.A.size == 0) {
            return false;
        }
        Stage stage = this;
        stage.screenToStageCoordinates(stage.q.set(screenX, screenY));
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStage(this.l);
        inputEvent.setStageX(this.q.x);
        inputEvent.setStageY(this.q.y);
        inputEvent.setPointer(pointer);
        inputEvent.setButton(button);
        SnapshotArray<TouchFocus> snapshotArray = this.A;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = 0;
        int n2 = snapshotArray.size;
        while (n < n2) {
            TouchFocus touchFocus = touchFocusArray[n];
            if (touchFocus.d == pointer && touchFocus.e == button && snapshotArray.removeValue(touchFocus, true)) {
                inputEvent.setTarget(touchFocus.c);
                inputEvent.setListenerActor(touchFocus.b);
                if (touchFocus.a.handle(inputEvent)) {
                    inputEvent.handle();
                }
                Pools.free(touchFocus);
            }
            ++n;
        }
        snapshotArray.end();
        n = inputEvent.isHandled() ? 1 : 0;
        Pools.free(inputEvent);
        return n != 0;
    }

    @Override
    public boolean keyDown(int keyCode) {
        Actor actor = this.y == null ? this.p : this.y;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this.l);
        inputEvent.setType(InputEvent.Type.keyDown);
        inputEvent.setKeyCode(keyCode);
        actor.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean keyUp(int keyCode) {
        Actor actor = this.y == null ? this.p : this.y;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this.l);
        inputEvent.setType(InputEvent.Type.keyUp);
        inputEvent.setKeyCode(keyCode);
        actor.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    @Override
    public boolean keyTyped(char character) {
        Actor actor = this.y == null ? this.p : this.y;
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this.l);
        inputEvent.setType(InputEvent.Type.keyTyped);
        inputEvent.setCharacter(character);
        actor.fire(inputEvent);
        boolean bl = inputEvent.isHandled();
        Pools.free(inputEvent);
        return bl;
    }

    public void addTouchFocus(EventListener listener, Actor listenerActor, Actor target, int pointer, int button) {
        TouchFocus touchFocus = Pools.obtain(TouchFocus.class);
        Pools.obtain(TouchFocus.class).b = listenerActor;
        touchFocus.c = target;
        touchFocus.a = listener;
        touchFocus.d = pointer;
        touchFocus.e = button;
        this.A.add(touchFocus);
    }

    public void removeTouchFocus(EventListener listener, Actor listenerActor, Actor target, int pointer, int button) {
        SnapshotArray<TouchFocus> snapshotArray = this.A;
        int n = snapshotArray.size - 1;
        while (n >= 0) {
            TouchFocus touchFocus = (TouchFocus)snapshotArray.get(n);
            if (touchFocus.a == listener && touchFocus.b == listenerActor && touchFocus.c == target && touchFocus.d == pointer && touchFocus.e == button) {
                snapshotArray.removeIndex(n);
                Pools.free(touchFocus);
            }
            --n;
        }
    }

    public void cancelTouchFocus(Actor actor) {
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this.l);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStageX(-2.1474836E9f);
        inputEvent.setStageY(-2.1474836E9f);
        SnapshotArray<TouchFocus> snapshotArray = this.A;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = 0;
        int n2 = snapshotArray.size;
        while (n < n2) {
            TouchFocus touchFocus = touchFocusArray[n];
            if (touchFocus.b == actor && snapshotArray.removeValue(touchFocus, true)) {
                inputEvent.setTarget(touchFocus.c);
                inputEvent.setListenerActor(touchFocus.b);
                inputEvent.setPointer(touchFocus.d);
                inputEvent.setButton(touchFocus.e);
                touchFocus.a.handle(inputEvent);
            }
            ++n;
        }
        snapshotArray.end();
        Pools.free(inputEvent);
    }

    public void cancelTouchFocus() {
        this.cancelTouchFocusExcept(null, null);
    }

    public void cancelTouchFocusExcept(EventListener exceptListener, Actor exceptActor) {
        InputEvent inputEvent = Pools.obtain(InputEvent.class);
        inputEvent.setStage(this.l);
        inputEvent.setType(InputEvent.Type.touchUp);
        inputEvent.setStageX(-2.1474836E9f);
        inputEvent.setStageY(-2.1474836E9f);
        SnapshotArray<TouchFocus> snapshotArray = this.A;
        TouchFocus[] touchFocusArray = snapshotArray.begin();
        int n = 0;
        int n2 = snapshotArray.size;
        while (n < n2) {
            TouchFocus touchFocus = touchFocusArray[n];
            if ((touchFocus.a != exceptListener || touchFocus.b != exceptActor) && snapshotArray.removeValue(touchFocus, true)) {
                inputEvent.setTarget(touchFocus.c);
                inputEvent.setListenerActor(touchFocus.b);
                inputEvent.setPointer(touchFocus.d);
                inputEvent.setButton(touchFocus.e);
                touchFocus.a.handle(inputEvent);
            }
            ++n;
        }
        snapshotArray.end();
        Pools.free(inputEvent);
    }

    public void addActor(Actor actor) {
        this.p.addActor(actor);
    }

    public void addAction(Action action) {
        this.p.addAction(action);
    }

    public Array<Actor> getActors() {
        return this.p.l;
    }

    public boolean addListener(EventListener listener) {
        return this.p.addListener(listener);
    }

    public boolean removeListener(EventListener listener) {
        return this.p.removeListener(listener);
    }

    public boolean addCaptureListener(EventListener listener) {
        return this.p.addCaptureListener(listener);
    }

    public boolean removeCaptureListener(EventListener listener) {
        return this.p.removeCaptureListener(listener);
    }

    public void clear() {
        this.unfocusAll();
        this.p.clear();
    }

    public void unfocusAll() {
        this.z = null;
        this.y = null;
        this.cancelTouchFocus();
    }

    public void unfocus(Actor actor) {
        this.cancelTouchFocus(actor);
        if (this.z != null && this.z.isDescendantOf(actor)) {
            this.z = null;
        }
        if (this.y != null && this.y.isDescendantOf(actor)) {
            this.y = null;
        }
    }

    public void setKeyboardFocus(Actor actor) {
        if (this.y == actor) {
            return;
        }
        FocusListener.FocusEvent focusEvent = Pools.obtain(FocusListener.FocusEvent.class);
        focusEvent.setStage(this.l);
        focusEvent.setType(FocusListener.FocusEvent.Type.keyboard);
        Actor actor2 = this.y;
        if (actor2 != null) {
            focusEvent.setFocused(false);
            focusEvent.setRelatedActor(actor);
            actor2.fire(focusEvent);
        }
        if (!focusEvent.isCancelled()) {
            this.y = actor;
            if (actor != null) {
                focusEvent.setFocused(true);
                focusEvent.setRelatedActor(actor2);
                actor.fire(focusEvent);
                if (focusEvent.isCancelled()) {
                    this.setKeyboardFocus(actor2);
                }
            }
        }
        Pools.free(focusEvent);
    }

    public Actor getKeyboardFocus() {
        return this.y;
    }

    public void setScrollFocus(Actor actor) {
        if (this.z == actor) {
            return;
        }
        FocusListener.FocusEvent focusEvent = Pools.obtain(FocusListener.FocusEvent.class);
        focusEvent.setStage(this.l);
        focusEvent.setType(FocusListener.FocusEvent.Type.scroll);
        Actor actor2 = this.z;
        if (actor2 != null) {
            focusEvent.setFocused(false);
            focusEvent.setRelatedActor(actor);
            actor2.fire(focusEvent);
        }
        if (!focusEvent.isCancelled()) {
            this.z = actor;
            if (actor != null) {
                focusEvent.setFocused(true);
                focusEvent.setRelatedActor(actor2);
                actor.fire(focusEvent);
                if (focusEvent.isCancelled()) {
                    this.setScrollFocus(actor2);
                }
            }
        }
        Pools.free(focusEvent);
    }

    public Actor getScrollFocus() {
        return this.z;
    }

    public float getWidth() {
        return this.f;
    }

    public float getHeight() {
        return this.g;
    }

    public float getGutterWidth() {
        return this.h;
    }

    public float getGutterHeight() {
        return this.i;
    }

    public lgSpriteBatch SpriteBatch() {
        return this.k;
    }

    @BA.Hide
    public Batch getSpriteBatch() {
        return this.k.getInternalObject();
    }

    public Camera getCamera() {
        return this.j;
    }

    public void setCamera(Camera camera) {
        this.j = camera;
    }

    public Group getRoot() {
        return this.p;
    }

    public Actor hit(float stageX, float stageY, boolean touchable) {
        this.p.parentToLocalCoordinates(this.q.set(stageX, stageY));
        return this.p.hit(this.q.x, this.q.y, touchable);
    }

    public Vector2 screenToStageCoordinates(Vector2 screenCoords) {
        this.j.unproject(a.set(screenCoords.x, screenCoords.y, 0.0f), this.b, this.c, this.d, this.e);
        screenCoords.x = Stage.a.x;
        screenCoords.y = Stage.a.y;
        return screenCoords;
    }

    public Vector2 stageToScreenCoordinates(Vector2 stageCoords) {
        this.j.project(a.set(stageCoords.x, stageCoords.y, 0.0f), this.b, this.c, this.d, this.e);
        stageCoords.x = Stage.a.x;
        stageCoords.y = this.e - Stage.a.y;
        return stageCoords;
    }

    public void calculateScissors(Rectangle area, Rectangle scissor) {
        ScissorStack.calculateScissors(this.j, this.b, this.c, this.d, this.e, this.k.getTransformMatrix(), area, scissor);
    }

    public void setActionsRequestRendering(boolean actionsRequestRendering) {
        this.B = actionsRequestRendering;
    }

    public boolean getActionsRequestRendering() {
        return this.B;
    }

    @Override
    public void dispose() {
        this.clear();
        if (this.o) {
            this.k.dispose();
        }
    }

    @BA.Hide
    public static final class TouchFocus
    implements Pool.Poolable {
        EventListener a;
        Actor b;
        Actor c;
        int d;
        int e;

        @Override
        public final void reset() {
            this.b = null;
            this.a = null;
            this.c = null;
        }
    }
}

