/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.AddAction;
import com.badlogic.gdx.scenes.scene2d.actions.AddListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.AfterAction;
import com.badlogic.gdx.scenes.scene2d.actions.AlphaAction;
import com.badlogic.gdx.scenes.scene2d.actions.ColorAction;
import com.badlogic.gdx.scenes.scene2d.actions.DelayAction;
import com.badlogic.gdx.scenes.scene2d.actions.LayoutAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveActorAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateByAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleByAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeByAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeToAction;
import com.badlogic.gdx.scenes.scene2d.actions.TimeScaleAction;
import com.badlogic.gdx.scenes.scene2d.actions.TouchableAction;
import com.badlogic.gdx.scenes.scene2d.actions.VisibleAction;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

@BA.ShortName(value="lgScn2DActions")
public class Actions {
    @BA.Hide
    public static <T extends Action> T action(Class<T> type) {
        Pool<T> pool = Pools.get(type);
        Action action = (Action)pool.obtain();
        action.setPool(pool);
        return (T)action;
    }

    @BA.Hide
    public static AddAction addAction(Action action) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setAction(action);
        return addAction;
    }

    public static AddAction AddActionToActor(Action action, Actor targetActor) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setTarget(targetActor);
        addAction.setAction(action);
        return addAction;
    }

    @BA.Hide
    public static RemoveAction removeAction(Action action) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setAction(action);
        return removeAction;
    }

    public static RemoveAction RemoveActionFromActor(Action action, Actor targetActor) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setTarget(targetActor);
        removeAction.setAction(action);
        return removeAction;
    }

    public static MoveToAction MoveTo(float x, float y) {
        return Actions.MoveTo3(x, y, 0.0f, null);
    }

    public static MoveToAction MoveTo2(float x, float y, float duration) {
        return Actions.MoveTo3(x, y, duration, null);
    }

    public static MoveToAction MoveTo3(float x, float y, float duration, Interpolation interpolation) {
        MoveToAction moveToAction = Actions.action(MoveToAction.class);
        moveToAction.setPosition(x, y);
        moveToAction.setDuration(duration);
        moveToAction.setInterpolation(interpolation);
        return moveToAction;
    }

    public static MoveByAction MoveBy(float amountX, float amountY) {
        return Actions.MoveBy3(amountX, amountY, 0.0f, null);
    }

    public static MoveByAction MoveBy2(float amountX, float amountY, float duration) {
        return Actions.MoveBy3(amountX, amountY, duration, null);
    }

    public static MoveByAction MoveBy3(float amountX, float amountY, float duration, Interpolation interpolation) {
        MoveByAction moveByAction = Actions.action(MoveByAction.class);
        moveByAction.setAmount(amountX, amountY);
        moveByAction.setDuration(duration);
        moveByAction.setInterpolation(interpolation);
        return moveByAction;
    }

    public static SizeToAction SizeTo(float x, float y) {
        return Actions.SizeTo3(x, y, 0.0f, null);
    }

    public static SizeToAction SizeTo2(float x, float y, float duration) {
        return Actions.SizeTo3(x, y, duration, null);
    }

    public static SizeToAction SizeTo3(float x, float y, float duration, Interpolation interpolation) {
        SizeToAction sizeToAction = Actions.action(SizeToAction.class);
        sizeToAction.setSize(x, y);
        sizeToAction.setDuration(duration);
        sizeToAction.setInterpolation(interpolation);
        return sizeToAction;
    }

    public static SizeByAction SizeBy(float amountX, float amountY) {
        return Actions.SizeBy3(amountX, amountY, 0.0f, null);
    }

    public static SizeByAction SizeBy2(float amountX, float amountY, float duration) {
        return Actions.SizeBy3(amountX, amountY, duration, null);
    }

    public static SizeByAction SizeBy3(float amountX, float amountY, float duration, Interpolation interpolation) {
        SizeByAction sizeByAction = Actions.action(SizeByAction.class);
        sizeByAction.setAmount(amountX, amountY);
        sizeByAction.setDuration(duration);
        sizeByAction.setInterpolation(interpolation);
        return sizeByAction;
    }

    public static ScaleToAction ScaleTo(float x, float y) {
        return Actions.ScaleTo3(x, y, 0.0f, null);
    }

    public static ScaleToAction ScaleTo2(float x, float y, float duration) {
        return Actions.ScaleTo3(x, y, duration, null);
    }

    public static ScaleToAction ScaleTo3(float x, float y, float duration, Interpolation interpolation) {
        ScaleToAction scaleToAction = Actions.action(ScaleToAction.class);
        scaleToAction.setScale(x, y);
        scaleToAction.setDuration(duration);
        scaleToAction.setInterpolation(interpolation);
        return scaleToAction;
    }

    public static ScaleByAction ScaleBy(float amountX, float amountY) {
        return Actions.ScaleBy3(amountX, amountY, 0.0f, null);
    }

    public static ScaleByAction ScaleBy2(float amountX, float amountY, float duration) {
        return Actions.ScaleBy3(amountX, amountY, duration, null);
    }

    public static ScaleByAction ScaleBy3(float amountX, float amountY, float duration, Interpolation interpolation) {
        ScaleByAction scaleByAction = Actions.action(ScaleByAction.class);
        scaleByAction.setAmount(amountX, amountY);
        scaleByAction.setDuration(duration);
        scaleByAction.setInterpolation(interpolation);
        return scaleByAction;
    }

    public static RotateToAction RotateTo(float rotation) {
        return Actions.RotateTo3(rotation, 0.0f, null);
    }

    public static RotateToAction RotateTo2(float rotation, float duration) {
        return Actions.RotateTo3(rotation, duration, null);
    }

    public static RotateToAction RotateTo3(float rotation, float duration, Interpolation interpolation) {
        RotateToAction rotateToAction = Actions.action(RotateToAction.class);
        rotateToAction.setRotation(rotation);
        rotateToAction.setDuration(duration);
        rotateToAction.setInterpolation(interpolation);
        return rotateToAction;
    }

    public static RotateByAction RotateBy(float rotationAmount) {
        return Actions.RotateBy3(rotationAmount, 0.0f, null);
    }

    public static RotateByAction RotateBy2(float rotationAmount, float duration) {
        return Actions.RotateBy3(rotationAmount, duration, null);
    }

    public static RotateByAction RotateBy3(float rotationAmount, float duration, Interpolation interpolation) {
        RotateByAction rotateByAction = Actions.action(RotateByAction.class);
        rotateByAction.setAmount(rotationAmount);
        rotateByAction.setDuration(duration);
        rotateByAction.setInterpolation(interpolation);
        return rotateByAction;
    }

    public static ColorAction Color(Color color) {
        return Actions.Color3(color, 0.0f, null);
    }

    public static ColorAction Color2(Color color, float duration) {
        return Actions.Color3(color, duration, null);
    }

    public static ColorAction Color3(Color color, float duration, Interpolation interpolation) {
        ColorAction colorAction = Actions.action(ColorAction.class);
        colorAction.setEndColor(color);
        colorAction.setDuration(duration);
        colorAction.setInterpolation(interpolation);
        return colorAction;
    }

    public static AlphaAction Alpha(float a2) {
        return Actions.Alpha3(a2, 0.0f, null);
    }

    public static AlphaAction Alpha2(float a2, float duration) {
        return Actions.Alpha3(a2, duration, null);
    }

    public static AlphaAction Alpha3(float a2, float duration, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(a2);
        alphaAction.setDuration(duration);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static AlphaAction FadeOut(float duration) {
        return Actions.Alpha3(0.0f, duration, null);
    }

    public static AlphaAction FadeOut2(float duration, Interpolation interpolation) {
        return Actions.fadeOut(duration, interpolation);
    }

    @BA.Hide
    public static AlphaAction fadeOut(float duration, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(0.0f);
        alphaAction.setDuration(duration);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static AlphaAction FadeIn(float duration) {
        return Actions.Alpha3(1.0f, duration, null);
    }

    public static AlphaAction FadeIn2(float duration, Interpolation interpolation) {
        return Actions.fadeIn(duration, interpolation);
    }

    @BA.Hide
    public static AlphaAction fadeIn(float duration, Interpolation interpolation) {
        AlphaAction alphaAction = Actions.action(AlphaAction.class);
        alphaAction.setAlpha(1.0f);
        alphaAction.setDuration(duration);
        alphaAction.setInterpolation(interpolation);
        return alphaAction;
    }

    public static VisibleAction Show() {
        return Actions.Visible(true);
    }

    public static VisibleAction Hide() {
        return Actions.Visible(false);
    }

    public static VisibleAction Visible(boolean visible) {
        VisibleAction visibleAction = Actions.action(VisibleAction.class);
        visibleAction.setVisible(visible);
        return visibleAction;
    }

    public static TouchableAction Touchable(Touchable touchable) {
        TouchableAction touchableAction = Actions.action(TouchableAction.class);
        touchableAction.setTouchable(touchable);
        return touchableAction;
    }

    public static RemoveActorAction removeActor() {
        return Actions.action(RemoveActorAction.class);
    }

    public static RemoveActorAction RemoveActor2(Actor removeActor) {
        RemoveActorAction removeActorAction = Actions.action(RemoveActorAction.class);
        removeActorAction.setTarget(removeActor);
        return removeActorAction;
    }

    public static DelayAction Delay(float duration) {
        DelayAction delayAction = Actions.action(DelayAction.class);
        delayAction.setDuration(duration);
        return delayAction;
    }

    public static DelayAction Delay2(float duration, Action delayedAction) {
        DelayAction delayAction = Actions.action(DelayAction.class);
        delayAction.setDuration(duration);
        delayAction.setAction(delayedAction);
        return delayAction;
    }

    public static TimeScaleAction TimeScale(float scale, Action scaledAction) {
        TimeScaleAction timeScaleAction = Actions.action(TimeScaleAction.class);
        timeScaleAction.setScale(scale);
        timeScaleAction.setAction(scaledAction);
        return timeScaleAction;
    }

    @BA.Hide
    public static SequenceAction sequence(Action action1) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action1);
        return sequenceAction;
    }

    public static SequenceAction Sequence2(Action action1, Action action2) {
        return Actions.sequence(action1, action2);
    }

    @BA.Hide
    public static SequenceAction sequence(Action action1, Action action2) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action1);
        sequenceAction.addAction(action2);
        return sequenceAction;
    }

    public static SequenceAction Sequence3(Action action1, Action action2, Action action3) {
        return Actions.sequence(action1, action2, action3);
    }

    @BA.Hide
    public static SequenceAction sequence(Action action1, Action action2, Action action3) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action1);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        return sequenceAction;
    }

    public static SequenceAction Sequence4(Action action1, Action action2, Action action3, Action action4) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action1);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        sequenceAction.addAction(action4);
        return sequenceAction;
    }

    public static SequenceAction Sequence5(Action action1, Action action2, Action action3, Action action4, Action action5) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        sequenceAction.addAction(action1);
        sequenceAction.addAction(action2);
        sequenceAction.addAction(action3);
        sequenceAction.addAction(action4);
        sequenceAction.addAction(action5);
        return sequenceAction;
    }

    public static SequenceAction Sequence(Action ... actions) {
        SequenceAction sequenceAction = Actions.action(SequenceAction.class);
        int n = 0;
        int n2 = actions.length;
        while (n < n2) {
            sequenceAction.addAction(actions[n]);
            ++n;
        }
        return sequenceAction;
    }

    @BA.Hide
    public static SequenceAction sequence() {
        return Actions.action(SequenceAction.class);
    }

    @BA.Hide
    public static ParallelAction parallel(Action action1) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action1);
        return parallelAction;
    }

    public static ParallelAction Parallel2(Action action1, Action action2) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action1);
        parallelAction.addAction(action2);
        return parallelAction;
    }

    public static ParallelAction Parallel3(Action action1, Action action2, Action action3) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action1);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        return parallelAction;
    }

    public static ParallelAction Parallel4(Action action1, Action action2, Action action3, Action action4) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action1);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        parallelAction.addAction(action4);
        return parallelAction;
    }

    public static ParallelAction Parallel5(Action action1, Action action2, Action action3, Action action4, Action action5) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        parallelAction.addAction(action1);
        parallelAction.addAction(action2);
        parallelAction.addAction(action3);
        parallelAction.addAction(action4);
        parallelAction.addAction(action5);
        return parallelAction;
    }

    public static ParallelAction Parallel(Action ... actions) {
        ParallelAction parallelAction = Actions.action(ParallelAction.class);
        int n = 0;
        int n2 = actions.length;
        while (n < n2) {
            parallelAction.addAction(actions[n]);
            ++n;
        }
        return parallelAction;
    }

    @BA.Hide
    public static ParallelAction parallel() {
        return Actions.action(ParallelAction.class);
    }

    public static RepeatAction Repeat(int count, Action repeatedAction) {
        RepeatAction repeatAction = Actions.action(RepeatAction.class);
        repeatAction.setCount(count);
        repeatAction.setAction(repeatedAction);
        return repeatAction;
    }

    public static RepeatAction Forever(Action repeatedAction) {
        RepeatAction repeatAction = Actions.action(RepeatAction.class);
        repeatAction.setCount(-1);
        repeatAction.setAction(repeatedAction);
        return repeatAction;
    }

    public static RunnableAction CallSub(final BA ba, final String SubName, final Object Parameter2) {
        RunnableAction runnableAction = Actions.action(RunnableAction.class);
        runnableAction.setRunnable(new Runnable(){

            @Override
            public final void run() {
                ba.raiseEvent(null, SubName.toLowerCase(BA.cul), new Object[]{Parameter2});
            }
        });
        return runnableAction;
    }

    @BA.Hide
    public static LayoutAction layout(boolean enabled) {
        LayoutAction layoutAction = Actions.action(LayoutAction.class);
        layoutAction.setLayoutEnabled(enabled);
        return layoutAction;
    }

    public static AfterAction After(Action action) {
        AfterAction afterAction = Actions.action(AfterAction.class);
        afterAction.setAction(action);
        return afterAction;
    }

    public static AddListenerAction AddListener(EventListener listener, boolean capture) {
        AddListenerAction addListenerAction = Actions.action(AddListenerAction.class);
        addListenerAction.setListener(listener);
        addListenerAction.setCapture(capture);
        return addListenerAction;
    }

    public static AddListenerAction AddListener2(EventListener listener, boolean capture, Actor targetActor) {
        AddListenerAction addListenerAction = Actions.action(AddListenerAction.class);
        addListenerAction.setTarget(targetActor);
        addListenerAction.setListener(listener);
        addListenerAction.setCapture(capture);
        return addListenerAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture) {
        RemoveListenerAction removeListenerAction = Actions.action(RemoveListenerAction.class);
        removeListenerAction.setListener(listener);
        removeListenerAction.setCapture(capture);
        return removeListenerAction;
    }

    public static RemoveListenerAction RemoveListener2(EventListener listener, boolean capture, Actor targetActor) {
        RemoveListenerAction removeListenerAction = Actions.action(RemoveListenerAction.class);
        removeListenerAction.setTarget(targetActor);
        removeListenerAction.setListener(listener);
        removeListenerAction.setCapture(capture);
        return removeListenerAction;
    }
}

