/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.scene2d.lgTable;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.SnapshotArray;

@BA.Hide
public class Button
extends lgTable
implements Disableable {
    private ButtonStyle p;
    boolean m;
    private boolean q;
    ButtonGroup n;
    protected ClickListener clickListener;
    private boolean r = true;

    public Button(Skin skin) {
        super(skin);
        this.a();
        this.setStyle(skin.get(ButtonStyle.class));
        Button button = this;
        button.setSize(button.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Skin skin, String styleName) {
        super(skin);
        this.a();
        this.setStyle(skin.get(styleName, ButtonStyle.class));
        Button button = this;
        button.setSize(button.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Actor child, Skin skin, String styleName) {
        this(child, skin.get(styleName, ButtonStyle.class));
    }

    public Button(Actor child, ButtonStyle style) {
        this.a();
        this.add(child);
        this.setStyle(style);
        Button button = this;
        button.setSize(button.getPrefWidth(), this.getPrefHeight());
    }

    public Button(ButtonStyle style) {
        this.a();
        this.setStyle(style);
        Button button = this;
        button.setSize(button.getPrefWidth(), this.getPrefHeight());
    }

    public Button() {
        this.a();
    }

    private void a() {
        this.setTouchable(Touchable.enabled);
        this.m = false;
        this.q = false;
        this.clickListener = new ClickListener(this){
            private /* synthetic */ Button a;
            {
                this.a = button;
            }

            @Override
            public final void clicked(InputEvent event, float x, float y) {
                if (this.a.isDisabled()) {
                    return;
                }
                this.a.setChecked(!this.a.m, true);
            }
        };
        this.addListener(this.clickListener);
    }

    public Button(Drawable up) {
        this(new ButtonStyle(up, null, null));
    }

    public Button(Drawable up, Drawable down) {
        this(new ButtonStyle(up, down, null));
    }

    public Button(Drawable up, Drawable down, Drawable checked) {
        this(new ButtonStyle(up, down, checked));
    }

    public Button(Actor child, Skin skin) {
        this(child, skin.get(ButtonStyle.class));
    }

    public void setChecked(boolean isChecked) {
        this.setChecked(isChecked, this.r);
    }

    protected void setChecked(boolean isChecked, boolean fireEvent) {
        if (this.m == isChecked) {
            return;
        }
        if (this.n != null && !this.n.canCheck(this, isChecked)) {
            return;
        }
        this.m = isChecked;
        if (fireEvent && !this.q) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.m = !isChecked;
            }
            Pools.free(changeEvent);
        }
    }

    public void toggle() {
        Button button = this;
        button.setChecked(!button.m);
    }

    @BA.Hide
    public boolean isChecked() {
        return this.m;
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    @BA.Hide
    public boolean isOver() {
        return this.clickListener.isOver();
    }

    @BA.Hide
    public ClickListener getClickListener() {
        return this.clickListener;
    }

    @Override
    @BA.Hide
    public boolean isDisabled() {
        return this.q;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.q = isDisabled;
    }

    @BA.Hide
    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.r = programmaticChangeEvents;
    }

    public void setStyle(ButtonStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.p = style;
        Drawable drawable = this.isPressed() && !this.isDisabled() ? (style.down == null ? style.up : style.down) : (this.isDisabled() && style.disabled != null ? style.disabled : (this.m && style.checked != null ? (this.isOver() && style.checkedOver != null ? style.checkedOver : style.checked) : (this.isOver() && style.over != null ? style.over : style.up)));
        this.setTblBackground(drawable);
    }

    public ButtonStyle getStyle() {
        return this.p;
    }

    @BA.Hide
    public ButtonGroup getButtonGroup() {
        return this.n;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float f;
        float f2;
        this.validate();
        boolean bl = this.isPressed();
        boolean bl2 = this.isDisabled();
        Drawable drawable = null;
        if (bl2 && this.p.disabled != null) {
            drawable = this.p.disabled;
        } else if (bl && !bl2 && this.p.down != null) {
            drawable = this.p.down;
        } else if (this.m && this.p.checked != null) {
            drawable = this.p.checkedOver != null && this.isOver() ? this.p.checkedOver : this.p.checked;
        } else if (this.isOver() && this.p.over != null) {
            drawable = this.p.over;
        } else if (this.p.up != null) {
            drawable = this.p.up;
        }
        this.setTblBackground(drawable);
        if (bl && !bl2) {
            f2 = this.p.pressedOffsetX;
            f = this.p.pressedOffsetY;
        } else {
            f2 = this.p.unpressedOffsetX;
            f = this.p.unpressedOffsetY;
        }
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        int n = 0;
        while (n < snapshotArray.size) {
            ((Actor)snapshotArray.get(n)).moveBy(f2, f);
            ++n;
        }
        super.draw(batch, parentAlpha);
        n = 0;
        while (n < snapshotArray.size) {
            ((Actor)snapshotArray.get(n)).moveBy(-f2, -f);
            ++n;
        }
        Stage stage = this.getStage();
        if (stage != null && stage.getActionsRequestRendering() && bl != this.clickListener.isPressed()) {
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public float getPrefWidth() {
        float f = super.getPrefWidth();
        if (this.p.up != null) {
            f = Math.max(f, this.p.up.getMinWidth());
        }
        if (this.p.down != null) {
            f = Math.max(f, this.p.down.getMinWidth());
        }
        if (this.p.checked != null) {
            f = Math.max(f, this.p.checked.getMinWidth());
        }
        return f;
    }

    @Override
    public float getPrefHeight() {
        float f = super.getPrefHeight();
        if (this.p.up != null) {
            f = Math.max(f, this.p.up.getMinHeight());
        }
        if (this.p.down != null) {
            f = Math.max(f, this.p.down.getMinHeight());
        }
        if (this.p.checked != null) {
            f = Math.max(f, this.p.checked.getMinHeight());
        }
        return f;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @BA.Hide
    public static class ButtonStyle {
        @BA.Hide
        public Drawable over;
        @BA.Hide
        public Drawable checkedOver;
        public Drawable up;
        public Drawable down;
        public Drawable checked;
        public Drawable disabled;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(Drawable up, Drawable down, Drawable checked) {
            this.up = up;
            this.down = down;
            this.checked = checked;
        }

        public ButtonStyle(ButtonStyle style) {
            this.up = style.up;
            this.down = style.down;
            this.over = style.over;
            this.checked = style.checked;
            this.checkedOver = style.checkedOver;
            this.disabled = style.disabled;
            this.pressedOffsetX = style.pressedOffsetX;
            this.pressedOffsetY = style.pressedOffsetY;
            this.unpressedOffsetX = style.unpressedOffsetX;
            this.unpressedOffsetY = style.unpressedOffsetY;
        }
    }
}

