/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.Scaling;

@BA.Hide
public class Image
extends Widget {
    private Scaling l;
    protected int align = 1;
    private float m;
    private float n;
    private float o;
    private float p;
    private Drawable q;

    public Image() {
        this((Drawable)null);
    }

    public Image(NinePatch patch) {
        this(new NinePatchDrawable(patch), Scaling.stretch, 1);
    }

    public Image(TextureRegion region) {
        this(new TextureRegionDrawable(region), Scaling.stretch, 1);
    }

    public Image(Texture texture) {
        this(new TextureRegionDrawable(new TextureRegion(texture)));
    }

    public Image(Skin skin, String drawableName) {
        this(skin.getDrawable(drawableName), Scaling.stretch, 1);
    }

    public Image(Drawable drawable) {
        this(drawable, Scaling.stretch, 1);
    }

    public Image(Drawable drawable, Scaling scaling) {
        this(drawable, scaling, 1);
    }

    public Image(Drawable drawable, Scaling scaling, int align) {
        this.setDrawable(drawable);
        this.l = scaling;
        this.align = align;
        Image image = this;
        image.setSize(image.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    @BA.Hide
    public void layout() {
        if (this.q == null) {
            return;
        }
        float f = this.q.getMinWidth();
        float f2 = this.q.getMinHeight();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        Vector2 vector2 = this.l.apply(f, f2, f3, f4);
        this.o = vector2.x;
        this.p = vector2.y;
        this.m = (this.align & 8) != 0 ? 0.0f : ((this.align & 0x10) != 0 ? (float)((int)(f3 - this.o)) : (float)((int)(f3 / 2.0f - this.o / 2.0f)));
        if ((this.align & 2) != 0) {
            this.n = (int)(f4 - this.p);
            return;
        }
        if ((this.align & 4) != 0) {
            this.n = 0.0f;
            return;
        }
        this.n = (int)(f4 / 2.0f - this.p / 2.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getScaleX();
        float f4 = this.getScaleY();
        if (this.q instanceof TransformDrawable) {
            float f5 = this.getRotation();
            if (f3 != 1.0f || f4 != 1.0f || f5 != 0.0f) {
                ((TransformDrawable)this.q).draw(batch, f + this.m, f2 + this.n, this.getOriginX() - this.m, this.getOriginY() - this.n, this.o, this.p, f3, f4, f5);
                return;
            }
        }
        if (this.q != null) {
            this.q.draw(batch, f + this.m, f2 + this.n, this.o * f3, this.p * f4);
        }
    }

    @BA.Hide
    public void setDrawable(Skin skin, String drawableName) {
        this.setDrawable(skin.getDrawable(drawableName));
    }

    public void setDrawable(Drawable drawable) {
        if (this.q == drawable) {
            return;
        }
        if (drawable != null) {
            if (this.getPrefWidth() != drawable.getMinWidth() || this.getPrefHeight() != drawable.getMinHeight()) {
                this.invalidateHierarchy();
            }
        } else {
            this.invalidateHierarchy();
        }
        this.q = drawable;
    }

    public Drawable getDrawable() {
        return this.q;
    }

    public void setScaling(Scaling scaling) {
        if (scaling == null) {
            throw new IllegalArgumentException("scaling cannot be null.");
        }
        this.l = scaling;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    public float getPrefWidth() {
        if (this.q != null) {
            return this.q.getMinWidth();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.q != null) {
            return this.q.getMinHeight();
        }
        return 0.0f;
    }

    public float getImageX() {
        return this.m;
    }

    public float getImageY() {
        return this.n;
    }

    public float getImageWidth() {
        return this.o;
    }

    public float getImageHeight() {
        return this.p;
    }
}

