/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgBitmapFont;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

@BA.Hide
public class Label
extends Widget {
    private static final Color l = new Color();
    private LabelStyle m;
    private final BitmapFont.TextBounds n = new BitmapFont.TextBounds();
    private final StringBuilder o = new StringBuilder();
    private StringBuilder p;
    private BitmapFontCache q;
    private int r = 8;
    private int s = 8;
    private boolean t;
    private float u;
    private boolean v = true;
    private float w = 1.0f;
    private float x = 1.0f;
    private boolean y;

    public Label() {
    }

    public Label(CharSequence text, Skin skin) {
        this(text, skin.get(LabelStyle.class));
    }

    public Label(CharSequence text, Skin skin, String styleName) {
        this(text, skin.get(styleName, LabelStyle.class));
    }

    public Label(CharSequence text, Skin skin, String fontName, Color color) {
        this(text, new LabelStyle(skin.getFont(fontName), color));
    }

    public Label(CharSequence text, Skin skin, String fontName, String colorName) {
        this(text, new LabelStyle(skin.getFont(fontName), skin.getColor(colorName)));
    }

    public Label(CharSequence text, LabelStyle style) {
        if (text != null) {
            this.o.append(text);
        }
        this.setStyle(style);
        if (text != null && text.length() > 0) {
            Label label = this;
            label.setSize(label.getPrefWidth(), this.getPrefHeight());
        }
    }

    public void setStyle(LabelStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        if (style.font == null) {
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        this.m = style;
        this.q = style.font.newFontCache();
        this.invalidateHierarchy();
    }

    public LabelStyle getStyle() {
        return this.m;
    }

    public void setText(CharSequence newText) {
        if (newText == null) {
            newText = "";
        }
        if (newText instanceof StringBuilder) {
            if (this.o.equals(newText)) {
                return;
            }
            this.o.setLength(0);
            this.o.append((CharSequence)((StringBuilder)newText));
        } else {
            if (this.textEquals(newText)) {
                return;
            }
            this.o.setLength(0);
            this.o.append(newText);
        }
        this.invalidateHierarchy();
    }

    public boolean textEquals(CharSequence other) {
        int n = this.o.length();
        if (n != other.length()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.o.charAt(n2) != other.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public CharSequence getText() {
        return this.o;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.v = true;
    }

    private void a() {
        BitmapFont bitmapFont = this.q.getFont();
        float f = bitmapFont.getScaleX();
        float f2 = bitmapFont.getScaleY();
        if (this.w != 1.0f || this.x != 1.0f) {
            bitmapFont.getData().setScale(this.w, this.x);
        }
        this.b();
        if (this.w != 1.0f || this.x != 1.0f) {
            bitmapFont.getData().setScale(f, f2);
        }
    }

    private void b() {
        this.v = false;
        if (this.t && !this.y) {
            float f = this.getWidth();
            if (this.m.background != null) {
                f -= this.m.background.getLeftWidth() + this.m.background.getRightWidth();
            }
            this.n.set(this.q.getFont().getWrappedBounds(this.o, f));
            return;
        }
        this.n.set(this.q.getFont().getMultiLineBounds(this.o));
    }

    @Override
    @BA.Hide
    public void layout() {
        StringBuilder stringBuilder;
        float f;
        BitmapFont bitmapFont = this.q.getFont();
        float f2 = bitmapFont.getScaleX();
        float f3 = bitmapFont.getScaleY();
        if (this.w != 1.0f || this.x != 1.0f) {
            bitmapFont.getData().setScale(this.w, this.x);
        }
        if (this.v) {
            this.b();
        }
        if (this.t && (f = this.getPrefHeight()) != this.u) {
            this.u = f;
            this.invalidateHierarchy();
        }
        f = this.getWidth();
        float f4 = this.getHeight();
        if (this.y && f < this.n.width) {
            float f5 = bitmapFont.getBounds((CharSequence)"...").width;
            stringBuilder = this.p != null ? this.p : (this.p = new StringBuilder());
            stringBuilder.setLength(0);
            if (f > f5) {
                stringBuilder.append(this.o, 0, bitmapFont.computeVisibleGlyphs(this.o, 0, this.o.length(), f - f5));
                stringBuilder.append("...");
            }
        } else {
            stringBuilder = this.o;
        }
        Drawable drawable = this.m.background;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (drawable != null) {
            f6 = drawable.getLeftWidth();
            f7 = drawable.getBottomHeight();
            f -= drawable.getLeftWidth() + drawable.getRightWidth();
            f4 -= drawable.getBottomHeight() + drawable.getTopHeight();
        }
        f7 = (this.r & 2) != 0 ? f7 + (this.q.getFont().isFlipped() ? 0.0f : f4 - this.n.height) + this.m.font.getDescent() : ((this.r & 4) != 0 ? f7 + (this.q.getFont().isFlipped() ? f4 - this.n.height : 0.0f) - this.m.font.getDescent() : (f7 += (float)((int)((f4 - this.n.height) / 2.0f))));
        if (!this.q.getFont().isFlipped()) {
            f7 += this.n.height;
        }
        if ((this.r & 8) == 0) {
            f6 = (this.r & 0x10) != 0 ? (f6 += f - this.n.width) : (f6 += (float)((int)((f - this.n.width) / 2.0f)));
        }
        this.q.setColor(Color.WHITE);
        if (this.t) {
            this.q.setWrappedText(stringBuilder, f6, f7, this.n.width, this.s);
        } else {
            this.q.setMultiLineText(stringBuilder, f6, f7, this.n.width, this.s);
        }
        if (this.w != 1.0f || this.x != 1.0f) {
            bitmapFont.getData().setScale(f2, f3);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = l.set(this.getColor());
        color.a *= parentAlpha;
        if (this.m.background != null) {
            batch.setColor(color.r, color.g, color.b, color.a);
            this.m.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.m.fontColor != null) {
            color.mul(this.m.fontColor);
        }
        this.q.tint(color);
        this.q.setPosition(this.getX(), this.getY());
        this.q.draw(batch);
    }

    @Override
    public float getPrefWidth() {
        if (this.t) {
            return 0.0f;
        }
        if (this.v) {
            this.a();
        }
        float f = this.n.width;
        Drawable drawable = this.m.background;
        if (drawable != null) {
            f += drawable.getLeftWidth() + drawable.getRightWidth();
        }
        return f;
    }

    @Override
    public float getPrefHeight() {
        if (this.v) {
            this.a();
        }
        float f = this.n.height - this.m.font.getDescent() * 2.0f;
        Drawable drawable = this.m.background;
        if (drawable != null) {
            f += drawable.getTopHeight() + drawable.getBottomHeight();
        }
        return f;
    }

    public lgBitmapFont.lgTextBounds getTextBounds() {
        if (this.v) {
            this.a();
        }
        return new lgBitmapFont.lgTextBounds(this.n);
    }

    public void setWrap(boolean wrap) {
        this.t = wrap;
        this.invalidateHierarchy();
    }

    public int getLabelAlign() {
        return this.r;
    }

    public int getLineAlign() {
        return this.s;
    }

    public void setAlignment(int alignment) {
        int n = alignment;
        this.setAlignment(n, n);
    }

    public void setAlignment(int labelAlign, int lineAlign) {
        this.r = labelAlign;
        this.s = (lineAlign & 8) != 0 ? 8 : ((lineAlign & 0x10) != 0 ? 16 : 1);
        this.invalidate();
    }

    public void setFontScale(float fontScale) {
        this.w = fontScale;
        this.x = fontScale;
        this.invalidateHierarchy();
    }

    public void setFontScale(float fontScaleX, float fontScaleY) {
        this.w = fontScaleX;
        this.x = fontScaleY;
        this.invalidateHierarchy();
    }

    public float getFontScaleX() {
        return this.w;
    }

    public void setFontScaleX(float fontScaleX) {
        this.w = fontScaleX;
        this.invalidateHierarchy();
    }

    public float getFontScaleY() {
        return this.x;
    }

    public void setFontScaleY(float fontScaleY) {
        this.x = fontScaleY;
        this.invalidateHierarchy();
    }

    public void setEllipsis(boolean ellipsis) {
        this.y = ellipsis;
    }

    protected BitmapFontCache getBitmapFontCache() {
        return this.q;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.o;
    }

    @BA.Hide
    public static class LabelStyle {
        @BA.Hide
        public BitmapFont font;
        public Color fontColor;
        public Drawable background;

        public LabelStyle() {
        }

        public LabelStyle(BitmapFont font, Color fontColor) {
            this.font = font;
            this.fontColor = fontColor;
        }

        public LabelStyle(LabelStyle style) {
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            this.background = style.background;
        }
    }
}

