/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class List
extends Widget
implements Cullable {
    private ListStyle o;
    String[] l;
    int m;
    private Rectangle p;
    private float q;
    private float r;
    float n;
    private float s;
    private float t;
    private boolean u = true;
    protected InputListener InputListnr;

    public List() {
    }

    public List(Object[] items, Skin skin) {
        this(items, skin.get(ListStyle.class));
    }

    public List(Object[] items, Skin skin, String styleName) {
        this(items, skin.get(styleName, ListStyle.class));
    }

    public List(Object[] items, ListStyle style) {
        this.Init(items, style);
    }

    protected void Init(Object[] items, ListStyle style) {
        this.setStyle(style);
        this.setItems(items);
        List list = this;
        list.setWidth(list.getPrefWidth());
        List list2 = this;
        list2.setHeight(list2.getPrefHeight());
        this.InputListnr = new InputListener(this){
            private /* synthetic */ List a;
            {
                this.a = list;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (!this.a.isSelectable()) {
                    return false;
                }
                List list = this.a;
                int n = list.m;
                list.m = (int)((list.getHeight() - y) / list.n);
                list.m = Math.max(0, list.m);
                list.m = Math.min(list.l.length - 1, list.m);
                if (n != list.m) {
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    if (list.fire(changeEvent)) {
                        list.m = n;
                    }
                    Pools.free(changeEvent);
                }
                return true;
            }
        };
        this.addListener(this.InputListnr);
    }

    public void setSelectable(boolean selectable) {
        this.u = selectable;
    }

    @BA.Hide
    public boolean isSelectable() {
        return this.u;
    }

    public void setStyle(ListStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.o = style;
        if (this.l != null) {
            List list = this;
            list.setItems(list.l);
            return;
        }
        this.invalidateHierarchy();
    }

    public ListStyle getStyle() {
        return this.o;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        BitmapFont bitmapFont = this.o.font;
        Drawable drawable = this.o.selection;
        Color color = this.o.fontColorSelected;
        Color color2 = this.o.fontColorUnselected;
        Color color3 = this.getColor();
        batch.setColor(color3.r, color3.g, color3.b, color3.a * parentAlpha);
        float f = this.getX();
        float f2 = this.getY();
        bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * parentAlpha);
        float f3 = this.getHeight();
        int n = 0;
        while (n < this.l.length) {
            if (this.p == null || f3 - this.n <= this.p.y + this.p.height && f3 >= this.p.y) {
                if (this.m == n) {
                    drawable.draw(batch, f, f2 + f3 - this.n, this.getWidth(), this.n);
                    bitmapFont.setColor(color.r, color.g, color.b, color.a * parentAlpha);
                }
                bitmapFont.draw(batch, this.l[n], f + this.s, f2 + f3 - this.t);
                if (this.m == n) {
                    bitmapFont.setColor(color2.r, color2.g, color2.b, color2.a * parentAlpha);
                }
            } else if (f3 < this.p.y) break;
            f3 -= this.n;
            ++n;
        }
    }

    public int getSelectedIndex() {
        return this.m;
    }

    public void setSelectedIndex(int index) {
        if (index < -1 || index >= this.l.length) {
            throw new GdxRuntimeException("index must be >= -1 and < " + this.l.length + ": " + index);
        }
        this.m = index;
    }

    public String getSelection() {
        if (this.l.length == 0 || this.m == -1) {
            return null;
        }
        return this.l[this.m];
    }

    @BA.Hide
    public int setSelection(String item) {
        this.m = -1;
        int n = 0;
        int n2 = this.l.length;
        while (n < n2) {
            if (this.l[n].equals(item)) {
                this.m = n;
                break;
            }
            ++n;
        }
        return this.m;
    }

    public void setItems(Object[] objects) {
        int n;
        Object object;
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            object = new String[objects.length];
            int n2 = 0;
            n = objects.length;
            while (n2 < n) {
                object[n2] = String.valueOf(objects[n2]);
                ++n2;
            }
            this.l = object;
        } else {
            this.l = (String[])objects;
        }
        this.m = 0;
        object = this.o.font;
        Drawable drawable = this.o.selection;
        this.n = ((BitmapFont)object).getCapHeight() - ((BitmapFont)object).getDescent() * 2.0f;
        this.n += drawable.getTopHeight() + drawable.getBottomHeight();
        this.s = drawable.getLeftWidth();
        this.t = drawable.getTopHeight() - ((BitmapFont)object).getDescent();
        this.q = 0.0f;
        n = 0;
        while (n < this.l.length) {
            BitmapFont.TextBounds textBounds = ((BitmapFont)object).getBounds(this.l[n]);
            this.q = Math.max(textBounds.width, this.q);
            ++n;
        }
        this.q += drawable.getLeftWidth() + drawable.getRightWidth();
        this.r = (float)this.l.length * this.n;
        this.invalidateHierarchy();
    }

    public String[] getItems() {
        return this.l;
    }

    public float getItemHeight() {
        return this.n;
    }

    public void setItemHeight(float Height) {
        this.t += (Height - this.n) / 2.0f;
        this.n = Height;
        this.r = (float)this.l.length * this.n;
        List list = this;
        list.setHeight(list.r);
        this.invalidateHierarchy();
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.q;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.r;
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.p = cullingArea;
    }

    @BA.Hide
    public static class ListStyle {
        @BA.Hide
        public BitmapFont font;
        public Color fontColorSelected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color fontColorUnselected = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable selection;

        public ListStyle() {
        }

        public ListStyle(BitmapFont font, Color fontColorSelected, Color fontColorUnselected, Drawable selection) {
            this.font = font;
            this.fontColorSelected.set(fontColorSelected);
            this.fontColorUnselected.set(fontColorUnselected);
            this.selection = selection;
        }

        public ListStyle(ListStyle style) {
            this.font = style.font;
            this.fontColorSelected.set(style.fontColorSelected);
            this.fontColorUnselected.set(style.fontColorUnselected);
            this.selection = style.selection;
        }
    }
}

