/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class ProgressBar
extends Widget
implements Disableable {
    private ProgressBarStyle p;
    private float q;
    private float r;
    private float s;
    private float t;
    private float u;
    float l;
    boolean m;
    private float v;
    private float w;
    private Interpolation x = Interpolation.linear;
    private float[] y;
    private float z;
    boolean n;
    boolean o;
    private Interpolation A = Interpolation.linear;

    public ProgressBar() {
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, ProgressBarStyle.class));
    }

    public ProgressBar(float min, float max, float stepSize, boolean vertical, ProgressBarStyle style) {
        this.Init(min, max, stepSize, vertical, style);
    }

    protected void Init(float min, float max, float stepSize, boolean vertical, ProgressBarStyle style) {
        if (min > max) {
            throw new IllegalArgumentException("max must be > min. min,max: " + min + ", " + max);
        }
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("stepSize must be > 0: ".concat(String.valueOf(stepSize)));
        }
        this.setStyle(style);
        this.q = min;
        this.r = max;
        this.s = stepSize;
        this.m = vertical;
        this.t = min;
        ProgressBar progressBar = this;
        progressBar.setSize(progressBar.getPrefWidth(), this.getPrefHeight());
    }

    public void setStyle(ProgressBarStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.p = style;
        this.invalidateHierarchy();
    }

    public ProgressBarStyle getStyle() {
        return this.p;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.w > 0.0f) {
            this.w -= delta;
            Stage stage = this.getStage();
            if (stage != null && stage.getActionsRequestRendering()) {
                Gdx.graphics.requestRendering();
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        ProgressBarStyle progressBarStyle = this.p;
        boolean bl = this.n;
        Drawable drawable = this.getKnobDrawable();
        Drawable drawable2 = bl && progressBarStyle.disabledBackground != null ? progressBarStyle.disabledBackground : progressBarStyle.background;
        Drawable drawable3 = bl && progressBarStyle.disabledKnobBefore != null ? progressBarStyle.disabledKnobBefore : progressBarStyle.knobBefore;
        Drawable drawable4 = bl && progressBarStyle.disabledKnobAfter != null ? progressBarStyle.disabledKnobAfter : progressBarStyle.knobAfter;
        Color color = this.getColor();
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        float f5 = drawable == null ? 0.0f : drawable.getMinHeight();
        float f6 = drawable == null ? 0.0f : drawable.getMinWidth();
        float f7 = this.getVisualPercent();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.m) {
            float f8 = f4;
            float f9 = 0.0f;
            if (drawable2 != null) {
                drawable2.draw(batch, f + (float)((int)((f3 - drawable2.getMinWidth()) * 0.5f)), f2, drawable2.getMinWidth(), f4);
                f9 = drawable2.getTopHeight();
                f8 -= f9 + drawable2.getBottomHeight();
            }
            float f10 = 0.0f;
            if (this.q != this.r) {
                if (drawable == null) {
                    f10 = drawable3 == null ? 0.0f : drawable3.getMinHeight() * 0.5f;
                    this.l = (f8 - f10) * f7;
                    this.l = Math.min(f8 - f10, this.l);
                } else {
                    f10 = f5 * 0.5f;
                    this.l = (f8 - f5) * f7;
                    this.l = Math.min(f8 - f5, this.l) + drawable2.getBottomHeight();
                }
                this.l = Math.max(0.0f, this.l);
            }
            if (drawable3 != null) {
                float f11 = 0.0f;
                if (drawable2 != null) {
                    f11 = f9;
                }
                drawable3.draw(batch, f + (float)((int)((f3 - drawable3.getMinWidth()) * 0.5f)), f2 + f11, drawable3.getMinWidth(), (int)(this.l + f10));
            }
            if (drawable4 != null) {
                drawable4.draw(batch, f + (float)((int)((f3 - drawable4.getMinWidth()) * 0.5f)), f2 + (float)((int)(this.l + f10)), drawable4.getMinWidth(), f4 - (float)((int)(this.l + f10)));
            }
            if (drawable != null) {
                drawable.draw(batch, f + (float)((int)((f3 - f6) * 0.5f)), (int)(f2 + this.l), f6, f5);
                return;
            }
        } else {
            float f12 = f3;
            float f13 = 0.0f;
            if (drawable2 != null) {
                drawable2.draw(batch, f, f2 + (float)((int)((f4 - drawable2.getMinHeight()) * 0.5f)), f3, drawable2.getMinHeight());
                f13 = drawable2.getLeftWidth();
                f12 -= f13 + drawable2.getRightWidth();
            }
            float f14 = 0.0f;
            if (this.q != this.r) {
                if (drawable == null) {
                    f14 = drawable3 == null ? 0.0f : drawable3.getMinWidth() * 0.5f;
                    this.l = (f12 - f14) * f7;
                    this.l = Math.min(f12 - f14, this.l);
                } else {
                    f14 = f6 * 0.5f;
                    this.l = (f12 - f6) * f7;
                    this.l = Math.min(f12 - f6, this.l) + f13;
                }
                this.l = Math.max(0.0f, this.l);
            }
            if (drawable3 != null) {
                float f15 = 0.0f;
                if (drawable2 != null) {
                    f15 = f13;
                }
                drawable3.draw(batch, f + f15, f2 + (float)((int)((f4 - drawable3.getMinHeight()) * 0.5f)), (int)(this.l + f14), drawable3.getMinHeight());
            }
            if (drawable4 != null) {
                drawable4.draw(batch, f + (float)((int)(this.l + f14)), f2 + (float)((int)((f4 - drawable4.getMinHeight()) * 0.5f)), f3 - (float)((int)(this.l + f14)), drawable4.getMinHeight());
            }
            if (drawable != null) {
                drawable.draw(batch, (int)(f + this.l), (int)(f2 + (f4 - f5) * 0.5f), f6, f5);
            }
        }
    }

    public float getValue() {
        return this.t;
    }

    public float getVisualValue() {
        if (this.w > 0.0f) {
            return this.x.apply(this.u, this.t, 1.0f - this.w / this.v);
        }
        return this.t;
    }

    public float getPercent() {
        return (this.t - this.q) / (this.r - this.q);
    }

    public float getVisualPercent() {
        return this.A.apply((this.getVisualValue() - this.q) / (this.r - this.q));
    }

    protected Drawable getKnobDrawable() {
        if (this.n && this.p.disabledKnob != null) {
            return this.p.disabledKnob;
        }
        return this.p.knob;
    }

    protected float getKnobPosition() {
        return this.l;
    }

    protected boolean setValue2(float value) {
        float f;
        block9: {
            value = this.clamp((float)Math.round(value / this.s) * this.s);
            if (!this.o || !Gdx.input.isKeyPressed(59) && !Gdx.input.isKeyPressed(60)) {
                float f2;
                ProgressBar progressBar = this;
                if (progressBar.y == null) {
                    f2 = value;
                } else {
                    int n = 0;
                    while (n < progressBar.y.length) {
                        if (Math.abs(value - progressBar.y[n]) <= progressBar.z) {
                            f2 = progressBar.y[n];
                            break block9;
                        }
                        ++n;
                    }
                    f2 = value = value;
                }
            }
        }
        if (value == (f = this.t)) {
            return false;
        }
        float f3 = this.getVisualValue();
        this.t = value;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean bl = this.fire(changeEvent);
        if (bl) {
            this.t = f;
        } else if (this.v > 0.0f) {
            this.u = f3;
            this.w = this.v;
        }
        Pools.free(changeEvent);
        return !bl;
    }

    protected float clamp(float value) {
        return MathUtils.clamp(value, this.q, this.r);
    }

    public void setRange(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min must be <= max");
        }
        this.q = min;
        this.r = max;
        if (this.t < min) {
            this.setValue2(min);
            return;
        }
        if (this.t > max) {
            this.setValue2(max);
        }
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: ".concat(String.valueOf(stepSize)));
        }
        this.s = stepSize;
    }

    @Override
    public float getPrefWidth() {
        if (this.m) {
            Drawable drawable = this.getKnobDrawable();
            Drawable drawable2 = this.n && this.p.disabledBackground != null ? this.p.disabledBackground : this.p.background;
            return Math.max(drawable == null ? 0.0f : drawable.getMinWidth(), drawable2.getMinWidth());
        }
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.m) {
            return 140.0f;
        }
        Drawable drawable = this.getKnobDrawable();
        Drawable drawable2 = this.n && this.p.disabledBackground != null ? this.p.disabledBackground : this.p.background;
        return Math.max(drawable == null ? 0.0f : drawable.getMinHeight(), drawable2 == null ? 0.0f : drawable2.getMinHeight());
    }

    public float getMinValue() {
        return this.q;
    }

    public float getMaxValue() {
        return this.r;
    }

    public float getStepSize() {
        return this.s;
    }

    public void setAnimateDuration(float duration) {
        this.v = duration;
    }

    public void setAnimateInterpolation(Interpolation animateInterpolation) {
        if (animateInterpolation == null) {
            throw new IllegalArgumentException("animateInterpolation cannot be null.");
        }
        this.x = animateInterpolation;
    }

    public void setVisualInterpolation(Interpolation interpolation) {
        this.A = interpolation;
    }

    public void setSnapToValues(float[] values, float threshold) {
        this.y = values;
        this.z = threshold;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.n = disabled;
    }

    public boolean getDisabled() {
        return this.n;
    }

    @Override
    @BA.Hide
    public boolean isDisabled() {
        return this.n;
    }

    @BA.Hide
    public static class ProgressBarStyle {
        public Drawable background;
        public Drawable disabledBackground;
        public Drawable knob;
        public Drawable disabledKnob;
        public Drawable knobBefore;
        public Drawable knobAfter;
        public Drawable disabledKnobBefore;
        public Drawable disabledKnobAfter;

        public ProgressBarStyle() {
        }

        public ProgressBarStyle(Drawable background, Drawable knob) {
            this.background = background;
            this.knob = knob;
        }

        public ProgressBarStyle(ProgressBarStyle style) {
            this.background = style.background;
            this.disabledBackground = style.disabledBackground;
            this.knob = style.knob;
            this.disabledKnob = style.disabledKnob;
            this.knobBefore = style.knobBefore;
            this.knobAfter = style.knobAfter;
            this.disabledKnobBefore = style.disabledKnobBefore;
            this.disabledKnobAfter = style.disabledKnobAfter;
        }
    }
}

