/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;

@BA.Hide
public class ScrollPane
extends WidgetGroup {
    private ScrollPaneStyle F;
    private Actor G;
    final Rectangle m = new Rectangle();
    final Rectangle n = new Rectangle();
    final Rectangle o = new Rectangle();
    final Rectangle p = new Rectangle();
    private final Rectangle H = new Rectangle();
    private final Rectangle I = new Rectangle();
    private final Rectangle J = new Rectangle();
    protected ActorGestureListener flickScrollListener;
    boolean q;
    boolean r;
    private boolean K = true;
    private boolean L = true;
    float s;
    float t;
    private float M;
    private float N;
    private float O;
    private float P;
    boolean u;
    boolean v;
    final Vector2 w = new Vector2();
    float x;
    float y;
    private boolean Q = true;
    private boolean R = true;
    float z;
    private float S = 1.0f;
    private float T;
    private float U = 1.0f;
    private boolean V = true;
    protected boolean disabled = false;
    protected boolean flickScroll = true;
    float A;
    float B;
    float C;
    private boolean W = true;
    private boolean X = true;
    float D = 1.0f;
    private float Y = 50.0f;
    private float Z = 30.0f;
    private float aa = 200.0f;
    private boolean ab;
    private boolean ac;
    private boolean ad;
    private boolean ae;
    private boolean af = true;
    private boolean ag;
    private boolean ah = true;
    int E = -1;
    protected InputListener InputListnr;

    public ScrollPane() {
    }

    public ScrollPane(Actor widget) {
        this(widget, new ScrollPaneStyle());
    }

    public ScrollPane(Actor widget, Skin skin) {
        this(widget, skin.get(ScrollPaneStyle.class));
    }

    public ScrollPane(Actor widget, Skin skin, String styleName) {
        this(widget, skin.get(styleName, ScrollPaneStyle.class));
    }

    public ScrollPane(Actor widget, ScrollPaneStyle style) {
        this.Init(widget, style);
    }

    protected void Init(Actor widget, ScrollPaneStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.F = style;
        this.setWidget(widget);
        this.setSize(150.0f, 150.0f);
        this.InputListnr = new InputListener(this){
            private float a;
            private /* synthetic */ ScrollPane b;
            {
                this.b = scrollPane;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (this.b.disabled) {
                    return false;
                }
                if (this.b.E != -1) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                this.b.getStage().setScrollFocus(this.b);
                if (!this.b.flickScroll) {
                    this.b.a();
                }
                if (this.b.z == 0.0f) {
                    return false;
                }
                if (this.b.q && this.b.m.contains(x, y)) {
                    event.stop();
                    this.b.a();
                    if (this.b.o.contains(x, y)) {
                        this.b.w.set(x, y);
                        this.a = this.b.o.x;
                        this.b.u = true;
                        this.b.E = pointer;
                        return true;
                    }
                    this.b.setScrollX(this.b.s + this.b.x * (float)(x < this.b.o.x ? -1 : 1));
                    return true;
                }
                if (this.b.r && this.b.n.contains(x, y)) {
                    event.stop();
                    this.b.a();
                    if (this.b.p.contains(x, y)) {
                        this.b.w.set(x, y);
                        this.a = this.b.p.y;
                        this.b.v = true;
                        this.b.E = pointer;
                        return true;
                    }
                    this.b.setScrollY(this.b.t + this.b.y * (float)(y < this.b.p.y ? 1 : -1));
                    return true;
                }
                return false;
            }

            @Override
            public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != this.b.E) {
                    return;
                }
                this.b.cancel();
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (pointer != this.b.E) {
                    return;
                }
                if (this.b.u) {
                    float f;
                    float f2 = x - this.b.w.x;
                    this.a = f = this.a + f2;
                    f = Math.max(this.b.m.x, f);
                    f = Math.min(this.b.m.x + this.b.m.width - this.b.o.width, f);
                    float f3 = this.b.m.width - this.b.o.width;
                    if (f3 != 0.0f) {
                        this.b.setScrollPercentX((f - this.b.m.x) / f3);
                    }
                    this.b.w.set(x, y);
                    return;
                }
                if (this.b.v) {
                    float f;
                    float f4 = y - this.b.w.y;
                    this.a = f = this.a + f4;
                    f = Math.max(this.b.n.y, f);
                    f = Math.min(this.b.n.y + this.b.n.height - this.b.p.height, f);
                    float f5 = this.b.n.height - this.b.p.height;
                    if (f5 != 0.0f) {
                        this.b.setScrollPercentY(1.0f - (f - this.b.n.y) / f5);
                    }
                    this.b.w.set(x, y);
                }
            }
        };
        this.addCaptureListener(this.InputListnr);
        this.flickScrollListener = new ActorGestureListener(this){
            private /* synthetic */ ScrollPane e;
            {
                this.e = scrollPane;
            }

            @Override
            public final void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                this.e.a();
                this.e.s -= deltaX;
                this.e.t += deltaY;
                this.e.c();
                this.e.b();
            }

            @Override
            public final void fling(InputEvent event, float x, float y, int button) {
                if (Math.abs(x) > 150.0f) {
                    this.e.C = this.e.D;
                    this.e.A = x;
                    this.e.b();
                }
                if (Math.abs(y) > 150.0f) {
                    this.e.C = this.e.D;
                    this.e.B = -y;
                    this.e.b();
                }
            }

            @Override
            public final boolean handle(Event event) {
                if (super.handle(event)) {
                    if (((InputEvent)event).getType() == InputEvent.Type.touchDown) {
                        this.e.C = 0.0f;
                    }
                    return true;
                }
                return false;
            }
        };
        ScrollPane scrollPane = this;
        scrollPane.addListener(scrollPane.flickScrollListener);
    }

    final void a() {
        this.z = this.S;
        this.T = this.U;
    }

    final void b() {
        if (!this.V) {
            return;
        }
        Stage stage = this.getStage();
        if (stage != null) {
            stage.cancelTouchFocusExcept(this.flickScrollListener, this);
        }
    }

    public void cancel() {
        this.E = -1;
        this.u = false;
        this.v = false;
        this.flickScrollListener.getGestureDetector().cancel();
    }

    final void c() {
        if (!this.af) {
            return;
        }
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.W ? MathUtils.clamp(this.s, -this.Y, this.O + this.Y) : MathUtils.clamp(this.s, 0.0f, this.O));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(scrollPane2.X ? MathUtils.clamp(this.t, -this.Y, this.P + this.Y) : MathUtils.clamp(this.t, 0.0f, this.P));
    }

    public void setStyle(ScrollPaneStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.F = style;
        this.invalidateHierarchy();
    }

    public ScrollPaneStyle getStyle() {
        return this.F;
    }

    @Override
    public void act(float delta) {
        Stage stage;
        super.act(delta);
        boolean bl = this.flickScrollListener.getGestureDetector().isPanning();
        boolean bl2 = false;
        if (this.z > 0.0f && this.Q && !bl && !this.u && !this.v) {
            this.T -= delta;
            if (this.T <= 0.0f) {
                this.z = Math.max(0.0f, this.z - delta);
            }
            bl2 = true;
        }
        if (this.C > 0.0f) {
            this.a();
            float f = this.C / this.D;
            this.s -= this.A * f * delta;
            this.t -= this.B * f * delta;
            this.c();
            if (this.s == -this.Y) {
                this.A = 0.0f;
            }
            if (this.s >= this.O + this.Y) {
                this.A = 0.0f;
            }
            if (this.t == -this.Y) {
                this.B = 0.0f;
            }
            if (this.t >= this.P + this.Y) {
                this.B = 0.0f;
            }
            this.C -= delta;
            if (this.C <= 0.0f) {
                this.A = 0.0f;
                this.B = 0.0f;
            }
            bl2 = true;
        }
        if (this.R && this.C <= 0.0f && !bl && (!this.u || this.q && this.O / (this.m.width - this.o.width) > this.x * 0.1f) && (!this.v || this.r && this.P / (this.n.height - this.p.height) > this.y * 0.1f)) {
            if (this.M != this.s) {
                if (this.M < this.s) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.min(scrollPane.s, this.M + Math.max(200.0f * delta, (this.s - this.M) * 7.0f * delta)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollX(Math.max(scrollPane.s, this.M - Math.max(200.0f * delta, (this.M - this.s) * 7.0f * delta)));
                }
                bl2 = true;
            }
            if (this.N != this.t) {
                if (this.N < this.t) {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.min(scrollPane.t, this.N + Math.max(200.0f * delta, (this.t - this.N) * 7.0f * delta)));
                } else {
                    ScrollPane scrollPane = this;
                    scrollPane.visualScrollY(Math.max(scrollPane.t, this.N - Math.max(200.0f * delta, (this.N - this.t) * 7.0f * delta)));
                }
                bl2 = true;
            }
        } else {
            if (this.M != this.s) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollX(scrollPane.s);
            }
            if (this.N != this.t) {
                ScrollPane scrollPane = this;
                scrollPane.visualScrollY(scrollPane.t);
            }
        }
        if (!bl) {
            if (this.W && this.q) {
                if (this.s < 0.0f) {
                    this.a();
                    this.s += (this.Z + (this.aa - this.Z) * -this.s / this.Y) * delta;
                    if (this.s > 0.0f) {
                        this.scrollX(0.0f);
                    }
                    bl2 = true;
                } else if (this.s > this.O) {
                    this.a();
                    this.s -= (this.Z + (this.aa - this.Z) * -(this.O - this.s) / this.Y) * delta;
                    if (this.s < this.O) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollX(scrollPane.O);
                    }
                    bl2 = true;
                }
            }
            if (this.X && this.r) {
                if (this.t < 0.0f) {
                    this.a();
                    this.t += (this.Z + (this.aa - this.Z) * -this.t / this.Y) * delta;
                    if (this.t > 0.0f) {
                        this.scrollY(0.0f);
                    }
                    bl2 = true;
                } else if (this.t > this.P) {
                    this.a();
                    this.t -= (this.Z + (this.aa - this.Z) * -(this.P - this.t) / this.Y) * delta;
                    if (this.t < this.P) {
                        ScrollPane scrollPane = this;
                        scrollPane.scrollY(scrollPane.P);
                    }
                    bl2 = true;
                }
            }
        }
        if (bl2 && (stage = this.getStage()) != null && stage.getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    @BA.Hide
    public void layout() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        Drawable drawable = this.F.background;
        Drawable drawable2 = this.F.hScrollKnob;
        Drawable drawable3 = this.F.vScrollKnob;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (drawable != null) {
            f6 = drawable.getLeftWidth();
            f7 = drawable.getRightWidth();
            f8 = drawable.getTopHeight();
            f9 = drawable.getBottomHeight();
        }
        float f10 = this.getWidth();
        float f11 = this.getHeight();
        float f12 = 0.0f;
        if (drawable2 != null) {
            f12 = drawable2.getMinHeight();
        }
        if (this.F.hScroll != null) {
            f12 = Math.max(f12, this.F.hScroll.getMinHeight());
        }
        float f13 = 0.0f;
        if (drawable3 != null) {
            f13 = drawable3.getMinWidth();
        }
        if (this.F.vScroll != null) {
            f13 = Math.max(f13, this.F.vScroll.getMinWidth());
        }
        this.x = f10 - f6 - f7;
        this.y = f11 - f8 - f9;
        if (this.G == null) {
            return;
        }
        if (this.G instanceof Layout) {
            Layout layout = (Layout)((Object)this.G);
            f5 = layout.getPrefWidth();
            f4 = layout.getPrefHeight();
        } else {
            f5 = this.G.getWidth();
            f4 = this.G.getHeight();
        }
        this.q = this.ab || f5 > this.x && !this.ad;
        this.r = this.ac || f4 > this.y && !this.ae;
        boolean bl = this.Q;
        if (!bl) {
            if (this.r) {
                this.x -= f13;
                if (!this.q && f5 > this.x && !this.ad) {
                    this.q = true;
                }
            }
            if (this.q) {
                this.y -= f12;
                if (!this.r && f4 > this.y && !this.ae) {
                    this.r = true;
                    this.x -= f13;
                }
            }
        }
        this.H.Set(f6, f9, this.x, this.y);
        if (bl) {
            if (this.q && this.r) {
                this.y -= f12;
                this.x -= f13;
            }
        } else if (this.ag) {
            if (this.q) {
                this.H.height += f12;
            }
            if (this.r) {
                this.H.width += f13;
            }
        } else {
            if (this.q && this.L) {
                this.H.y += f12;
            }
            if (this.r && !this.K) {
                this.H.x += f13;
            }
        }
        f5 = this.ad ? this.x : Math.max(this.x, f5);
        f4 = this.ae ? this.y : Math.max(this.y, f4);
        this.O = f5 - this.x;
        this.P = f4 - this.y;
        if (bl && this.q && this.r) {
            this.P -= f12;
            this.O -= f13;
        }
        ScrollPane scrollPane = this;
        scrollPane.scrollX(MathUtils.clamp(scrollPane.s, 0.0f, this.O));
        ScrollPane scrollPane2 = this;
        scrollPane2.scrollY(MathUtils.clamp(scrollPane2.t, 0.0f, this.P));
        if (this.q) {
            if (drawable2 != null) {
                f3 = this.F.hScroll != null ? this.F.hScroll.getMinHeight() : drawable2.getMinHeight();
                f2 = this.K ? f6 : f6 + f13;
                f = this.L ? f9 : f11 - f8 - f3;
                this.m.Set(f2, f, this.x, f3);
                this.o.width = this.ah ? Math.max(drawable2.getMinWidth(), (float)((int)(this.m.width * this.x / f5))) : drawable2.getMinWidth();
                this.o.height = drawable2.getMinHeight();
                this.o.x = this.m.x + (float)((int)((this.m.width - this.o.width) * this.getScrollPercentX()));
                this.o.y = this.m.y;
            } else {
                this.m.Set(0.0f, 0.0f, 0.0f, 0.0f);
                this.o.Set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.r) {
            if (drawable3 != null) {
                f3 = this.F.vScroll != null ? this.F.vScroll.getMinWidth() : drawable3.getMinWidth();
                f = this.L ? f11 - f8 - this.y : f9;
                f2 = this.K ? f10 - f7 - f3 : f6;
                this.n.Set(f2, f, f3, this.y);
                this.p.width = drawable3.getMinWidth();
                this.p.height = this.ah ? Math.max(drawable3.getMinHeight(), (float)((int)(this.n.height * this.y / f4))) : drawable3.getMinHeight();
                this.p.x = this.K ? f10 - f7 - drawable3.getMinWidth() : f6;
                this.p.y = this.n.y + (float)((int)((this.n.height - this.p.height) * (1.0f - this.getScrollPercentY())));
            } else {
                this.n.Set(0.0f, 0.0f, 0.0f, 0.0f);
                this.p.Set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        this.G.setSize(f5, f4);
        if (this.G instanceof Layout) {
            ((Layout)((Object)this.G)).validate();
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.G == null || this.getStage() == null) {
            return;
        }
        this.validate();
        this.applyTransform(batch, this.computeTransform());
        if (this.q) {
            this.o.x = this.m.x + (float)((int)((this.m.width - this.o.width) * this.getVisualScrollPercentX()));
        }
        if (this.r) {
            this.p.y = this.n.y + (float)((int)((this.n.height - this.p.height) * (1.0f - this.getVisualScrollPercentY())));
        }
        float f = this.H.y;
        f = !this.r ? (f -= (float)((int)this.P)) : (f -= (float)((int)(this.P - this.N)));
        float f2 = this.H.x;
        if (this.q) {
            f2 -= (float)((int)this.M);
        }
        if (!this.Q && this.ag) {
            float f3;
            if (this.q && this.L) {
                f3 = 0.0f;
                if (this.F.hScrollKnob != null) {
                    f3 = this.F.hScrollKnob.getMinHeight();
                }
                if (this.F.hScroll != null) {
                    f3 = Math.max(f3, this.F.hScroll.getMinHeight());
                }
                f += f3;
            }
            if (this.r && !this.K) {
                f3 = 0.0f;
                if (this.F.hScrollKnob != null) {
                    f3 = this.F.hScrollKnob.getMinWidth();
                }
                if (this.F.hScroll != null) {
                    f3 = Math.max(f3, this.F.hScroll.getMinWidth());
                }
                f2 += f3;
            }
        }
        this.G.setPosition(f2, f);
        if (this.G instanceof Cullable) {
            this.I.x = -this.G.getX() + this.H.x;
            this.I.y = -this.G.getY() + this.H.y;
            this.I.width = this.H.width;
            this.I.height = this.H.height;
            ((Cullable)((Object)this.G)).setCullingArea(this.I);
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.F.background != null) {
            this.F.background.draw(batch, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        this.getStage().calculateScissors(this.H, this.J);
        batch.flush();
        if (ScissorStack.pushScissors(this.J)) {
            this.drawChildren(batch, parentAlpha);
            batch.flush();
            ScissorStack.popScissors();
        }
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha * Interpolation.fade.apply(this.z / this.S));
        if (this.q && this.r && this.F.corner != null) {
            this.F.corner.draw(batch, this.m.x + this.m.width, this.m.y, this.n.width, this.n.y);
        }
        if (this.q) {
            if (this.F.hScroll != null) {
                this.F.hScroll.draw(batch, this.m.x, this.m.y, this.m.width, this.m.height);
            }
            if (this.F.hScrollKnob != null) {
                this.F.hScrollKnob.draw(batch, this.o.x, this.o.y, this.o.width, this.o.height);
            }
        }
        if (this.r) {
            if (this.F.vScroll != null) {
                this.F.vScroll.draw(batch, this.n.x, this.n.y, this.n.width, this.n.height);
            }
            if (this.F.vScrollKnob != null) {
                this.F.vScrollKnob.draw(batch, this.p.x, this.p.y, this.p.width, this.p.height);
            }
        }
        this.resetTransform(batch);
    }

    public void fling(float flingTime, float velocityX, float velocityY) {
        this.C = flingTime;
        this.A = velocityX;
        this.B = velocityY;
    }

    @Override
    public float getPrefWidth() {
        if (this.G instanceof Layout) {
            float f = ((Layout)((Object)this.G)).getPrefWidth();
            if (this.F.background != null) {
                f += this.F.background.getLeftWidth() + this.F.background.getRightWidth();
            }
            if (this.ac) {
                float f2 = 0.0f;
                if (this.F.vScrollKnob != null) {
                    f2 = this.F.vScrollKnob.getMinWidth();
                }
                if (this.F.vScroll != null) {
                    f2 = Math.max(f2, this.F.vScroll.getMinWidth());
                }
                f += f2;
            }
            return f;
        }
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.G instanceof Layout) {
            float f = ((Layout)((Object)this.G)).getPrefHeight();
            if (this.F.background != null) {
                f += this.F.background.getTopHeight() + this.F.background.getBottomHeight();
            }
            if (this.ab) {
                float f2 = 0.0f;
                if (this.F.hScrollKnob != null) {
                    f2 = this.F.hScrollKnob.getMinHeight();
                }
                if (this.F.hScroll != null) {
                    f2 = Math.max(f2, this.F.hScroll.getMinHeight());
                }
                f += f2;
            }
            return f;
        }
        return 150.0f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setWidget(Actor widget) {
        if (widget == this) {
            throw new IllegalArgumentException("widget cannot be the ScrollPane.");
        }
        if (this.G != null) {
            ScrollPane scrollPane = this;
            super.removeActor(scrollPane.G);
        }
        this.G = widget;
        if (widget != null) {
            super.addActor(widget);
        }
    }

    @BA.Hide
    public Actor getWidget() {
        return this.G;
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public void addActorAfter(Actor actorAfter, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor != this.G) {
            return false;
        }
        this.setWidget(null);
        return true;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (x < 0.0f || x >= this.getWidth() || y < 0.0f || y >= this.getHeight()) {
            return null;
        }
        if (this.q && this.m.contains(x, y)) {
            return this;
        }
        if (this.r && this.n.contains(x, y)) {
            return this;
        }
        return super.hit(x, y, touchable);
    }

    protected void scrollX(float pixelsX) {
        this.s = pixelsX;
    }

    protected void scrollY(float pixelsY) {
        this.t = pixelsY;
    }

    protected void visualScrollX(float pixelsX) {
        this.M = pixelsX;
    }

    protected void visualScrollY(float pixelsY) {
        this.N = pixelsY;
    }

    public void setScrollX(float pixels) {
        this.scrollX(MathUtils.clamp(pixels, 0.0f, this.O));
    }

    public float getScrollX() {
        return this.s;
    }

    public void setScrollY(float pixels) {
        this.scrollY(MathUtils.clamp(pixels, 0.0f, this.P));
    }

    public float getScrollY() {
        return this.t;
    }

    public void updateVisualScroll() {
        this.M = this.s;
        this.N = this.t;
    }

    public float getVisualScrollX() {
        if (!this.q) {
            return 0.0f;
        }
        return this.M;
    }

    public float getVisualScrollY() {
        if (!this.r) {
            return 0.0f;
        }
        return this.N;
    }

    public float getVisualScrollPercentX() {
        return MathUtils.clamp(this.M / this.O, 0.0f, 1.0f);
    }

    public float getVisualScrollPercentY() {
        return MathUtils.clamp(this.N / this.P, 0.0f, 1.0f);
    }

    public float getScrollPercentX() {
        return MathUtils.clamp(this.s / this.O, 0.0f, 1.0f);
    }

    public void setScrollPercentX(float percentX) {
        ScrollPane scrollPane = this;
        scrollPane.scrollX(scrollPane.O * MathUtils.clamp(percentX, 0.0f, 1.0f));
    }

    public float getScrollPercentY() {
        return MathUtils.clamp(this.t / this.P, 0.0f, 1.0f);
    }

    public void setScrollPercentY(float percentY) {
        ScrollPane scrollPane = this;
        scrollPane.scrollY(scrollPane.P * MathUtils.clamp(percentY, 0.0f, 1.0f));
    }

    public void setFlickScroll(boolean flickScroll) {
        if (this.flickScroll == flickScroll) {
            return;
        }
        this.flickScroll = flickScroll;
        if (!this.disabled) {
            if (flickScroll) {
                ScrollPane scrollPane = this;
                scrollPane.addListener(scrollPane.flickScrollListener);
            } else {
                ScrollPane scrollPane = this;
                scrollPane.removeListener(scrollPane.flickScrollListener);
            }
        }
        this.invalidate();
    }

    public void setFlickScrollTapSquareSize(float halfTapSquareSize) {
        this.flickScrollListener.getGestureDetector().setTapSquareSize(halfTapSquareSize);
    }

    public void scrollTo(float x, float y, float width, float height) {
        this.scrollTo(x, y, width, height, false, false);
    }

    public void scrollTo(float x, float y, float width, float height, boolean centerHorizontal, boolean centerVertical) {
        float f = this.s;
        if (centerHorizontal) {
            f = x - this.x / 2.0f + width / 2.0f;
        } else {
            if (x + width > f + this.x) {
                f = x + width - this.x;
            }
            if (x < f) {
                f = x;
            }
        }
        this.scrollX(MathUtils.clamp(f, 0.0f, this.O));
        float f2 = this.t;
        if (centerVertical) {
            f2 = this.P - y + this.y / 2.0f - height / 2.0f;
        } else {
            if (f2 > this.P - y - height + this.y) {
                f2 = this.P - y - height + this.y;
            }
            if (f2 < this.P - y) {
                f2 = this.P - y;
            }
        }
        this.scrollY(MathUtils.clamp(f2, 0.0f, this.P));
    }

    public float getMaxX() {
        return this.O;
    }

    public float getMaxY() {
        return this.P;
    }

    public float getScrollBarHeight() {
        if (!this.q) {
            return 0.0f;
        }
        float f = 0.0f;
        if (this.F.hScrollKnob != null) {
            f = this.F.hScrollKnob.getMinHeight();
        }
        if (this.F.hScroll != null) {
            f = Math.max(f, this.F.hScroll.getMinHeight());
        }
        return f;
    }

    public float getScrollBarWidth() {
        if (!this.r) {
            return 0.0f;
        }
        float f = 0.0f;
        if (this.F.vScrollKnob != null) {
            f = this.F.vScrollKnob.getMinWidth();
        }
        if (this.F.vScroll != null) {
            f = Math.max(f, this.F.vScroll.getMinWidth());
        }
        return f;
    }

    public float getScrollWidth() {
        return this.x;
    }

    public float getScrollHeight() {
        return this.y;
    }

    public boolean isScrollX() {
        return this.q;
    }

    public boolean isScrollY() {
        return this.r;
    }

    public void setScrollingDisabled(boolean x, boolean y) {
        this.ad = x;
        this.ae = y;
    }

    public boolean isLeftEdge() {
        return !this.q || this.s <= 0.0f;
    }

    public boolean isRightEdge() {
        return !this.q || this.s >= this.O;
    }

    public boolean isTopEdge() {
        return !this.r || this.t <= 0.0f;
    }

    public boolean isBottomEdge() {
        return !this.r || this.t >= this.P;
    }

    public boolean isDragging() {
        return this.E != -1;
    }

    public boolean isPanning() {
        return this.flickScrollListener.getGestureDetector().isPanning();
    }

    public boolean isFlinging() {
        return this.C > 0.0f;
    }

    public void setVelocityX(float velocityX) {
        this.A = velocityX;
    }

    public float getVelocityX() {
        if (this.C <= 0.0f) {
            return 0.0f;
        }
        float f = this.C / this.D;
        f = f * f * f;
        return this.A * f * f * f;
    }

    public void setVelocityY(float velocityY) {
        this.B = velocityY;
    }

    public float getVelocityY() {
        return this.B;
    }

    public void setOverscroll(boolean overscrollX, boolean overscrollY) {
        this.W = overscrollX;
        this.X = overscrollY;
    }

    public void setupOverscroll(float distance, float speedMin, float speedMax) {
        this.Y = distance;
        this.Z = speedMin;
        this.aa = speedMax;
    }

    public void setForceScroll(boolean x, boolean y) {
        this.ab = x;
        this.ac = y;
    }

    public boolean isForceScrollX() {
        return this.ab;
    }

    public boolean isForceScrollY() {
        return this.ac;
    }

    public void setFlingTime(float flingTime) {
        this.D = flingTime;
    }

    public void setClamp(boolean clamp) {
        this.af = clamp;
    }

    public void setScrollBarPositions(boolean bottom, boolean right) {
        this.L = bottom;
        this.K = right;
    }

    public void setFadeScrollBars(boolean fadeScrollBars) {
        if (this.Q == fadeScrollBars) {
            return;
        }
        this.Q = fadeScrollBars;
        if (!fadeScrollBars) {
            this.z = this.S;
        }
        this.invalidate();
    }

    public void setupFadeScrollBars(float fadeAlphaSeconds, float fadeDelaySeconds) {
        this.S = fadeAlphaSeconds;
        this.U = fadeDelaySeconds;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.R = smoothScrolling;
    }

    public void setScrollbarsOnTop(boolean scrollbarsOnTop) {
        this.ag = scrollbarsOnTop;
        this.invalidate();
    }

    public boolean getVariableSizeKnobs() {
        return this.ah;
    }

    public void setVariableSizeKnobs(boolean variableSizeKnobs) {
        this.ah = variableSizeKnobs;
    }

    public void setCancelTouchFocus(boolean cancelTouchFocus) {
        this.V = cancelTouchFocus;
    }

    @BA.Hide
    public static class ScrollPaneStyle {
        public Drawable background;
        public Drawable corner;
        public Drawable hScroll;
        public Drawable hScrollKnob;
        public Drawable vScroll;
        public Drawable vScrollKnob;

        public ScrollPaneStyle() {
        }

        public ScrollPaneStyle(Drawable background, Drawable hScroll, Drawable hScrollKnob, Drawable vScroll, Drawable vScrollKnob) {
            this.background = background;
            this.hScroll = hScroll;
            this.hScrollKnob = hScrollKnob;
            this.vScroll = vScroll;
            this.vScrollKnob = vScrollKnob;
        }

        public ScrollPaneStyle(ScrollPaneStyle style) {
            this.background = style.background;
            this.hScroll = style.hScroll;
            this.hScrollKnob = style.hScrollKnob;
            this.vScroll = style.vScroll;
            this.vScrollKnob = style.vScrollKnob;
        }
    }
}

