/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class SelectBox
extends Widget
implements Disableable {
    static final Vector2 l = new Vector2();
    SelectBoxStyle m;
    String[] n;
    int o = 0;
    private final BitmapFont.TextBounds s = new BitmapFont.TextBounds();
    a p;
    private float t;
    private float u;
    protected ClickListener clickListener;
    int q;
    boolean r;
    protected BA ba;

    public SelectBox() {
    }

    public SelectBox(Object[] items, Skin skin) {
        this(items, skin.get(SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, Skin skin, String styleName) {
        this(items, skin.get(styleName, SelectBoxStyle.class));
    }

    public SelectBox(Object[] items, SelectBoxStyle style) {
        this.Init(items, style);
    }

    protected void Init(Object[] items, SelectBoxStyle style) {
        this.setStyle(style);
        this.setItems(items);
        SelectBox selectBox = this;
        selectBox.setSize(selectBox.getPrefWidth(), this.getPrefHeight());
        this.clickListener = new ClickListener(this){
            private /* synthetic */ SelectBox a;
            {
                this.a = selectBox;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (this.a.r) {
                    return false;
                }
                Stage stage = this.a.getStage();
                if (this.a.p == null) {
                    this.a.p = this.a.new a();
                }
                Stage stage2 = stage;
                a a2 = this.a.p;
                stage2.addActor(a2);
                a2.SelectBox.this.localToStageCoordinates(l.set(0.0f, 0.0f));
                a2.G.set(l);
                a2.F.setItems(a2.SelectBox.this.n);
                a2.F.setSelectedIndex(a2.SelectBox.this.o);
                float f = a2.F.getItemHeight();
                float f2 = f * (float)(a2.SelectBox.this.q <= 0 ? a2.SelectBox.this.n.length : Math.min(a2.SelectBox.this.q, a2.SelectBox.this.n.length));
                Drawable drawable = a2.getStyle().background;
                if (drawable != null) {
                    f2 += drawable.getTopHeight() + drawable.getBottomHeight();
                }
                float f3 = SelectBox.l.y;
                float f4 = stage2.getCamera().viewportHeight - SelectBox.l.y - a2.SelectBox.this.getHeight();
                boolean bl = true;
                if (f2 > f3) {
                    if (f4 > f3) {
                        bl = false;
                        f2 = Math.min(f2, f4);
                    } else {
                        f2 = f3;
                    }
                }
                if (bl) {
                    a2.setY(SelectBox.l.y - f2);
                } else {
                    a2.setY(SelectBox.l.y + a2.SelectBox.this.getHeight());
                }
                a2.setX(SelectBox.l.x);
                a a3 = a2;
                a3.setWidth(a3.SelectBox.this.getWidth());
                a2.setHeight(f2);
                a2.scrollTo(0.0f, a2.F.getHeight() - (float)a2.SelectBox.this.o * f - f / 2.0f, 0.0f, 0.0f, true, true);
                a2.updateVisualScroll();
                a2.clearActions();
                a2.getColor().a = 0.0f;
                a2.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
                stage2.setScrollFocus(a2);
                return true;
            }
        };
        this.addListener(this.clickListener);
    }

    public void setMaxListCount(int maxListCount) {
        this.q = maxListCount;
    }

    public int getMaxListCount() {
        return this.q;
    }

    public void setStyle(SelectBoxStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.m = style;
        if (this.n != null) {
            SelectBox selectBox = this;
            selectBox.setItems(selectBox.n);
            return;
        }
        this.invalidateHierarchy();
    }

    public SelectBoxStyle getStyle() {
        return this.m;
    }

    public void setItems(Object[] objects) {
        Object object;
        if (objects == null) {
            throw new IllegalArgumentException("items cannot be null.");
        }
        if (!(objects instanceof String[])) {
            object = new String[objects.length];
            int n = 0;
            int n2 = objects.length;
            while (n < n2) {
                object[n] = String.valueOf(objects[n]);
                ++n;
            }
            objects = object;
        }
        this.n = (String[])objects;
        this.o = 0;
        object = this.m.background;
        BitmapFont bitmapFont = this.m.font;
        this.u = object != null ? Math.max(object.getTopHeight() + object.getBottomHeight() + bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f, object.getMinHeight()) : bitmapFont.getCapHeight() - bitmapFont.getDescent() * 2.0f;
        float f = 0.0f;
        int n = 0;
        while (n < this.n.length) {
            f = Math.max(bitmapFont.getBounds((CharSequence)this.n[n]).width, f);
            ++n;
        }
        this.t = f;
        if (object != null) {
            this.t += object.getLeftWidth() + object.getRightWidth();
        }
        List.ListStyle listStyle = this.m.listStyle;
        ScrollPane.ScrollPaneStyle scrollPaneStyle = this.m.scrollStyle;
        this.t = Math.max(this.t, f + (scrollPaneStyle.background == null ? 0.0f : scrollPaneStyle.background.getLeftWidth() + scrollPaneStyle.background.getRightWidth()) + listStyle.selection.getLeftWidth() + listStyle.selection.getRightWidth() + Math.max(this.m.scrollStyle.vScroll != null ? this.m.scrollStyle.vScroll.getMinWidth() : 0.0f, this.m.scrollStyle.vScrollKnob != null ? this.m.scrollStyle.vScrollKnob.getMinWidth() : 0.0f));
        if (this.n.length > 0) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            this.fire(changeEvent);
            Pools.free(changeEvent);
        }
        this.invalidateHierarchy();
    }

    public String[] getItems() {
        return this.n;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable drawable = this.r && this.m.backgroundDisabled != null ? this.m.backgroundDisabled : (this.p != null && this.p.hasParent() && this.m.backgroundOpen != null ? this.m.backgroundOpen : (this.clickListener.isOver() && this.m.backgroundOver != null ? this.m.backgroundOver : (this.m.background != null ? this.m.background : null)));
        BitmapFont bitmapFont = this.m.font;
        Color color = this.r && this.m.disabledFontColor != null ? this.m.disabledFontColor : this.m.fontColor;
        Color color2 = this.getColor();
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * parentAlpha);
        if (drawable != null) {
            drawable.draw(batch, f, f2, f3, f4);
        }
        if (this.n.length > 0) {
            String string = this.n[this.o];
            this.s.set(bitmapFont.getBounds(string));
            if (drawable != null) {
                f3 -= drawable.getLeftWidth() + drawable.getRightWidth();
                f += drawable.getLeftWidth();
                f2 += (float)((int)((f4 -= drawable.getBottomHeight() + drawable.getTopHeight()) / 2.0f + drawable.getBottomHeight() + this.s.height / 2.0f));
            } else {
                f2 += (float)((int)(f4 / 2.0f + this.s.height / 2.0f));
            }
            int n = bitmapFont.computeVisibleGlyphs(string, 0, string.length(), f3);
            bitmapFont.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            bitmapFont.draw(batch, string, f, f2, 0, n);
        }
    }

    @BA.Hide
    public void setSelection(int selection) {
        if (selection < 0) {
            throw new IllegalArgumentException("selection cannot be < 0.");
        }
        this.o = selection;
    }

    @BA.Hide
    public void setSelection(String item) {
        int n = 0;
        while (n < this.n.length) {
            if (this.n[n].equals(item)) {
                this.o = n;
            }
            ++n;
        }
    }

    @BA.Hide
    public int getSelectionIndex() {
        return this.o;
    }

    public String getSelection() {
        return this.n[this.o];
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled && !this.r) {
            this.hideList();
        }
        this.r = disabled;
    }

    public boolean getDisabled() {
        return this.r;
    }

    @Override
    @BA.Hide
    public boolean isDisabled() {
        return this.r;
    }

    @Override
    public float getPrefWidth() {
        return this.t;
    }

    @Override
    public float getPrefHeight() {
        return this.u;
    }

    public void hideList() {
        if (this.p == null || this.p.getParent() == null) {
            return;
        }
        this.p.addAction(Actions.sequence(Actions.fadeOut(0.15f, Interpolation.fade), Actions.removeActor()));
    }

    @BA.Hide
    public List getList() {
        if (this.p == null || this.p.getParent() == null) {
            return null;
        }
        return this.p.F;
    }

    final class a
    extends ScrollPane {
        final List F;
        final Vector2 G;

        public a() {
            super(null, SelectBox.this.m.scrollStyle);
            this.G = new Vector2();
            this.setOverscroll(false, false);
            this.setFadeScrollBars(false);
            this.F = new List();
            this.F.Initialize(SelectBox.this.ba, "");
            this.F.Init(new Object[0], SelectBox.this.m.listStyle);
            this.F.InputListnr.Initialize(SelectBox.this.ba, "");
            super.Initialize(SelectBox.this.ba, "");
            this.flickScrollListener.Initialize(SelectBox.this.ba, "");
            this.InputListnr.Initialize(SelectBox.this.ba, "");
            a a2 = this;
            a2.setWidget(a2.F);
            InputListener inputListener = new InputListener(this){
                private /* synthetic */ a a;
                {
                    this.a = a2;
                }

                @Override
                public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getTarget() == this.a.F) {
                        return true;
                    }
                    this.a.SelectBox.this.hideList();
                    return false;
                }

                @Override
                public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (this.a.hit(x, y, true) == this.a.F) {
                        this.a.SelectBox.this.setSelection(this.a.F.getSelectedIndex());
                        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                        this.a.SelectBox.this.fire(changeEvent);
                        Pools.free(changeEvent);
                        this.a.SelectBox.this.hideList();
                    }
                }
            };
            inputListener.Initialize(SelectBox.this.ba, "");
            this.addListener(inputListener);
        }

        @Override
        public final Actor hit(float x, float y, boolean touchable) {
            Actor actor = super.hit(x, y, touchable);
            if (actor != null) {
                return actor;
            }
            return this;
        }

        @Override
        public final void act(float delta) {
            super.act(delta);
            SelectBox.this.localToStageCoordinates(l.set(0.0f, 0.0f));
            if (SelectBox.l.x != this.G.x || SelectBox.l.y != this.G.y) {
                SelectBox.this.hideList();
            }
        }
    }

    @BA.Hide
    public static class SelectBoxStyle {
        @BA.Hide
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color disabledFontColor;
        public Drawable background;
        @BA.Hide
        public ScrollPane.ScrollPaneStyle scrollStyle;
        @BA.Hide
        public List.ListStyle listStyle;
        public Drawable backgroundOver;
        public Drawable backgroundOpen;
        public Drawable backgroundDisabled;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont font, Color fontColor, Drawable background, ScrollPane.ScrollPaneStyle scrollStyle, List.ListStyle listStyle) {
            this.font = font;
            this.fontColor.set(fontColor);
            this.background = background;
            this.scrollStyle = scrollStyle;
            this.listStyle = listStyle;
        }

        public SelectBoxStyle(SelectBoxStyle style) {
            this.font = style.font;
            this.fontColor.set(style.fontColor);
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.background = style.background;
            this.backgroundOver = style.backgroundOver;
            this.backgroundOpen = style.backgroundOpen;
            this.backgroundDisabled = style.backgroundDisabled;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(style.scrollStyle);
            this.listStyle = new List.ListStyle(style.listStyle);
        }
    }
}

