/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class Slider
extends ProgressBar {
    int p = -1;
    private Interpolation q = Interpolation.linear;

    public Slider() {
    }

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, SliderStyle style) {
        this.Init(min, max, stepSize, vertical, style);
    }

    protected void Init(float min, float max, float stepSize, boolean vertical, SliderStyle style) {
        super.Init(min, max, stepSize, vertical, style);
        this.o = true;
        InputListener inputListener = new InputListener(this){
            private /* synthetic */ Slider a;
            {
                this.a = slider;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (this.a.n) {
                    return false;
                }
                if (this.a.p != -1) {
                    return false;
                }
                this.a.p = pointer;
                this.a.a(x, y);
                return true;
            }

            @Override
            public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != this.a.p) {
                    return;
                }
                this.a.p = -1;
                if (!this.a.a(x, y)) {
                    ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                    this.a.fire(changeEvent);
                    Pools.free(changeEvent);
                }
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                this.a.a(x, y);
            }
        };
        inputListener.Initialize(this._ba, "");
        this.addListener(inputListener);
    }

    public void setStyle(SliderStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style instanceof SliderStyle)) {
            throw new IllegalArgumentException("style must be a SliderStyle.");
        }
        super.setStyle(style);
    }

    @Override
    public SliderStyle getStyle() {
        return (SliderStyle)super.getStyle();
    }

    final boolean a(float f, float f2) {
        float f3;
        float f4;
        float f5;
        SliderStyle sliderStyle = this.getStyle();
        Drawable drawable = this.n && sliderStyle.disabledKnob != null ? sliderStyle.disabledKnob : sliderStyle.knob;
        Drawable drawable2 = this.n && sliderStyle.disabledBackground != null ? sliderStyle.disabledBackground : sliderStyle.background;
        float f6 = this.l;
        float f7 = this.getMinValue();
        float f8 = this.getMaxValue();
        if (this.m) {
            f5 = this.getHeight() - drawable2.getTopHeight() - drawable2.getBottomHeight();
            f4 = drawable == null ? 0.0f : drawable.getMinHeight();
            this.l = f2 - drawable2.getBottomHeight() - f4 * 0.5f;
            f3 = f7 + (f8 - f7) * this.q.apply(this.l / (f5 - f4));
            this.l = Math.max(0.0f, this.l);
            this.l = Math.min(f5 - f4, this.l);
        } else {
            f5 = this.getWidth() - drawable2.getLeftWidth() - drawable2.getRightWidth();
            f4 = drawable == null ? 0.0f : drawable.getMinWidth();
            this.l = f - drawable2.getLeftWidth() - f4 * 0.5f;
            f3 = f7 + (f8 - f7) * this.q.apply(this.l / (f5 - f4));
            this.l = Math.max(0.0f, this.l);
            this.l = Math.min(f5 - f4, this.l);
        }
        f5 = f3;
        boolean bl = this.setValue2(f3);
        if (f3 == f5) {
            this.l = f6;
        }
        return bl;
    }

    public boolean isDragging() {
        return this.p != -1;
    }

    public void setVisualInterpolationInverse(Interpolation interpolation) {
        this.q = interpolation;
    }

    @BA.Hide
    public static class SliderStyle
    extends ProgressBar.ProgressBarStyle {
        public SliderStyle() {
        }

        public SliderStyle(Drawable background, Drawable knob) {
            super(background, knob);
        }

        public SliderStyle(SliderStyle style) {
            super(style);
        }
    }
}

