/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class SplitPane
extends WidgetGroup {
    SplitPaneStyle m;
    protected Actor firstWidget;
    protected Actor secondWidget;
    protected boolean vertical;
    protected float splitAmount = 0.5f;
    protected float minAmount;
    protected float maxAmount = 1.0f;
    private Rectangle q = new Rectangle();
    private Rectangle r = new Rectangle();
    Rectangle n = new Rectangle();
    private Rectangle s = new Rectangle();
    private Rectangle t = new Rectangle();
    Vector2 o = new Vector2();
    Vector2 p = new Vector2();
    protected InputListener InputListnr;

    public SplitPane() {
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Skin skin) {
        this(firstWidget, secondWidget, vertical, skin, "default-" + (vertical ? "vertical" : "horizontal"));
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, Skin skin, String styleName) {
        this(firstWidget, secondWidget, vertical, skin.get(styleName, SplitPaneStyle.class));
    }

    public SplitPane(Actor firstWidget, Actor secondWidget, boolean vertical, SplitPaneStyle style) {
        this.Init(firstWidget, secondWidget, vertical, style);
    }

    protected void Init(Actor firstWidget, Actor secondWidget, boolean vertical, SplitPaneStyle style) {
        this.firstWidget = firstWidget;
        this.secondWidget = secondWidget;
        this.vertical = vertical;
        this.setStyle(style);
        this.setFirstWidget(firstWidget);
        this.setSecondWidget(secondWidget);
        SplitPane splitPane = this;
        splitPane.setSize(splitPane.getPrefWidth(), this.getPrefHeight());
        SplitPane splitPane2 = this;
        splitPane2.InputListnr = new InputListener(splitPane2){
            private int a = -1;
            private /* synthetic */ SplitPane b;
            {
                this.b = splitPane;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (this.a != -1) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (this.b.n.contains(x, y)) {
                    this.a = pointer;
                    this.b.o.set(x, y);
                    this.b.p.set(this.b.n.x, this.b.n.y);
                    super.touchDown(event, x, y, pointer, button);
                    return true;
                }
                return false;
            }

            @Override
            public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == this.a) {
                    this.a = -1;
                }
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (pointer != this.a) {
                    return;
                }
                Drawable drawable = this.b.m.handle;
                if (!this.b.vertical) {
                    float f;
                    float f2 = x - this.b.o.x;
                    float f3 = this.b.getWidth() - drawable.getMinWidth();
                    this.b.p.x = f = this.b.p.x + f2;
                    f = Math.max(0.0f, f);
                    f = Math.min(f3, f);
                    this.b.splitAmount = f / f3;
                    if (this.b.splitAmount < this.b.minAmount) {
                        this.b.splitAmount = this.b.minAmount;
                    }
                    if (this.b.splitAmount > this.b.maxAmount) {
                        this.b.splitAmount = this.b.maxAmount;
                    }
                    this.b.o.set(x, y);
                } else {
                    float f;
                    float f4 = y - this.b.o.y;
                    float f5 = this.b.getHeight() - drawable.getMinHeight();
                    this.b.p.y = f = this.b.p.y + f4;
                    f = Math.max(0.0f, f);
                    f = Math.min(f5, f);
                    this.b.splitAmount = 1.0f - f / f5;
                    if (this.b.splitAmount < this.b.minAmount) {
                        this.b.splitAmount = this.b.minAmount;
                    }
                    if (this.b.splitAmount > this.b.maxAmount) {
                        this.b.splitAmount = this.b.maxAmount;
                    }
                    this.b.o.set(x, y);
                }
                this.b.invalidate();
                super.touchDragged(event, x, y, pointer);
            }
        };
        splitPane2.addListener(splitPane2.InputListnr);
    }

    @BA.Hide
    public void setStyle(SplitPaneStyle style) {
        this.m = style;
        this.invalidateHierarchy();
    }

    public SplitPaneStyle getStyle() {
        return this.m;
    }

    @Override
    @BA.Hide
    public void layout() {
        Object object;
        if (!this.vertical) {
            SplitPane splitPane = this;
            Drawable drawable = splitPane.m.handle;
            float f = splitPane.getHeight();
            float f2 = splitPane.getWidth() - drawable.getMinWidth();
            float f3 = (int)(f2 * splitPane.splitAmount);
            float f4 = f2 - f3;
            float f5 = drawable.getMinWidth();
            splitPane.q.Set(0.0f, 0.0f, f3, f);
            splitPane.r.Set(f3 + f5, 0.0f, f4, f);
            splitPane.n.Set(f3, 0.0f, f5, f);
        } else {
            SplitPane splitPane = this;
            Drawable drawable = splitPane.m.handle;
            float f = splitPane.getWidth();
            float f6 = splitPane.getHeight();
            float f7 = f6 - drawable.getMinHeight();
            float f8 = (int)(f7 * splitPane.splitAmount);
            float f9 = f7 - f8;
            float f10 = drawable.getMinHeight();
            splitPane.q.Set(0.0f, f6 - f8, f, f8);
            splitPane.r.Set(0.0f, 0.0f, f, f9);
            splitPane.n.Set(0.0f, f9, f, f10);
        }
        Actor actor = this.firstWidget;
        if (actor != null) {
            object = this.q;
            actor.SetBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            if (actor instanceof Layout) {
                ((Layout)((Object)actor)).validate();
            }
        }
        if ((object = this.secondWidget) != null) {
            Rectangle rectangle = this.r;
            ((Actor)object).SetBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (object instanceof Layout) {
                ((Layout)object).validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float f;
        float f2;
        float f3 = this.firstWidget == null ? 0.0f : (f2 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.getWidth());
        float f4 = this.secondWidget == null ? 0.0f : (f = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.getWidth());
        if (this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.m.handle.getMinWidth() + f;
    }

    @Override
    public float getPrefHeight() {
        float f;
        float f2;
        float f3 = this.firstWidget == null ? 0.0f : (f2 = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.getHeight());
        float f4 = this.secondWidget == null ? 0.0f : (f = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.getHeight());
        if (!this.vertical) {
            return Math.max(f2, f);
        }
        return f2 + this.m.handle.getMinHeight() + f;
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    @BA.Hide
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        Color color = this.getColor();
        Drawable drawable = this.m.handle;
        this.applyTransform(batch, this.computeTransform());
        if (this.firstWidget != null) {
            batch.flush();
            this.getStage().calculateScissors(this.q, this.s);
            if (ScissorStack.pushScissors(this.s)) {
                if (this.firstWidget.isVisible()) {
                    this.firstWidget.draw(batch, parentAlpha * color.a);
                }
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        if (this.secondWidget != null) {
            batch.flush();
            this.getStage().calculateScissors(this.r, this.t);
            if (ScissorStack.pushScissors(this.t)) {
                if (this.secondWidget.isVisible()) {
                    this.secondWidget.draw(batch, parentAlpha * color.a);
                }
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        batch.setColor(color.r, color.g, color.b, parentAlpha * color.a);
        drawable.draw(batch, this.n.x, this.n.y, this.n.width, this.n.height);
        this.resetTransform(batch);
    }

    public void setSplitAmount(float split) {
        this.splitAmount = Math.max(Math.min(this.maxAmount, split), this.minAmount);
        this.invalidate();
    }

    @BA.Hide
    public float getSplit() {
        return this.splitAmount;
    }

    public void setMinSplitAmount(float minAmount) {
        if (minAmount < 0.0f) {
            throw new GdxRuntimeException("minAmount has to be >= 0");
        }
        if (minAmount >= this.maxAmount) {
            throw new GdxRuntimeException("minAmount has to be < maxAmount");
        }
        this.minAmount = minAmount;
    }

    public void setMaxSplitAmount(float maxAmount) {
        if (maxAmount > 1.0f) {
            throw new GdxRuntimeException("maxAmount has to be <= 1");
        }
        if (maxAmount <= this.minAmount) {
            throw new GdxRuntimeException("maxAmount has to be > minAmount");
        }
        this.maxAmount = maxAmount;
    }

    public void setFirstWidget(Actor widget) {
        if (this.firstWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.firstWidget);
        }
        this.firstWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    public void setSecondWidget(Actor widget) {
        if (this.secondWidget != null) {
            SplitPane splitPane = this;
            super.removeActor(splitPane.secondWidget);
        }
        this.secondWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    @Override
    @BA.Hide
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    @BA.Hide
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    @BA.Hide
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget.");
    }

    @Override
    @BA.Hide
    public boolean removeActor(Actor actor) {
        throw new UnsupportedOperationException("Use ScrollPane#setWidget(null).");
    }

    @BA.Hide
    public static class SplitPaneStyle {
        public Drawable handle;

        public SplitPaneStyle() {
        }

        public SplitPaneStyle(Drawable handle) {
            this.handle = handle;
        }

        public SplitPaneStyle(SplitPaneStyle style) {
            this.handle = style.handle;
        }
    }
}

