/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.scene2d.lgButton;
import anywheresoftware.b4a.libgdx.scene2d.lgLabel;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

@BA.Hide
public class TextButton
extends lgButton {
    private lgLabel p;
    private TextButtonStyle q;

    public TextButton() {
    }

    public TextButton(String text, Skin skin) {
        this(text, skin.get(TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String text, Skin skin, String styleName) {
        this(text, skin.get(styleName, TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String text, TextButtonStyle style) {
        this.Init(text, style);
    }

    protected void Init(String text, TextButtonStyle style) {
        this.setStyle(style);
        this.q = style;
        lgLabel.lgLabelStyle lgLabelStyle2 = new lgLabel.lgLabelStyle();
        new lgLabel.lgLabelStyle().font = style.font;
        lgLabelStyle2.fontColor = style.fontColor;
        this.p = new lgLabel();
        this.p.Initialize(this._ba, text, lgLabelStyle2, "");
        this.p.setAlignment(1);
        TextButton textButton = this;
        textButton.add(textButton.p).expand().fill();
        TextButton textButton2 = this;
        textButton2.setSize(textButton2.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style instanceof TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        super.setStyle(style);
        this.q = (TextButtonStyle)style;
        if (this.p != null) {
            TextButtonStyle textButtonStyle = (TextButtonStyle)style;
            lgLabel.lgLabelStyle lgLabelStyle2 = this.p.getStyle();
            this.p.getStyle().font = textButtonStyle.font;
            lgLabelStyle2.fontColor = textButtonStyle.fontColor;
            this.p.setStyle((Label.LabelStyle)lgLabelStyle2);
        }
    }

    @Override
    public TextButtonStyle getStyle() {
        return this.q;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color color = this.isDisabled() && this.q.disabledFontColor != null ? this.q.disabledFontColor : (this.isPressed() && this.q.downFontColor != null ? this.q.downFontColor : (this.isChecked() && this.q.checkedFontColor != null ? (this.isOver() && this.q.checkedOverFontColor != null ? this.q.checkedOverFontColor : this.q.checkedFontColor) : (this.isOver() && this.q.overFontColor != null ? this.q.overFontColor : this.q.fontColor)));
        if (color != null) {
            this.p.getStyle().fontColor = color;
        }
        super.draw(batch, parentAlpha);
    }

    public lgLabel getLabel() {
        return this.p;
    }

    public Cell getLabelCell() {
        TextButton textButton = this;
        return textButton.getCell(textButton.p);
    }

    public void setText(String text) {
        this.p.setText(text);
    }

    public CharSequence getText() {
        return this.p.getText();
    }

    @BA.Hide
    public static class TextButtonStyle
    extends lgButton.lgButtonStyle {
        @BA.Hide
        public BitmapFont font;
        @BA.Hide
        public Color overFontColor;
        @BA.Hide
        public Color checkedOverFontColor;
        public Color fontColor;
        public Color downFontColor;
        public Color checkedFontColor;
        public Color disabledFontColor;

        public TextButtonStyle() {
        }

        public TextButtonStyle(Drawable up, Drawable down, Drawable checked, BitmapFont font) {
            this.font = font;
        }

        public TextButtonStyle(TextButtonStyle style) {
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.downFontColor != null) {
                this.downFontColor = new Color(style.downFontColor);
            }
            if (style.overFontColor != null) {
                this.overFontColor = new Color(style.overFontColor);
            }
            if (style.checkedFontColor != null) {
                this.checkedFontColor = new Color(style.checkedFontColor);
            }
            if (style.checkedOverFontColor != null) {
                this.checkedFontColor = new Color(style.checkedOverFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
        }
    }
}

