/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;

@BA.Hide
public class TextField
extends Widget
implements Disableable {
    private static final Vector2 G = new Vector2();
    private static final Vector2 H = new Vector2();
    private static final Vector2 I = new Vector2();
    static boolean l = System.getProperty("os.name").contains("Mac");
    TextFieldStyle m;
    String n;
    private String J;
    private CharSequence K;
    int o;
    protected Clipboard clipboard;
    TextFieldListener p;
    TextFieldFilter q;
    OnscreenKeyboard r = new DefaultOnscreenKeyboard();
    boolean s = true;
    boolean t;
    private boolean L = true;
    private boolean M;
    private StringBuilder N;
    private final BitmapFont.TextBounds O = new BitmapFont.TextBounds();
    float u;
    float v;
    private int P;
    private int Q;
    private final FloatArray R = new FloatArray();
    final FloatArray w = new FloatArray();
    boolean x = true;
    private float S = 0.32f;
    long y;
    boolean z;
    int A;
    private float T;
    private float U;
    private char V = (char)149;
    InputListener B;
    a C = new a(this);
    float D = 0.4f;
    float E = 0.1f;
    private boolean W;
    int F = 0;

    public TextField() {
    }

    public TextField(String text, TextFieldStyle style) {
        this.setStyle(style);
        this.clipboard = Gdx.app.getClipboard();
        this.setText(text);
        TextField textField = this;
        textField.setSize(textField.getPrefWidth(), this.getPrefHeight());
        this.initialize();
    }

    protected void initialize() {
        this.B = new ClickListener(this){
            private /* synthetic */ TextField a;
            {
                this.a = textField;
            }

            @Override
            public final void clicked(InputEvent event, float x, float y) {
                if (this.getTapCount() > 1) {
                    this.a.setSelection(0, this.a.n.length());
                }
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!super.touchDown(event, x, y, pointer, button)) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (this.a.t) {
                    return true;
                }
                this.a.clearSelection();
                this.a(x);
                this.a.A = this.a.o;
                Stage stage = this.a.getStage();
                if (stage != null) {
                    stage.setKeyboardFocus(this.a);
                }
                this.a.r.show(true);
                return true;
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                super.touchDragged(event, x, y, pointer);
                this.a.y = 0L;
                this.a.x = false;
                int n = this.a.o;
                this.a(x);
                this.a.z = this.a.z || n != this.a.o;
            }

            private void a(float f) {
                this.a.y = 0L;
                this.a.x = false;
                f -= this.a.u + this.a.v;
                int n = 0;
                while (n < this.a.w.size) {
                    if (this.a.w.items[n] > f) {
                        this.a.o = Math.max(0, n - 1);
                        return;
                    }
                    ++n;
                }
                this.a.o = Math.max(0, this.a.w.size - 1);
            }

            @Override
            public final boolean keyDown(InputEvent event, int keycode) {
                if (this.a.t) {
                    return false;
                }
                this.a.y = 0L;
                this.a.x = false;
                Stage stage = this.a.getStage();
                if (stage != null && stage.getKeyboardFocus() == this.a) {
                    boolean bl;
                    boolean bl2 = false;
                    if (l ? Gdx.input.isKeyPressed(63) : (bl = Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130))) {
                        if (keycode == 50) {
                            this.a.b();
                            return true;
                        }
                        if (keycode == 31 || keycode == 133) {
                            this.a.copy();
                            return true;
                        }
                        if (keycode == 52 || keycode == 67) {
                            this.a.cut();
                            return true;
                        }
                        if (keycode == 29) {
                            this.a.selectAll();
                            return true;
                        }
                    }
                    if (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60)) {
                        int n;
                        if (keycode == 133) {
                            this.a.b();
                        }
                        if (keycode == 112 && this.a.z) {
                            this.a.copy();
                            this.a.c();
                        }
                        if (keycode == 21) {
                            if (!this.a.z) {
                                this.a.A = this.a.o;
                                this.a.z = true;
                            }
                            while (--this.a.o > 0 && bl) {
                                char c2 = this.a.n.charAt(this.a.o);
                                n = c2;
                                if (!(c2 >= 'A' && n <= 90 || n >= 97 && n <= 122) && (n < 48 || n > 57)) break;
                            }
                            bl2 = true;
                        }
                        if (keycode == 22) {
                            if (!this.a.z) {
                                this.a.A = this.a.o;
                                this.a.z = true;
                            }
                            n = this.a.n.length();
                            while (++this.a.o < n && bl) {
                                char c3 = this.a.n.charAt(this.a.o - 1);
                                if (!(c3 >= 'A' && c3 <= 'Z' || c3 >= 'a' && c3 <= 'z') && (c3 < '0' || c3 > '9')) break;
                            }
                            bl2 = true;
                        }
                        if (keycode == 3) {
                            if (!this.a.z) {
                                this.a.A = this.a.o;
                                this.a.z = true;
                            }
                            this.a.o = 0;
                        }
                        if (keycode == 132) {
                            if (!this.a.z) {
                                this.a.A = this.a.o;
                                this.a.z = true;
                            }
                            this.a.o = this.a.n.length();
                        }
                        this.a.o = Math.max(0, this.a.o);
                        this.a.o = Math.min(this.a.n.length(), this.a.o);
                    } else {
                        int n;
                        if (keycode == 21) {
                            while (this.a.o-- > 1 && bl) {
                                char c4 = this.a.n.charAt(this.a.o - 1);
                                n = c4;
                                if (!(c4 >= 'A' && n <= 90 || n >= 97 && n <= 122) && (n < 48 || n > 57)) break;
                            }
                            this.a.clearSelection();
                            bl2 = true;
                        }
                        if (keycode == 22) {
                            n = this.a.n.length();
                            while (++this.a.o < n && bl) {
                                char c5 = this.a.n.charAt(this.a.o - 1);
                                if (!(c5 >= 'A' && c5 <= 'Z' || c5 >= 'a' && c5 <= 'z') && (c5 < '0' || c5 > '9')) break;
                            }
                            this.a.clearSelection();
                            bl2 = true;
                        }
                        if (keycode == 3) {
                            this.a.o = 0;
                            this.a.clearSelection();
                        }
                        if (keycode == 132) {
                            this.a.o = this.a.n.length();
                            this.a.clearSelection();
                        }
                        this.a.o = Math.max(0, this.a.o);
                        this.a.o = Math.min(this.a.n.length(), this.a.o);
                    }
                    if (bl2 && (!this.a.C.isScheduled() || this.a.C.a != keycode)) {
                        this.a.C.a = keycode;
                        this.a.C.cancel();
                        Timer.schedule(this.a.C, this.a.D, this.a.E);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public final boolean keyUp(InputEvent event, int keycode) {
                if (this.a.t) {
                    return false;
                }
                this.a.C.cancel();
                return true;
            }

            @Override
            public final boolean keyTyped(InputEvent event, char character) {
                if (this.a.t) {
                    return false;
                }
                BitmapFont bitmapFont = this.a.m.font;
                Stage stage = this.a.getStage();
                if (stage != null && stage.getKeyboardFocus() == this.a) {
                    if (character == '\b') {
                        if (this.a.o > 0 || this.a.z) {
                            if (!this.a.z) {
                                this.a.n = String.valueOf(this.a.n.substring(0, this.a.o - 1)) + this.a.n.substring(this.a.o);
                                this.a.a();
                                --this.a.o;
                                this.a.u = 0.0f;
                            } else {
                                this.a.c();
                            }
                        }
                    } else if (character == '\u007f') {
                        if (this.a.o < this.a.n.length() || this.a.z) {
                            if (!this.a.z) {
                                this.a.n = String.valueOf(this.a.n.substring(0, this.a.o)) + this.a.n.substring(this.a.o + 1);
                                this.a.a();
                            } else {
                                this.a.c();
                            }
                        }
                    } else if ((character == '\t' || character == '\n') && this.a.s) {
                        this.a.next(Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60));
                    } else if (bitmapFont.containsCharacter(character)) {
                        if (character != '\r' && character != '\n' && this.a.q != null && !this.a.q.acceptChar(this.a, character)) {
                            return true;
                        }
                        if (this.a.F > 0 && this.a.n.length() + 1 > this.a.F) {
                            return true;
                        }
                        if (!this.a.z) {
                            this.a.n = String.valueOf(this.a.n.substring(0, this.a.o)) + character + this.a.n.substring(this.a.o, this.a.n.length());
                            this.a.a();
                            ++this.a.o;
                        } else {
                            int n = Math.min(this.a.o, this.a.A);
                            int n2 = Math.max(this.a.o, this.a.A);
                            this.a.n = String.valueOf(n > 0 ? this.a.n.substring(0, n) : "") + (n2 < this.a.n.length() ? this.a.n.substring(n2, this.a.n.length()) : "");
                            this.a.o = n;
                            this.a.n = String.valueOf(this.a.n.substring(0, this.a.o)) + character + this.a.n.substring(this.a.o, this.a.n.length());
                            this.a.a();
                            ++this.a.o;
                            this.a.clearSelection();
                        }
                    }
                    if (this.a.p != null) {
                        this.a.p.keyTyped(this.a, character);
                    }
                    return true;
                }
                return false;
            }
        };
        this.addListener(this.B);
        this.B.Initialize(this._ba, "");
    }

    public void setMaxLength(int maxLength) {
        this.F = maxLength;
    }

    public int getMaxLength() {
        return this.F;
    }

    public void setOnlyFontChars(boolean onlyFontChars) {
        this.L = onlyFontChars;
    }

    public void setStyle(TextFieldStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.m = style;
        this.invalidateHierarchy();
    }

    public void setPasswordCharacter(char passwordCharacter) {
        this.V = passwordCharacter;
        if (this.M) {
            this.a();
        }
    }

    public TextFieldStyle getStyle() {
        return this.m;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float f;
        float f2;
        Stage stage = this.getStage();
        boolean bl = stage != null && stage.getKeyboardFocus() == this;
        BitmapFont bitmapFont = this.m.font;
        Color color = this.t && this.m.disabledFontColor != null ? this.m.disabledFontColor : (bl && this.m.focusedFontColor != null ? this.m.focusedFontColor : this.m.fontColor);
        Drawable drawable = this.m.selection;
        Drawable drawable2 = this.m.cursor;
        Drawable drawable3 = this.t && this.m.disabledBackground != null ? this.m.disabledBackground : (bl && this.m.focusedBackground != null ? this.m.focusedBackground : this.m.background);
        Color color2 = this.getColor();
        float f3 = this.getX();
        float f4 = this.getY();
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        float f7 = this.O.height / 2.0f + bitmapFont.getDescent();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * parentAlpha);
        float f8 = 0.0f;
        if (drawable3 != null) {
            drawable3.draw(batch, f3, f4, f5, f6);
            f8 = drawable3.getLeftWidth();
            f2 = drawable3.getBottomHeight();
            f7 = (int)(f7 + (f6 - drawable3.getTopHeight() - f2) / 2.0f + f2);
        } else {
            f7 = (int)(f7 + f6 / 2.0f);
        }
        TextField textField = this;
        float f9 = textField.getWidth();
        if (textField.m.background != null) {
            f9 -= textField.m.background.getLeftWidth() + textField.m.background.getRightWidth();
        }
        float f10 = textField.w.get(textField.o) - Math.abs(textField.u);
        if (f <= 0.0f) {
            textField.u = textField.o > 0 ? -textField.w.get(textField.o - 1) : 0.0f;
        } else if (f10 > f9) {
            textField.u -= f10 - f9;
        }
        textField.P = 0;
        textField.v = 0.0f;
        float f11 = Math.abs(textField.u);
        int n = textField.w.size;
        float f12 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            if (textField.w.items[n2] >= f11) {
                textField.P = n2;
                f12 = textField.w.items[n2];
                textField.v = f12 - f11;
                break;
            }
            ++n2;
        }
        textField.Q = Math.min(textField.K.length(), textField.o + 1);
        while (textField.Q <= textField.K.length()) {
            if (textField.w.items[textField.Q] - f12 > f9) break;
            ++textField.Q;
        }
        textField.Q = Math.max(0, textField.Q - 1);
        if (textField.z) {
            n2 = Math.min(textField.o, textField.A);
            int n3 = Math.max(textField.o, textField.A);
            float f13 = Math.max(textField.w.get(n2), f12);
            float f14 = Math.min(textField.w.get(n3), textField.w.get(textField.Q));
            textField.T = f13;
            textField.U = f14 - f13;
        }
        if (textField.W) {
            textField.v = f9 - (textField.w.items[textField.Q] - f12);
            if (textField.z) {
                textField.T += textField.v;
            }
        }
        if (bl && this.z && drawable != null) {
            drawable.draw(batch, f3 + this.T + f8 + this.u, f4 + f7 - this.O.height - bitmapFont.getDescent(), this.U, this.O.height + bitmapFont.getDescent() / 2.0f);
        }
        float f15 = f2 = bitmapFont.isFlipped() ? -this.O.height : 0.0f;
        if (this.K.length() == 0) {
            if (!bl && this.J != null) {
                if (this.m.messageFontColor != null) {
                    bitmapFont.setColor(this.m.messageFontColor.r, this.m.messageFontColor.g, this.m.messageFontColor.b, this.m.messageFontColor.a * parentAlpha);
                } else {
                    bitmapFont.setColor(0.7f, 0.7f, 0.7f, parentAlpha);
                }
                (this.m.messageFont != null ? this.m.messageFont : bitmapFont).draw(batch, this.J, f3 + f8, f4 + f7 + f2);
            }
        } else {
            bitmapFont.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            bitmapFont.draw(batch, this.K, f3 + f8 + this.v, f4 + f7 + f2, this.P, this.Q);
        }
        if (bl && !this.t) {
            long l;
            textField = this;
            long l2 = TimeUtils.nanoTime();
            if ((float)(l - textField.y) / 1.0E9f > textField.S) {
                textField.x = !textField.x;
                textField.y = l2;
            }
            if (this.x && drawable2 != null) {
                drawable2.draw(batch, f3 + f8 + this.v + this.w.get(this.o) - this.w.items[this.P] - 1.0f, f4 + f7 - this.O.height - bitmapFont.getDescent(), drawable2.getMinWidth(), this.O.height + bitmapFont.getDescent() / 2.0f);
            }
        }
    }

    final void a() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < this.n.length()) {
            n = this.n.charAt(n2);
            stringBuilder.append((char)(this.m.font.containsCharacter((char)n) ? n : 32));
            ++n2;
        }
        String string = stringBuilder.toString();
        if (this.M && this.m.font.containsCharacter(this.V)) {
            if (this.N == null) {
                this.N = new StringBuilder(string.length());
            }
            if (this.N.length() > string.length()) {
                this.N.setLength(string.length());
            } else {
                n = this.N.length();
                int n3 = string.length();
                while (n < n3) {
                    this.N.append(this.V);
                    ++n;
                }
            }
            this.K = this.N;
        } else {
            this.K = string;
        }
        this.m.font.computeGlyphAdvancesAndPositions(this.K, this.R, this.w);
        if (this.A > string.length()) {
            this.A = string.length();
        }
    }

    public void copy() {
        if (this.z && !this.M) {
            int n = Math.min(this.o, this.A);
            int n2 = Math.max(this.o, this.A);
            this.clipboard.setContents(this.n.substring(n, n2));
        }
    }

    public void cut() {
        if (this.z && !this.M) {
            this.copy();
            this.c();
        }
    }

    final void b() {
        String string = this.clipboard.getContents();
        if (string != null) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < string.length()) {
                if (this.F > 0 && this.n.length() + stringBuilder.length() + 1 > this.F) break;
                char c2 = string.charAt(n);
                if (this.m.font.containsCharacter(c2) && (this.q == null || this.q.acceptChar(this, c2))) {
                    stringBuilder.append(c2);
                }
                ++n;
            }
            string = stringBuilder.toString();
            if (!this.z) {
                this.n = String.valueOf(this.n.substring(0, this.o)) + string + this.n.substring(this.o, this.n.length());
                this.a();
                this.o += string.length();
                return;
            }
            n = Math.min(this.o, this.A);
            int n2 = Math.max(this.o, this.A);
            StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(n > 0 ? this.n.substring(0, n) : ""));
            if (n2 < this.n.length()) {
                String string3 = this.n;
                string2 = string3.substring(n2, string3.length());
            } else {
                string2 = "";
            }
            this.n = stringBuilder2.append(string2).toString();
            this.o = n;
            this.n = String.valueOf(this.n.substring(0, this.o)) + string + this.n.substring(this.o, this.n.length());
            this.a();
            this.o = n + string.length();
            this.clearSelection();
        }
    }

    final void c() {
        String string;
        int n = Math.min(this.o, this.A);
        int n2 = Math.max(this.o, this.A);
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(n > 0 ? this.n.substring(0, n) : ""));
        if (n2 < this.n.length()) {
            String string2 = this.n;
            string = string2.substring(n2, string2.length());
        } else {
            string = "";
        }
        this.n = stringBuilder.append(string).toString();
        this.a();
        this.o = n;
        this.clearSelection();
    }

    public void next(boolean up) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        this.getParent().localToStageCoordinates(G.set(this.getX(), this.getY()));
        TextField textField = this.a(stage.getActors(), null, H, G, up);
        if (textField == null) {
            if (up) {
                G.set(Float.MIN_VALUE, Float.MIN_VALUE);
            } else {
                G.set(Float.MAX_VALUE, Float.MAX_VALUE);
            }
            TextField textField2 = this;
            textField = textField2.a(textField2.getStage().getActors(), null, H, G, up);
        }
        if (textField != null) {
            stage.setKeyboardFocus(textField);
            return;
        }
        Gdx.input.setOnscreenKeyboardVisible(false);
    }

    private TextField a(Array<Actor> array, TextField textField, Vector2 vector2, Vector2 vector22, boolean bl) {
        int n = 0;
        int n2 = array.size;
        while (n < n2) {
            Actor actor = array.get(n);
            if (actor != this) {
                if (actor instanceof TextField) {
                    TextField textField2 = (TextField)actor;
                    if (!textField2.isDisabled() && textField2.s) {
                        Vector2 vector23 = actor.getParent().localToStageCoordinates(I.set(actor.getX(), actor.getY()));
                        if ((vector23.y < vector22.y || vector23.y == vector22.y && vector23.x > vector22.x) ^ bl && (textField == null || (vector23.y > vector2.y || vector23.y == vector2.y && vector23.x < vector2.x) ^ bl)) {
                            textField = (TextField)actor;
                            vector2.set(vector23);
                        }
                    }
                } else if (actor instanceof Group) {
                    textField = this.a(((Group)actor).getChildren(), textField, vector2, vector22, bl);
                }
            }
            ++n;
        }
        return textField;
    }

    @BA.Hide
    public void setTextFieldListener(TextFieldListener listener) {
        this.p = listener;
    }

    @BA.Hide
    public void setTextFieldFilter(TextFieldFilter filter) {
        this.q = filter;
    }

    public void setFocusTraversal(boolean focusTraversal) {
        this.s = focusTraversal;
    }

    public String getMessageText() {
        return this.J;
    }

    public void setMessageText(String messageText) {
        this.J = messageText;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        BitmapFont bitmapFont = this.m.font;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < text.length()) {
            if (this.F > 0 && stringBuilder.length() + 1 > this.F) break;
            char c2 = text.charAt(n);
            if (!(this.L && !this.m.font.containsCharacter(c2) || this.q != null && !this.q.acceptChar(this, c2))) {
                stringBuilder.append(c2);
            }
            ++n;
        }
        this.n = stringBuilder.toString();
        this.a();
        this.o = 0;
        this.clearSelection();
        this.O.set(bitmapFont.getBounds(this.K));
        this.O.height -= bitmapFont.getDescent() * 2.0f;
        bitmapFont.computeGlyphAdvancesAndPositions(this.K, this.R, this.w);
    }

    public String getText() {
        return this.n;
    }

    public void setSelection(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            throw new IllegalArgumentException("selectionStart must be >= 0");
        }
        if (selectionEnd < 0) {
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        selectionStart = Math.min(this.n.length(), selectionStart);
        selectionEnd = Math.min(this.n.length(), selectionEnd);
        if (selectionEnd == selectionStart) {
            this.clearSelection();
            return;
        }
        if (selectionEnd < selectionStart) {
            int n = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = n;
        }
        this.z = true;
        this.A = selectionStart;
        this.o = selectionEnd;
    }

    public void selectAll() {
        this.setSelection(0, this.n.length());
    }

    public void clearSelection() {
        this.z = false;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.o = Math.min(cursorPosition, this.n.length());
    }

    public int getCursorPosition() {
        return this.o;
    }

    @BA.Hide
    public OnscreenKeyboard getOnscreenKeyboard() {
        return this.r;
    }

    @BA.Hide
    public void setOnscreenKeyboard(OnscreenKeyboard keyboard) {
        this.r = keyboard;
    }

    @BA.Hide
    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        float f = this.O.height;
        if (this.m.background != null) {
            f = Math.max(f + this.m.background.getBottomHeight() + this.m.background.getTopHeight(), this.m.background.getMinHeight());
        }
        return f;
    }

    public void setRightAligned(boolean rightAligned) {
        this.W = rightAligned;
    }

    public void setPasswordMode(boolean passwordMode) {
        this.M = passwordMode;
        this.a();
    }

    public void setBlinkTime(float blinkTime) {
        this.S = blinkTime;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.t = disabled;
    }

    public boolean getDisabled() {
        return this.t;
    }

    @Override
    @BA.Hide
    public boolean isDisabled() {
        return this.t;
    }

    @BA.Hide
    public boolean isPasswordMode() {
        return this.M;
    }

    @BA.Hide
    public TextFieldFilter getTextFieldFilter() {
        return this.q;
    }

    @BA.Hide
    public static class DefaultOnscreenKeyboard
    implements OnscreenKeyboard {
        @Override
        public void show(boolean visible) {
            Gdx.input.setOnscreenKeyboardVisible(visible);
        }
    }

    final class a
    extends Timer.Task {
        int a;
        private /* synthetic */ TextField f;

        a(TextField textField) {
            this.f = textField;
        }

        @Override
        public final void run() {
            this.f.B.keyDown(null, this.a);
        }
    }

    public static interface OnscreenKeyboard {
        public void show(boolean var1);
    }

    public static interface TextFieldFilter {
        public boolean acceptChar(TextField var1, char var2);

        @BA.Hide
        public static class DigitsOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(TextField textField, char key) {
                return Character.isDigit(key);
            }
        }
    }

    public static interface TextFieldListener {
        public void keyTyped(TextField var1, char var2);
    }

    @BA.Hide
    public static class TextFieldStyle {
        @BA.Hide
        public BitmapFont font;
        public Color fontColor;
        public Color focusedFontColor;
        public Color disabledFontColor;
        public Drawable background;
        public Drawable focusedBackground;
        public Drawable disabledBackground;
        public Drawable cursor;
        public Drawable selection;
        @BA.Hide
        public BitmapFont messageFont;
        public Color messageFontColor;

        public TextFieldStyle() {
        }

        public TextFieldStyle(BitmapFont font, Color fontColor, Drawable cursor, Drawable selection, Drawable background) {
            this.background = background;
            this.cursor = cursor;
            this.font = font;
            this.fontColor = fontColor;
            this.selection = selection;
        }

        public TextFieldStyle(TextFieldStyle style) {
            this.messageFont = style.messageFont;
            if (style.messageFontColor != null) {
                this.messageFontColor = new Color(style.messageFontColor);
            }
            this.background = style.background;
            this.focusedBackground = style.focusedBackground;
            this.disabledBackground = style.disabledBackground;
            this.cursor = style.cursor;
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            if (style.focusedFontColor != null) {
                this.focusedFontColor = new Color(style.focusedFontColor);
            }
            if (style.disabledFontColor != null) {
                this.disabledFontColor = new Color(style.disabledFontColor);
            }
            this.selection = style.selection;
        }
    }
}

